/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiType;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransactionProxyFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.transaction.interceptor.TransactionProxyFactoryBean";
    @NonNls
    private static final String PROXY_INTERFACES_PROPERTY_NAME = "proxyInterfaces";
    @NonNls
    private static final String TARGET_PROPERTY_NAME = "target";

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        if (context instanceof SpringBean) {
            SpringBean springBean = (SpringBean)context;
            PsiType type = TransactionProxyFactoryBeanTypeResolver.getTargetType(springBean);
            if (type != null && TransactionProxyFactoryBeanTypeResolver.isCglibExplicitlyEnabled(springBean)) {
                Set<String> set = Collections.singleton(type.getCanonicalText());
                if (set == null) {
                    TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(0);
                }
                return set;
            }
            Set<String> proxyInterfaceNames = TransactionProxyFactoryBeanTypeResolver.getTypesFromClassArrayProperty(springBean, PROXY_INTERFACES_PROPERTY_NAME);
            if (!proxyInterfaceNames.isEmpty()) {
                Set<String> set = proxyInterfaceNames;
                if (set == null) {
                    TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(1);
                }
                return set;
            }
            if (type != null) {
                Set<String> targetInterfaceNames = TransactionProxyFactoryBeanTypeResolver.getAllInterfaceNames(type);
                if (!targetInterfaceNames.isEmpty()) {
                    Set<String> set = targetInterfaceNames;
                    if (set == null) {
                        TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(2);
                    }
                    return set;
                }
                Set<String> set = Collections.singleton(type.getCanonicalText());
                if (set == null) {
                    TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(3);
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    private static PsiType getTargetType(@NotNull SpringBean context) {
        if (context == null) {
            TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(5);
        }
        return TransactionProxyFactoryBeanTypeResolver.getTypeFromProperty(context, TARGET_PROPERTY_NAME);
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(6);
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

