/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyPlaceholderFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            PropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            PropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (!(root instanceof XmlFile) || quick || !JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages()) {
            if (FoldingDescriptor.EMPTY == null) {
                PropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY;
        }
        DomFileElement fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)((XmlFile)root));
        if (fileElement == null) {
            if (FoldingDescriptor.EMPTY == null) {
                PropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(3);
            }
            return FoldingDescriptor.EMPTY;
        }
        final PlaceholderUtils placeholderUtils = PlaceholderUtils.getInstance();
        SmartList regions = new SmartList();
        fileElement.accept(new DomElementVisitor((List)regions){
            final /* synthetic */ List val$regions;
            {
                this.val$regions = list;
            }

            public void visitDomElement(DomElement element) {
                if (!DomUtil.hasXml((DomElement)element)) {
                    return;
                }
                if (element instanceof GenericDomValue) {
                    if (placeholderUtils.isRawTextPlaceholder((GenericDomValue)element)) {
                        XmlElement xmlElement = element.getXmlElement();
                        if (xmlElement instanceof XmlAttribute) {
                            XmlAttributeValue value = ((XmlAttribute)xmlElement).getValueElement();
                            if (value != null) {
                                ContainerUtil.addIfNotNull((Collection)this.val$regions, (Object)PropertyPlaceholderFoldingBuilder.createDescriptor((PsiElement)value));
                            }
                        } else if (xmlElement instanceof XmlTag) {
                            ContainerUtil.addIfNotNull((Collection)this.val$regions, (Object)PropertyPlaceholderFoldingBuilder.createDescriptor((PsiElement)xmlElement));
                        }
                    }
                } else {
                    element.acceptChildren((DomElementVisitor)this);
                }
            }
        });
        FoldingDescriptor[] foldingDescriptorArray = regions.isEmpty() ? FoldingDescriptor.EMPTY : regions.toArray(new FoldingDescriptor[regions.size()]);
        if (foldingDescriptorArray == null) {
            PropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(4);
        }
        return foldingDescriptorArray;
    }

    @Nullable
    private static FoldingDescriptor createDescriptor(final PsiElement element) {
        for (PsiReference reference : element.getReferences()) {
            if (!(reference instanceof PlaceholderPropertyReference)) continue;
            if (((PlaceholderPropertyReference)reference).multiResolve(false).length == 0) {
                return null;
            }
            return new FoldingDescriptor(element, ((PlaceholderPropertyReference)reference).getFullTextRange().shiftRight(element.getTextRange().getStartOffset())){

                @NotNull
                public Set<Object> getDependencies() {
                    PsiElement property = PropertyPlaceholderFoldingBuilder.resolveProperty(element);
                    if (property != null) {
                        PsiFile containingFile = property.getContainingFile();
                        Set set = ContainerUtil.createMaybeSingletonSet((Object)containingFile);
                        if (set == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return set;
                    }
                    Set set = super.getDependencies();
                    if (set == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder$2", "getDependencies"));
                }
            };
        }
        return null;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            PropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(5);
        }
        PsiElement element = node.getPsi();
        PsiElement property = PropertyPlaceholderFoldingBuilder.resolveProperty(element);
        String text = null;
        if (property instanceof IProperty) {
            text = ((IProperty)property).getUnescapedValue();
        }
        if (text == null) {
            return null;
        }
        return text.trim().isEmpty() ? "<empty>" : text;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Nullable
    private static PsiElement resolveProperty(PsiElement element) {
        for (PsiReference reference : element.getReferences()) {
            ResolveResult[] results;
            if (!(reference instanceof PlaceholderPropertyReference) || (results = ((PlaceholderPropertyReference)reference).multiResolve(false)).length <= 0) continue;
            return results[0].getElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/folding/PropertyPlaceholderFoldingBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

