/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelImpl;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelImpl;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCachedModelFactory {
    private static final Key<CachedValue<Map<Pair<Module, String>, LocalXmlModel>>> LOCAL_XML_MODEL_KEY = Key.create((String)"LOCAL_XML_MODEL_KEY");
    private static final Key<CachedValue<Map<Pair<Module, String>, LocalAnnotationModel>>> LOCAL_ANNO_MODEL_KEY = Key.create((String)"LOCAL_ANN_MODEL_KEY");

    @Nullable
    public static LocalXmlModel getOrCreateLocalXmlModel(@NotNull XmlFile configFile, @NotNull Module module, @Nullable Set<String> activeProfiles) {
        if (configFile == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(1);
        }
        if (module.isDisposed()) {
            return null;
        }
        Pair key = Pair.create((Object)module, (Object)SpringProfileUtils.profilesAsString(activeProfiles));
        Map localXmlModelsMap = (Map)CachedValuesManager.getManager((Project)configFile.getProject()).getCachedValue((UserDataHolder)configFile, LOCAL_XML_MODEL_KEY, () -> {
            if (configFile == null) {
                SpringCachedModelFactory.$$$reportNull$$$0(17);
            }
            ConcurrentMap localXmlModelTHashMap = ConcurrentFactoryMap.createMap(key1 -> {
                if (configFile == null) {
                    SpringCachedModelFactory.$$$reportNull$$$0(18);
                }
                LocalXmlModelImpl localXmlModel = new LocalXmlModelImpl(configFile, (Module)key1.first);
                Set<String> profiles = SpringCachedModelFactory.getProfilesFromString((String)key1.second);
                localXmlModel.setActiveProfiles(profiles);
                return localXmlModel;
            });
            return CachedValueProvider.Result.create((Object)localXmlModelTHashMap, (Object[])SpringCachedModelFactory.getLocalXmlModelDependencies((PsiFile)configFile));
        }, false);
        return (LocalXmlModel)localXmlModelsMap.get(key);
    }

    @Nullable
    public static LocalAnnotationModel getOrCreateLocalAnnotationModel(@NotNull SpringConfiguration configuration, @Nullable Module module, @NotNull Set<String> activeProfiles) {
        if (configuration == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(2);
        }
        if (activeProfiles == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(3);
        }
        if (module == null) {
            return null;
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configuration.getPsiElement(), module, activeProfiles);
    }

    @Nullable
    public static LocalAnnotationModel getOrCreateLocalAnnotationModel(@NotNull PsiClass psiClass, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (psiClass == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(6);
        }
        if (module.isDisposed()) {
            return null;
        }
        Pair key = Pair.create((Object)module, (Object)SpringProfileUtils.profilesAsString(activeProfiles));
        Map localAnnotationModelsMap = (Map)CachedValuesManager.getManager((Project)psiClass.getProject()).getCachedValue((UserDataHolder)psiClass, LOCAL_ANNO_MODEL_KEY, () -> {
            if (psiClass == null) {
                SpringCachedModelFactory.$$$reportNull$$$0(13);
            }
            if (module == null) {
                SpringCachedModelFactory.$$$reportNull$$$0(14);
            }
            ConcurrentMap localAnnoModelTHashMap = ConcurrentFactoryMap.createMap(key1 -> {
                if (psiClass == null) {
                    SpringCachedModelFactory.$$$reportNull$$$0(15);
                }
                if (module == null) {
                    SpringCachedModelFactory.$$$reportNull$$$0(16);
                }
                LocalAnnotationModelImpl annotationModel = new LocalAnnotationModelImpl(psiClass, module);
                Set<String> profiles = Collections.unmodifiableSet(SpringCachedModelFactory.getProfilesFromString((String)key1.second));
                annotationModel.setActiveProfiles(profiles);
                return annotationModel;
            });
            return CachedValueProvider.Result.create((Object)localAnnoModelTHashMap, (Object[])SpringCachedModelFactory.getLocalAnnotationModelDependencies(psiClass));
        }, false);
        return (LocalAnnotationModel)localAnnotationModelsMap.get(key);
    }

    @NotNull
    private static Set<String> getProfilesFromString(String key) {
        if (key.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringCachedModelFactory.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set set = ContainerUtil.map2Set((Collection)StringUtil.split((String)key, (String)","), (Function)StringUtil.TRIMMER);
        if (set == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Object[] getLocalXmlModelDependencies(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(9);
        }
        Project project = psiFile.getProject();
        SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance((Project)project);
        Object[] dependencies = new Object[]{psiFile, springModificationTrackersManager.getProfilesModificationTracker(), springModificationTrackersManager.getCustomBeanParserModificationTracker(), ProjectRootManager.getInstance((Project)project), springModificationTrackersManager.getOuterModelsModificationTracker()};
        if (dependencies == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(10);
        }
        return dependencies;
    }

    @NotNull
    private static Object[] getLocalAnnotationModelDependencies(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(11);
        }
        Project project = psiClass.getProject();
        SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance((Project)project);
        Object[] dependencies = new Object[]{psiClass, springModificationTrackersManager.getProfilesModificationTracker(), springModificationTrackersManager.getMultipleContextsModificationTracker(), ProjectRootManager.getInstance((Project)project), springModificationTrackersManager.getOuterModelsModificationTracker()};
        if (dependencies == null) {
            SpringCachedModelFactory.$$$reportNull$$$0(12);
        }
        return dependencies;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: 
            case 5: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringCachedModelFactory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringCachedModelFactory";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesFromString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalXmlModelDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalAnnotationModelDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLocalXmlModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLocalAnnotationModel";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocalXmlModelDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModelDependencies";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateLocalAnnotationModel$3";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateLocalXmlModel$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

