/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.annotator;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.gutter.SpringClassAnnotator;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroups;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.cacheable.jam.SpringJamCustomCacheableElement;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheEvict;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachePut;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheable;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCacheableAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<SpringJamCacheableElement, Collection<? extends PsiElement>> CACHEABLE_CONVERTOR = cacheableElement -> ContainerUtil.createMaybeSingletonList(cacheableElement.getPsiElement());

    public String getId() {
        return "SpringCacheableAnnotator";
    }

    public String getName() {
        return "Cacheable operations with the same names";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.ShowCacheable;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringCommonUtils.hasSpringFacets((Project)psiElement.getProject()) || !SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (!SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_4_2)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiMethod psiMethod;
        if (psiElement == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(3);
        }
        if (!(psiElement instanceof PsiAnnotation)) {
            return;
        }
        PsiMember element = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class);
        if (!(element instanceof PsiMethod) && !(element instanceof PsiClass)) {
            return;
        }
        if (element instanceof PsiMethod && (!(psiMethod = (PsiMethod)element).hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor())) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        List cacheableElements = SemService.getSemService((Project)psiElement.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)element);
        if (cacheableElements.isEmpty() || SpringCacheableAnnotator.hasCustomCacheResolver(module)) {
            return;
        }
        for (SpringJamCacheableElement cacheableElement : cacheableElements) {
            if (!psiElement.equals(cacheableElement.getAnnotation())) continue;
            SpringCacheableAnnotator.doAnnotateCacheable(result, cacheableElement);
        }
        if (element instanceof PsiClass) {
            SpringCacheableAnnotator.annotateCachingGroup((PsiElement)element, result);
        }
    }

    private static void annotateCachingGroup(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        SpringCachingGroups cachingGroups;
        if (psiElement == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(4);
        }
        if ((cachingGroups = (SpringCachingGroups)JamService.getJamService((Project)psiElement.getProject()).getJamElement(psiElement, new JamMemberMeta[]{SpringCachingGroups.META})) != null) {
            for (SpringJamCacheable springJamCacheable : cachingGroups.getCacheables()) {
                SpringCacheableAnnotator.doAnnotateCacheable(result, springJamCacheable);
            }
            for (SpringJamCachePut springJamCachePut : cachingGroups.getCachePuts()) {
                SpringCacheableAnnotator.doAnnotateCacheable(result, springJamCachePut);
            }
            for (SpringJamCacheEvict springJamCacheEvict : cachingGroups.getCacheEvict()) {
                SpringCacheableAnnotator.doAnnotateCacheable(result, springJamCacheEvict);
            }
        }
    }

    private static void doAnnotateCacheable(Collection<? super RelatedItemLineMarkerInfo> result, SpringJamCacheableElement cacheableElement) {
        Set<SpringJamCacheableElement> cacheableElements;
        PsiAnnotation psiAnnotation = cacheableElement.getAnnotation();
        if (psiAnnotation != null && !(cacheableElements = SpringCacheableAnnotator.findCacheableWithTheSameName(cacheableElement)).isEmpty()) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.ShowCacheable, CACHEABLE_CONVERTOR).setTargets(cacheableElements).setPopupTitle(SpringBundle.message("spring.cacheable.element.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.cacheable.element.tooltip.text", new Object[0]));
            PsiElement identifier = SpringClassAnnotator.getIdentifier(psiAnnotation);
            if (identifier != null) {
                result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(identifier));
            }
        }
    }

    private static boolean hasCustomCacheResolver(@NotNull Module module) {
        PsiClass cacheResolver;
        if (module == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(5);
        }
        if ((cacheResolver = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.cache.interceptor.CacheResolver")) == null) {
            return true;
        }
        SpringModel combinedModel = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        return SpringModelSearchers.doesBeanExist((CommonSpringModel)combinedModel, (PsiClass)cacheResolver);
    }

    private static Set<SpringJamCacheableElement> findCacheableWithTheSameName(@NotNull SpringJamCacheableElement<?> cacheableElement) {
        if (cacheableElement == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(6);
        }
        Object psiElement = cacheableElement.getPsiElement();
        HashSet cacheableElements = ContainerUtil.newHashSet();
        Set<String> cacheNames = cacheableElement.getCacheNames();
        if (cacheNames.isEmpty()) {
            cacheNames = SpringCacheableAnnotator.getDefaultCacheNames(psiElement);
        }
        if (!cacheNames.isEmpty()) {
            Set<SpringJamCacheableElement> allCacheable = SpringCacheableAnnotator.findAllCacheable(psiElement);
            for (SpringJamCacheableElement element : allCacheable) {
                if (element.equals(cacheableElement)) continue;
                Set<String> names = element.getCacheNames();
                if (names.isEmpty()) {
                    names = SpringCacheableAnnotator.getDefaultCacheNames(element.getPsiElement());
                }
                if (!SpringCacheableAnnotator.hasSameNames(names, cacheNames)) continue;
                cacheableElements.add(element);
            }
        }
        return cacheableElements;
    }

    @NotNull
    private static Set<String> getDefaultCacheNames(@NotNull PsiMember psiElement) {
        if (psiElement == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(7);
        }
        if (!psiElement.isValid()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringCacheableAnnotator.$$$reportNull$$$0(8);
            }
            return set;
        }
        PsiClass aClass = psiElement.getContainingClass();
        if (aClass != null) {
            SemService service = SemService.getSemService((Project)aClass.getProject());
            SpringJamCacheConfig cacheConfig = (SpringJamCacheConfig)service.getSemElement(SpringJamCacheConfig.CACHE_CONFIG_JAM_KEY, (PsiElement)aClass);
            if (cacheConfig != null) {
                Set<String> set = cacheConfig.getCacheNames();
                if (set == null) {
                    SpringCacheableAnnotator.$$$reportNull$$$0(9);
                }
                return set;
            }
            SpringJamCustomCacheConfig customCacheConfig = (SpringJamCustomCacheConfig)service.getSemElement(SpringJamCustomCacheConfig.JAM_KEY, (PsiElement)aClass);
            if (customCacheConfig != null) {
                Set<String> set = customCacheConfig.getCacheNames();
                if (set == null) {
                    SpringCacheableAnnotator.$$$reportNull$$$0(10);
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static boolean hasSameNames(Set<String> names1, Set<String> names2) {
        for (String name1 : names1) {
            for (String name2 : names2) {
                if (!name1.equals(name2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Set<SpringJamCacheableElement> findAllCacheable(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            Set<SpringJamCacheableElement> set = Collections.emptySet();
            if (set == null) {
                SpringCacheableAnnotator.$$$reportNull$$$0(12);
            }
            return set;
        }
        JamService service = JamService.getJamService((Project)module.getProject());
        GlobalSearchScope scope = psiElement.getResolveScope();
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        result.addAll(service.getJamMethodElements(SpringJamCacheable.CACHEABLE_JAM_KEY, "org.springframework.cache.annotation.Cacheable", scope));
        result.addAll(service.getJamMethodElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, "org.springframework.cache.annotation.CachePut", scope));
        result.addAll(service.getJamMethodElements(SpringJamCacheEvict.CACHE_EVICT_JAM_KEY, "org.springframework.cache.annotation.CacheEvict", scope));
        result.addAll(service.getJamClassElements(SpringJamCacheable.CACHEABLE_JAM_KEY, "org.springframework.cache.annotation.Cacheable", scope));
        result.addAll(service.getJamClassElements(SpringJamCachePut.CACHE_PUT_JAM_KEY, "org.springframework.cache.annotation.CachePut", scope));
        result.addAll(service.getJamClassElements(SpringJamCacheEvict.CACHE_EVICT_JAM_KEY, "org.springframework.cache.annotation.CacheEvict", scope));
        result.addAll(service.getJamClassElements(SpringJamCacheConfig.CACHE_CONFIG_JAM_KEY, "org.springframework.cache.annotation.CacheConfig", scope));
        result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(scope, module, "org.springframework.cache.annotation.Cacheable"));
        result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(scope, module, "org.springframework.cache.annotation.CachePut"));
        result.addAll(SpringCacheableAnnotator.getCustomCacheableElements(scope, module, "org.springframework.cache.annotation.CacheEvict"));
        for (SpringCachingGroups cachingGroups : service.getJamClassElements(SpringCachingGroups.META, "org.springframework.cache.annotation.Caching", scope)) {
            result.addAll(cachingGroups.getCacheables());
            result.addAll(cachingGroups.getCacheEvict());
            result.addAll(cachingGroups.getCachePuts());
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(13);
        }
        return linkedHashSet;
    }

    private static List<SpringJamCustomCacheableElement> getCustomCacheableElements(@NotNull GlobalSearchScope scope, Module module, @NotNull String definingAnno) {
        if (scope == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(14);
        }
        if (definingAnno == null) {
            SpringCacheableAnnotator.$$$reportNull$$$0(15);
        }
        SmartList customCacheables = new SmartList();
        List customAnnotations = ContainerUtil.mapNotNull((Collection)JamAnnotationTypeUtil.getInstance((Module)module).getAnnotationTypesWithChildren(definingAnno), PsiClass::getQualifiedName);
        JamService service = JamService.getJamService((Project)scope.getProject());
        for (String customAnno : customAnnotations) {
            customCacheables.addAll(service.getJamMethodElements(SpringJamCustomCacheableElement.CUSTOM_ROOT_JAM_KEY, customAnno, scope));
            customCacheables.addAll(service.getJamClassElements(SpringJamCustomCacheableElement.CUSTOM_ROOT_JAM_KEY, customAnno, scope));
        }
        return customCacheables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheableElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definingAnno";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/cacheable/annotator/SpringCacheableAnnotator";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCacheNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllCacheable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotateCachingGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomCacheResolver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findCacheableWithTheSameName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCacheNames";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCustomCacheableElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

