/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupMethodInspection
extends SpringBeanInspectionBase {
    private static void checkLookupMethodReturnType(LookupMethod lookupMethod, PsiMethod method, DomElementAnnotationHolder holder) {
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            holder.createProblem((DomElement)lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.constructor.not.allowed", new Object[0]), new LocalQuickFix[0]);
        } else if (!(returnType instanceof PsiClassType) || ((PsiClassType)returnType).resolve() == null) {
            holder.createProblem((DomElement)lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.incorrect.return.type", new Object[0]), new LocalQuickFix[0]);
        } else {
            SpringBeanPointer beanPointer = (SpringBeanPointer)lookupMethod.getBean().getValue();
            if (beanPointer != null) {
                PsiClass beanClass = beanPointer.getBeanClass();
                if (beanClass == null) {
                    holder.createProblem((DomElement)lookupMethod.getBean(), SpringBundle.message("spring.bean.lookup.method.bean.has.no.class", new Object[0]), new LocalQuickFix[0]);
                } else {
                    PsiClass returnClass = ((PsiClassType)returnType).resolve();
                    assert (returnClass != null);
                    if (!SpringBeanCoreUtils.isEffectiveClassType(Collections.singletonList(returnType), beanPointer.getSpringBean()) && !InheritanceUtil.isInheritorOrSelf((PsiClass)beanClass, (PsiClass)returnClass, (boolean)true)) {
                        String beanName = beanPointer.getName();
                        if (StringUtil.isEmpty((String)beanName)) {
                            beanName = "unknown";
                        }
                        String message = SpringBundle.message("spring.bean.lookup.method.return.type.mismatch", beanName);
                        holder.createProblem((DomElement)lookupMethod.getName(), message, new LocalQuickFix[0]);
                        holder.createProblem((DomElement)lookupMethod.getBean(), message, new LocalQuickFix[0]);
                    }
                }
            }
        }
    }

    private static void checkLookupMethodIdentifiers(LookupMethod lookupMethod, DomElementAnnotationHolder holder, PsiMethod method) {
        if (!method.hasModifierProperty("public") && !method.hasModifierProperty("protected")) {
            holder.createProblem((DomElement)lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.must.be.public.or.protected", new Object[0]), new LocalQuickFix[0]);
        }
        if (method.hasModifierProperty("static")) {
            holder.createProblem((DomElement)lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.must.be.not.static", new Object[0]), new LocalQuickFix[0]);
        }
        if (method.getParameterList().getParametersCount() > 0) {
            holder.createProblem((DomElement)lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.must.have.no.parameters", new Object[0]), new LocalQuickFix[0]);
        }
    }

    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        if (springBean == null) {
            LookupMethodInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            LookupMethodInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            LookupMethodInspection.$$$reportNull$$$0(2);
        }
        for (LookupMethod lookupMethod : springBean.getLookupMethods()) {
            PsiMethod method = (PsiMethod)lookupMethod.getName().getValue();
            if (method == null) continue;
            LookupMethodInspection.checkLookupMethodIdentifiers(lookupMethod, holder, method);
            LookupMethodInspection.checkLookupMethodReturnType(lookupMethod, method, holder);
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringBeanLookupMethodInspection" == null) {
            LookupMethodInspection.$$$reportNull$$$0(3);
        }
        return "SpringBeanLookupMethodInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/LookupMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/LookupMethodInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkBean";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

