/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringInactiveProfileHighlightingInspection
extends DomElementsInspection<Beans> {
    public SpringInactiveProfileHighlightingInspection() {
        super(Beans.class, new Class[0]);
    }

    @Nullable
    protected ProblemDescriptor[] checkDomFile(@NotNull DomFileElement<Beans> domFileElement, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (domFileElement == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(1);
        }
        HashSet descriptors = new HashSet();
        XmlFile xmlFile = domFileElement.getFile();
        Beans beans = (Beans)domFileElement.getRootElement();
        SpringModel springModel = SpringManager.getInstance((Project)xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
        if (springModel != null) {
            Set activeProfiles = springModel.getActiveProfiles();
            if (SpringProfileUtils.isActiveProfile((Beans)beans, (Set)activeProfiles)) {
                for (Beans innerBeans : beans.getBeansProfiles()) {
                    if (SpringProfileUtils.isActiveProfile((Beans)innerBeans, (Set)activeProfiles)) continue;
                    descriptors.add(this.createProblem(manager, innerBeans, springModel));
                }
            } else {
                descriptors.add(this.createProblem(manager, beans, springModel));
            }
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    @NotNull
    public ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull Beans beans, @NotNull SpringModel springModel) {
        if (manager == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(2);
        }
        if (beans == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(3);
        }
        if (springModel == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(4);
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)beans.getXmlTag(), SpringBundle.message("SpringInactiveProfilesHighlightingPass.inactive.profile", new Object[0]), true, this.getFixes(beans.getProfile().getNames(), springModel.getFileSet()), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
        if (problemDescriptor == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(5);
        }
        return problemDescriptor;
    }

    public LocalQuickFix[] getFixes(@NotNull Set<String> names, @Nullable SpringFileSet set) {
        if (names == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(6);
        }
        HashSet fixes = new HashSet();
        if (set != null) {
            for (String name : names) {
                fixes.add(new MyLocalQuickFix(name, set));
            }
        }
        return fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringInactiveProfileHighlightingInspection" == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(7);
        }
        return "SpringInactiveProfileHighlightingInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDomFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private final String myProfileName;
        private final SpringFileSet myFileSet;

        public MyLocalQuickFix(String name, SpringFileSet set) {
            this.myProfileName = name;
            this.myFileSet = set;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.activate.profile", this.myProfileName);
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.activate.profile.family.name", new Object[0]);
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyLocalQuickFix.$$$reportNull$$$0(3);
            }
            Set activeProfiles = this.myFileSet.getActiveProfiles();
            activeProfiles.add(this.myProfileName);
            this.myFileSet.setActiveProfiles(activeProfiles);
            SpringModificationTrackersManager.getInstance((Project)project).fireActiveProfilesChanged();
            PsiManager.getInstance((Project)project).dropPsiCaches();
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
            UsageTrigger.trigger((String)"spring.SpringInactiveProfilesAnnotator.activateProfile");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$MyLocalQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$MyLocalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

