/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.model.custom.ComponentScanExtender;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringCdiNamed;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringManagedBean;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringJamModelImpl
extends SpringJamModel {
    private final Module myModule;
    private final JamService myJamService;

    public SpringJamModelImpl(@NotNull Module module) {
        if (module == null) {
            SpringJamModelImpl.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myJamService = JamService.getJamService((Project)this.myModule.getProject());
    }

    @NotNull
    public List<SpringStereotypeElement> getStereotypeComponents() {
        Project project = this.myModule.getProject();
        if (DumbService.isDumb((Project)project)) {
            List<SpringStereotypeElement> list = Collections.emptyList();
            if (list == null) {
                SpringJamModelImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, () -> {
            List<SpringStereotypeElement> components = this.getStereotypeComponents(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
            return CachedValueProvider.Result.create(components, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<SpringStereotypeElement> getStereotypeComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(3);
        }
        ArrayList<SpringStereotypeElement> stereotypeElements = new ArrayList<SpringStereotypeElement>();
        stereotypeElements.addAll(this.getComponents(scope));
        stereotypeElements.addAll(this.getControllers(scope));
        stereotypeElements.addAll(this.getRepositories(scope));
        stereotypeElements.addAll(this.getServices(scope));
        stereotypeElements.addAll(this.getConfigurations(scope));
        stereotypeElements.addAll(this.getCdiNamed(scope));
        stereotypeElements.addAll(this.getManagedBeans(scope));
        stereotypeElements.addAll(this.getCustomStereotypeComponents(scope));
        stereotypeElements.addAll(this.getStereotypeComponentExtensions(scope));
        ArrayList<SpringStereotypeElement> arrayList = stereotypeElements;
        if (arrayList == null) {
            SpringJamModelImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private List<CustomSpringComponent> getCustomStereotypeComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(5);
        }
        SmartList customSpringComponents = new SmartList();
        for (String anno : JamAnnotationTypeUtil.getInstance((Module)this.myModule).getUserDefinedCustomComponentAnnotations()) {
            customSpringComponents.addAll(this.myJamService.getJamClassElements(CustomSpringComponent.JAM_KEY, anno, scope));
        }
        return customSpringComponents;
    }

    private List<SpringStereotypeElement> getStereotypeComponentExtensions(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(6);
        }
        SmartList stereotypeElements = new SmartList();
        for (ComponentScanExtender extender : (ComponentScanExtender[])Extensions.getExtensions((ExtensionPointName)ComponentScanExtender.EP_NAME)) {
            stereotypeElements.addAll(extender.getComponents(scope, this.myModule.getProject()));
        }
        return stereotypeElements;
    }

    @NotNull
    private List<SpringComponent> getComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(7);
        }
        List list = this.myJamService.getJamClassElements((JamMemberMeta)SpringComponent.META, "org.springframework.stereotype.Component", scope);
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private List<SpringCdiNamed> getCdiNamed(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(9);
        }
        List list = this.myJamService.getJamClassElements(SpringCdiNamed.META, "javax.inject.Named", scope);
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private List<SpringController> getControllers(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(11);
        }
        List controllers = ContainerUtil.newSmartList();
        Collection controllerAnnotations = (Collection)SpringController.getControllerAnnotations().fun((Object)this.myModule);
        for (String anno : controllerAnnotations) {
            controllers.addAll(this.myJamService.getJamClassElements((JamMemberMeta)SpringController.META, anno, scope));
        }
        List list = controllers;
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    private List<SpringRepository> getRepositories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(13);
        }
        List repositories = ContainerUtil.newSmartList();
        Collection repositoryAnnotations = (Collection)SpringRepository.getRepositoryAnnotations().fun((Object)this.myModule);
        for (String anno : repositoryAnnotations) {
            repositories.addAll(this.myJamService.getJamClassElements(SpringRepository.META, anno, scope));
        }
        return repositories;
    }

    @NotNull
    private List<SpringService> getServices(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(14);
        }
        List services = ContainerUtil.newSmartList();
        Collection serviceAnnotations = (Collection)SpringService.getServiceAnnotations().fun((Object)this.myModule);
        for (String anno : serviceAnnotations) {
            services.addAll(this.myJamService.getJamClassElements((JamMemberMeta)SpringService.META, anno, scope));
        }
        List list = services;
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private List<SpringManagedBean> getManagedBeans(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(16);
        }
        List list = this.myJamService.getJamClassElements(SpringManagedBean.META, "javax.annotation.ManagedBean", scope);
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public List<SpringConfiguration> getConfigurations(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringJamModelImpl.$$$reportNull$$$0(18);
        }
        if (DumbService.isDumb((Project)this.myModule.getProject())) {
            List<SpringConfiguration> list = Collections.emptyList();
            if (list == null) {
                SpringJamModelImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        List configurations = ContainerUtil.newSmartList();
        Collection configurationAnnotations = (Collection)SpringConfiguration.getAnnotations().fun((Object)this.myModule);
        for (String anno : configurationAnnotations) {
            configurations.addAll(this.myJamService.getJamClassElements((JamMemberMeta)SpringConfiguration.META, anno, scope));
        }
        List list = configurations;
        if (list == null) {
            SpringJamModelImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/SpringJamModelImpl";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/SpringJamModelImpl";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypeComponents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCdiNamed";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagedBeans";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeComponents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomStereotypeComponents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeComponentExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCdiNamed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getControllers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getManagedBeans";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

