/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.SpringTestingDirtiesContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringTestingDirtiesContextInspection
extends BaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (aClass == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass)) == null || !SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
        SpringTestingDirtiesContext dirtiesContext = (SpringTestingDirtiesContext)SpringTestingDirtiesContext.CLASS_META.getJamElement((PsiModifierListOwner)aClass);
        if (dirtiesContext != null) {
            SpringTestingDirtiesContextInspection.checkMethodModeOnClass(holder, dirtiesContext);
            SpringTestingDirtiesContextInspection.checkHierarchyMode(aClass, holder, dirtiesContext);
        }
        for (PsiMethod method : aClass.getMethods()) {
            SpringTestingDirtiesContext methodDirties = (SpringTestingDirtiesContext)SpringTestingDirtiesContext.METHOD_META.getJamElement((PsiModifierListOwner)method);
            if (methodDirties == null) continue;
            SpringTestingDirtiesContextInspection.checkHierarchyMode(aClass, holder, methodDirties);
            SpringTestingDirtiesContextInspection.checkClassModeOnMethod(holder, methodDirties);
        }
        return holder.getResultsArray();
    }

    private static void checkMethodModeOnClass(ProblemsHolder holder, SpringTestingDirtiesContext dirtiesContext) {
        PsiAnnotationMemberValue psiElement;
        JamEnumAttributeElement methodModeElement = dirtiesContext.getMethodModeElement();
        if (methodModeElement.getValue() != null && (psiElement = methodModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.method.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkClassModeOnMethod(ProblemsHolder holder, SpringTestingDirtiesContext methodDirties) {
        PsiAnnotationMemberValue psiElement;
        JamEnumAttributeElement methodModeElement = methodDirties.getClassModeElement();
        if (methodModeElement.getValue() != null && (psiElement = methodModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.class.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkHierarchyMode(@Nullable PsiClass aClass, ProblemsHolder holder, @NotNull SpringTestingDirtiesContext dirtiesContext) {
        PsiAnnotationMemberValue psiElement;
        if (dirtiesContext == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(2);
        }
        if (aClass == null) {
            return;
        }
        JamEnumAttributeElement hierarchyModeElement = dirtiesContext.getHierarchyModeElement();
        if (hierarchyModeElement.getValue() != null && SpringContextHierarchy.META.getJamElement((PsiModifierListOwner)aClass) == null && (psiElement = hierarchyModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.hierarchy.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringTestingDirtiesContextInspection" == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(3);
        }
        return "SpringTestingDirtiesContextInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtiesContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/SpringTestingDirtiesContextInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/SpringTestingDirtiesContextInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkHierarchyMode";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

