/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.SpringDiagramCategoryManager;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdge;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdgeCreationUtil;
import com.intellij.spring.perspectives.diagrams.SpringDiagramNode;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.beans.UserDefinedClassWrapper;
import com.intellij.spring.perspectives.diagrams.edges.ByConstructorAutowire;
import com.intellij.spring.perspectives.diagrams.edges.ByNameAutowire;
import com.intellij.spring.perspectives.diagrams.edges.ByTypeAutowire;
import com.intellij.spring.perspectives.diagrams.edges.DependsOnEdge;
import com.intellij.spring.perspectives.diagrams.edges.FactoryBeanEdge;
import com.intellij.spring.perspectives.diagrams.edges.InjectionEdge;
import com.intellij.spring.perspectives.diagrams.edges.LookupMethodEdge;
import com.intellij.spring.perspectives.diagrams.edges.ParentBeanEdge;
import com.intellij.spring.perspectives.diagrams.edges.ScannedBeanEdge;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.events.DomEvent;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramDataModel
extends DiagramDataModel<SpringElementWrapper> {
    private static final Key<Boolean> PROCESSED_KEY = Key.create((String)"PROCESSED_KEY");
    private final SpringElementWrapper myElement;
    private final Collection<DiagramNode<SpringElementWrapper>> myNodes = ContainerUtil.newLinkedHashSet();
    private final Collection<DiagramEdge<SpringElementWrapper>> myEdges = ContainerUtil.newLinkedHashSet();
    private final Collection<SpringElementWrapper> myRemovedNodes = ContainerUtil.newLinkedHashSet();
    private final ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter;
    private CommonSpringModel myApplicationModel;

    public SpringDiagramDataModel(Project project, DiagramProvider<SpringElementWrapper> springBaseBeanPointerDiagramProvider, @Nullable SpringElementWrapper element) {
        super(project, springBaseBeanPointerDiagramProvider);
        this.myElement = element;
        DomEventListener domEventListener = new DomEventListener(){

            public void eventOccured(DomEvent event) {
                SpringDiagramDataModel.this.incModificationCount();
            }
        };
        DomManager.getDomManager((Project)project).addDomEventListener(domEventListener, (Disposable)this);
        this.myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetConfigurationChanged(SpringFacet facet) {
                SpringDiagramDataModel.this.incModificationCount();
            }

            public void facetRemoved(SpringFacet facet) {
                SpringDiagramDataModel.this.incModificationCount();
            }

            public void facetAdded(SpringFacet facet) {
                SpringDiagramDataModel.this.incModificationCount();
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).registerListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter, (Disposable)this);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                SpringDiagramDataModel.this.incModificationCount();
            }
        });
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        messageBusConnection.subscribe(ProjectTopics.MODULES);
    }

    @NotNull
    public Collection<DiagramNode<SpringElementWrapper>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<SpringElementWrapper>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<SpringElementWrapper> n) {
        SpringElementWrapper identifyingElement = (SpringElementWrapper)n.getIdentifyingElement();
        if (identifyingElement instanceof SpringBeanPointerWrapper) {
            SpringBeanPointer beanPointer = (SpringBeanPointer)((SpringBeanPointerWrapper)identifyingElement).getWrapped();
            String string = beanPointer.isValid() ? SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)beanPointer) : "";
            if (string == null) {
                SpringDiagramDataModel.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = identifyingElement.getName();
        if (string == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> getOrCreateElement(SpringBeanPointer beanPointer) {
        DiagramNode<SpringElementWrapper> target = this.getNode(beanPointer);
        if (target == null) {
            target = this.addNode(beanPointer);
        }
        return target;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> addNode(SpringBeanPointer element) {
        return element == null ? null : this.addNode((SpringElementWrapper)SpringBeanPointerWrapper.create((SpringBeanPointer)element));
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> addNode(SpringElementWrapper beanPointerWrapper) {
        if (this.myRemovedNodes.contains(beanPointerWrapper)) {
            return null;
        }
        SpringDiagramNode node = new SpringDiagramNode(beanPointerWrapper, this.getProvider());
        if (!this.myNodes.contains(node)) {
            this.myNodes.add((DiagramNode<SpringElementWrapper>)node);
        }
        return node;
    }

    public DiagramNode<SpringElementWrapper> addElement(SpringElementWrapper element) {
        if (element instanceof UserDefinedClassWrapper) {
            LocalXmlModel localXmlModel;
            DomFileElement root;
            PsiClass wrapped = (PsiClass)((UserDefinedClassWrapper)element).getWrapped();
            CommonSpringModel model = this.getApplicationModel(true);
            if (model instanceof LocalXmlModel && (root = (localXmlModel = (LocalXmlModel)model).getRoot()) != null) {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{localXmlModel.getConfig()})) {
                    return null;
                }
                Beans beans = (Beans)root.getRootElement();
                SpringBean springBean = beans.addBean();
                springBean.getClazz().setStringValue(wrapped.getQualifiedName());
                Project project = wrapped.getProject();
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.FIELD, null, null, (PsiType)PsiTypesUtil.getClassType((PsiClass)wrapped));
                for (String beanName : info.names) {
                    if (SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName) != null) continue;
                    springBean.getId().setStringValue(beanName);
                }
                SpringBean stableCopy = (SpringBean)springBean.createStableCopy();
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(psiDocumentManager.getDocument(((XmlFile)localXmlModel.getConfig()).getContainingFile()));
                SpringBeanPointer pointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)stableCopy);
                return this.addNode(pointer);
            }
        }
        return this.addNode(element);
    }

    public void refreshDataModel() {
        if (DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        this.clearAll();
        this.updateDataModel();
    }

    protected void updateDataModel() {
        DiagramState diagramState = new DiagramState(this.getBuilder());
        this.myApplicationModel = this.getApplicationModel(diagramState.isCategoryEnabled(SpringDiagramCategoryManager.LOCAL));
        if (this.myApplicationModel == null) {
            return;
        }
        Collection pointers = this.myApplicationModel.getAllCommonBeans();
        THashSet pointerSet = new THashSet(pointers);
        for (SpringBeanPointer pointer : pointers) {
            DiagramNode<SpringElementWrapper> sourceNode = this.getOrCreateElement(pointer);
            if (sourceNode == null) continue;
            this.processDependencies(this.myApplicationModel, (Set<SpringBeanPointer>)pointerSet, pointer, sourceNode);
        }
    }

    protected void processDependencies(@NotNull CommonSpringModel model, @NotNull Set<SpringBeanPointer> pointerSet, @NotNull SpringBeanPointer pointer, @NotNull DiagramNode<SpringElementWrapper> node) {
        if (model == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(4);
        }
        if (pointerSet == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(5);
        }
        if (pointer == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(6);
        }
        if (node == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(7);
        }
        if (this.isProcessed(node)) {
            return;
        }
        SpringDiagramDataModel.setProcessed(node);
        CommonSpringBean springBean = pointer.getSpringBean();
        if (springBean instanceof SpringBean) {
            this.addSpringBeanDependencies(node, pointer, model, pointerSet);
        } else if (springBean instanceof CollectionElements) {
            this.addCollectionElements(node, pointer, pointerSet, model);
        } else if (springBean instanceof DomSpringBean) {
            this.addPointedDependencies(node, pointer, pointerSet, model);
        }
        this.addComponentScanDependencies(node, pointer, model, pointerSet);
        this.addAnnotatedAutowiring(node, springBean, model);
    }

    private void addCollectionElements(DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer pointer, Set<SpringBeanPointer> modelBeans, CommonSpringModel model) {
        CommonSpringBean springBean = pointer.getSpringBean();
        if (springBean instanceof CollectionElements) {
            LinkedHashMap<SpringBeanPointer, DomElement> beans = new LinkedHashMap<SpringBeanPointer, DomElement>();
            SpringPropertyUtils.addCollectionReferences((CollectionElements)((CollectionElements)springBean), beans);
            this.handleBeanMap(sourceNode, model, modelBeans, beans);
        }
    }

    private void addSpringBeanDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer springBeanPointer, CommonSpringModel model, Set<SpringBeanPointer> modelBeans) {
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(8);
        }
        this.addInjectedDependencies(sourceNode, springBeanPointer, model, modelBeans);
        this.addLookupMethodInjectedDependencies(sourceNode, springBeanPointer, modelBeans);
        this.addFactoryBeanDependencies(sourceNode, springBeanPointer, modelBeans);
        this.addParentBeanDependencies(sourceNode, springBeanPointer, modelBeans);
        this.addDependsOnDependencies(sourceNode, springBeanPointer);
        this.addAutowiredDependencies(sourceNode, springBeanPointer, model);
    }

    private void addComponentScanDependencies(DiagramNode<SpringElementWrapper> node, SpringBeanPointer pointer, CommonSpringModel model, Set<SpringBeanPointer> beans) {
        Module module = model.getModule();
        if (module == null) {
            return;
        }
        CommonSpringBean commonSpringBean = pointer.getSpringBean();
        if (commonSpringBean instanceof SpringBeansPackagesScanBean) {
            for (CommonSpringBean bean : ((SpringBeansPackagesScanBean)commonSpringBean).getScannedElements(module)) {
                SpringBeanPointer targetPointer = BeanService.getInstance().createSpringBeanPointer(bean);
                DiagramNode<SpringElementWrapper> targetNode = this.getNode(targetPointer);
                if (targetNode == null) {
                    targetNode = this.addNode(targetPointer);
                }
                if (targetNode == null) continue;
                this.processDependencies(model, beans, targetPointer, targetNode);
                this.addEdge(new ScannedBeanEdge(node, targetNode));
            }
        }
    }

    private void addPointedDependencies(final DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer springBeanPointer, final Set<SpringBeanPointer> pointerSet, final CommonSpringModel model) {
        CommonSpringBean springBean = springBeanPointer.getSpringBean();
        if (SpringDiagramDataModel.isCustomSchemaBean(springBean)) {
            ((DomSpringBean)springBean).acceptChildren(new DomElementVisitor(){

                public void visitDomElement(DomElement element) {
                    if (element instanceof SpringBean && DomUtil.hasXml((DomElement)element)) {
                        SpringBeanPointer pointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)((SpringBean)element));
                        DiagramNode<SpringElementWrapper> targetNode = SpringDiagramDataModel.this.getNode(pointer);
                        if (targetNode == null) {
                            targetNode = SpringDiagramDataModel.this.addNode(pointer);
                        }
                        if (targetNode != null) {
                            SpringDiagramDataModel.this.processDependencies(model, pointerSet, pointer, targetNode);
                            SpringDiagramDataModel.this.addEdge((SpringDiagramEdge)new InjectionEdge((DiagramNode<SpringElementWrapper>)sourceNode, targetNode, element));
                        }
                    } else if (element instanceof GenericAttributeValue && DomUtil.hasXml((DomElement)element)) {
                        SpringBeanPointer beanPointer;
                        DiagramNode<SpringElementWrapper> target;
                        Object pointer = ((GenericDomValue)element).getValue();
                        if (pointer instanceof SpringBeanPointer && (target = SpringDiagramDataModel.this.getOrCreateElement(beanPointer = (SpringBeanPointer)pointer)) != null) {
                            XmlAttribute xmlAttribute = ((GenericAttributeValue)element).getXmlAttribute();
                            String attrName = xmlAttribute != null ? xmlAttribute.getLocalName() : null;
                            SpringDiagramDataModel.this.addEdge((SpringDiagramEdge)new InjectionEdge((DiagramNode<SpringElementWrapper>)sourceNode, target, element, attrName));
                        }
                    } else if (element instanceof SpringValueHolderDefinition) {
                        SpringDiagramDataModel.this.addSpringValueHolderDependencies((DiagramNode<SpringElementWrapper>)sourceNode, pointerSet, (SpringValueHolderDefinition)element, model);
                    } else {
                        List children = DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)true);
                        for (DomElement child : children) {
                            child.accept((DomElementVisitor)this);
                        }
                    }
                }
            });
        }
    }

    private void addEdge(@Nullable DiagramNode<SpringElementWrapper> source, @Nullable DiagramNode<SpringElementWrapper> target, @NotNull SpringDependencyType info) {
        if (info == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(9);
        }
        this.addEdge(source, target, info, null);
    }

    private void addEdge(@Nullable DiagramNode<SpringElementWrapper> source, @Nullable DiagramNode<SpringElementWrapper> target, @NotNull SpringDependencyType info, @Nullable String customInfo) {
        if (info == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(10);
        }
        if (source != null && target != null) {
            this.addEdge(new SpringDiagramEdge(source, target, info, customInfo));
        }
    }

    private void addEdge(SpringDiagramEdge edge) {
        if (!this.myEdges.contains(edge)) {
            this.myEdges.add((DiagramEdge<SpringElementWrapper>)edge);
        }
    }

    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getJavaStructureModificationCount();
    }

    private static boolean isCustomSchemaBean(CommonSpringBean springBean) {
        return springBean instanceof DomSpringBean && !(springBean instanceof SpringBean);
    }

    private void addAutowiredDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer springBeanPointer, CommonSpringModel model) {
        PsiClass beanClass;
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(11);
        }
        if ((beanClass = springBeanPointer.getBeanClass()) == null) {
            return;
        }
        SpringBean springBean = (SpringBean)springBeanPointer.getSpringBean();
        if (SpringAutowireUtil.isByTypeAutowired(springBean)) {
            this.addByTypeAutowireDependencies(sourceNode, springBeanPointer, model);
        } else if (SpringAutowireUtil.isByNameAutowired(springBean)) {
            this.addByNameAutowireDependencies(sourceNode, springBeanPointer);
        } else if (SpringAutowireUtil.isConstructorAutowire(springBean)) {
            this.addConstructorAutowireDependencies(sourceNode, springBeanPointer, model);
        }
    }

    private void addAnnotatedAutowiring(@NotNull DiagramNode<SpringElementWrapper> sourceNode, CommonSpringBean commonSpringBean, CommonSpringModel model) {
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(12);
        }
        Map<PsiMember, Set<SpringBeanPointer>> map = SpringAutowireUtil.getAutowireAnnotationProperties(commonSpringBean, model);
        for (Map.Entry<PsiMember, Set<SpringBeanPointer>> entry : map.entrySet()) {
            PsiMember member = entry.getKey();
            Set<SpringBeanPointer> springBeans = entry.getValue();
            for (SpringBeanPointer bean : springBeans) {
                DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(bean);
                if (targetNode == null) continue;
                this.addEdge(sourceNode, targetNode, SpringDiagramDataModel.getAnnotatedAutowireType(member));
            }
        }
    }

    private static SpringDependencyType getAnnotatedAutowireType(PsiMember member) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, Collections.singleton("javax.annotation.Resource"))) {
            return SpringDependencyType.ANNO_RESOURCE_AUTOWIRED;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, Collections.singleton("javax.inject.Inject"))) {
            return SpringDependencyType.ANNO_INJECT_AUTOWIRED;
        }
        return SpringDependencyType.ANNO_AUTOWIRED;
    }

    private void addConstructorAutowireDependencies(DiagramNode<SpringElementWrapper> sourceNode, @NotNull SpringBeanPointer beanPointer, CommonSpringModel model) {
        if (beanPointer == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(13);
        }
        Map<PsiType, Collection<SpringBeanPointer>> autowiredProperties = SpringAutowireUtil.getConstructorAutowiredProperties((SpringBean)beanPointer.getSpringBean(), model);
        for (Collection<SpringBeanPointer> springBeans : autowiredProperties.values()) {
            for (SpringBeanPointer bean : springBeans) {
                DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(bean);
                if (targetNode == null) continue;
                this.addEdge(new ByConstructorAutowire(sourceNode, targetNode));
            }
        }
    }

    private void addByNameAutowireDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer springBean) {
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(14);
        }
        Map<PsiMethod, SpringBeanPointer> autowiredProperties = SpringAutowireUtil.getByNameAutowiredProperties((SpringBean)springBean.getSpringBean());
        for (SpringBeanPointer bean : autowiredProperties.values()) {
            DiagramNode<SpringElementWrapper> targetNode;
            if (bean == null || (targetNode = this.getOrCreateElement(bean)) == null) continue;
            this.addEdge(new ByNameAutowire(sourceNode, targetNode));
        }
    }

    private void addByTypeAutowireDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer beanPointer, CommonSpringModel processor) {
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(15);
        }
        Map<PsiMethod, Collection<SpringBeanPointer>> autowiredProperties = SpringAutowireUtil.getByTypeAutowiredProperties((SpringBean)beanPointer.getSpringBean(), processor);
        for (Collection<SpringBeanPointer> springBeans : autowiredProperties.values()) {
            for (SpringBeanPointer bean : springBeans) {
                DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(bean);
                if (targetNode == null) continue;
                this.addEdge(new ByTypeAutowire(sourceNode, targetNode));
            }
        }
    }

    private void addParentBeanDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer springBeanPointer, Set<SpringBeanPointer> modelBeans) {
        DiagramNode<SpringElementWrapper> targetNode;
        GenericAttributeValue parentBean;
        SpringBeanPointer parentBeanValue;
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(16);
        }
        if ((parentBeanValue = (SpringBeanPointer)(parentBean = ((SpringBean)springBeanPointer.getSpringBean()).getParentBean()).getValue()) == null) {
            return;
        }
        SpringBeanPointer parentBeanPointer = parentBeanValue.getBasePointer();
        if (modelBeans.contains(parentBeanPointer) && (targetNode = this.getOrCreateElement(parentBeanPointer)) != null) {
            this.addEdge((SpringDiagramEdge)new ParentBeanEdge(sourceNode, targetNode, (DomElement)parentBean));
        }
    }

    private void addDependsOnDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer springBeanPointer) {
        SpringBean bean;
        GenericAttributeValue dependsOn;
        List dependsOnBeanPointer;
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(17);
        }
        if ((dependsOnBeanPointer = (List)(dependsOn = (bean = (SpringBean)springBeanPointer.getSpringBean()).getDependsOn()).getValue()) != null) {
            for (SpringBeanPointer dependsOnBean : dependsOnBeanPointer) {
                SpringBeanPointer pointer;
                DiagramNode<SpringElementWrapper> targetNode;
                if (dependsOnBean == null || (targetNode = this.getOrCreateElement(pointer = dependsOnBean.getBasePointer())) == null) continue;
                this.addEdge((SpringDiagramEdge)new DependsOnEdge(sourceNode, targetNode, (DomElement)dependsOn));
            }
        }
    }

    private void addFactoryBeanDependencies(@NotNull DiagramNode<SpringElementWrapper> node, SpringBeanPointer springBeanPointer, Set<SpringBeanPointer> modelBeans) {
        DiagramNode<SpringElementWrapper> source;
        GenericAttributeValue factoryBean;
        SpringBeanPointer factoryBeanValue;
        if (node == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(18);
        }
        if ((factoryBeanValue = (SpringBeanPointer)(factoryBean = ((SpringBean)springBeanPointer.getSpringBean()).getFactoryBean()).getValue()) == null) {
            return;
        }
        SpringBeanPointer factoryBeanPointer = factoryBeanValue.getBasePointer();
        if (modelBeans.contains(factoryBeanPointer) && (source = this.getOrCreateElement(factoryBeanPointer)) != null) {
            this.addEdge((SpringDiagramEdge)new FactoryBeanEdge(source, node, (DomElement)factoryBean));
        }
    }

    private void addInjectedDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer pointer, CommonSpringModel model, Set<SpringBeanPointer> modelBeans) {
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(19);
        }
        for (SpringValueHolderDefinition valueHolderDefinition : SpringPropertyUtils.getValueHolders((CommonSpringBean)pointer.getSpringBean())) {
            this.addSpringValueHolderDependencies(sourceNode, modelBeans, valueHolderDefinition, model);
        }
    }

    private void addSpringValueHolderDependencies(DiagramNode<SpringElementWrapper> sourceNode, Set<SpringBeanPointer> modelBeans, SpringValueHolderDefinition valueHolderDefinition, CommonSpringModel model) {
        this.handleBeanMap(sourceNode, model, modelBeans, SpringPropertyUtils.getValueHolderDependencies((SpringValueHolderDefinition)valueHolderDefinition));
    }

    private void handleBeanMap(DiagramNode<SpringElementWrapper> sourceNode, CommonSpringModel model, Set<SpringBeanPointer> modelBeans, Map<SpringBeanPointer, DomElement> beanMap) {
        for (Map.Entry<SpringBeanPointer, DomElement> entry : beanMap.entrySet()) {
            SpringBeanPointer bean = entry.getKey();
            DomElement identifyingElement = entry.getValue();
            if (!SpringDiagramDataModel.modelBeansContain(modelBeans, bean)) continue;
            DiagramNode<SpringElementWrapper> targetNode = this.getNode(bean);
            if (targetNode == null) {
                targetNode = this.addNode(bean);
            }
            if (targetNode == null) continue;
            this.processDependencies(model, modelBeans, bean, targetNode);
            this.addEdge((SpringDiagramEdge)new InjectionEdge(sourceNode, targetNode, identifyingElement));
        }
    }

    private static void setProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
        if (targetNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(20);
        }
        targetNode.putUserData(PROCESSED_KEY, (Object)true);
    }

    protected boolean isProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
        Boolean isProcessed;
        if (targetNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(21);
        }
        return (isProcessed = (Boolean)targetNode.getUserData(PROCESSED_KEY)) != null && isProcessed != false;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> getNode(@NotNull SpringBeanPointer bean) {
        if (bean == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(22);
        }
        for (DiagramNode<SpringElementWrapper> node : this.myNodes) {
            if (!bean.equals(((SpringElementWrapper)node.getIdentifyingElement()).getWrapped())) continue;
            return node;
        }
        return null;
    }

    private static boolean modelBeansContain(Collection<SpringBeanPointer> modelBeans, SpringBeanPointer bean) {
        if (modelBeans.contains(bean)) {
            return true;
        }
        CommonSpringBean commonSpringBean = bean.getSpringBean();
        if (commonSpringBean instanceof DomSpringBean) {
            for (DomSpringBean parent = (DomSpringBean)((DomSpringBean)commonSpringBean).getParentOfType(DomSpringBean.class, true); parent != null; parent = (DomSpringBean)parent.getParentOfType(DomSpringBean.class, true)) {
                SpringBeanPointer beanPointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)parent);
                if (!modelBeans.contains(beanPointer)) continue;
                return true;
            }
        }
        return false;
    }

    private void addLookupMethodInjectedDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer beanPointer, Set<SpringBeanPointer> modelBeans) {
        CommonSpringBean springBean;
        if (sourceNode == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(23);
        }
        if ((springBean = beanPointer.getSpringBean()) instanceof SpringBean) {
            for (LookupMethod method : ((SpringBean)springBean).getLookupMethods()) {
                DiagramNode<SpringElementWrapper> targetNode;
                SpringBeanPointer pointer;
                GenericAttributeValue bean = method.getBean();
                SpringBeanPointer beanValue = (SpringBeanPointer)bean.getValue();
                if (beanValue == null || !modelBeans.contains(pointer = beanValue.getBasePointer()) || (targetNode = this.getOrCreateElement(pointer)) == null) continue;
                this.addEdge((SpringDiagramEdge)new LookupMethodEdge(sourceNode, targetNode, (DomElement)bean));
            }
        }
    }

    @Nullable
    public CommonSpringModel getApplicationModel(boolean isLocalModel) {
        return this.myElement == null ? null : this.myElement.getProcessingSpringModel(isLocalModel);
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SpringDiagramDataModel springDiagramDataModel = this;
        if (springDiagramDataModel == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(24);
        }
        return springDiagramDataModel;
    }

    public void dispose() {
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).unregisterListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter);
    }

    public DiagramEdge<SpringElementWrapper> createEdge(@NotNull DiagramNode<SpringElementWrapper> from, @NotNull DiagramNode<SpringElementWrapper> to) {
        DiagramEdge<SpringElementWrapper> edge;
        if (from == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(25);
        }
        if (to == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(26);
        }
        if ((edge = SpringDiagramEdgeCreationUtil.createEdge(from, to, this.myEdges, this.getBuilder(), this.myApplicationModel)) != null) {
            this.myEdges.add(edge);
        }
        return edge;
    }

    public void removeNode(DiagramNode<SpringElementWrapper> node) {
        this.myRemovedNodes.add((SpringElementWrapper)node.getIdentifyingElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSpringBeanDependencies";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotatedAutowiring";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addConstructorAutowireDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addByNameAutowireDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addByTypeAutowireDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addParentBeanDependencies";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addDependsOnDependencies";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addFactoryBeanDependencies";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedDependencies";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setProcessed";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isProcessed";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addLookupMethodInjectedDependencies";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

