/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.TypePresentationService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringBeanScopeManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBeanScopeReference
extends PsiReferenceBase<PsiLiteralExpression> {
    private static final List<String> DEFAULT_SCOPE_NAMES = ContainerUtil.map((Object[])SpringBeanScope.getDefaultScopes(), SpringBeanScope::getValue);

    public SpringBeanScopeReference(PsiLiteralExpression element) {
        super((PsiElement)element);
    }

    public PsiElement resolve() {
        Object value = ((PsiLiteralExpression)this.getElement()).getValue();
        if (value instanceof String) {
            if (DEFAULT_SCOPE_NAMES.contains(value)) {
                return this.getElement();
            }
            for (SpringBeanScope beanScope : SpringBeanScopeManager.getInstance().getCustomBeanScopes(this.getElement())) {
                if (!value.equals(beanScope.getValue())) continue;
                return this.getElement();
            }
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(DEFAULT_SCOPE_NAMES.size());
        for (String scope : DEFAULT_SCOPE_NAMES) {
            variants.add(SpringBeanScopeReference.getLookupElement(scope));
        }
        for (SpringBeanScope beanScope : SpringBeanScopeManager.getInstance().getCustomBeanScopes(this.getElement())) {
            variants.add(SpringBeanScopeReference.getLookupElement(beanScope.getValue()));
        }
        Object[] objectArray = variants.toArray(new LookupElement[variants.size()]);
        if (objectArray == null) {
            SpringBeanScopeReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    private static LookupElementBuilder getLookupElement(String scope) {
        return LookupElementBuilder.create((String)scope).withIcon(TypePresentationService.getService().getTypeIcon(SpringBeanScope.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringBeanScopeReference", "getVariants"));
    }
}

