/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.references.SpringQualifierNameReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringQualifierNameContributor
extends PsiReferenceContributor {
    private static final Key<PsiElement> PSI_ELEMENT_KEY = Key.create((String)"psiElement");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringQualifierNameContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().with(SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION)).save(PSI_ELEMENT_KEY)).annotationParam((ElementPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>("customSpringAnno"){

            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (s.equals("javax.inject.Named")) {
                    return false;
                }
                PsiElement element = (PsiElement)context.get(PSI_ELEMENT_KEY);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    return false;
                }
                if (SpringQualifierNameContributor.isQualifierAnnotation(s, "org.springframework.beans.factory.annotation.Qualifier", module)) {
                    return true;
                }
                return SpringQualifierNameContributor.isQualifierAnnotation(s, "javax.inject.Qualifier", module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/references/SpringQualifierNameContributor$1", "accepts"));
            }
        }), "value"), (PsiReferenceProvider)new SpringQualifierNameReferenceProvider());
    }

    private static boolean isQualifierAnnotation(@NotNull String anno, @NotNull String qualifierAnno, @NotNull Module module) {
        if (anno == null) {
            SpringQualifierNameContributor.$$$reportNull$$$0(1);
        }
        if (qualifierAnno == null) {
            SpringQualifierNameContributor.$$$reportNull$$$0(2);
        }
        if (module == null) {
            SpringQualifierNameContributor.$$$reportNull$$$0(3);
        }
        Collection classes = JamAnnotationTypeUtil.getInstance((Module)module).getAnnotationTypesWithChildren(qualifierAnno);
        for (PsiClass qualifierAnnoClass : classes) {
            if (!anno.equals(qualifierAnnoClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierAnno";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/references/SpringQualifierNameContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isQualifierAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

