/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.codeInspection.htmlInspections.HtmlDeprecatedTagInspection;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithAnotherAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithCssAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlPresentationalElementInspection
extends HtmlLocalInspectionTool {
    @NonNls
    private static final Set<String> ourHtmlReplacableTags = new HashSet();
    @NonNls
    private static final Set<String> ourCssReplacableTags;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.presentational.tag", (Object[])new Object[0]);
        if (string == null) {
            HtmlPresentationalElementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("HtmlPresentationalElement" == null) {
            HtmlPresentationalElementInspection.$$$reportNull$$$0(1);
        }
        return "HtmlPresentationalElement";
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlPresentationalElementInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            HtmlPresentationalElementInspection.$$$reportNull$$$0(3);
        }
        String name = tag.getName().toLowerCase();
        if (HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            if (HtmlUtil.isHtml5Context((XmlElement)tag)) {
                return;
            }
            LocalQuickFix[] fixes = null;
            if (ourCssReplacableTags.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithCssAction(name)};
                if (ourHtmlReplacableTags.contains(name)) {
                    fixes = new LocalQuickFix[]{fixes[0], new ReplaceHtmlTagWithAnotherAction(name)};
                }
            } else if (ourHtmlReplacableTags.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithAnotherAction(name)};
            }
            HtmlDeprecatedTagInspection.registerTag(tag, "html.inspections.check.presentational.tag", holder, fixes, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    static {
        ourHtmlReplacableTags.addAll(Arrays.asList("i", "b", "tt"));
        ourCssReplacableTags = new HashSet();
        ourCssReplacableTags.addAll(Arrays.asList("i", "b", "big", "small", "tt"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlPresentationalElementInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlPresentationalElementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

