/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class LobInfo<T extends LobInfo>
implements Comparable<T>,
Serializable {
    public static final int MAX_ARRAY_SIZE = 100;
    public final long length;

    public LobInfo(long length) {
        this.length = length;
    }

    public boolean isTruncated() {
        return this.length != this.getLoadedDataLength();
    }

    protected abstract long getLoadedDataLength();

    @Override
    public int compareTo(T o) {
        return Comparing.compare((long)this.length, (long)((LobInfo)o).length);
    }

    public static void freeLob(Clob lob) {
        try {
            lob.free();
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    public static void freeLob(Blob lob) {
        try {
            lob.free();
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromClob(Clob lob, int maxLobLength) throws Exception {
        try {
            int subLength;
            long length = lob.length();
            int n = subLength = (long)maxLobLength < length ? maxLobLength : (int)length;
            ClobInfo clobInfo = new ClobInfo(length, length != (long)subLength && subLength <= 0 ? null : (subLength > 0 ? lob.getSubString(1L, subLength) : ""));
            return clobInfo;
        }
        finally {
            LobInfo.freeLob(lob);
        }
    }

    public static Object fromString(String string, int maxLobLength) {
        int subLength;
        int length = string.length();
        int n = subLength = maxLobLength < length ? maxLobLength : length;
        return subLength == length ? string : new ClobInfo(length, subLength <= 0 ? null : string.substring(0, subLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromBlob(Blob lob, int maxLobLength) throws Exception {
        try {
            int subLength;
            long length = lob.length();
            int n = subLength = (long)maxLobLength < length ? maxLobLength : (int)length;
            BlobInfo blobInfo = new BlobInfo(length, length != (long)subLength && subLength <= 0 ? null : (subLength > 0 ? lob.getBytes(1L, subLength) : ArrayUtilRt.EMPTY_BYTE_ARRAY));
            return blobInfo;
        }
        finally {
            LobInfo.freeLob(lob);
        }
    }

    public static Object fromByteArray(byte[] data, int maxLobLength) {
        Object object;
        int subLength;
        int length = data.length;
        int n = subLength = maxLobLength < length ? maxLobLength : length;
        if (subLength == length) {
            object = data;
        } else {
            BlobInfo blobInfo;
            object = blobInfo;
            blobInfo = new BlobInfo(length, subLength <= 0 ? null : ArrayUtil.realloc((byte[])data, (int)subLength));
        }
        return object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LobInfo)) {
            return false;
        }
        LobInfo info = (LobInfo)o;
        return !this.isTruncated() && !info.isTruncated() && this.length == info.length;
    }

    public int hashCode() {
        return (int)(this.length ^ this.length >>> 32);
    }

    public static class FileClobInfo
    extends ClobInfo {
        public final File file;
        public final String charset;

        public FileClobInfo(File file, String charset) {
            super(file.length(), "");
            this.file = file;
            this.charset = charset;
        }

        @Override
        public boolean isTruncated() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileClobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileClobInfo info = (FileClobInfo)o;
            if (FileUtil.filesEqual((File)this.file, (File)info.file)) {
                return false;
            }
            return !(this.charset != null ? !this.charset.equals(info.charset) : info.charset != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + FileUtil.fileHashCode((File)this.file);
            result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
            return result;
        }
    }

    public static class FileBlobInfo
    extends BlobInfo {
        public final File file;

        public FileBlobInfo(File file) {
            super(file.length(), ArrayUtilRt.EMPTY_BYTE_ARRAY);
            this.file = file;
        }

        @Override
        public boolean isTruncated() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileBlobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileBlobInfo info = (FileBlobInfo)o;
            return FileUtil.filesEqual((File)this.file, (File)info.file);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + FileUtil.fileHashCode((File)this.file);
            return result;
        }
    }

    public static class BlobInfo
    extends LobInfo<BlobInfo> {
        public final byte[] data;

        public BlobInfo(long length, byte[] data) {
            super(length);
            this.data = data;
        }

        @Override
        protected long getLoadedDataLength() {
            return this.data != null ? (long)this.data.length : 0L;
        }

        @Override
        public int compareTo(BlobInfo o) {
            int superVal = super.compareTo(o);
            if (superVal != 0 || this.length == 0L) {
                return superVal;
            }
            return Comparing.compare((byte[])this.data, (byte[])o.data);
        }

        @Override
        public int compareTo(@NotNull byte[] bytes) {
            int lenVal;
            if (bytes == null) {
                BlobInfo.$$$reportNull$$$0(0);
            }
            if ((lenVal = Comparing.compare((long)this.length, (long)bytes.length)) != 0 || this.length == 0L) {
                return lenVal;
            }
            return Comparing.compare((byte[])this.data, (byte[])bytes);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BlobInfo info = (BlobInfo)o;
            return Arrays.equals(this.data, info.data);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.data != null ? Arrays.hashCode(this.data) : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/database/remote/jdbc/LobInfo$BlobInfo", "compareTo"));
        }
    }

    public static class ClobInfo
    extends LobInfo<ClobInfo> {
        public final String data;

        public ClobInfo(long length, String data) {
            super(length);
            this.data = data;
        }

        @Override
        protected long getLoadedDataLength() {
            return StringUtil.length((CharSequence)this.data);
        }

        @Override
        public int compareTo(ClobInfo o) {
            int superVal = super.compareTo(o);
            if (superVal != 0) {
                return superVal;
            }
            return Comparing.compare((Comparable)((Object)this.data), (Comparable)((Object)o.data));
        }

        @Override
        public int compareTo(@NotNull String str) {
            int lenVal;
            if (str == null) {
                ClobInfo.$$$reportNull$$$0(0);
            }
            if ((lenVal = Comparing.compare((long)this.length, (long)str.length())) != 0 || this.length == 0L) {
                return lenVal;
            }
            return Comparing.compare((Comparable)((Object)this.data), (Comparable)((Object)str));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClobInfo info = (ClobInfo)o;
            return !(this.data != null ? !this.data.equals(info.data) : info.data != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/remote/jdbc/LobInfo$ClobInfo", "compareTo"));
        }
    }
}

