/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.el.SpringELBundle;
import com.intellij.spring.el.SpringELFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringElStaticFieldInjectionInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiAnnotation psiAnnotation;
        if (field == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(1);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)manager.getProject())) {
            return null;
        }
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty("static") && (psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (boolean)true, (String[])new String[]{"org.springframework.beans.factory.annotation.Value"})) != null && SpringElStaticFieldInjectionInspection.isSpElInjected(psiAnnotation)) {
            PsiJavaCodeReferenceElement nameReferenceElement = psiAnnotation.getNameReferenceElement();
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)(nameReferenceElement != null ? nameReferenceElement : psiAnnotation), SpringELBundle.message("SpringElStaticFieldInjectionInspection.cannot.inject.in.static.fields", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, false)};
        }
        return super.checkField(field, manager, isOnTheFly);
    }

    private static boolean isSpElInjected(PsiAnnotation annotation) {
        Ref ref = Ref.create((Object)false);
        for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value = pair.getValue();
            if (!(value instanceof PsiLiteralExpression)) continue;
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)annotation.getProject());
            manager.enumerate((PsiElement)value, (injectedPsi, places) -> {
                if (injectedPsi.getFileType() instanceof SpringELFileType) {
                    ref.set((Object)true);
                }
            });
        }
        return (Boolean)ref.get();
    }

    @NotNull
    public String getShortName() {
        if ("SpringElStaticFieldInjectionInspection" == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(2);
        }
        return "SpringElStaticFieldInjectionInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/el/inspections/SpringElStaticFieldInjectionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/el/inspections/SpringElStaticFieldInjectionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

