/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectRefactoring
extends BaseRefactoringAction {
    public static final DataKey<Consumer<AbstractDbRefactoringDialog>> INTERCEPTOR = DataKey.create((String)"DatabaseObjectRefactoring.INTERCEPTOR");

    @Nullable
    public static DasObject getDasObject(@Nullable PsiElement element) {
        if (element instanceof DasObject) {
            return (DasObject)element;
        }
        DasObject res = DatabaseObjectRefactoring.getDasObject(element == null ? null : element.getReference());
        if (res == null) {
            res = (DasObject)PsiTreeUtil.getParentOfType((PsiElement)element, PsiObject.class, (boolean)false);
        }
        return res;
    }

    @Nullable
    public static DasObject getDasObject(@Nullable PsiReference ref) {
        return ref == null ? null : (DasObject)ObjectUtils.tryCast((Object)ref.resolve(), DasObject.class);
    }

    @Nullable
    public static DasObject getDasObject(@Nullable Editor editor, @Nullable PsiFile file) {
        DasObject res = null;
        if (file != null && editor != null && (res = DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(editor.getCaretModel().getOffset()))) == null) {
            res = DatabaseObjectRefactoring.getDasObject(file.findElementAt(editor.getCaretModel().getOffset()));
        }
        return res;
    }

    @Nullable
    public static PsiElement getPlace(@Nullable Editor editor, @Nullable PsiFile file) {
        return file != null && editor != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    @Nullable
    public static DasObject getDasObject(@NotNull DataContext context) {
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        DasObject res = DatabaseObjectRefactoring.getDasObject(editor, file);
        if (res == null && element != null) {
            res = DatabaseObjectRefactoring.getDasObject(element);
        }
        return res;
    }

    @NotNull
    public static JBIterable<DasObject> getDasObjects(@NotNull DataContext context) {
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(1);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        JBIterable res = JBIterable.empty();
        if (editor != null && file != null) {
            res = JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).filterMap(caret -> DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(caret.getOffset())));
        }
        JBIterable jBIterable = res.isEmpty() ? JBIterable.of((Object)DatabaseObjectRefactoring.getDasObject(context)) : res;
        if (jBIterable == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    public boolean isAvailableInEditorOnly() {
        return false;
    }

    public boolean isEnabledOnElement(@NotNull PsiElement element) {
        DasObject object;
        if (element == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(3);
        }
        DatabaseEditorContext context = (object = DatabaseObjectRefactoring.getDasObject(element)) == null ? null : DbRefactoringHelper.createContext(object, element);
        return context != null && DbRefactoringHelper.isTableOrEditableTableChild(object, context) && !DataImporter.isBusy(object);
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language instanceof SqlLanguage;
    }

    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(4);
        }
        if (elements.length != 1) {
            return false;
        }
        return this.isEnabledOnElement(elements[0]);
    }

    private static void showDialog(@Nullable PsiElement place, @Nullable DasObject object, @Nullable Consumer<AbstractDbRefactoringDialog> interceptor) {
        DatabaseEditorContext context;
        DatabaseEditorContext databaseEditorContext = context = object == null ? null : DbRefactoringHelper.createContext(object, place);
        if (context == null || !DbRefactoringHelper.isTableOrEditableTableChild(object, context)) {
            return;
        }
        DbTableDialog dialog = new DbTableDialog(context);
        AbstractDbRefactoringDialog.ResultProcessor proc = DbRefactoringHelper.getResultProcessor(object, dialog, place);
        dialog.setResultProcessor(proc);
        dialog.configureForModification(object, DbRefactoringHelper.isForceCreate(object));
        DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> dialog.export(object, true)));
        if (interceptor != null) {
            interceptor.consume((Object)dialog);
        } else {
            dialog.finishAndShow();
        }
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(5);
        }
        return new RefactoringActionHandler(){

            public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabaseObjectRefactoring.showDialog(DatabaseObjectRefactoring.getPlace(editor, file), DatabaseObjectRefactoring.getDasObject(editor, file), (Consumer<AbstractDbRefactoringDialog>)((Consumer)INTERCEPTOR.getData(dataContext)));
            }

            public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (elements == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (elements.length == 1) {
                    DatabaseObjectRefactoring.showDialog(elements[0], DatabaseObjectRefactoring.getDasObject(elements[0]), (Consumer<AbstractDbRefactoringDialog>)((Consumer)INTERCEPTOR.getData(dataContext)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elements";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/actions/DatabaseObjectRefactoring$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static String getDesc(@NotNull ObjectKind kind) {
        if (kind == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(6);
        }
        String string = "Modify " + DatabaseObjectRefactoring.getKindTitle(kind) + "...";
        if (string == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getKindTitle(@NotNull ObjectKind kind) {
        if (kind == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(8);
        }
        String string = StringUtil.capitalizeWords((String)StringUtil.toLowerCase((String)kind.toString().replaceAll("[-_]", " ")), (boolean)true);
        if (string == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            DasObject object = DatabaseObjectRefactoring.getDasObject(e.getDataContext());
            if (object != null) {
                presentation.setText(DatabaseObjectRefactoring.getDesc(object.getKind()));
                if (e.getPlace() != "unknown" && object instanceof PsiElement) {
                    presentation.setIcon(((PsiElement)object).getIcon(0));
                }
            }
        } else {
            presentation.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseObjectRefactoring";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseObjectRefactoring";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasObjects";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesc";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDasObject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDasObjects";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDesc";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getKindTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

