/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OpenConsoleAction
extends DumbAwareAction {
    public OpenConsoleAction() {
        super(null, null, AllIcons.RunConfigurations.Ql_console);
    }

    public void update(@NotNull AnActionEvent e) {
        JBIterable<DbElement> elements;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(0);
        }
        boolean enabled = !(elements = OpenConsoleAction.getElements(e)).filterMap(o -> DbImplUtil.getMaybeLocalDataSource((DatabaseSystem)o.getDataSource())).isEmpty();
        boolean visible = enabled || e.isFromActionToolbar();
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(1);
        }
        JBIterable<DbElement> elements = OpenConsoleAction.getElements(e);
        List namespaces = elements.filterMap(o -> (DbElement)JBIterable.generate((Object)o, p -> p.getDbParent()).filter(p -> p instanceof DasNamespace || p instanceof DatabaseSystem).first()).unique().toList();
        this.actionPerformedInner(e, namespaces);
    }

    protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
        Project project;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(2);
        }
        if (namespaces == null) {
            OpenConsoleAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<PersistenceConsoleProvider.Runner> runners = OpenConsoleAction.getRunners(project, namespaces);
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, (Editor)e.getData(CommonDataKeys.EDITOR), e);
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull Project project, @NotNull List<DbElement> namespaces) {
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(4);
        }
        if (namespaces == null) {
            OpenConsoleAction.$$$reportNull$$$0(5);
        }
        JBIterable namespacesIt = JBIterable.from(namespaces);
        DbElement single = (DbElement)namespacesIt.single();
        Set allowedIds = namespacesIt.map(o -> o.getDataSource().getUniqueId()).toSet();
        ArrayList result2 = ContainerUtil.newArrayList();
        PairConsumer consumer = (element, console) -> DatabaseEditorHelper.openConsoleForFile(console.getProject(), (DasNamespace)ObjectUtils.tryCast((Object)element, DasNamespace.class), console.getLanguageConsole().getVirtualFile());
        for (JdbcConsole console2 : JdbcConsoleProvider.getRunningConsoles(project)) {
            if (!allowedIds.contains(console2.getDataSource().getUniqueId())) continue;
            result2.add(JdbcConsoleProvider.newRunner(console2, () -> consumer.consume((Object)single, (Object)console2)));
        }
        if (single != null) {
            result2.addAll(JdbcConsoleProvider.newRunner(single.getDataSource(), null, (Consumer<JdbcConsole>)((Consumer)console -> consumer.consume((Object)single, console))).getSubRunners());
        } else {
            namespacesIt.unique(o -> o.getDataSource()).map(o -> JdbcConsoleProvider.newRunner(o.getDataSource(), null, (Consumer<JdbcConsole>)((Consumer)console -> consumer.consume(o, console)))).addAllTo((Collection)result2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            OpenConsoleAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static JBIterable<DbElement> getElements(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                OpenConsoleAction.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        JBIterable byPsi = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filterMap(psi -> {
            if (psi instanceof DbElement) {
                return (DbElement)psi;
            }
            if (psi instanceof DatabaseStructure.FamilyGroup) {
                return (DbElement)psi.getParent();
            }
            return null;
        });
        JBIterable byFile = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filterMap(file -> {
            if (file instanceof DatabaseElementVirtualFileImpl) {
                return ((DatabaseElementVirtualFileImpl)((Object)file)).findElement();
            }
            if (DbConsoleRootType.isConsoleFile(file)) {
                return DbConsoleRootType.getDataSource(project, file);
            }
            return null;
        });
        JBIterable jBIterable = byPsi.append((Iterable)byFile);
        if (jBIterable == null) {
            OpenConsoleAction.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenConsoleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenConsoleAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedInner";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Default
    extends OpenConsoleAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Default.$$$reportNull$$$0(0);
            }
            if (OpenConsoleAction.getElements(e).find(o -> !(o instanceof DbDataSource)) != null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            super.update(e);
        }

        @Override
        protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
            if (e == null) {
                Default.$$$reportNull$$$0(1);
            }
            if (namespaces == null) {
                Default.$$$reportNull$$$0(2);
            }
            for (DbElement namespace : namespaces) {
                DatabaseEditorHelper.openConsoleFile(namespace, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaces";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/OpenConsoleAction$Default";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformedInner";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CreateNew
    extends OpenConsoleAction {
        @Override
        protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
            if (e == null) {
                CreateNew.$$$reportNull$$$0(0);
            }
            if (namespaces == null) {
                CreateNew.$$$reportNull$$$0(1);
            }
            for (DbElement namespace : namespaces) {
                DatabaseEditorHelper.openConsoleFile(namespace, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespaces";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/OpenConsoleAction$CreateNew";
            objectArray[2] = "actionPerformedInner";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

