/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SshSession;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliCredentialsManager
implements Closeable {
    private static final Logger LOG = Logger.getInstance(CliCredentialsManager.class);
    private static final String MESSAGE = "Enter Username and Password";
    private final LocalDataSource myDataSource;
    private final CliConfiguration myConfiguration;
    private final Project myProject;
    private final String myCommand;
    private final List<CliLexeme> myLexemes;
    private SshSession mySession;

    public CliCredentialsManager(@NotNull LocalDataSource source, @NotNull CliConfiguration configuration, @NotNull Project project, @NotNull String command) {
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            CliCredentialsManager.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CliCredentialsManager.$$$reportNull$$$0(2);
        }
        if (command == null) {
            CliCredentialsManager.$$$reportNull$$$0(3);
        }
        this.myDataSource = source;
        this.myConfiguration = configuration;
        this.myProject = project;
        this.myCommand = StringUtil.trim((String)command);
        this.myLexemes = DbCliUtil.rawLexemes(this.myCommand);
    }

    @NotNull
    public Pair<String, String> getCommandAndPassword() {
        Pair<String, String> pair = this.getHostPort();
        if (pair == null) {
            CliCredentialsManager.cancelDump();
        }
        ConnectionData host = this.getData(this.myConfiguration.getHostIndicators(), (String)pair.getFirst());
        ConnectionData port = this.getData(this.myConfiguration.getPortIndicators(), (String)pair.getSecond());
        DataSourceSslConfiguration cfg = this.myDataSource.getSslCfg();
        ConnectionData sslCa = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslCaIndicators(), cfg.myCaCertPath);
        ConnectionData sslCert = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslCertIndicators(), cfg.myClientCertPath);
        ConnectionData sslKey = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslKeyIndicators(), cfg.myClientKeyPath);
        CliCredentials credentials = this.getCredentials(this.myDataSource);
        ConnectionData username = credentials.getUsername();
        ConnectionData password = credentials.getPassword();
        if (!username.isEnteredByUser() && username.isEmpty()) {
            CliCredentialsManager.cancelDump();
        }
        String sanitizedCommand = this.syncCredentials(this.myCommand, credentials);
        CliConfiguration.Parameters parameters = new CliConfiguration.Parameters(CliCredentialsManager.getValue(username), CliCredentialsManager.getValue(host), CliCredentialsManager.getValue(port), CliCredentialsManager.getValue(sslCa), CliCredentialsManager.getValue(sslCert), CliCredentialsManager.getValue(sslKey));
        String command = this.myConfiguration.getCommand(sanitizedCommand, parameters);
        Pair pair2 = Pair.create((Object)command, (Object)CliCredentialsManager.getValue(password));
        if (pair2 == null) {
            CliCredentialsManager.$$$reportNull$$$0(4);
        }
        return pair2;
    }

    @Nullable
    private Pair<String, String> getHostPort() {
        try {
            DataSourceSshTunnelConfiguration configuration = this.myDataSource.getSshConfiguration();
            if (configuration != null && configuration.isEnabled()) {
                Pair tunnel;
                boolean inUnitTest = ApplicationManager.getApplication().isUnitTestMode();
                Pair pair = tunnel = inUnitTest ? Pair.create(null, (Object)Integer.parseInt(configuration.getProxyPort())) : configuration.createTunnel(this.myDataSource);
                if (tunnel != null) {
                    this.mySession = (SshSession)tunnel.getFirst();
                    return Pair.create((Object)"localhost", (Object)String.valueOf(tunnel.getSecond()));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Can't create SSH tunnel. Trying to connect with default host and port", (Throwable)e);
        }
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        RawConnectionConfig config = this.myDataSource.getConnectionConfig();
        if (driver == null || config == null) {
            CliCredentialsManager.cancelDump();
        }
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        String url = config.getUrl();
        return JdbcUrlParserUtil.extractHostPort(parsers, url, (Ref<JdbcUrlParser>)Ref.create());
    }

    @Override
    public void close() throws IOException {
        if (this.mySession == null) {
            return;
        }
        try {
            this.mySession.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    private static String getValue(@Nullable ConnectionData data) {
        return data == null || data.isEnteredByUser() || data.isEmpty() ? null : data.getValue();
    }

    @NotNull
    private CliCredentials getCredentials(@NotNull LocalDataSource source) {
        DatabaseCredentials databaseCredentials;
        Credentials credentials;
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(5);
        }
        String userName = (credentials = (databaseCredentials = DatabaseCredentials.getInstance()).getCredentials(source)) == null || StringUtil.isEmpty((String)credentials.getUserName()) ? "" : credentials.getUserName();
        String pass = credentials == null || StringUtil.isEmpty((String)credentials.getPasswordAsString()) ? "" : credentials.getPasswordAsString();
        ConnectionData username = this.getData(this.myConfiguration.getUsernameIndicators(), userName);
        ConnectionData password = this.getData(this.myConfiguration.getPasswordIndicators(), pass);
        boolean differentSources = password.isEnteredByUser() != username.isEnteredByUser();
        boolean canAskPassword = !password.isEnteredByUser() || !this.myConfiguration.getPasswordIndicators().isSuppress();
        boolean canAskUsername = !username.isEnteredByUser() || !this.myConfiguration.getUsernameIndicators().isSuppress();
        boolean somethingEmpty = !password.isEnteredByUser() && password.isEmpty() || !username.isEnteredByUser() && username.isEmpty();
        boolean ask = differentSources && canAskPassword && canAskUsername || somethingEmpty;
        CliCredentials cliCredentials = !ask || ApplicationManager.getApplication().isUnitTestMode() ? new CliCredentials(username, password, false, false) : this.askCredentials(this.myLexemes, databaseCredentials, source, username, password);
        if (cliCredentials == null) {
            CliCredentialsManager.$$$reportNull$$$0(6);
        }
        return cliCredentials;
    }

    @NotNull
    private String syncCredentials(@NotNull String command, @NotNull CliCredentials credentials) {
        if (command == null) {
            CliCredentialsManager.$$$reportNull$$$0(7);
        }
        if (credentials == null) {
            CliCredentialsManager.$$$reportNull$$$0(8);
        }
        LexemeIndicators usernameIndicators = this.myConfiguration.getUsernameIndicators();
        LexemeIndicators passwordIndicators = this.myConfiguration.getPasswordIndicators();
        String string = DbCliUtil.getCommandWithout(command, credentials.isUsernameRemoveNeeded() ? usernameIndicators : null, credentials.isPasswordRemoveNeeded() ? passwordIndicators : null);
        if (string == null) {
            CliCredentialsManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private CliCredentials askCredentials(@NotNull List<CliLexeme> lexemes, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource source, @NotNull ConnectionData username, @NotNull ConnectionData password) {
        Pair<String, String> pair;
        if (lexemes == null) {
            CliCredentialsManager.$$$reportNull$$$0(10);
        }
        if (credentials == null) {
            CliCredentialsManager.$$$reportNull$$$0(11);
        }
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(12);
        }
        if (username == null) {
            CliCredentialsManager.$$$reportNull$$$0(13);
        }
        if (password == null) {
            CliCredentialsManager.$$$reportNull$$$0(14);
        }
        boolean noStore = username.isEnteredByUser() || password.isEnteredByUser();
        LexemeIndicators usernameIndicators = this.myConfiguration.getUsernameIndicators();
        LexemeIndicators passwordIndicators = this.myConfiguration.getPasswordIndicators();
        String usernameForDialog = username.isEnteredByUser() ? CliCredentialsManager.getArgumentValue(lexemes, usernameIndicators) : username.getValue();
        String passwordForDialog = password.isEnteredByUser() ? CliCredentialsManager.getArgumentValue(lexemes, passwordIndicators) : password.getValue();
        Pair<String, String> pair2 = pair = noStore ? CliCredentialsManager.getNoStored(source, usernameForDialog, passwordForDialog) : this.getStored(source, credentials, usernameForDialog);
        if (pair == null) {
            CliCredentialsManager.cancelDump();
        }
        boolean removeUsername = username.isEnteredByUser() && !StringUtil.equals((CharSequence)usernameForDialog, (CharSequence)((CharSequence)pair.getFirst()));
        boolean removePassword = password.isEnteredByUser() && !StringUtil.equals((CharSequence)passwordForDialog, (CharSequence)((CharSequence)pair.getSecond()));
        boolean notSetUsername = !removeUsername && username.isEnteredByUser();
        boolean notSetPassword = !removePassword && password.isEnteredByUser();
        CliCredentials cliCredentials = new CliCredentials(new ConnectionData((String)pair.getFirst(), notSetUsername), new ConnectionData((String)pair.getSecond(), notSetPassword), removeUsername, removePassword);
        if (cliCredentials == null) {
            CliCredentialsManager.$$$reportNull$$$0(15);
        }
        return cliCredentials;
    }

    @Nullable
    private static Pair<String, String> getNoStored(@NotNull LocalDataSource source, @Nullable String username, @Nullable String password) {
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(16);
        }
        return (Pair)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (source == null) {
                CliCredentialsManager.$$$reportNull$$$0(23);
            }
            PasswordPromptComponent component = new PasswordPromptComponent(true, MESSAGE, true, null);
            component.setUserName(username);
            component.setPassword(password);
            DialogBuilder builder = new DialogBuilder().centerPanel(component.getComponent()).title(String.format("Dumping %s", source.getName())).okActionEnabled(true);
            builder.addCancelAction();
            builder.addOkAction();
            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
            if (!builder.showAndGet()) {
                return null;
            }
            return Pair.create((Object)component.getUserName(), (Object)String.valueOf(component.getPassword()));
        });
    }

    @Nullable
    private Pair<String, String> getStored(@NotNull LocalDataSource source, @NotNull DatabaseCredentials credentials, @Nullable String username) {
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(17);
        }
        if (credentials == null) {
            CliCredentialsManager.$$$reportNull$$$0(18);
        }
        Credentials asked = null;
        try {
            asked = credentials.askCredentialsWhenFailed(this.myProject, source, MESSAGE, username).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        return asked == null || StringUtil.isEmpty((String)asked.getUserName()) || StringUtil.isEmpty((String)asked.getPasswordAsString()) ? null : Pair.create((Object)asked.getUserName(), (Object)asked.getPasswordAsString());
    }

    @Nullable
    private static String getArgumentValue(@NotNull List<CliLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            CliCredentialsManager.$$$reportNull$$$0(19);
        }
        if (indicators == null) {
            CliCredentialsManager.$$$reportNull$$$0(20);
        }
        if (indicators.isSuppress()) {
            return "";
        }
        if (!indicators.hasParameter()) {
            return null;
        }
        int index = DbCliUtil.getIndexFromCommand(lexemes, indicators);
        if (index == -1 || index == lexemes.size() - 1) {
            return null;
        }
        return StringUtil.trim((String)lexemes.get(index + 1).getText());
    }

    private static void cancelDump() {
        throw new ProcessCanceledException();
    }

    @NotNull
    private ConnectionData getData(@Nullable LexemeIndicators indicators, @NotNull String string) {
        if (string == null) {
            CliCredentialsManager.$$$reportNull$$$0(21);
        }
        ConnectionData connectionData = new ConnectionData(string, this.containsIndicator(indicators));
        if (connectionData == null) {
            CliCredentialsManager.$$$reportNull$$$0(22);
        }
        return connectionData;
    }

    private boolean containsIndicator(@Nullable LexemeIndicators indicators) {
        if (indicators == null) {
            return false;
        }
        return ContainerUtil.find(this.myLexemes, DbCliUtil.argumentWithParameterFinder(this.myLexemes, indicators)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliCredentialsManager";
                break;
            }
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexemes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicators";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliCredentialsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandAndPassword";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "syncCredentials";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "askCredentials";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "syncCredentials";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "askCredentials";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNoStored";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getStored";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNoStored$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CliCredentials {
        private final ConnectionData myUsername;
        private final ConnectionData myPassword;
        private final boolean myUsernameRemoveNeeded;
        private final boolean myPasswordRemoveNeeded;

        private CliCredentials(@NotNull ConnectionData username, @NotNull ConnectionData password, boolean usernameRemoveNeeded, boolean passwordRemoveNeeded) {
            if (username == null) {
                CliCredentials.$$$reportNull$$$0(0);
            }
            if (password == null) {
                CliCredentials.$$$reportNull$$$0(1);
            }
            this.myUsername = username;
            this.myPassword = password;
            this.myUsernameRemoveNeeded = usernameRemoveNeeded;
            this.myPasswordRemoveNeeded = passwordRemoveNeeded;
        }

        public boolean isPasswordRemoveNeeded() {
            return this.myPasswordRemoveNeeded;
        }

        public boolean isUsernameRemoveNeeded() {
            return this.myUsernameRemoveNeeded;
        }

        @NotNull
        public ConnectionData getPassword() {
            ConnectionData connectionData = this.myPassword;
            if (connectionData == null) {
                CliCredentials.$$$reportNull$$$0(2);
            }
            return connectionData;
        }

        @NotNull
        public ConnectionData getUsername() {
            ConnectionData connectionData = this.myUsername;
            if (connectionData == null) {
                CliCredentials.$$$reportNull$$$0(3);
            }
            return connectionData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "username";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "password";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliCredentialsManager$CliCredentials";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliCredentialsManager$CliCredentials";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPassword";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsername";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConnectionData {
        private final String myValue;
        private final boolean myEnteredByUser;

        ConnectionData(@Nullable String value, boolean enteredByUser) {
            this.myValue = value;
            this.myEnteredByUser = enteredByUser;
        }

        boolean isEnteredByUser() {
            return this.myEnteredByUser;
        }

        @Nullable
        String getValue() {
            return this.myValue;
        }

        boolean isEmpty() {
            return this.myValue != null && this.myValue.isEmpty();
        }
    }
}

