/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliCredentialsManager;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class CliRunner
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CliRunner.class);
    private static final int TIMEOUT_MS = 300;
    private final DbDataSource myDataSource;
    private final CliConfiguration myConfiguration;
    private final List<String> myParameterizable;
    private final String myCommand;
    private final Project myProject;

    public CliRunner(@NotNull DbDataSource source, @NotNull Project project, @NotNull CliConfiguration configuration, @NotNull List<String> parameterizable, @NotNull String command) {
        if (source == null) {
            CliRunner.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CliRunner.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CliRunner.$$$reportNull$$$0(2);
        }
        if (parameterizable == null) {
            CliRunner.$$$reportNull$$$0(3);
        }
        if (command == null) {
            CliRunner.$$$reportNull$$$0(4);
        }
        this.myDataSource = source;
        this.myProject = project;
        this.myConfiguration = configuration;
        this.myParameterizable = parameterizable;
        this.myCommand = command;
    }

    public void dispose() {
    }

    public void run() {
        AtomicReference<ProgressIndicator> ref = new AtomicReference<ProgressIndicator>();
        Ref reporterRef = Ref.create();
        String title = String.format("%s (%s)", this.myConfiguration.getName(), this.myDataSource.getName());
        ConsoleView view2 = DbUIUtil.addConsole(this.myProject, title, () -> true, () -> this.runBackgroundable(ref, (DataAuditor.PrintingAdapter)reporterRef.get()), ref);
        reporterRef.set((Object)new DataAuditor.ConsoleLogger(view2));
        this.runBackgroundable(ref, (DataAuditor.PrintingAdapter)reporterRef.get());
    }

    private void runBackgroundable(final @NotNull AtomicReference<ProgressIndicator> indicatorRef, final @NotNull DataAuditor.PrintingAdapter reporter) {
        if (indicatorRef == null) {
            CliRunner.$$$reportNull$$$0(5);
        }
        if (reporter == null) {
            CliRunner.$$$reportNull$$$0(6);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, this.myConfiguration.getOperation().getTaskTitle()){

            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicatorRef.set(indicator);
                try (CliCredentialsManager manager = new CliCredentialsManager((LocalDataSource)CliRunner.this.myDataSource.getDelegate(), CliRunner.this.myConfiguration, CliRunner.this.myProject, CliRunner.this.myCommand);){
                    Pair<String, String> commandAndPassword = manager.getCommandAndPassword();
                    String command = (String)commandAndPassword.getFirst();
                    String password = (String)commandAndPassword.getSecond();
                    CliConfiguration.CliBuilder builder = CliRunner.this.myConfiguration.getCliBuilder(CliRunner.this.myProject);
                    GeneralCommandLine line = builder.build(CliRunner.this.myParameterizable, command, password);
                    final CliConfiguration.CliNotificationManager notificationManager = builder.getNotificationManager();
                    notificationManager.start(indicator, (DatabaseSystem)CliRunner.this.myDataSource);
                    OSProcessHandler handler = new OSProcessHandler(line);
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            notificationManager.update(indicator, reporter, event.getText(), outputType);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/database/cli/CliRunner$1$1";
                            objectArray[2] = "onTextAvailable";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    handler.startNotify();
                    while (!handler.waitFor(300L)) {
                        if (indicator.isCanceled()) {
                            handler.destroyProcess();
                            CliRunner.this.notifyEnd(command, reporter, notificationManager, true);
                        }
                        indicator.checkCanceled();
                    }
                    CliRunner.this.notifyEnd(command, reporter, notificationManager, false);
                }
                catch (ExecutionException | IOException e) {
                    LOG.warn(e);
                    reporter.println(e.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/cli/CliRunner$1", "run"));
            }
        });
    }

    private void notifyEnd(@NotNull String command, @NotNull DataAuditor.PrintingAdapter reporter, @NotNull CliConfiguration.CliNotificationManager manager, boolean cancelled) {
        String arg;
        if (command == null) {
            CliRunner.$$$reportNull$$$0(7);
        }
        if (reporter == null) {
            CliRunner.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            CliRunner.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)(arg = this.myConfiguration.getFileParameterSearcher().search(command, this.myParameterizable)))) {
            return;
        }
        String path = DbCliUtil.clearString(arg, StringUtil::unquoteString);
        File file = new File(path);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile == null || !file.exists()) {
            return;
        }
        manager.finished(path, reporter, cancelled);
        DatabaseSystem delegate = this.myDataSource.getDelegate();
        if (this.myConfiguration.getOperation() != CliConfiguration.Operation.RESTORE) {
            return;
        }
        ObjectUtils.consumeIfCast((Object)delegate, LocalDataSource.class, l -> {
            LoaderContext context = new LoaderContext(this.myProject, (LocalDataSource)l).includeAllSchemas();
            DataSourceUiUtil.performManualSyncTask(context);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizable";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorRef";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/cli/CliRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runBackgroundable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyEnd";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

