/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vendors.oracle.OracleCompilationErrorsObtainer;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlImportForeignSchemaStatement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JdbcConsole
extends AbstractQueryLanguageConsole<LocalDataSource>
implements DataRequest.TxIsolationOwner {
    public static final String CONSOLE_TOOLWINDOW_ID = "Database Console";
    private static final Key<PlanView> PLAN_VIEW_KEY = Key.create((String)"PlanView");
    private static final Key<Boolean> SCHEDULE_REFRESH = Key.create((String)"SCHEDULE_REFRESH");
    private static final Key<IntrospectionScopeUpdater> SCOPE_UPDATER = Key.create((String)"SCOPE_UPDATER");
    private static final String TOGGLE_CONSOLE_TOOLBAR_PROP = "Database.Console";
    private AnAction myRunAction;
    private AnAction myCloseAction;
    private AnAction myTerminateAction;
    private AnAction myToggleAction;
    private final AtomicReference<SearchPath> mySearchPath;
    private final AtomicReference<Boolean> myScheduleRefresh;
    private Content myPlanContent;
    private final ScriptModel<?> myScriptModel;
    private final EventDispatcher<SearchPathReceiver> myPathDispatcher;
    private volatile int myIsolation;
    private static final Key<List<JdbcConsole>> DATABASE_CONSOLE_LIST = Key.create((String)"DATABASE_CONSOLE_LIST");

    @Override
    public int getTxIsolation() {
        return this.myIsolation;
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.myIsolation = isolation;
    }

    @NotNull
    public static Builder newConsole(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(0);
        }
        Builder builder = new Builder(project);
        if (builder == null) {
            JdbcConsole.$$$reportNull$$$0(1);
        }
        return builder;
    }

    @NotNull
    public static ToggleToolbarAction createToggleConsoleToolbarAction(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(2);
        }
        ToggleToolbarAction action = ToggleToolbarAction.createAction((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)project), () -> {
            if (project == null) {
                JdbcConsole.$$$reportNull$$$0(37);
            }
            return JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getAllEditors()).filter(o -> {
                if (project == null) {
                    JdbcConsole.$$$reportNull$$$0(38);
                }
                Editor editor = o instanceof TextEditor ? ((TextEditor)o).getEditor() : null;
                EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
                return editorEx != null && editorEx.getPermanentHeaderComponent() != null && JdbcConsole.findConsole(project, editorEx.getVirtualFile()) != null;
            }).map(o -> o.getComponent());
        });
        action.getTemplatePresentation().setText("Show Toolbar in Console");
        ToggleToolbarAction toggleToolbarAction = action;
        if (toggleToolbarAction == null) {
            JdbcConsole.$$$reportNull$$$0(3);
        }
        return toggleToolbarAction;
    }

    @Deprecated
    public static boolean beforeExecuteRange(@NotNull JdbcConsole console, TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(4);
        }
        if (range.isEmpty()) {
            return false;
        }
        ScriptModel subModel = console.getScriptModel().subModel(range);
        return console.beforeExecuteQueries(subModel);
    }

    @Deprecated
    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(5);
        }
        TextRange range = ScriptModelUtil.getSelectedStatementsRange(console, DatabaseSettings.getDefaultExecOption());
        return JdbcConsole.getQueryText(console, range);
    }

    @Deprecated
    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console, @NotNull TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(6);
        }
        if (range == null) {
            JdbcConsole.$$$reportNull$$$0(7);
        }
        if (range.isEmpty()) {
            return null;
        }
        String selected = range.subSequence((CharSequence)console.getLanguageConsole().getEditorDocument().getText()).toString();
        JBIterable parameters = console.getScriptModel().subModel(range).parameters();
        return ScriptModelUtil.statementText(console.getPStorage(), parameters, selected, 0);
    }

    @Nullable
    public static DataAuditor createAdvancedErrorsObtainer(@NotNull DatabaseSystem info, @NotNull DataAuditor sink) {
        DatabaseFamilyId dbFamilyId;
        if (info == null) {
            JdbcConsole.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            JdbcConsole.$$$reportNull$$$0(9);
        }
        if ((dbFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)info)).isOracle()) {
            return new OracleCompilationErrorsObtainer(sink);
        }
        return null;
    }

    private JdbcConsole(@NotNull LanguageConsoleView languageConsole, @NotNull DataBus.Consuming messageBus, @NotNull LocalDataSource dataSource, @Nullable String query) {
        if (languageConsole == null) {
            JdbcConsole.$$$reportNull$$$0(10);
        }
        if (messageBus == null) {
            JdbcConsole.$$$reportNull$$$0(11);
        }
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(12);
        }
        super(languageConsole, messageBus, dataSource);
        this.mySearchPath = new AtomicReference();
        this.myScheduleRefresh = new AtomicReference<Boolean>(false);
        this.myPathDispatcher = EventDispatcher.create(SearchPathReceiver.class);
        this.setCurrentTx(DataRequest.getInitialTxMarker(DbImplUtil.getLocalDataSource(dataSource).isAutoCommit()));
        this.getLanguageConsole().setPrompt("sql> ");
        ConsoleHistoryController controller = new ConsoleHistoryController(DbConsoleRootType.getInstance(), dataSource.getUniqueId(), this.getLanguageConsole()){

            protected int insertTextMultiline(String text2, Editor editor, Document document) {
                TextRange range = ScriptModelUtil.getSelectedStatementsRange(JdbcConsole.this, DatabaseSettings.getDefaultExecOption());
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text2);
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getStartOffset() + text2.length());
                return range.getStartOffset();
            }
        };
        JdbcDriverManager.getDriverManager(this.getProject()).addModificationTrackerListener(new ModificationTrackerListener<JdbcDriverManager>(){

            public void modificationCountChanged(JdbcDriverManager source) {
                FileEditorManagerEx.getInstanceEx((Project)JdbcConsole.this.getProject()).updateFilePresentation(JdbcConsole.this.getLanguageConsole().getVirtualFile());
            }
        }, this);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console");
        JdbcConsole.getActiveConsoles(this.getProject()).add(this);
        controller.setMultiline(true).install();
        if (StringUtil.isNotEmpty((String)query) && StringUtil.isEmpty((String)this.getLanguageConsole().getEditorDocument().getText())) {
            this.getLanguageConsole().setInputText(query);
        }
        this.myScriptModel = SqlPsiFacade.getInstance((Project)this.getProject()).createScriptModel(this.getLanguageConsole().getFile());
        Disposer.register((Disposable)this, this.myScriptModel);
        this.myIsolation = -1;
        this.initActions();
    }

    @Override
    public void updateConsoleOnRequestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(13);
        }
        if (this.mySearchPath.get() == null) {
            this.updateSearchPath(context.getSearchPath());
        }
    }

    @Override
    public void updateConsoleOnRequestFinished(@NotNull DataRequest.Context context) {
        IntrospectionScopeUpdater scopeUpdater;
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(14);
        }
        ObjectUtils.consumeIfCast((Object)((Object)context), DataRequest.TxContext.class, ex -> ex.updateIsolation(this));
        ConsoleDataRequest consoleRequest = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
        boolean updateSearchPath = this.mySearchPath.get() == null || consoleRequest == null || consoleRequest.isLastInChain();
        boolean requestAutoSync = consoleRequest != null && consoleRequest.isLastInChain() && Boolean.TRUE.equals(consoleRequest.getSharedDataHolder().getUserData(SCHEDULE_REFRESH));
        boolean inTransaction2 = context.txMarker.getOwner() != null;
        IntrospectionScopeUpdater introspectionScopeUpdater = scopeUpdater = consoleRequest == null ? null : (IntrospectionScopeUpdater)consoleRequest.getSharedDataHolder().getUserData(SCOPE_UPDATER);
        if (this.isValid() && updateSearchPath) {
            this.updateSearchPath(context.getSearchPath());
        }
        if (this.isTargetValid() && requestAutoSync) {
            LoaderContext loaderContext = this.prepareContext();
            if (scopeUpdater != null) {
                loaderContext.getScopeUpdater().merge(scopeUpdater);
            }
            DataSourceUiUtil.performAutoSyncTask(loaderContext);
            if (inTransaction2) {
                this.myScheduleRefresh.set(true);
            }
        }
    }

    @NotNull
    private LoaderContext prepareContext() {
        LoaderContext loaderContext = DataSourceUiUtil.getConnectionContext(this.getProject(), (LocalDataSource)this.getTarget(), SearchPath.getCurrent((SearchPath)this.mySearchPath.get()));
        if (loaderContext == null) {
            JdbcConsole.$$$reportNull$$$0(15);
        }
        return loaderContext;
    }

    @Override
    public void updateConsoleOnTxCompleted(@NotNull DataRequest.Context context, boolean commit) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(16);
        }
        if (this.isTargetValid() && commit && this.myScheduleRefresh.getAndSet(false).booleanValue()) {
            DataSourceUiUtil.performAutoSyncTask(this.prepareContext());
        }
    }

    public void setSearchPath(@Nullable SearchPath schemaPaths) {
        this.updateSearchPath(schemaPaths);
    }

    private void updateSearchPath(@Nullable SearchPath schemaPaths) {
        if (Comparing.equal((Object)schemaPaths, (Object)this.mySearchPath.get())) {
            return;
        }
        this.mySearchPath.set(schemaPaths);
        TransactionGuard.submitTransaction((Disposable)this.getProject(), () -> {
            VirtualFile virtualFile = this.getLanguageConsole().getVirtualFile();
            DatabaseEditorHelper.initSearchPath(this.getLanguageConsole().getFile());
            ChooseSchemaAction.setSelectedSearchPath(virtualFile, this.mySearchPath.get());
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
            AssignColorAction.updateFileEditors(FileEditorManagerEx.getInstanceEx((Project)this.getProject()), virtualFile);
        });
    }

    @Override
    @NotNull
    public Promise<Void> showConsole(boolean activateToolWindow, boolean requestFocus) {
        if (!activateToolWindow) {
            this.ensureContentInitialized(false);
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                JdbcConsole.$$$reportNull$$$0(17);
            }
            return promise;
        }
        Promise<Void> promise = super.showConsole(true, requestFocus);
        if (promise == null) {
            JdbcConsole.$$$reportNull$$$0(18);
        }
        return promise;
    }

    @Override
    protected void setupToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            JdbcConsole.$$$reportNull$$$0(19);
        }
        Project project = this.getProject();
        DefaultActionGroup group2 = new DefaultActionGroup();
        final MyAutoScrollFromHandler scrollFromHandler = new MyAutoScrollFromHandler(project, toolWindow);
        MyAutoScrollToHandler scrollToHandler = new MyAutoScrollToHandler(project, toolWindow);
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll from Editor", (Getter<Boolean>)((Getter)scrollFromHandler::isAutoScrollEnabled), (Setter<Boolean>)((Setter)scrollFromHandler::setAutoScrollEnabled)));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll to Editor", (Getter<Boolean>)((Getter)scrollToHandler::isAutoScrollMode), (Setter<Boolean>)((Setter)scrollToHandler::setAutoScrollMode)));
        toolWindow.setAdditionalGearActions((ActionGroup)group2);
        DumbAwareAction scrollFromEditorAction = new DumbAwareAction("Scroll from Editor", "Select console open in the active editor", AllIcons.General.Locate){

            public void actionPerformed(AnActionEvent e) {
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                FileEditor[] editors = fileEditorManager.getSelectedEditors();
                if (editors.length != 0) {
                    scrollFromHandler.selectElementFromEditor(editors[0]);
                }
            }
        };
        scrollFromEditorAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.LocateHover);
        toolWindow.setTitleActions(new AnAction[]{scrollFromEditorAction});
    }

    public boolean isToolWindowContentPresent() {
        return this.getContent().getManager() != null;
    }

    @Override
    protected void updatePendingRequestsEDT() {
        super.updatePendingRequestsEDT();
        FileEditorManagerEx.getInstanceEx((Project)this.getProject()).updateFilePresentation(this.getLanguageConsole().getVirtualFile());
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = (LocalDataSource)this.getTarget();
        if (localDataSource == null) {
            JdbcConsole.$$$reportNull$$$0(20);
        }
        return localDataSource;
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        SearchPath path = this.getSearchPath();
        return path == null ? null : path.getCurrent();
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath.get();
    }

    @Override
    @NotNull
    protected PlaceInGrid getResultPlaceInGrid() {
        PlaceInGrid placeInGrid = PlaceInGrid.center;
        if (placeInGrid == null) {
            JdbcConsole.$$$reportNull$$$0(21);
        }
        return placeInGrid;
    }

    public static List<JdbcConsole> getActiveConsoles(Project project) {
        List data = (List)project.getUserData(DATABASE_CONSOLE_LIST);
        if (data == null) {
            data = ContainerUtil.createLockFreeCopyOnWriteList();
            project.putUserData(DATABASE_CONSOLE_LIST, (Object)data);
            DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

                public void modificationCountChanged(DbPsiFacade dbFacade) {
                    Project project = dbFacade.getProject();
                    List validAndInvalidConsoles = ContainerUtil.notNullize((List)((List)project.getUserData(DATABASE_CONSOLE_LIST)));
                    for (JdbcConsole console : validAndInvalidConsoles) {
                        if (!JdbcConsole.isDataSourceValid(dbFacade, console.getDataSource())) continue;
                        console.updateTitle();
                    }
                }
            }, (Disposable)project);
        }
        Iterator it = data.iterator();
        while (it.hasNext()) {
            JdbcConsole console = (JdbcConsole)it.next();
            if (console.isValid()) continue;
            it.remove();
            DbUIUtil.invokeLaterIfNeeded(() -> Disposer.dispose((Disposable)console));
        }
        return data;
    }

    @Nullable
    public static JdbcConsole findConsole(@NotNull AnActionEvent e) {
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(22);
        }
        JdbcConsole console = JdbcConsole.getConsole(e);
        return e.getData(CONSOLE_KEY) == null && console == null ? JdbcConsoleProvider.getAttachedConsole(e.getProject(), (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) : console;
    }

    @Nullable
    public static JdbcConsole findConsole(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        JdbcConsole console = JdbcConsole.getConsole(project, virtualFile);
        if (console != null) {
            return console;
        }
        return JdbcConsoleProvider.getAttachedConsole(project, virtualFile);
    }

    @Nullable
    public static JdbcConsole getConsole(@NotNull AnActionEvent e) {
        AbstractQueryLanguageConsole console;
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(23);
        }
        if ((console = (AbstractQueryLanguageConsole)e.getData(CONSOLE_KEY)) != null) {
            return console instanceof JdbcConsole ? (JdbcConsole)console : null;
        }
        return JdbcConsole.getConsole(e.getProject(), (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    @Nullable
    public static JdbcConsole getConsole(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            if (!Comparing.equal((Object)console.getLanguageConsole().getVirtualFile(), (Object)file)) continue;
            return console;
        }
        return null;
    }

    @Override
    @NotNull
    public String getToolWindowId() {
        if (CONSOLE_TOOLWINDOW_ID == null) {
            JdbcConsole.$$$reportNull$$$0(24);
        }
        return CONSOLE_TOOLWINDOW_ID;
    }

    @Override
    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = DatabaseIcons.ToolWindowConsole;
        if (icon == null) {
            JdbcConsole.$$$reportNull$$$0(25);
        }
        return icon;
    }

    @Override
    protected String getHelpID() {
        return "reference.runToolWindow.jdbcTab";
    }

    @Override
    protected void buildConsoleUi(boolean focused) {
        this.myDataConsumer.resetOutputTabCounter();
        this.getUi().getDefaults().initTabDefaults(0, DatabaseMessages.message((String)"jdbc.console.tab.title", (Object[])new Object[0]), null);
        this.getUi().getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getLanguageConsole().getComponent(), (Object)"Center");
        final String title = DatabaseMessages.message((String)"jdbc.console.tab.title.console", (Object[])new Object[0]);
        JComponent toFocus = this.getLanguageConsole().getHistoryViewer().getContentComponent();
        Content output = this.getUi().createContent("Input", (JComponent)loadingPanel, title, AllIcons.Debugger.Console, toFocus);
        DefaultActionGroup outputActions = new DefaultActionGroup();
        JdbcConsole.addLeftToolbarConsoleActions(outputActions, (ConsoleView)this.getLanguageConsole());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getLanguageConsole().getComponent());
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        AnAction specificActionGroup = actionManager.getAction("Console.Dialect.SpecificGroup");
        if (specificActionGroup != null) {
            consoleActions.add(specificActionGroup);
        }
        consoleActions.addSeparator();
        consoleActions.add(actionManager.getAction("Database.Settings"));
        consoleActions.add(this.myToggleAction);
        consoleActions.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getLanguageConsole()).getBrowseHistory());
        consoleActions.add(this.getUi().getOptions().getLayoutActions());
        consoleActions.addSeparator();
        consoleActions.add(this.myTerminateAction);
        consoleActions.add(this.myCloseAction);
        for (AnAction action : consoleActions.getChildActionsOrStubs()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        this.getUi().getOptions().setLeftToolbar((ActionGroup)consoleActions, "toolbar");
        this.getLanguageConsole().setConsoleEditorEnabled(false);
        if (focused) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(this.getLanguageConsole().getVirtualFile(), true);
        }
        output.setCloseable(false);
        this.getUi().addContent(output, 0, PlaceInGrid.center, false);
        this.getUi().getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                if (!JdbcConsole.this.isValid()) {
                    return;
                }
                if (title.equals(event.getContent().getDisplayName())) {
                    FileEditorManager.getInstance((Project)JdbcConsole.this.getProject()).openFile(JdbcConsole.this.getLanguageConsole().getVirtualFile(), true, true);
                }
            }
        });
    }

    @Override
    @NotNull
    public ScriptModel<?> getScriptModel() {
        ScriptModel<?> scriptModel = this.myScriptModel;
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(26);
        }
        return scriptModel;
    }

    public void buildConsoleHeaderComponent(Editor editor) {
        this.checkValid();
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup leftGroup = new DefaultActionGroup();
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        leftGroup.add(this.myRunAction);
        leftGroup.addSeparator();
        leftGroup.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getLanguageConsole()).getBrowseHistory());
        leftGroup.add(this.myToggleAction);
        leftGroup.add(actionManager.getAction("Database.Settings"));
        leftGroup.addSeparator();
        leftGroup.add(actionManager.getAction("Console.Transaction"));
        leftGroup.addSeparator();
        leftGroup.add(this.myTerminateAction);
        rightGroup.add(actionManager.getAction("Console.Jdbc.ChooseSchema"));
        rightGroup.add(actionManager.getAction("Console.Jdbc.ChooseConsole"));
        EditorHeaderComponent headerComponent = new EditorHeaderComponent();
        ActionToolbar leftToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)leftGroup, true);
        ActionToolbar rightToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)rightGroup, true);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        leftToolbar.setTargetComponent(editor.getContentComponent());
        rightToolbar.setTargetComponent(editor.getContentComponent());
        headerComponent.add((Component)leftToolbar.getComponent(), "Center");
        headerComponent.add((Component)rightToolbar.getComponent(), "East");
        ((EditorEx)editor).setPermanentHeaderComponent((JComponent)headerComponent);
        editor.setHeaderComponent((JComponent)headerComponent);
        ToggleToolbarAction.setToolbarVisible((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)this.getProject()), (Iterable)JBIterable.of((Object)headerComponent), null);
        DatabaseEditorHelper.updateToolbarColor(this.getProject(), this.getLanguageConsole().getVirtualFile(), (JComponent)headerComponent);
    }

    public void executeQueries(@NotNull Editor sourceEditor, @NotNull ScriptModel<?> model, @NotNull DatabaseSettings.ExecOption execOption) {
        boolean scheduleRefresh;
        if (sourceEditor == null) {
            JdbcConsole.$$$reportNull$$$0(27);
        }
        if (model == null) {
            JdbcConsole.$$$reportNull$$$0(28);
        }
        if (execOption == null) {
            JdbcConsole.$$$reportNull$$$0(29);
        }
        IntrospectionScopeUpdater scopeUpdater = null;
        if (this.getDataSource().isAutoSynchronize()) {
            SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)model.statements().transform(ScriptModelUtil.TO_OBJECT).filter(PsiElement.class).toList());
            boolean bl = scheduleRefresh = !((SyntaxTraverser)s.filter(e -> JdbcConsole.triggersIntrospection(e))).traverse().isEmpty();
            if (scheduleRefresh) {
                scopeUpdater = DbSqlUtil.getScopeUpdater((SyntaxTraverser<PsiElement>)s, this.getCurrentNamespace(), ((LocalDataSource)this.getTarget()).getModel());
            }
        } else {
            scheduleRefresh = false;
        }
        ConsoleDataRequest request = ConsoleDataRequest.newConsoleRequest(this, sourceEditor, model, execOption.newTab);
        request.getSharedDataHolder().putUserData(SCHEDULE_REFRESH, (Object)scheduleRefresh);
        request.getSharedDataHolder().putUserData(SCOPE_UPDATER, scopeUpdater);
        this.getMessageBus().getDataProducer().processRequest(request);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console.run.intention");
    }

    private static boolean triggersIntrospection(@NotNull PsiElement e) {
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(30);
        }
        if (e instanceof SqlTableDefinition || e instanceof SqlImportForeignSchemaStatement) {
            return true;
        }
        if (e instanceof SqlAlterStatement) {
            ObjectKind kind;
            SqlReferenceExpression ref = ((SqlAlterStatement)e).getAlterTargetReference();
            ObjectKind objectKind = kind = ref == null ? null : ref.getReferenceElementType().getTargetKind();
            if (kind == null) {
                return false;
            }
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
                return true;
            }
            return PsiTreeUtil.getChildOfType((PsiElement)e, SqlRenameToClause.class) != null;
        }
        return e instanceof SqlDdlStatement;
    }

    public void switchSchema(@NotNull SearchPath to, boolean force) {
        if (to == null) {
            JdbcConsole.$$$reportNull$$$0(31);
        }
        if (force && this.getCurrentTx().getOwner() == this && JdbcUrlParserUtil.outOfBounds(this.getDataSource(), SearchPath.getCurrent((SearchPath)this.getSearchPath()), to.getCurrent())) {
            int res = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)"Current connection will be closed.\nCommit current transaction?", (String)"Current Transaction", (Icon)Messages.getWarningIcon());
            if (res == 0) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxCommit(this));
            } else if (res == 1) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxRollback(this.getCurrentTx()));
            } else {
                return;
            }
        }
        ((SearchPathReceiver)this.myPathDispatcher.getMulticaster()).receive(to);
        this.updateSearchPath(to);
        this.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(this, to, force));
    }

    @Override
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent) {
        if (parent == null) {
            JdbcConsole.$$$reportNull$$$0(32);
        }
        return GridDataHookUpManager.getInstance(this.getProject()).createDatabaseHookUp(this.getMessageBus(), new SearchPathSender(){

            @Override
            public void subscribe(@NotNull SearchPathReceiver receiver) {
                if (receiver == null) {
                    6.$$$reportNull$$$0(0);
                }
                JdbcConsole.this.myPathDispatcher.addListener((EventListener)receiver, (Disposable)receiver);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "com/intellij/database/console/JdbcConsole$6", "subscribe"));
            }
        }, parent);
    }

    @NotNull
    public Content createPlanContent() {
        PlanView view2 = PlanView.createView(this.getProject());
        Content content = this.getUi().createContent("Input", view2.getComponent(), "Plan", DatabaseIcons.Table, view2.getPreferredFocusedComponent());
        content.setCloseable(true);
        PLAN_VIEW_KEY.set((UserDataHolder)content, (Object)view2);
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                JdbcConsole.this.myPlanContent = null;
            }
        });
        Content content2 = content;
        if (content2 == null) {
            JdbcConsole.$$$reportNull$$$0(33);
        }
        return content2;
    }

    public void showPlan(@Nullable PlanModel plan) {
        if (plan != null) {
            this.ensureContentInitialized(true);
            if (this.myPlanContent == null) {
                this.myPlanContent = this.createPlanContent();
                this.getUi().addContent(this.myPlanContent, -1, PlaceInGrid.bottom, false);
                this.getUi().setBouncing(this.myPlanContent, true);
            }
            ((PlanView)PLAN_VIEW_KEY.get((UserDataHolder)this.myPlanContent)).setModel(plan);
            this.getUi().selectAndFocus(this.myPlanContent, true, false);
        } else if (this.myPlanContent != null) {
            this.getUi().removeContent(this.myPlanContent, true);
            this.myPlanContent = null;
        }
    }

    private void initActions() {
        this.myRunAction = ActionManager.getInstance().getAction("Console.Jdbc.Execute");
        this.myTerminateAction = new DumbAwareAction(null, null, AllIcons.Actions.Suspend){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                JdbcConsole.this.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(JdbcConsole.this));
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(!JdbcConsole.this.isIdle());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/console/JdbcConsole$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myCloseAction = new DumbAwareAction("Close", "Close", AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                JdbcConsole.this.closeToolWindowContent();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/console/JdbcConsole$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myToggleAction = this.initParameterView();
        JComponent shortcutTarget = this.getLanguageConsole().getConsoleEditor().getComponent();
        EmptyAction.setupAction((AnAction)this.myCloseAction, (String)"Console.Jdbc.Close", (JComponent)shortcutTarget);
        EmptyAction.setupAction((AnAction)this.myTerminateAction, (String)"Console.Jdbc.Terminate", (JComponent)shortcutTarget);
    }

    public void closeToolWindowContent() {
        ContentManager manager = this.getContent().getManager();
        if (manager != null) {
            manager.removeContent(this.getContent(), false);
        }
        DatabaseEditorHelper.disposeConsoleIfSafe(this.getLanguageConsole().getVirtualFile(), FileEditorManager.getInstance((Project)this.getProject()));
    }

    @Override
    public boolean isTargetValid() {
        return JdbcConsole.isDataSourceValid(DbPsiFacade.getInstance((Project)this.getProject()), this.getDataSource());
    }

    @Override
    public void dispose() {
        JdbcConsole.getActiveConsoles(this.getProject()).remove(this);
        super.dispose();
    }

    public void updateTitle() {
        String title = JdbcConsole.getTitle(this.getProject(), this.getLanguageConsole().getVirtualFile());
        this.getLanguageConsole().setTitle(title);
        this.getContent().setDisplayName(title);
    }

    private static boolean isDataSourceValid(@NotNull DbPsiFacade dbFacade, @NotNull DatabaseSystem dataSource) {
        if (dbFacade == null) {
            JdbcConsole.$$$reportNull$$$0(34);
        }
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(35);
        }
        return dbFacade.findDataSource(dataSource.getUniqueId()) != null;
    }

    @NotNull
    private static String getTitle(Project project, VirtualFile file) {
        String string = EditorTabbedContainer.calcTabTitle((Project)project, (VirtualFile)file);
        if (string == null) {
            JdbcConsole.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 12: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 22: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleConsoleToolbarAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareContext";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "showConsole";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultPlaceInGrid";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIcon";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptModel";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlanContent";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsole";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 36: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToggleConsoleToolbarAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAdvancedErrorsObtainer";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestStarted";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestFinished";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnTxCompleted";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupToolWindow";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findConsole";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "switchSchema";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createGridDataHookUp";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDataSourceValid";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createToggleConsoleToolbarAction$2";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SearchPathReceiver
    extends EventListener,
    Disposable {
        public void receive(@Nullable SearchPath var1);
    }

    public static interface SearchPathSender {
        public void subscribe(@NotNull SearchPathReceiver var1);
    }

    private static class MyAutoScrollToHandler {
        private static final String PROPERTY = "database.console.AUTO_SCROLL_TO_SOURCE";
        private final Project myProject;
        private boolean myEnabled;

        MyAutoScrollToHandler(final @NotNull Project project, @NotNull ToolWindowEx toolWindow) {
            if (project == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(PROPERTY, true);
            toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void selectionChanged(ContentManagerEvent event) {
                    if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                        TransactionGuard.submitTransaction((Disposable)project, () -> this.selectContentEditor(event.getContent()));
                    }
                }
            });
        }

        protected boolean isAutoScrollMode() {
            return this.myEnabled;
        }

        protected void setAutoScrollMode(boolean enabled) {
            this.myEnabled = enabled;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPERTY, enabled, true);
        }

        private void selectContentEditor(@NotNull Content content) {
            JdbcConsole console;
            if (content == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(2);
            }
            if (!this.myEnabled || !this.myProject.isOpen()) {
                return;
            }
            VirtualFile currentFile = FileEditorManagerEx.getInstanceEx((Project)this.myProject).getCurrentFile();
            JdbcConsole currentConsole = JdbcConsole.findConsole(this.myProject, currentFile);
            if (currentConsole == (console = (JdbcConsole)JdbcConsole.getConsole(content))) {
                return;
            }
            VirtualFile virtualFile = console.getLanguageConsole().getVirtualFile();
            FileEditorManagerEx.getInstanceEx((Project)this.myProject).openFile(virtualFile, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcConsole$MyAutoScrollToHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectContentEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyAutoScrollFromHandler
    extends AutoScrollFromSourceHandler {
        private static final String PROPERTY = "database.console.AUTO_SCROLL_FROM_SOURCE";
        private boolean myEnabled;

        MyAutoScrollFromHandler(@NotNull Project project, @NotNull ToolWindowEx toolWindow) {
            if (project == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(1);
            }
            super(project, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
            this.myEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(PROPERTY, true);
            this.install();
        }

        protected boolean isAutoScrollEnabled() {
            return this.myEnabled;
        }

        protected void setAutoScrollEnabled(boolean enabled) {
            this.myEnabled = enabled;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPERTY, enabled, true);
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            VirtualFile virtualFile;
            JdbcConsole console;
            if (editor == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(2);
            }
            if ((console = JdbcConsole.findConsole(this.myProject, virtualFile = FileEditorManagerEx.getInstanceEx((Project)this.myProject).getFile(editor))) != null && console.isToolWindowContentPresent()) {
                console.showConsole(true, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcConsole$MyAutoScrollFromHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RawErrorsObtainer
    extends DataAuditor,
    Disposable {
        public boolean obtainErrors(@NotNull DataRequest.Context var1, @NotNull String var2);
    }

    public static class Builder {
        Project myProject;
        private String myQuery;
        private VirtualFile myVirtualFile;
        private DatabaseSystem myInfo;

        public Builder(Project project) {
            this.myProject = project;
        }

        public Builder withQuery(CharSequence query) {
            this.myQuery = query == null ? null : query.toString();
            return this;
        }

        public Builder forFile(VirtualFile file) {
            this.myVirtualFile = file;
            return this;
        }

        public Builder fromDataSource(DatabaseSystem info) {
            this.myInfo = info;
            return this;
        }

        @NotNull
        public JdbcConsole buildAndShow(boolean focused) {
            JdbcConsole console = this.build();
            console.showConsole(focused);
            ValueLookupManager instance = ValueLookupManager.getInstance((Project)this.myProject);
            if (instance != null) {
                instance.startListening();
            }
            JdbcConsole jdbcConsole = console;
            if (jdbcConsole == null) {
                Builder.$$$reportNull$$$0(0);
            }
            return jdbcConsole;
        }

        @NotNull
        public JdbcConsole build() {
            LocalDataSource dataSource = DbImplUtil.getLocalDataSource(this.myInfo);
            VirtualFile file = this.myVirtualFile != null ? this.myVirtualFile : DatabaseEditorHelper.getConsoleVirtualFile(this.myInfo);
            AbstractQueryLanguageConsole.LOG.assertTrue(file != null, (Object)"Console file is not available");
            AbstractQueryLanguageConsole existing = (AbstractQueryLanguageConsole)JBIterable.from(AbstractQueryLanguageConsole.getActiveConsoles(this.myProject, JdbcConsole.CONSOLE_TOOLWINDOW_ID)).find(o -> o.getLanguageConsole().getVirtualFile().equals(file));
            AbstractQueryLanguageConsole.LOG.assertTrue(existing == null, (Object)("Console already created for " + file.getName()));
            String title = JdbcConsole.getTitle(this.myProject, file);
            SimpleRequestBroker broker = SimpleRequestBroker.newInstance(this.myProject, title);
            LanguageConsoleImpl consoleView = new LanguageConsoleImpl(this.myProject, title, file);
            JdbcConsole console = new JdbcConsole((LanguageConsoleView)consoleView, (DataBus.Consuming)broker, dataSource, this.myQuery);
            JdbcEngine engine = new JdbcEngine(this.myProject, broker, dataSource, null);
            Disposer.register((Disposable)console, (Disposable)engine);
            DataAuditor obtainer = JdbcConsole.createAdvancedErrorsObtainer(dataSource, console.getHistoryLogger());
            if (obtainer != null) {
                if (obtainer instanceof Disposable) {
                    Disposer.register((Disposable)console, (Disposable)((Disposable)obtainer));
                }
                console.getMessageBus().addAuditor(obtainer);
            }
            JdbcConsole jdbcConsole = console;
            if (jdbcConsole == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return jdbcConsole;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/console/JdbcConsole$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildAndShow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

