/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceScopeEditorTree;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceScopeEditor {
    private static final Key<DataSourceScopeEditor> EDITOR_KEY = Key.create((String)"DataSourceScopeEditor");
    private final Project myProject;
    private final MyTree myTree;
    protected BasicModel myModel;
    protected IntrospectionScope mySelectedScope;
    protected IntrospectionScope myPermStructure;
    private boolean mySchemaRoot;
    private boolean mySkipSpecForRoot;
    private final JComponent myPanel;

    public DataSourceScopeEditor(@NotNull Project project) {
        if (project == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(0);
        }
        this.myModel = null;
        this.mySelectedScope = IntrospectionScope.EMPTY_SCOPE;
        this.myPermStructure = IntrospectionScope.EMPTY_SCOPE;
        this.mySchemaRoot = false;
        this.mySkipSpecForRoot = true;
        this.myTree = new MyTree(this, project, new DataSourceScopeEditorTree.MyNode(null, ObjectKind.NONE, null){

            @Override
            public ObjectKind getChildKind() {
                return DataSourceScopeEditor.this.mySchemaRoot ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
            }
        });
        this.myProject = project;
        UIUtil.putClientProperty((JComponent)this.getTree(), EDITOR_KEY, (Object)this);
        this.myTree.getSearchModel().addNodeListener(new FilteringTree.SearchTreeModel.Listener<DataSourceScopeEditorTree.MyNode>(){

            @Override
            public void beforeNodeChanged(DataSourceScopeEditorTree.MyNode x) {
                DataSourceScopeEditor.this.beforeStateChanged();
            }

            @Override
            public void nodeChanged(DataSourceScopeEditorTree.MyNode x) {
                DataSourceScopeEditor.this.onStateChanged();
            }
        });
        this.myTree.getSearchModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesInserted(TreeModelEvent e) {
                if (DataSourceScopeEditor.this.mySkipSpecForRoot) {
                    for (Object o : e.getChildren()) {
                        CheckedTreeNode node = (CheckedTreeNode)ObjectUtils.tryCast((Object)o, CheckedTreeNode.class);
                        DataSourceScopeEditorTree.MyNode userNode = (DataSourceScopeEditorTree.MyNode)DataSourceScopeEditor.this.myTree.getSearchModel().getUserObject(node);
                        if (userNode == null || userNode.getKind() != ObjectKind.DATABASE) continue;
                        DbUIUtil.invokeLater(() -> DataSourceScopeEditor.this.myTree.getTree().expandPath(new TreePath(node.getPath())));
                    }
                }
            }
        });
        JComponent northPanel = this.createNorthPanel();
        northPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)northPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent(), (boolean)true);
        this.myPanel.add((Component)scrollPane, "Center");
    }

    @NotNull
    protected JComponent createNorthPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        ActionToolbar actionsToolbar = ActionManager.getInstance().createActionToolbar("DbSourceScopeEditor", (ActionGroup)this.createTreeActions(), true);
        actionsToolbar.setTargetComponent((JComponent)this.getTree());
        northPanel.add((Component)actionsToolbar.getComponent(), "East");
        this.myTree.installSimple();
        JPanel jPanel = northPanel;
        if (jPanel == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void beforeStateChanged() {
    }

    protected void onStateChanged() {
    }

    protected FilteringTree<CheckedTreeNode, DataSourceScopeEditorTree.MyNode> getFilteringTree() {
        return this.myTree;
    }

    public void setScopes(@Nullable IntrospectionScope selection, @Nullable IntrospectionScope structure) {
        boolean structChanged;
        boolean permStructChanged;
        if (selection == null && structure == null) {
            return;
        }
        boolean selChanged = selection != null && !selection.equals(this.mySelectedScope);
        if (selChanged) {
            this.mySelectedScope = selection;
        }
        if (permStructChanged = structure != null && !structure.equals(this.myPermStructure)) {
            this.myPermStructure = structure;
        }
        boolean bl = structChanged = permStructChanged || selChanged;
        if (selChanged) {
            this.myTree.recheck(this.mySelectedScope);
        }
        DbUIUtil.invokeLater(() -> {
            if (structChanged) {
                IntrospectionScope tempStructure = IntrospectionScopes.union(this.myPermStructure, this.mySelectedScope);
                if (permStructChanged || tempStructure != this.myPermStructure) {
                    this.myTree.createShadowStructure((DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject(), tempStructure);
                    this.myTree.getSearchModel().updateStructure();
                }
            }
            this.myTree.recheck(this.mySelectedScope);
            this.onSetScopeReady();
        });
    }

    protected void onSetScopeReady() {
    }

    @NotNull
    protected MultiMap<String, String> getEditorState() {
        DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject();
        MultiMap state = MultiMap.createLinkedSet();
        if (root2.getChildKind() == ObjectKind.SCHEMA) {
            Collection schemas = state.getModifiable((Object)"*");
            DataSourceScopeEditor.getNodeNames(root2.getChildNodes()).addAllTo(schemas);
        } else {
            for (DataSourceScopeEditorTree.MyNode node : root2.getChildNodes()) {
                String name = DataSourceScopeEditor.getNodeName(node);
                if (name == null || !node.isChecked()) continue;
                Collection schemas = state.getModifiable((Object)name);
                if (node.getObject() == "*") {
                    schemas.add("*");
                } else if (node instanceof DataSourceScopeEditorTree.CurNode) {
                    schemas.add("@");
                }
                DataSourceScopeEditor.getNodeNames(node.getChildNodes()).addAllTo(schemas);
            }
        }
        MultiMap multiMap = state;
        if (multiMap == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    public boolean hasSpeedSearchActive() {
        return SpeedSearchSupply.getSupply((JComponent)this.getTree()) != null;
    }

    @NotNull
    private static JBIterable<String> getNodeNames(Iterable<DataSourceScopeEditorTree.MyNode> nodes2) {
        JBIterable jBIterable = JBIterable.from(nodes2).filter(DbCheckBoxTree.MyNode::isChecked).transform(n -> DataSourceScopeEditor.getNodeName(n)).filter(Conditions.notNull());
        if (jBIterable == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Nullable
    protected static String getNodeName(DataSourceScopeEditorTree.MyNode n) {
        if (n instanceof DataSourceScopeEditorTree.CurNode) {
            return "@";
        }
        if (n.getObject() == "*") {
            return "*";
        }
        return n.getName();
    }

    public void setInitialModel(@Nullable LocalDataSource dataSource, @Nullable BasicModel tempModel) {
        this.myModel = tempModel;
        this.mySchemaRoot = dataSource != null && this.isSchemaRoot(dataSource, this.myModel);
        this.mySkipSpecForRoot = dataSource != null && DataSourceScopeEditor.isSingleRoot(dataSource);
        this.myTree.update();
    }

    protected DataSourceScopeEditorTree.MyNode getRoot() {
        return (DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject();
    }

    @Nullable
    protected LocalDataSource getDataSource(boolean withCredentials) {
        return null;
    }

    public void introspectIfEmpty() {
        LocalDataSource dataSource = this.getDataSource(false);
        if (dataSource == null || !DbImplUtil.canConnectTo(dataSource) || this.myModel != null && !this.myModel.getRoot().getNamespaces().isEmpty()) {
            return;
        }
        this.reintrospect(null);
    }

    private boolean canReintrospect() {
        LocalDataSource dataSource = this.getDataSource(false);
        return dataSource != null && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource);
    }

    public void reintrospect(@Nullable List<BasicNamespace> objects) {
        CompletionStage<DataSourceSyncManager.SyncResult> promise;
        LocalDataSource dataSource = this.getDataSource(true);
        if (dataSource == null) {
            return;
        }
        LoaderContext context = new LoaderContext(this.myProject, dataSource).setNamespacesOnly(true);
        if (objects != null) {
            context.getSelection().addAll(objects);
        }
        if ((promise = DataSourceSyncManager.getInstance().tryPerform(context, true, true)) == null) {
            return;
        }
        promise.whenCompleteAsync((res, e) -> {
            BasicModel model;
            AsyncUtil.addUnhandledError(context.getErrorHandler(), e, context.getDataSource().getName(), DbImplUtil.getDatabaseDialect(context.getDataSource()).getFamilyId());
            if (res != null && (model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class)) != null && !model.getRoot().getNamespaces().isEmpty()) {
                this.myModel = model;
                this.mySchemaRoot = this.isSchemaRoot(dataSource, model);
                this.mySkipSpecForRoot = DataSourceScopeEditor.isSingleRoot(dataSource);
                this.myTree.update();
                this.onStateChanged();
            }
            this.handleIntrospectionError(StringUtil.nullize((String)context.getErrorHandler().getSummary()));
        }, AsyncUtil.EDT_EXECUTOR);
    }

    protected void handleIntrospectionError(@Nullable String msg) {
    }

    private static boolean isSingleRoot(@NotNull LocalDataSource dataSource) {
        DatabaseFamilyId familyId;
        if (dataSource == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(4);
        }
        return (familyId = DbImplUtil.getDatabaseDialect(dataSource).getFamilyId()).isPostgres() || familyId.isH2() || familyId.isHsqldb();
    }

    protected boolean isSchemaRoot(@NotNull LocalDataSource dataSource, @Nullable BasicModel tempModel) {
        BasicNamespace rootNamespace;
        if (dataSource == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(5);
        }
        NamingFamily<? extends BasicMateNamespace> namespaces = tempModel == null ? null : tempModel.getRoot().getNamespaces();
        BasicNamespace basicNamespace = rootNamespace = namespaces == null || namespaces.isEmpty() ? null : (BasicNamespace)namespaces.first();
        return rootNamespace == null ? DbImplUtil.getDatabaseDialect(dataSource).getMetaModel().getRootNamespaceKinds().contains((Object)ObjectKind.SCHEMA) : rootNamespace.getKind() == ObjectKind.SCHEMA;
    }

    @NotNull
    public Tree getTree() {
        DataSourceScopeEditorTree dataSourceScopeEditorTree = this.myTree.getTree();
        if (dataSourceScopeEditorTree == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(6);
        }
        return dataSourceScopeEditorTree;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @NotNull
    protected DefaultActionGroup createTreeActions() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new RefreshAction(), this.createExpandActon(), this.createCollapseAction()});
        if (defaultActionGroup == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    @NotNull
    private AnAction createCollapseAction() {
        CollapseAllAction action = new CollapseAllAction((JTree)this.getTree());
        action.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CollapseAll"), (JComponent)this.getTree());
        CollapseAllAction collapseAllAction = action;
        if (collapseAllAction == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(9);
        }
        return collapseAllAction;
    }

    @NotNull
    private AnAction createExpandActon() {
        ExpandAllAction action = new ExpandAllAction((JTree)this.getTree());
        action.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ExpandAll"), (JComponent)this.getTree());
        ExpandAllAction expandAllAction = action;
        if (expandAllAction == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(10);
        }
        return expandAllAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNorthPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapseAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandActon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSingleRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTree
    extends FilteringTree<CheckedTreeNode, DataSourceScopeEditorTree.MyNode> {
        final /* synthetic */ DataSourceScopeEditor this$0;

        public MyTree(@NotNull DataSourceScopeEditor dataSourceScopeEditor, Project project, DataSourceScopeEditorTree.MyNode root2) {
            if (dataSourceScopeEditor == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyTree.$$$reportNull$$$0(1);
            }
            this(dataSourceScopeEditor, project, DataSourceScopeEditorTree.createNode(root2));
        }

        private MyTree(@NotNull DataSourceScopeEditor dataSourceScopeEditor, Project project, CheckedTreeNode root2) {
            if (dataSourceScopeEditor == null) {
                MyTree.$$$reportNull$$$0(2);
            }
            if (project == null) {
                MyTree.$$$reportNull$$$0(3);
            }
            this.this$0 = dataSourceScopeEditor;
            super(project, (Tree)new DataSourceScopeEditorTree(root2), root2);
        }

        @Override
        protected Class<? extends CheckedTreeNode> getNodeClass() {
            return CheckedTreeNode.class;
        }

        @Override
        @NotNull
        protected CheckedTreeNode createNode(@Nullable DataSourceScopeEditorTree.MyNode obj) {
            CheckedTreeNode checkedTreeNode = DataSourceScopeEditorTree.createNode(obj);
            if (checkedTreeNode == null) {
                MyTree.$$$reportNull$$$0(4);
            }
            return checkedTreeNode;
        }

        @Override
        @NotNull
        protected Iterable<DataSourceScopeEditorTree.MyNode> getChildren(@NotNull DataSourceScopeEditorTree.MyNode obj) {
            if (obj == null) {
                MyTree.$$$reportNull$$$0(5);
            }
            JBIterable jBIterable = obj.getChildNodes();
            if (jBIterable == null) {
                MyTree.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        protected String getText(@Nullable DataSourceScopeEditorTree.MyNode object) {
            return object == null || object.getObject() == "*" ? null : object.getName();
        }

        @NotNull
        public DataSourceScopeEditorTree getTree() {
            DataSourceScopeEditorTree dataSourceScopeEditorTree = (DataSourceScopeEditorTree)super.getTree();
            if (dataSourceScopeEditorTree == null) {
                MyTree.$$$reportNull$$$0(7);
            }
            return dataSourceScopeEditorTree;
        }

        @Override
        protected void rebuildTree() {
            DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)this.getSearchModel().getRootObject();
            if (this.this$0.myModel == null) {
                root2.setHasAllAndCur(!this.this$0.mySkipSpecForRoot);
                DataSourceScopeEditorTree.CurNode current = root2.getCurNode();
                if (current != null) {
                    current.setCurObject(null);
                }
                root2.setChildren(null);
                root2.setShadowChildren(null);
                return;
            }
            this.addNodes(root2, this.sorted((Iterable<? extends BasicNamespace>)this.this$0.myModel.getRoot().getNamespaces().jbi()));
            this.createShadowStructure(root2, IntrospectionScopes.union(this.this$0.myPermStructure, this.this$0.mySelectedScope));
            this.getSearchModel().updateStructure();
        }

        private void addNodes(@NotNull DataSourceScopeEditorTree.MyNode p, @NotNull Iterable<BasicNamespace> objects) {
            if (p == null) {
                MyTree.$$$reportNull$$$0(8);
            }
            if (objects == null) {
                MyTree.$$$reportNull$$$0(9);
            }
            ObjectKind childKind = p.getChildKind();
            Map<String, DataSourceScopeEditorTree.MyNode> oldCache = this.mapByName((Iterable<DataSourceScopeEditorTree.MyNode>)p.getChildNodes(), childKind);
            ArrayList children = ContainerUtil.newArrayList();
            BasicNamespace cur = null;
            for (BasicNamespace object : objects) {
                DataSourceScopeEditorTree.MyNode node = oldCache.remove(object.getName());
                if (node != null) {
                    node.setObject(object);
                } else {
                    node = new DataSourceScopeEditorTree.MyNode(object.getName(), object.getKind(), object);
                }
                children.add(node);
                if (object.isCurrent()) {
                    cur = object;
                }
                if (object.getKind() == ObjectKind.SCHEMA) continue;
                this.addNodes(node, this.sorted((Iterable<? extends BasicNamespace>)object.getDbChildren().filter(BasicNamespace.class)));
            }
            oldCache.values().forEach(o -> o.setObject(o.getName()));
            p.setHasAllAndCur(p.getKind() != ObjectKind.NONE || !this.this$0.mySkipSpecForRoot || p.getAllNode() != null);
            DataSourceScopeEditorTree.CurNode current = p.getCurNode();
            if (current != null) {
                current.setCurObject(cur);
            }
            p.setChildren(children);
            p.setShadowChildren(oldCache.values());
        }

        private Iterable<BasicNamespace> sorted(Iterable<? extends BasicNamespace> children) {
            ArrayList namespaces = ContainerUtil.newArrayList(children);
            Collections.sort(namespaces, (n1, n2) -> StringUtil.naturalCompare((String)n1.getName(), (String)n2.getName()));
            return namespaces;
        }

        private void createShadowStructure(@NotNull DataSourceScopeEditorTree.MyNode root2, @NotNull IntrospectionScope scope) {
            if (root2 == null) {
                MyTree.$$$reportNull$$$0(10);
            }
            if (scope == null) {
                MyTree.$$$reportNull$$$0(11);
            }
            ObjectKind childKind = root2.getChildKind();
            if (!this.this$0.mySchemaRoot) {
                HashSet processedDb = ContainerUtil.newHashSet();
                ArrayList rootShadow = ContainerUtil.newArrayList();
                Map<String, DataSourceScopeEditorTree.MyNode> oldRootCache = this.mapByName(root2.getShadowChildren(), childKind);
                Map<String, DataSourceScopeEditorTree.MyNode> objects = this.mapByName(root2.getChildren(), childKind);
                if (scope.databases().contains("@") || scope.databases().contains("*")) {
                    root2.setHasAllAndCur(true);
                }
                for (String db : scope.databases()) {
                    if (db.equals("*") || db.equals("@")) continue;
                    DataSourceScopeEditorTree.MyNode object = objects.get(db);
                    if (object != null) {
                        processedDb.add(object);
                    } else {
                        object = oldRootCache.get(db);
                        if (object == null) {
                            object = new DataSourceScopeEditorTree.MyNode(db, ObjectKind.DATABASE, db);
                        }
                        rootShadow.add(object);
                    }
                    this.fillShadowSchemas(scope.schemas(db), object);
                }
                root2.setShadowChildren(rootShadow);
                for (DataSourceScopeEditorTree.MyNode node : root2.getChildren()) {
                    if (processedDb.contains(node)) continue;
                    node.purgeShadow();
                }
            } else {
                this.fillShadowSchemas(scope.schemas("*"), root2);
            }
        }

        private void fillShadowSchemas(Iterable<String> schemas, DataSourceScopeEditorTree.MyNode p) {
            ArrayList dbShadow = ContainerUtil.newArrayList();
            Map<String, DataSourceScopeEditorTree.MyNode> schemaObjects = this.mapByName(p.getChildren(), p.getChildKind());
            Map<String, DataSourceScopeEditorTree.MyNode> oldSchemasCache = this.mapByName(p.getShadowChildren(), p.getChildKind());
            if (JBIterable.from(schemas).contains((Object)"@") || JBIterable.from(schemas).contains((Object)"*")) {
                p.setHasAllAndCur(true);
            }
            for (String sc : schemas) {
                if (sc.equals("*") || sc.equals("@") || schemaObjects.containsKey(sc)) continue;
                DataSourceScopeEditorTree.MyNode schema = oldSchemasCache.get(sc);
                if (schema == null) {
                    schema = new DataSourceScopeEditorTree.MyNode(sc, ObjectKind.SCHEMA, sc);
                }
                dbShadow.add(schema);
            }
            p.setShadowChildren(dbShadow);
            for (DataSourceScopeEditorTree.MyNode node : p.getChildNodes()) {
                node.purgeShadow();
            }
        }

        private Map<String, DataSourceScopeEditorTree.MyNode> mapByName(Iterable<DataSourceScopeEditorTree.MyNode> children, ObjectKind childKind) {
            HashMap oldCache = ContainerUtil.newHashMap();
            for (DataSourceScopeEditorTree.MyNode node : children) {
                if (node.getKind() != childKind || node instanceof DataSourceScopeEditorTree.CurNode || node.getObject() == "*") continue;
                oldCache.put(node.getName(), node);
            }
            return oldCache;
        }

        private void recheck(@NotNull IntrospectionScope scope) {
            if (scope == null) {
                MyTree.$$$reportNull$$$0(12);
            }
            FilteringTree.SearchTreeModel model = this.this$0.myTree.getSearchModel();
            DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)model.getRootObject();
            if (this.this$0.mySchemaRoot) {
                Iterator iterator = root2.getChildNodes().iterator();
                while (iterator.hasNext()) {
                    DataSourceScopeEditorTree.MyNode o;
                    String sc = DataSourceScopeEditor.getNodeName(o = (DataSourceScopeEditorTree.MyNode)iterator.next());
                    o.setChecked(sc != null && scope.schemas("*").contains(sc));
                }
            } else {
                for (DataSourceScopeEditorTree.MyNode o : root2.getChildNodes()) {
                    String db = DataSourceScopeEditor.getNodeName(o);
                    boolean checked = db != null && scope.databases().contains(db);
                    o.setChecked(checked);
                    for (DataSourceScopeEditorTree.MyNode oo : o.getChildNodes()) {
                        String sc = DataSourceScopeEditor.getNodeName(oo);
                        oo.setChecked(db != null && sc != null && scope.schemas(db).contains(sc));
                    }
                }
            }
            this.getTree().updateFromNodes();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodes";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createShadowStructure";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "recheck";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RefreshAction
    extends DumbAwareAction {
        public RefreshAction() {
            super("Refresh", "Refresh schemas list", AllIcons.Actions.Refresh);
        }

        public void update(AnActionEvent e) {
            DataSourceScopeEditor editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY);
            boolean enabled = editor != null && editor.canReintrospect();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription("Refresh schemas list" + (enabled ? "" : " (already running)"));
        }

        public void actionPerformed(AnActionEvent e) {
            DataSourceScopeEditor editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY);
            if (editor != null) {
                List objects = JBIterable.of((Object[])editor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).transform(n -> {
                    DataSourceScopeEditorTree.MyNode node = (DataSourceScopeEditorTree.MyNode)editor.myTree.getUserObject((TreeNode)n);
                    return node == null ? null : node.getObject();
                }).filter(BasicNamespace.class).toList();
                editor.reintrospect(objects);
            }
        }
    }
}

