/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcChangesBrowser
extends ChangesBrowser {
    private static final Logger LOG = Logger.getInstance(DbSrcChangesBrowser.class);
    public static final ChangeNodeDecorator MY_DECORATOR = new ChangeNodeDecorator(){

        public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) {
                return;
            }
            Icon icon = DbSrcUtils.getIcon(revision.getFile().getPath());
            if (icon != null) {
                component.setIcon(icon);
            }
        }

        public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
        }
    };

    public DbSrcChangesBrowser(Project project) {
        super(project, DbSrcChangesTracker.getInstance(project).getChangeLists(), Collections.emptyList(), null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.setChangesToDisplay(this.getTrackedChanges());
        DbSrcChangesTracker.getInstance(project).addListener((ModificationTrackerListener<DbSrcChangesTracker>)((ModificationTrackerListener)source -> UIUtil.invokeLaterIfNeeded(() -> this.setChangesToDisplay(this.getTrackedChanges()))), (Disposable)this);
    }

    @NotNull
    public List<Change> getTrackedChanges() {
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)JBIterable.from(DbSrcChangesTracker.getInstance(this.myProject).getChangeLists()).flatten(DbSrcChangesTracker.DbSrcChangeList::getChanges).toList());
        if (arrayList == null) {
            DbSrcChangesBrowser.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator, boolean showFlatten) {
        DefaultTreeModel defaultTreeModel = new MyTreeModelBuilder(this.myProject, showFlatten).setDBChangeLists(ContainerUtil.filter(DbSrcChangesTracker.getInstance(this.myProject).getChangeLists(), c -> !c.getChanges().isEmpty())).build();
        if (defaultTreeModel == null) {
            DbSrcChangesBrowser.$$$reportNull$$$0(1);
        }
        return defaultTreeModel;
    }

    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        super.buildToolBar(toolBarGroup);
        DumbAwareAction revertAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                Stream<VirtualFile> files = DbSrcChangesBrowser.this.getSelectedFiles();
                e.getPresentation().setEnabled(files.findAny().isPresent());
            }

            public void actionPerformed(AnActionEvent e) {
                Stream<VirtualFile> files = DbSrcChangesBrowser.this.getSelectedFiles();
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        DbSrcUtils.revert(files.collect(Collectors.toList()));
                    }
                    catch (IOException ex) {
                        LOG.error((Throwable)ex);
                    }
                });
            }
        };
        ActionUtil.copyFrom((AnAction)revertAction, (String)"ChangesView.Revert");
        revertAction.registerCustomShortcutSet((JComponent)this.myViewer, null);
        toolBarGroup.add((AnAction)revertAction);
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedFiles() {
        DbSrcFileSystem dbFs = DbSrcFileSystem.getInstance();
        Stream<VirtualFile> stream = this.getSelectedChanges().stream().map(c -> {
            ContentRevision revision = c.getAfterRevision();
            return revision == null ? null : dbFs.findFileByPath(revision.getFile().getPath());
        }).filter(Objects::nonNull);
        if (stream == null) {
            DbSrcChangesBrowser.$$$reportNull$$$0(2);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackedChanges";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyTreeModelBuilder
    extends TreeModelBuilder {
        public MyTreeModelBuilder(@NotNull Project project, boolean showFlatten) {
            if (project == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(0);
            }
            super(project, showFlatten);
        }

        @NotNull
        public TreeModelBuilder setDBChangeLists(@NotNull Collection<DbSrcChangesTracker.DbSrcChangeList> changeLists) {
            if (changeLists == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(1);
            }
            for (DbSrcChangesTracker.DbSrcChangeList list : changeLists) {
                List changes = ContainerUtil.sorted(list.getChanges(), (Comparator)PATH_LENGTH_COMPARATOR);
                ChangesBrowserChangeListNode listNode = this.createDBChangeListNode(list, changes);
                listNode.markAsHelperNode();
                this.myModel.insertNodeInto((MutableTreeNode)listNode, (MutableTreeNode)this.myRoot, 0);
                for (Change change : changes) {
                    this.insertChangeNode(change, (ChangesBrowserNode)listNode, this.createChangeNode(change, MY_DECORATOR), MyTreeModelBuilder::createDBPathNode);
                }
            }
            MyTreeModelBuilder myTreeModelBuilder = this;
            if (myTreeModelBuilder == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(2);
            }
            return myTreeModelBuilder;
        }

        private ChangesBrowserChangeListNode createDBChangeListNode(final @NotNull DbSrcChangesTracker.DbSrcChangeList list, List<Change> changes) {
            if (list == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(3);
            }
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
            return new ChangesBrowserChangeListNode(this.myProject, list, listRemoteState){

                public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
                    super.render(renderer, selected, expanded, hasFocus);
                    LocalDataSource dataSource = list.getDataSource();
                    if (dataSource != null) {
                        renderer.setIcon(dataSource.getBaseIcon());
                    }
                }
            };
        }

        @Nullable
        private static ChangesBrowserNode createDBPathNode(@NotNull StaticFilePath path) {
            Boolean res;
            if (path == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(4);
            }
            if (!Boolean.TRUE.equals(res = DbSrcFileSystem.processPath(path.getPath(), new DbSrcFileSystem.ItemProcessor<Boolean>(){

                @Override
                public Boolean processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                    if (dataSourceId == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return !original;
                }

                @Override
                public Boolean processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String kind) {
                    if (dataSourceId == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return Boolean.TRUE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "dataSourceId";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processFile";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processFolder";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }))) {
                return null;
            }
            return new MyChangesBrowserFilePathNode(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeLists";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDBChangeLists";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDBChangeLists";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDBChangeListNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDBPathNode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyChangesBrowserFilePathNode
        extends ChangesBrowserFilePathNode {
            public MyChangesBrowserFilePathNode(@NotNull StaticFilePath path) {
                if (path == null) {
                    MyChangesBrowserFilePathNode.$$$reportNull$$$0(0);
                }
                super(VcsUtil.getFilePath((String)path.getPath(), (boolean)true));
            }

            @NotNull
            protected String getRelativePath(FilePath path) {
                String result2;
                FilePath parent = MyChangesBrowserFilePathNode.safeCastToFilePath((Object)((ChangesBrowserNode)this.getParent()).getUserObject());
                Iterable<String> items = parent == null ? DbSrcFileSystem.processPath(path.getPath(), new DbSrcFileSystem.ItemProcessor<Iterable<String>>(){

                    @Override
                    public Iterable<String> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
                        if (dataSourceId == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ArrayList names = path == null ? Collections.emptyList() : ContainerUtil.newArrayList(path.names());
                        return group2 == null ? names : ContainerUtil.append((List)names, (Object[])new String[]{group2});
                    }

                    @Override
                    public Iterable<String> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                        if (dataSourceId == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (path == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return path.names();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "dataSourceId";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "path";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$MyChangesBrowserFilePathNode$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processFolder";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processFile";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }) : ((result2 = FileUtil.getRelativePath((String)parent.getPath(), (String)path.getPath(), (char)'/', (boolean)true)) == null ? null : DbSrcFileSystem.splitPath(result2));
                String string = items == null ? path.getPath() : StringUtil.join(items, (String)".");
                if (string == null) {
                    MyChangesBrowserFilePathNode.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
                Icon icon;
                super.render(renderer, selected, expanded, hasFocus);
                FilePath path = (FilePath)ObjectUtils.tryCast((Object)this.userObject, FilePath.class);
                if (path != null && (icon = DbSrcUtils.getIcon(path.getPath())) != null) {
                    renderer.setIcon(icon);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$MyChangesBrowserFilePathNode";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$MyChangesBrowserFilePathNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRelativePath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

