/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.db2.Db2;
import com.intellij.database.model.db2.Db2ModModel;
import com.intellij.database.model.db2.Db2ModRoot;
import com.intellij.database.model.db2.Db2ModSchema;
import com.intellij.database.model.db2.Db2ModTable;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.util.ArrayUtil;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDb2Dialect
extends AbstractDatabaseDialect
implements DatabaseDialect,
AbstractDatabaseDialect.SplitAlterColumnSupport {
    protected AbstractDb2Dialect(MetaModel metaModel, TypeHelper typeHelper, KeywordHelper keywordHelper, Casing casing) {
        super(metaModel, typeHelper, keywordHelper, casing);
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(0);
        }
        if (column == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(1);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(2);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(3);
        }
        if (table == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(4);
        }
        if (model == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(5);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(6);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(7);
        }
        if (connection == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(8);
        }
        Map<String, Object> map2 = DbImplUtil.resultRowAsMap(connection, String.format("SELECT tabname, card, collationname, create_time FROM syscat.tables WHERE owner = '%s' AND tabname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeStr(DasUtil.getSchema((DasObject)element)), DbImplUtil.escapeSql(element.getName(), true, this)), "CARD", "rows", "COLLATIONNAME", "collation", "CREATE_TIME", "created");
        if (map2 == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(9);
        }
        return map2;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(10);
        }
        if (from == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(11);
        }
        if (toName == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(12);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)from.getTable()).space();
        builder.keywords("RENAME", "COLUMN").space();
        builder.columnRef((DasObject)from).space();
        builder.keyword("TO").space();
        builder.newName(toName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(14);
        }
        if (from == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(15);
        }
        if (to == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(16);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)to.getTable()).space();
        builder.keyword("ALTER").space();
        builder.columnRef((DasObject)to).space();
        builder.keywords("SET", "DATA", "TYPE").space();
        builder.type((DasTypedObject)to);
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(18);
        }
        if (column == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(19);
        }
        String alterClause = "ALTER COLUMN";
        String defaultClause = "SET DEFAULT";
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterSQL(builder, column, "ALTER COLUMN", false, "SET DEFAULT");
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.CASCADE, DasForeignKey.RuleAction.NO_ACTION, DasForeignKey.RuleAction.SET_NULL, DasForeignKey.RuleAction.SET_DEFAULT), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.CASCADE, DasForeignKey.RuleAction.NO_ACTION, DasForeignKey.RuleAction.SET_NULL, DasForeignKey.RuleAction.RESTRICT));
        if (foreignKeyEditorCaps == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(21);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull String sequenceName) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(22);
        }
        if (column == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(23);
        }
        if (sequenceName == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(24);
        }
        DasTable table = column.getTable();
        String columnName = column.getName();
        DasTable sequence = (DasTable)DialectUtils.withNewModel(Db2.RDBMS, Db2ModModel.class, Db2ModRoot.class, root2 -> {
            if (sequenceName == null) {
                AbstractDb2Dialect.$$$reportNull$$$0(78);
            }
            return (Db2ModTable)DialectUtils.create(((Db2ModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)table))).getTables(), sequenceName);
        });
        this.sqlCreateSequence(builder, sequence, "1", "1", "", "1", "", false);
        builder.newStatement();
        builder.keywords("CREATE", "TRIGGER").space();
        builder.newName(columnName + "_trigger").newLine();
        builder.keyword("NO CASCADE BEFORE INSERT ON").space();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("REFERENCING NEW AS").space().ref(null, "n").newLine();
        builder.keyword("FOR EACH ROW").newLine();
        builder.keyword("SET").space().ref(null, "n").symbol(".").ref(null, columnName).space();
        builder.symbol("=").space().keyword("NEXTVAL FOR").space();
        builder.qualifiedRef((DasObject)sequence);
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(25);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(26);
        }
        if (column == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(27);
        }
        String tableName = column.getTable().getName();
        String columnName = column.getName();
        String sequenceName = tableName.toUpperCase(Locale.ENGLISH) + "_" + columnName.toUpperCase(Locale.ENGLISH) + "_SEQ";
        DdlBuilder ddlBuilder = this.sqlAddColumnAutoIncrement(builder, column, sequenceName);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(28);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(29);
        }
        if (keyInfo == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(30);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(31);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey keyInfo, boolean matchFull) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(32);
        }
        DasForeignKey.RuleAction deleteOverride = null;
        DasForeignKey.RuleAction updateOverride = null;
        if (keyInfo.getUpdateRule() != DasForeignKey.RuleAction.RESTRICT && keyInfo.getUpdateRule() != DasForeignKey.RuleAction.NO_ACTION) {
            updateOverride = DasForeignKey.RuleAction.NO_ACTION;
        }
        if (keyInfo.getDeleteRule() == DasForeignKey.RuleAction.SET_DEFAULT) {
            deleteOverride = DasForeignKey.RuleAction.NO_ACTION;
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, keyInfo, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, deleteOverride, updateOverride);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(33);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(34);
        }
        if (index == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(35);
        }
        if (accessMethod == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(36);
        }
        if (tablespace == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(37);
        }
        if (constraints == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(38);
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index, accessMethod);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(39);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(40);
        }
        if (sequence == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(41);
        }
        if (increment == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(42);
        }
        if (minimum == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(43);
        }
        if (maximum == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(44);
        }
        if (start == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(45);
        }
        if (cache == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(46);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateSequenceSQL(builder, sequence, increment, minimum, maximum, start, cache, "");
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(47);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(48);
        }
        if (view2 == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(49);
        }
        if (definition == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(50);
        }
        if (checkOption == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(51);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewSQL(builder, view2, definition, checkOption, this);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(52);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(53);
        }
        if (table == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(54);
        }
        if (constraintName == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(55);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(57);
        }
        if (table == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(58);
        }
        if (indexName == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(59);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropIndexSQL(builder, table, index, indexName, null, false);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(61);
        }
        if (view2 == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(62);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view2, null);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(63);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(64);
        }
        if (table == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(65);
        }
        if (newName == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(66);
        }
        builder.keywords("RENAME", "TABLE").space();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("TO").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(67);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String newName) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(68);
        }
        if (view2 == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(69);
        }
        if (newName == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(70);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.rename.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsAccessMethods() {
        return false;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(71);
        }
        if (qualifier == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(72);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDbParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), catalog, DasUtil.getName((DasObject)catalog), pkg, pkgName);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(73);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(74);
        }
        String string = "BLOB(x'" + DialectUtils.toHexString(binaryData) + "')";
        if (string == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(75);
        }
        return string;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system, int rows) {
        if (builder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(76);
        }
        DdlBuilder ddlBuilder = AbstractDb2Dialect.fetchFirst(builder, rows);
        if (ddlBuilder == null) {
            AbstractDb2Dialect.$$$reportNull$$$0(77);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 33: 
            case 39: 
            case 47: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 67: 
            case 73: 
            case 75: 
            case 77: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 33: 
            case 39: 
            case 47: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 67: 
            case 73: 
            case 75: 
            case 77: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 19: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 33: 
            case 39: 
            case 47: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 67: 
            case 73: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/AbstractDb2Dialect";
                break;
            }
            case 4: 
            case 54: 
            case 58: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 24: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequenceName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 49: 
            case 62: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 66: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/AbstractDb2Dialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefault";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 25: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSequence";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 33: 
            case 39: 
            case 47: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 67: 
            case 73: 
            case 75: 
            case 77: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sqlAddColumnAutoIncrement$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 33: 
            case 39: 
            case 47: 
            case 52: 
            case 56: 
            case 60: 
            case 63: 
            case 67: 
            case 73: 
            case 75: 
            case 77: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

