/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.OracleDialect;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.impl.MemoryTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class DialectUtils {
    public static <T, M extends BasicModModel, R extends BasicModRoot> T withNewModel(Rdbms rdbms, Class<M> modelClass, Class<R> rootClass, Function<R, T> function) {
        BasicModModel model = (BasicModModel)new ModelFactory(new MemoryTextStorage()).createModel(rdbms, modelClass);
        Ref resultRef = Ref.create();
        model.modify(rootClass, root2 -> resultRef.set(function.fun(root2)));
        return (T)resultRef.get();
    }

    public static <T extends BasicModNamedElement> T create(ModNamingFamily<? extends T> f, DasObject copy) {
        if (copy == null) {
            return DialectUtils.create(f, "");
        }
        T obj = f.createOrGet(copy.getName());
        obj.setNameScripted(DbSqlUtil.isSqlObject(copy));
        obj.setNameQuoted(DbSqlUtil.isQuoted(copy));
        return obj;
    }

    public static <T extends BasicModNamedElement> T create(ModNamingFamily<? extends T> f, String name) {
        T obj = f.createOrGet(name);
        obj.setNameScripted(true);
        obj.setNameQuoted(false);
        return obj;
    }

    public static DdlBuilder getObjectCommentAlterSQL(@NotNull DdlBuilder builder, @NotNull String type, @NotNull DasObject object, boolean dropIsNull, @NotNull SqlLanguageDialect language) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(0);
        }
        if (type == null) {
            DialectUtils.$$$reportNull$$$0(1);
        }
        if (object == null) {
            DialectUtils.$$$reportNull$$$0(2);
        }
        if (language == null) {
            DialectUtils.$$$reportNull$$$0(3);
        }
        builder.keywords("COMMENT", "ON", type).space();
        DasColumn column = (DasColumn)ObjectUtils.tryCast((Object)object, DasColumn.class);
        if (column != null) {
            builder.qualifiedRef((DasObject)column.getTable()).symbol(".").columnRef((DasObject)column).space();
        } else {
            builder.qualifiedRef(object).space();
        }
        builder.keyword("IS").space();
        if (object.getComment() == null || !dropIsNull) {
            builder.literal(language.asStringLiteral(StringUtil.notNullize((String)object.getComment())));
        } else {
            builder.literal("NULL");
        }
        return builder;
    }

    public static DdlBuilder getColumnCommentAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean dropIsNull, @NotNull SqlLanguageDialect language) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(4);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(5);
        }
        if (language == null) {
            DialectUtils.$$$reportNull$$$0(6);
        }
        return DialectUtils.getObjectCommentAlterSQL(builder, "COLUMN", (DasObject)column, dropIsNull, language);
    }

    public static DdlBuilder getColumnDropSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(7);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(8);
        }
        return DialectUtils.getColumnDropSQL(builder, column, "DROP", false, "");
    }

    public static DdlBuilder getColumnDropSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, String dropClause, boolean addConstraintClause, @NotNull String constraintClause) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(9);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(10);
        }
        if (constraintClause == null) {
            DialectUtils.$$$reportNull$$$0(11);
        }
        builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)column.getTable()).space();
        builder.keyword(dropClause).space();
        builder.columnRef((DasObject)column);
        if (addConstraintClause) {
            builder.space();
            builder.keyword(constraintClause);
        }
        return builder;
    }

    @NotNull
    public static DdlBuilder getTableDropSQL(@NotNull DdlBuilder builder, @NotNull DasTable tableInfo, boolean supportsCascade, boolean cascadeValue, boolean supportsMatViews, String cascadeClause, boolean isMatView) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(12);
        }
        if (tableInfo == null) {
            DialectUtils.$$$reportNull$$$0(13);
        }
        builder.keyword("DROP").space();
        if (tableInfo.getKind() == ObjectKind.FOREIGN_TABLE) {
            builder.keyword("FOREIGN").space().keyword("TABLE");
        } else if (supportsMatViews && isMatView) {
            builder.keyword("MATERIALIZED").space().keyword("VIEW");
        } else {
            builder.keyword("TABLE");
        }
        builder.space().qualifiedRef((DasObject)tableInfo);
        if (supportsCascade && cascadeValue && !cascadeClause.isEmpty()) {
            builder.space().keyword(cascadeClause);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DialectUtils.$$$reportNull$$$0(14);
        }
        return ddlBuilder;
    }

    @NotNull
    public static DdlBuilder getCollationDropSql(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(15);
        }
        if (object == null) {
            DialectUtils.$$$reportNull$$$0(16);
        }
        DdlBuilder ddlBuilder = builder.keyword("DROP").space().keyword("COLLATION").space().qualifiedRef(object);
        if (ddlBuilder == null) {
            DialectUtils.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    public static DdlBuilder getColumnNullableAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn info, @NotNull String alterClause, boolean specifyType) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(18);
        }
        if (info == null) {
            DialectUtils.$$$reportNull$$$0(19);
        }
        if (alterClause == null) {
            DialectUtils.$$$reportNull$$$0(20);
        }
        return DialectUtils.getColumnNullableAlterSQL(builder, (DasTypedObject)info, !info.isNotNull(), alterClause, specifyType);
    }

    public static DdlBuilder getColumnNullableAlterSQL(@NotNull DdlBuilder builder, @NotNull DasTypedObject column, boolean nullable, @NotNull String alterClause, boolean specifyType) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(21);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(22);
        }
        if (alterClause == null) {
            DialectUtils.$$$reportNull$$$0(23);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef(column.getDbParent()).space().keyword(alterClause).space();
        builder.columnRef((DasObject)column);
        if (specifyType) {
            builder.space().type(column);
        }
        DialectUtils.addNullabilityClause(builder, !nullable, true);
        return builder;
    }

    public static DdlBuilder getAddPrimaryKeySQL(@NotNull DdlBuilder builder, @NotNull DasTableKey pk, boolean appendConstraintName) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(24);
        }
        if (pk == null) {
            DialectUtils.$$$reportNull$$$0(25);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)pk.getTable());
        builder.space().keyword("ADD").space();
        if (StringUtil.isNotEmpty((String)pk.getName()) && !appendConstraintName) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (DasConstraint)pk);
        if (appendConstraintName) {
            builder.space().keyword("CONSTRAINT").space();
            builder.constraintRef((DasObject)pk);
        }
        return builder;
    }

    @NotNull
    public static DdlBuilder getAddForeignKeyConstraintSQL(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex, @NotNull DatabaseDialectEx dialect) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(26);
        }
        if (keyInfo == null) {
            DialectUtils.$$$reportNull$$$0(27);
        }
        if (dialect == null) {
            DialectUtils.$$$reportNull$$$0(28);
        }
        builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)keyInfo.getTable());
        builder.newLine().keyword("ADD").space();
        String keyName = keyInfo.getName();
        if (StringUtil.isNotEmpty((String)keyName)) {
            builder.keyword("CONSTRAINT").space();
            builder.constraintRef((DasObject)keyInfo).newLine();
        }
        dialect.sqlDefineForeignKey(builder, keyInfo, matchFull);
        builder.newStatement();
        if (autoFKIndex && StringUtil.isNotEmpty((String)keyName)) {
            DialectUtils.getAddIndexSQL(builder, (DasTableChild)keyInfo, "", "", "");
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DialectUtils.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    static DdlBuilder foreignKeyTail(DdlBuilder builder, DasForeignKey keyInfo, @Nullable DasForeignKey.Deferrability deferrabilityOverride, boolean matchFull, @Nullable DasForeignKey.RuleAction deleteOverride, @Nullable DasForeignKey.RuleAction updateOverride) {
        DasForeignKey.Deferrability deferrability;
        builder.keywords("FOREIGN", "KEY").space();
        DialectUtils.columnList(builder, (DasConstraint)keyInfo);
        DasTable table = keyInfo.getTable();
        if (table != null) {
            builder.pushDefaultSchema(ObjectPath.of((DasObject)DasUtil.getNamespace((DasObject)table)));
        }
        builder.space();
        DialectUtils.refColumnList(builder, keyInfo);
        if (table != null) {
            builder.popDefaultSchema();
        }
        if (matchFull) {
            builder.space().keyword("MATCH").space().keyword("FULL");
        }
        DialectUtils.constructFKConstraintActionClause(builder, true, deleteOverride != null ? deleteOverride : keyInfo.getDeleteRule());
        DialectUtils.constructFKConstraintActionClause(builder, false, updateOverride != null ? updateOverride : keyInfo.getUpdateRule());
        DasForeignKey.Deferrability deferrability2 = deferrability = deferrabilityOverride != null ? deferrabilityOverride : keyInfo.getDeferrability();
        if (deferrability != null) {
            if (deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE) {
                builder.space().keyword("DEFERRABLE");
            }
            if (deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED) {
                builder.space().keyword("INITIALLY").space().keyword("DEFERRED");
            }
        }
        return builder;
    }

    public static DdlBuilder getAddUniqueConstraintSQL(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(30);
        }
        if (table == null) {
            DialectUtils.$$$reportNull$$$0(31);
        }
        if (constraintName == null) {
            DialectUtils.$$$reportNull$$$0(32);
        }
        if (columns2 == null) {
            DialectUtils.$$$reportNull$$$0(33);
        }
        builder.keyword("ALTER").space().keyword("TABLE");
        builder.space();
        builder.qualifiedRef((DasObject)table);
        builder.newLine();
        builder.space();
        builder.keyword("ADD").space().keyword("CONSTRAINT");
        builder.space();
        builder.constraintRef(constraint, constraintName);
        builder.space();
        builder.keyword("UNIQUE");
        builder.space().symbol("(");
        DialectUtils.appendColumnList(builder, columns2);
        builder.symbol(")");
        return builder;
    }

    public static DdlBuilder getColumnNameAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName, @NotNull String alterClause, @NotNull String renameToClause) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(34);
        }
        if (from == null) {
            DialectUtils.$$$reportNull$$$0(35);
        }
        if (toName == null) {
            DialectUtils.$$$reportNull$$$0(36);
        }
        if (alterClause == null) {
            DialectUtils.$$$reportNull$$$0(37);
        }
        if (renameToClause == null) {
            DialectUtils.$$$reportNull$$$0(38);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)from.getTable());
        builder.space();
        builder.keyword(alterClause);
        builder.space();
        builder.columnRef((DasObject)from);
        builder.space();
        builder.keyword(renameToClause);
        builder.space();
        builder.newName(toName);
        return builder;
    }

    public static DdlBuilder getColumnDefaultAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, String alterClause, boolean specifyType, String defaultClause) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(39);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(40);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable());
        builder.space();
        builder.keyword(alterClause);
        builder.space();
        builder.columnRef((DasObject)column);
        if (specifyType) {
            builder.space().type((DasTypedObject)column);
        }
        builder.space().keyword(defaultClause).space();
        builder.literal(StringUtil.notNullize((String)column.getDefault(), (String)"NULL"));
        return builder;
    }

    public static DdlBuilder getColumnDefaultAlterOrDropSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        String defVal;
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(41);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(42);
        }
        boolean drop = (defVal = column.getDefault()) == null || defVal.isEmpty();
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column);
        if (drop) {
            builder.space().keyword("DROP").space().keyword("DEFAULT");
        } else {
            DialectUtils.addDefaultClauseIfNeeded(builder, column, "SET DEFAULT");
        }
        return builder;
    }

    public static void addDefaultClauseIfNeeded(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull String defaultClause) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(43);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(44);
        }
        if (defaultClause == null) {
            DialectUtils.$$$reportNull$$$0(45);
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, defaultClause, column.getDefault());
    }

    public static void addDefaultClauseIfNeeded(@NotNull DdlBuilder builder, @NotNull String defaultClause, @Nullable String defVal) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(46);
        }
        if (defaultClause == null) {
            DialectUtils.$$$reportNull$$$0(47);
        }
        if (StringUtil.isNotEmpty((String)defVal)) {
            builder.space().keyword(defaultClause).space();
            builder.literal(defVal);
        }
    }

    public static void addCommentClauseIfNeeded(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull SqlLanguageDialect language) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(48);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(49);
        }
        if (language == null) {
            DialectUtils.$$$reportNull$$$0(50);
        }
        if (!StringUtil.isEmpty((String)column.getComment())) {
            builder.space().keyword("COMMENT").space().literal(language.asStringLiteral(column.getComment()));
        }
    }

    public static void addNullabilityClause(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean supportsNullQualifier) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(51);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(52);
        }
        DialectUtils.addNullabilityClause(builder, column.isNotNull(), supportsNullQualifier);
    }

    public static void addNullabilityClause(@NotNull DdlBuilder builder, boolean notNull, boolean supportsNullQualifier) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(53);
        }
        if (notNull) {
            builder.space().keyword("NOT");
        }
        if (supportsNullQualifier || notNull) {
            builder.space().keyword("NULL");
        }
    }

    @NotNull
    public static DdlBuilder getColumnTypeAlterSQL(@NotNull DdlBuilder builder, @NotNull String alterClause, @NotNull String setClause, boolean repeatColumn, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(54);
        }
        if (alterClause == null) {
            DialectUtils.$$$reportNull$$$0(55);
        }
        if (setClause == null) {
            DialectUtils.$$$reportNull$$$0(56);
        }
        if (to == null) {
            DialectUtils.$$$reportNull$$$0(57);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)to.getTable());
        builder.space();
        builder.keyword(alterClause);
        builder.space();
        if (repeatColumn) {
            builder.columnRef((DasObject)to);
            builder.space();
        }
        builder.columnRef((DasObject)to);
        builder.space();
        if (!setClause.isEmpty()) {
            builder.keyword(setClause);
            builder.space();
        }
        builder.type((DasTypedObject)to);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DialectUtils.$$$reportNull$$$0(58);
        }
        return ddlBuilder;
    }

    public static DdlBuilder getDropPrimaryKeySQL(@NotNull DdlBuilder builder, @NotNull DasTableKey pk, boolean useConstraintName, boolean cascadeConstraints) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(59);
        }
        if (pk == null) {
            DialectUtils.$$$reportNull$$$0(60);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)pk.getTable());
        if (useConstraintName) {
            builder.space().keyword("DROP").space().keyword("CONSTRAINT").space();
            builder.constraintRef((DasObject)pk);
        } else {
            builder.space().keywords("DROP", "PRIMARY", "KEY");
        }
        if (cascadeConstraints) {
            builder.space().keyword("CASCADE");
        }
        return builder;
    }

    public static DdlBuilder getDropIndexSQL(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, @Nullable Boolean cascade, boolean onTable) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(61);
        }
        if (table == null) {
            DialectUtils.$$$reportNull$$$0(62);
        }
        if (indexName == null) {
            DialectUtils.$$$reportNull$$$0(63);
        }
        builder.keyword("DROP").space().keyword("INDEX");
        builder.space();
        builder.qualifiedRefOpt((DasObject)index, (DasObject)table, indexName);
        if (cascade != null) {
            builder.space().keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        if (onTable) {
            builder.space().keyword("ON").space().qualifiedRef((DasObject)table);
        }
        return builder;
    }

    public static DdlBuilder getDropSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasObject sequence, @Nullable Boolean cascade) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(64);
        }
        if (sequence == null) {
            DialectUtils.$$$reportNull$$$0(65);
        }
        builder.keywords("DROP", "SEQUENCE").space().qualifiedRef(sequence);
        if (cascade != null) {
            builder.space().keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        return builder;
    }

    public static DdlBuilder getDropConstraintSQL(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(66);
        }
        if (table == null) {
            DialectUtils.$$$reportNull$$$0(67);
        }
        if (constraintName == null) {
            DialectUtils.$$$reportNull$$$0(68);
        }
        return builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef((DasObject)table).space().keyword("DROP").space().keyword("CONSTRAINT").space().constraintRef(constraint, constraintName);
    }

    public static DdlBuilder getDropViewSQL(@NotNull DdlBuilder builder, @NotNull DasTable view2, @Nullable Boolean cascade) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(69);
        }
        if (view2 == null) {
            DialectUtils.$$$reportNull$$$0(70);
        }
        builder.keyword("DROP").space().keyword("VIEW").space().qualifiedRef((DasObject)view2);
        if (cascade != null) {
            builder.space();
            builder.keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        return builder;
    }

    public static DdlBuilder getAddIndexSQL(@NotNull DdlBuilder builder, @NotNull DasTableChild keyOrIndex, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(71);
        }
        if (keyOrIndex == null) {
            DialectUtils.$$$reportNull$$$0(72);
        }
        if (accessMethod == null) {
            DialectUtils.$$$reportNull$$$0(73);
        }
        if (tablespace == null) {
            DialectUtils.$$$reportNull$$$0(74);
        }
        if (constraints == null) {
            DialectUtils.$$$reportNull$$$0(75);
        }
        builder.keyword("CREATE").space();
        if (!(keyOrIndex instanceof DasIndex) || ((DasIndex)keyOrIndex).isUnique()) {
            builder.keyword("UNIQUE").space();
        }
        builder.keyword("INDEX").space();
        builder.identifier((DasObject)keyOrIndex, keyOrIndex.getName());
        builder.space().keyword("ON").space().qualifiedRef((DasObject)keyOrIndex.getTable()).space();
        if (!accessMethod.isEmpty()) {
            builder.keyword("USING").space();
            builder.plain(accessMethod).space();
        }
        if (keyOrIndex instanceof DasIndex) {
            DialectUtils.columnList(builder, (DasIndex)keyOrIndex);
        } else {
            DialectUtils.columnList(builder, (DasConstraint)keyOrIndex);
        }
        if (!tablespace.isEmpty()) {
            builder.newLine().space().keyword("TABLESPACE").space().ref(null, tablespace);
        }
        if (!constraints.isEmpty()) {
            builder.newLine().space().keyword("WHERE").space().plain(constraints);
        }
        return builder;
    }

    public static DdlBuilder getRenameTableSQL(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newTableName) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(76);
        }
        if (table == null) {
            DialectUtils.$$$reportNull$$$0(77);
        }
        if (newTableName == null) {
            DialectUtils.$$$reportNull$$$0(78);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keyword("RENAME").space().keyword("TO").space();
        builder.newName(newTableName, (DasObject)table);
        return builder;
    }

    public static DdlBuilder getDropForeignKeySQL(@NotNull DdlBuilder builder, @Nullable DasForeignKey fk, @NotNull String fkName, @NotNull DasTable table) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(79);
        }
        if (fkName == null) {
            DialectUtils.$$$reportNull$$$0(80);
        }
        if (table == null) {
            DialectUtils.$$$reportNull$$$0(81);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef((DasObject)table).space().keyword("DROP").space().keyword("CONSTRAINT").space().constraintRef((DasObject)fk, fkName);
        return builder;
    }

    public static void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode, int dirPos, boolean inOutSeparate) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(82);
        }
        DasArgument.Direction parameterType = parameter.getArgumentDirection();
        if (dirPos == 0) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, true);
        }
        if (longMode && StringUtil.isNotEmpty((String)parameter.getName())) {
            if (builder.getDialect().getFamilyId().isTransactSql()) {
                builder.plain(parameter.getName()).space();
            } else {
                builder.identifier((DasObject)parameter, parameter.getName()).space();
            }
        }
        if (dirPos == 1) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, true);
        }
        builder.type((DasTypedObject)parameter);
        if (dirPos == 2) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, false);
        }
    }

    public static void sqlParameterDirection(@NotNull DdlBuilder builder, DasArgument.Direction parameterType, boolean inOutSeparate, boolean space) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(83);
        }
        if (parameterType != DasArgument.Direction.IN) {
            if (!space) {
                builder.space();
            }
            if (inOutSeparate && parameterType == DasArgument.Direction.INOUT) {
                builder.keywords("IN", "OUT");
            } else {
                builder.keyword(parameterType.name());
            }
            if (space) {
                builder.space();
            }
        }
    }

    @NotNull
    public static DdlBuilder getCreateTableSQL(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @NotNull DatabaseDialectEx dialect, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(84);
        }
        if (tables == null) {
            DialectUtils.$$$reportNull$$$0(85);
        }
        if (dialect == null) {
            DialectUtils.$$$reportNull$$$0(86);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateTableSQL(builder, tables, constraintsAtEnd, false, dialect, ignoreFks);
        if (ddlBuilder == null) {
            DialectUtils.$$$reportNull$$$0(87);
        }
        return ddlBuilder;
    }

    public static <T> boolean contains(@Nullable Collection<? extends T> col, T item) {
        return col != null && col.contains(item);
    }

    @NotNull
    public static DdlBuilder getCreateTableSQL(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, boolean suppressKeysCreation, @NotNull DatabaseDialectEx dialect, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(88);
        }
        if (tables == null) {
            DialectUtils.$$$reportNull$$$0(89);
        }
        if (dialect == null) {
            DialectUtils.$$$reportNull$$$0(90);
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(dialect);
        boolean fkInside = tables.size() == 1 && !DasUtil.getForeignKeys((DasTable)tables.get(0)).isEmpty() || !dialect.supportsAddForeignKey() || ignoreFks != null;
        boolean first0 = true;
        Iterator<? extends DasTable> iterator = tables.iterator();
        while (iterator.hasNext()) {
            DasTable dasTable;
            DasTable table = dasTable = iterator.next();
            DasTable tableDelegate = null;
            if (table instanceof DbTableImpl) {
                tableDelegate = (DasTable)((DbTableImpl)table).getDelegate();
            }
            if (tableDelegate != null) {
                table = tableDelegate;
            }
            if (first0) {
                first0 = false;
            } else {
                builder.newStatement();
            }
            builder.keyword("CREATE").space().keyword("TABLE").space();
            builder.qualifiedRef((DasObject)dasTable);
            builder.newLine().symbol("(");
            DasTableKey pkInfo = builder.isJdbcOdbc() ? null : DasUtil.getPrimaryKey((DasTable)table);
            MultiRef pkColumnsRef = pkInfo == null ? DasUtil.emptyMultiRef() : pkInfo.getColumnsRef();
            boolean oneColumnPk = pkColumnsRef.size() == 1;
            JBIterable infos = DasUtil.getColumns((DasObject)table);
            boolean first = true;
            for (DasColumn column : builder.sortKeysIfNeeded(infos)) {
                if (first) {
                    first = false;
                } else {
                    builder.symbol(",");
                }
                builder.newLine().tab();
                boolean isSinglePk = oneColumnPk && DasUtil.containsName((String)column.getName(), (MultiRef)pkColumnsRef);
                dialect.sqlDefineColumn(builder, column, isSinglePk);
            }
            if (pkColumnsRef.size() > 1) {
                String name;
                builder.symbol(",").newLine().tab();
                String string = name = pkInfo != null ? pkInfo.getName() : null;
                if (StringUtil.isNotEmpty((String)name) && !QNameUtil.isFakeName(name)) {
                    builder.keyword("CONSTRAINT").space();
                    builder.identifier((DasObject)pkInfo, name).space();
                }
                builder.keywords("PRIMARY", "KEY").space();
                DialectUtils.columnList(builder, (DasConstraint)pkInfo);
            }
            if (fkInside && !suppressKeysCreation) {
                for (DasForeignKey foreignKeyInfo : DasUtil.getForeignKeys((DasTable)table)) {
                    if (DialectUtils.contains(ignoreFks, foreignKeyInfo)) continue;
                    builder.symbol(",").newLine();
                    builder.tab();
                    String name = foreignKeyInfo.getName();
                    if (StringUtil.isNotEmpty((String)name) && !QNameUtil.isFakeName(name)) {
                        builder.keyword("CONSTRAINT").space();
                        builder.identifier((DasObject)foreignKeyInfo, name).space();
                    }
                    dialect.sqlDefineForeignKey(builder, foreignKeyInfo, false);
                }
            }
            if (table.getKind() != ObjectKind.VIEW) {
                for (DasIndex index : DasUtil.getIndices((DasTable)table)) {
                    String indexName;
                    if (pkInfo instanceof BasicKey && Comparing.equal((String)((BasicKey)pkInfo).getUnderlyingIndexName(), (String)index.getName()) || StringUtil.isNotEmpty((String)(indexName = index.getName()))) continue;
                    builder.symbol(",").newLine();
                    builder.tab();
                    if (index.isUnique()) {
                        builder.keyword("UNIQUE").space();
                    }
                    builder.keyword("INDEX").space();
                    DialectUtils.columnList(builder, index);
                }
            }
            builder.newLine().symbol(")");
            if (builder.isJdbcOdbc()) continue;
            if (!constraintsAtEnd && !suppressKeysCreation) {
                DialectUtils.createConstraintsAndIndices(builder, table, tables, fkInside, dialect);
            }
            if (!dialect.supportsColumnComment() || dialect.supportsColumnCommentsInTableDefinition()) continue;
            for (DasColumn info : infos) {
                if (!StringUtil.isNotEmpty((String)info.getComment())) continue;
                DialectUtils.getColumnCommentAlterSQL(builder.newStatement(), info, false, language);
            }
        }
        if (constraintsAtEnd && !suppressKeysCreation) {
            for (DasTable dasTable : tables) {
                DialectUtils.createConstraintsAndIndices(builder, dasTable, tables, fkInside, dialect);
            }
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DialectUtils.$$$reportNull$$$0(91);
        }
        return ddlBuilder;
    }

    private static void createConstraintsAndIndices(@NotNull DdlBuilder builder, @NotNull DasTable tableInfo, @NotNull List<? extends DasTable> tables, boolean fkInside, @NotNull DatabaseDialectEx dialect) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(92);
        }
        if (tableInfo == null) {
            DialectUtils.$$$reportNull$$$0(93);
        }
        if (tables == null) {
            DialectUtils.$$$reportNull$$$0(94);
        }
        if (dialect == null) {
            DialectUtils.$$$reportNull$$$0(95);
        }
        if (!fkInside) {
            DialectUtils.createConstraints(builder, tableInfo, tables, !builder.skipExternalReferences(), dialect);
        }
        DialectUtils.createIndices(builder, tableInfo);
    }

    public static <E> Iterable<E> resolve(final @NotNull MultiRef<E> ref) {
        if (ref == null) {
            DialectUtils.$$$reportNull$$$0(96);
        }
        return new Iterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                Iterator iterator = new Iterator<E>(){
                    MultiRef.It<E> it;
                    {
                        this.it = ref.iterate();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public E next() {
                        this.it.next();
                        return this.it.resolve();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils$1", "iterator"));
            }
        };
    }

    public static void columnList(DdlBuilder builder, DasConstraint o) {
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)o.getColumnsRef());
    }

    public static void columnList(DdlBuilder builder, DasIndex o) {
        builder.symbol("(");
        boolean first = true;
        MultiRef.It it = o.getColumnsRef().iterate();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasTypedObject column = (DasTypedObject)it.resolve();
            if (column != null) {
                builder.columnRef((DasObject)column);
                DasIndex.Sorting sorting = o.getColumnSorting(column);
                if (sorting != DasIndex.Sorting.DESCENDING) continue;
                builder.space().keyword("DESC");
                continue;
            }
            if (name.length() >= 2 && name.charAt(0) == '\u001b') {
                builder.plain(name.substring(1));
                continue;
            }
            builder.columnRef(name);
        }
        builder.symbol(")");
    }

    public static void columnList(DdlBuilder builder, MultiRef<? extends DasTypedObject> o) {
        DialectUtils.columnList(builder, o, false);
    }

    public static boolean columnList(DdlBuilder builder, MultiRef<? extends DasTypedObject> o, boolean noParensForEmpty) {
        boolean first = true;
        MultiRef.It it = o.iterate();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (first) {
                builder.symbol("(");
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasTypedObject column = (DasTypedObject)it.resolve();
            if (column != null) {
                builder.columnRef((DasObject)column);
                continue;
            }
            builder.columnRef((String)ObjectUtils.chooseNotNull((Object)name, (Object)DasUtil.NO_NAME));
        }
        if (!first) {
            builder.symbol(")");
        } else if (!noParensForEmpty) {
            builder.symbol("(").symbol(")");
        } else {
            return false;
        }
        return true;
    }

    public static void refColumnList(DdlBuilder builder, DasForeignKey keyInfo) {
        String refTableName = StringUtil.notNullize((String)keyInfo.getRefTableName());
        builder.keyword("REFERENCES").space().qualifiedRefOpt((DasObject)keyInfo.getRefTable(), refTableName);
        DdlBuilder.Marker mark = builder.mark();
        builder.space();
        if (!DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)keyInfo.getRefColumns(), true)) {
            mark.replace("");
        }
        mark.finish();
    }

    public static DdlBuilder getColumnDefinitionSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean isSinglePkColumn) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(97);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(98);
        }
        return DialectUtils.getColumnDefinitionSQL(builder, column, isSinglePkColumn, null);
    }

    public static DdlBuilder getColumnDefinitionSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean isSinglePkColumn, @Nullable String type) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(99);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(100);
        }
        builder.columnRef((DasObject)column);
        builder.space();
        if (type != null) {
            builder.type(type);
        } else {
            builder.type((DasTypedObject)column);
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        if (isSinglePkColumn) {
            builder.space().keywords("PRIMARY", "KEY");
        }
        DialectUtils.addNullabilityClause(builder, column, false);
        return builder;
    }

    public static DdlBuilder getCreateViewSQL(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption, @NotNull DatabaseDialectEx dialect) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(101);
        }
        if (view2 == null) {
            DialectUtils.$$$reportNull$$$0(102);
        }
        if (definition == null) {
            DialectUtils.$$$reportNull$$$0(103);
        }
        if (checkOption == null) {
            DialectUtils.$$$reportNull$$$0(104);
        }
        if (dialect == null) {
            DialectUtils.$$$reportNull$$$0(105);
        }
        builder.keyword("CREATE").space().keyword("VIEW").space().qualifiedRef((DasObject)view2).space().keyword("AS").space().plain(definition);
        if (dialect.supportsCheckOptionsForViews() && !checkOption.isEmpty()) {
            builder.newLine().keyword("WITH").space().keyword(checkOption).space().keyword("CHECK").space().keyword("OPTION");
        }
        return builder;
    }

    public static DdlBuilder getCreateSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimumClause, @NotNull String minimum, @NotNull String maximumClause, @NotNull String maximum, @NotNull String start, @NotNull String cache, @NotNull String cycleClause) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(106);
        }
        if (sequence == null) {
            DialectUtils.$$$reportNull$$$0(107);
        }
        if (increment == null) {
            DialectUtils.$$$reportNull$$$0(108);
        }
        if (minimumClause == null) {
            DialectUtils.$$$reportNull$$$0(109);
        }
        if (minimum == null) {
            DialectUtils.$$$reportNull$$$0(110);
        }
        if (maximumClause == null) {
            DialectUtils.$$$reportNull$$$0(111);
        }
        if (maximum == null) {
            DialectUtils.$$$reportNull$$$0(112);
        }
        if (start == null) {
            DialectUtils.$$$reportNull$$$0(113);
        }
        if (cache == null) {
            DialectUtils.$$$reportNull$$$0(114);
        }
        if (cycleClause == null) {
            DialectUtils.$$$reportNull$$$0(115);
        }
        builder.keyword("CREATE").space().keyword("SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence);
        if (!increment.isEmpty()) {
            builder.space().keyword("INCREMENT").space().keyword("BY").space().literal(increment);
        }
        if (!minimumClause.isEmpty()) {
            builder.space().keyword(minimumClause);
        }
        if (!minimum.isEmpty()) {
            builder.space().literal(minimum);
        }
        if (!maximumClause.isEmpty()) {
            builder.space().keyword(maximumClause);
        }
        if (!maximum.isEmpty()) {
            builder.space().literal(maximum);
        }
        if (!start.isEmpty()) {
            builder.space().keywords("START", "WITH");
            builder.space().literal(start);
        }
        if (!cache.isEmpty()) {
            builder.space().keyword("CACHE");
            builder.space().literal(cache);
        }
        if (!cycleClause.isEmpty()) {
            builder.space().keyword(cycleClause);
        }
        return builder;
    }

    public static DdlBuilder getCreateSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasTable sequenceName, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, @NotNull String cycleClause) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(116);
        }
        if (sequenceName == null) {
            DialectUtils.$$$reportNull$$$0(117);
        }
        if (increment == null) {
            DialectUtils.$$$reportNull$$$0(118);
        }
        if (minimum == null) {
            DialectUtils.$$$reportNull$$$0(119);
        }
        if (maximum == null) {
            DialectUtils.$$$reportNull$$$0(120);
        }
        if (start == null) {
            DialectUtils.$$$reportNull$$$0(121);
        }
        if (cache == null) {
            DialectUtils.$$$reportNull$$$0(122);
        }
        if (cycleClause == null) {
            DialectUtils.$$$reportNull$$$0(123);
        }
        return DialectUtils.getCreateSequenceSQL(builder, sequenceName, increment, !minimum.isEmpty() ? "MINVALUE" : "NO MINVALUE", minimum, !maximum.isEmpty() ? "MAXVALUE" : "NO MAXVALUE", maximum, start, cache, cycleClause);
    }

    public static DdlBuilder getAlterSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, @NotNull String cycleClause) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(124);
        }
        if (sequence == null) {
            DialectUtils.$$$reportNull$$$0(125);
        }
        if (increment == null) {
            DialectUtils.$$$reportNull$$$0(126);
        }
        if (minimum == null) {
            DialectUtils.$$$reportNull$$$0(127);
        }
        if (maximum == null) {
            DialectUtils.$$$reportNull$$$0(128);
        }
        if (restart == null) {
            DialectUtils.$$$reportNull$$$0(129);
        }
        if (cache == null) {
            DialectUtils.$$$reportNull$$$0(130);
        }
        if (cycleClause == null) {
            DialectUtils.$$$reportNull$$$0(131);
        }
        builder.keywords("ALTER", "SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence).newLine();
        if (!increment.isEmpty()) {
            builder.keywords("INCREMENT", "BY").space();
            builder.literal(increment).space();
        }
        if (!minimum.isEmpty()) {
            builder.keyword("MINVALUE").space();
            builder.literal(minimum).space();
        } else {
            builder.keywords("NO", "MINVALUE");
        }
        if (!maximum.isEmpty()) {
            builder.keyword("MAXVALUE").space();
            builder.literal(maximum).newLine();
        } else {
            builder.keyword("NO").keyword("MAXVALUE").newLine();
        }
        if (!restart.isEmpty()) {
            builder.keywords("RESTART", "WITH").space();
            builder.plain(restart).space();
        }
        if (!cache.isEmpty()) {
            builder.keyword("CACHE").space();
            builder.plain(cache).space();
        }
        if (!cycleClause.isEmpty()) {
            builder.keyword(cycleClause);
        }
        return builder;
    }

    public static void createIndices(@NotNull DdlBuilder builder, @NotNull DasTable table) {
        DasTableKey pk;
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(132);
        }
        if (table == null) {
            DialectUtils.$$$reportNull$$$0(133);
        }
        if (table.getKind() == ObjectKind.VIEW) {
            return;
        }
        if (table instanceof DbTableImpl) {
            table = (DasTable)((DbTableImpl)table).getDelegate();
        }
        String pkName = (pk = DasUtil.getPrimaryKey((DasTable)table)) != null ? pk.getName() : null;
        boolean isOracle = builder.getDialect() instanceof OracleDialect;
        for (DasIndex ind : DasUtil.getIndices((DasTable)table)) {
            DasIndex index = ind instanceof DbIndex ? (DasIndex)((DbIndex)ind).getDelegate() : ind;
            String indexName = index.getName();
            if (StringUtil.isEmpty((String)indexName) || pk instanceof BasicKey && indexName.equals(((BasicKey)pk).getUnderlyingIndexName()) || index.isUnique() && isOracle && pkName != null && pkName.equals(indexName)) continue;
            builder.newStatement();
            builder.keyword("CREATE").space();
            if (index.isUnique()) {
                builder.keyword("UNIQUE").space();
            }
            builder.keyword("INDEX").space();
            builder.identifier((DasObject)index, indexName);
            builder.space().keyword("ON").space();
            builder.qualifiedRef((DasObject)table).space();
            DialectUtils.columnList(builder, index);
        }
    }

    public static void createConstraints(@NotNull DdlBuilder builder, @NotNull DasTable tableInfo, @NotNull List<? extends DasTable> tables, boolean includeExternalReferences, @NotNull DatabaseDialectEx dialect) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(134);
        }
        if (tableInfo == null) {
            DialectUtils.$$$reportNull$$$0(135);
        }
        if (tables == null) {
            DialectUtils.$$$reportNull$$$0(136);
        }
        if (dialect == null) {
            DialectUtils.$$$reportNull$$$0(137);
        }
        for (DasForeignKey keyInfo : DasUtil.getForeignKeys((DasTable)tableInfo)) {
            if (!includeExternalReferences) {
                boolean found = false;
                for (DasTable dasTable : tables) {
                    if (!dasTable.getName().equalsIgnoreCase(keyInfo.getRefTableName())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            builder.newStatement();
            builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef((DasObject)keyInfo.getTable()).space();
            builder.keyword("ADD").space();
            dialect.sqlDefineForeignKey(builder, keyInfo, false);
        }
    }

    private static void constructFKConstraintActionClause(@NotNull DdlBuilder builder, boolean onDelete, DasForeignKey.RuleAction rule) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(138);
        }
        if (rule == null) {
            return;
        }
        String updateDelete = onDelete ? "DELETE" : "UPDATE";
        switch (rule) {
            case CASCADE: {
                builder.space().keyword("ON").space().keyword(updateDelete);
                builder.space().keyword("CASCADE");
                break;
            }
            case SET_NULL: {
                builder.space().keyword("ON").space().keyword(updateDelete);
                builder.space().keyword("SET").space().keyword("NULL");
                break;
            }
            case SET_DEFAULT: {
                builder.space().keyword("ON").space().keyword(updateDelete);
                builder.space().keyword("SET").space().keyword("DEFAULT");
                break;
            }
        }
    }

    public static DdlBuilder getAddColumnSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean addDefaultClause, boolean supportsNullQualifier, boolean addNullClause) throws UnsupportedOperationException {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(139);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(140);
        }
        return DialectUtils.getAddColumnSQL(builder, column, addDefaultClause, supportsNullQualifier, addNullClause, null);
    }

    public static DdlBuilder getAddColumnSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean addDefaultClause, boolean supportsNullQualifier, boolean addNullClause, @Nullable String type) throws UnsupportedOperationException {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(141);
        }
        if (column == null) {
            DialectUtils.$$$reportNull$$$0(142);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable());
        builder.space();
        builder.keyword("ADD");
        builder.space();
        builder.newName(column.getName());
        builder.space();
        if (type != null) {
            builder.type(type);
        } else {
            builder.type((DasTypedObject)column);
        }
        if (addDefaultClause) {
            DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        }
        if (addNullClause && (column.getDataType().getLength() != -1 || column.getDataType().getScale() != -1)) {
            DialectUtils.addNullabilityClause(builder, column, supportsNullQualifier);
        }
        return builder;
    }

    @NotNull
    public static String stripQuotesFromIdentifier(@NotNull DatabaseDialectEx dialect, @NotNull String identifier, @NotNull String strWithQuotes) {
        if (dialect == null) {
            DialectUtils.$$$reportNull$$$0(143);
        }
        if (identifier == null) {
            DialectUtils.$$$reportNull$$$0(144);
        }
        if (strWithQuotes == null) {
            DialectUtils.$$$reportNull$$$0(145);
        }
        String string = strWithQuotes.replaceAll(dialect.quoteIdentifier(identifier, true, false), identifier);
        if (string == null) {
            DialectUtils.$$$reportNull$$$0(146);
        }
        return string;
    }

    @NotNull
    public static String toHexString(@NotNull byte[] bytes) {
        if (bytes == null) {
            DialectUtils.$$$reportNull$$$0(147);
        }
        CharOut out = CharOut.Util.newSink(new StringBuilder(bytes.length * 2));
        for (byte b : bytes) {
            DialectUtils.appendHex(out, (long)b & 0xFFL, 2);
        }
        String string = out.toString();
        if (string == null) {
            DialectUtils.$$$reportNull$$$0(148);
        }
        return string;
    }

    @NotNull
    public static String toPresentableHexString(@NotNull byte[] bytes) {
        String string;
        if (bytes == null) {
            DialectUtils.$$$reportNull$$$0(149);
        }
        try {
            int expectedLength = (bytes.length / 16 + 1) * 78;
            CharOut out = CharOut.Util.newSink(new StringBuilder(expectedLength));
            DialectUtils.toPresentableHexString(new ByteArrayInputStream(bytes), out);
            string = out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            DialectUtils.$$$reportNull$$$0(150);
        }
        return string;
    }

    public static void toPresentableHexString(@NotNull InputStream input, @NotNull CharOut output) throws IOException {
        if (input == null) {
            DialectUtils.$$$reportNull$$$0(151);
        }
        if (output == null) {
            DialectUtils.$$$reportNull$$$0(152);
        }
        long i2 = 0L;
        StringBuilder sb2 = new StringBuilder();
        while (input.available() > 0) {
            sb2.setLength(0);
            DialectUtils.appendHex(output, i2 * 16L, 8).append("  ");
            for (int j = 0; j < 16; ++j) {
                if (input.available() > 0) {
                    int value = input.read();
                    DialectUtils.appendHex(output, value, 2).append(" ");
                    sb2.append((char)(!Character.isISOControl(value) ? (int)value : 46));
                    continue;
                }
                while (j < 16) {
                    output.append("   ");
                    ++j;
                }
            }
            output.append("   ").append(sb2).append("\n");
            ++i2;
        }
        input.close();
    }

    private static CharOut appendHex(CharOut out, long value, int padTo) {
        String hex = Long.toHexString(value);
        for (int i2 = hex.length(); i2 < padTo; ++i2) {
            out.append("0");
        }
        return out.append(hex.toUpperCase(Locale.ENGLISH));
    }

    @NotNull
    public static DdlBuilder getCreateViewWithCheckOptionSQL(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(153);
        }
        if (view2 == null) {
            DialectUtils.$$$reportNull$$$0(154);
        }
        if (definition == null) {
            DialectUtils.$$$reportNull$$$0(155);
        }
        if (checkOption == null) {
            DialectUtils.$$$reportNull$$$0(156);
        }
        builder.keywords("CREATE", "VIEW").space();
        builder.qualifiedRef((DasObject)view2).space();
        builder.keyword("AS").space();
        builder.plain(definition);
        if (!checkOption.isEmpty()) {
            builder.space().keywords("WITH", "CHECK", "OPTION");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DialectUtils.$$$reportNull$$$0(157);
        }
        return ddlBuilder;
    }

    static DdlBuilder createIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(158);
        }
        if (index == null) {
            DialectUtils.$$$reportNull$$$0(159);
        }
        if (accessMethod == null) {
            DialectUtils.$$$reportNull$$$0(160);
        }
        builder.keyword("CREATE").space();
        if (index.isUnique()) {
            builder.keyword("UNIQUE").space();
            if ("HASH".equalsIgnoreCase(accessMethod)) {
                builder.keyword("HASH").space();
            }
        }
        builder.keyword("INDEX").space();
        builder.identifier((DasObject)index, index.getName()).space();
        builder.keyword("ON").space();
        builder.qualifiedRef((DasObject)index.getTable()).space();
        DialectUtils.columnList(builder, index);
        return builder;
    }

    static DdlBuilder alterSequenceSQL(DdlBuilder builder, DasTable sequence, String increment, String restart) {
        builder.keywords("ALTER", "SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence).space();
        if (StringUtil.isNotEmpty((String)restart)) {
            builder.keywords("RESTART", "WITH").space();
            builder.literal(restart);
        }
        if (StringUtil.isNotEmpty((String)increment)) {
            builder.space().keywords("INCREMENT", "BY").space();
            builder.literal(increment);
        }
        return builder;
    }

    @NotNull
    public static String sqlConcat(@NotNull List<String> statements2) {
        if (statements2 == null) {
            DialectUtils.$$$reportNull$$$0(161);
        }
        String string = StringUtil.join(statements2, (String)";\n") + (statements2.isEmpty() ? "" : ";");
        if (string == null) {
            DialectUtils.$$$reportNull$$$0(162);
        }
        return string;
    }

    public static void appendColumnList(DdlBuilder builder, Iterable<DasColumn> columns2) {
        DialectUtils.appendColumnList(null, builder, columns2);
    }

    public static void appendColumnList(@Nullable String alias, DdlBuilder builder, Iterable<DasColumn> columns2) {
        boolean first = true;
        for (DasColumn column : columns2) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.columnRef((DasObject)column);
        }
    }

    public static void appendStringList(DdlBuilder builder, Iterable<String> columns2) {
        boolean first = true;
        for (String column : columns2) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.columnRef(column);
        }
    }

    public static void appendPlainList(DdlBuilder builder, Iterable<String> values) {
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.plain(value);
        }
    }

    static DdlBuilder sqlDropProcedure(DdlBuilder builder, DasRoutine procedure, boolean ifExists) {
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type).space();
        if (ifExists) {
            builder.keywords("IF", "EXISTS").space();
        }
        return builder.qualifiedRef((DasObject)procedure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 17: 
            case 29: 
            case 58: 
            case 87: 
            case 91: 
            case 146: 
            case 148: 
            case 150: 
            case 157: 
            case 162: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 17: 
            case 29: 
            case 58: 
            case 87: 
            case 91: 
            case 146: 
            case 148: 
            case 150: 
            case 157: 
            case 162: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 6: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 22: 
            case 40: 
            case 42: 
            case 44: 
            case 49: 
            case 52: 
            case 98: 
            case 100: 
            case 140: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintClause";
                break;
            }
            case 13: 
            case 93: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableInfo";
                break;
            }
            case 14: 
            case 17: 
            case 29: 
            case 58: 
            case 87: 
            case 91: 
            case 146: 
            case 148: 
            case 150: 
            case 157: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/DialectUtils";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: 
            case 23: 
            case 37: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alterClause";
                break;
            }
            case 25: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 28: 
            case 86: 
            case 90: 
            case 95: 
            case 105: 
            case 137: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 31: 
            case 62: 
            case 67: 
            case 77: 
            case 81: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 32: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameToClause";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultClause";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setClause";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 65: 
            case 107: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 70: 
            case 102: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyOrIndex";
                break;
            }
            case 73: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTableName";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkName";
                break;
            }
            case 85: 
            case 89: 
            case 94: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 103: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 104: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 108: 
            case 118: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumClause";
                break;
            }
            case 110: 
            case 119: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximumClause";
                break;
            }
            case 112: 
            case 120: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 113: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 114: 
            case 122: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 115: 
            case 123: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cycleClause";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequenceName";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strWithQuotes";
                break;
            }
            case 147: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/DialectUtils";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableDropSQL";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollationDropSql";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddForeignKeyConstraintSQL";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnTypeAlterSQL";
                break;
            }
            case 87: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateTableSQL";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesFromIdentifier";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableHexString";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateViewWithCheckOptionSQL";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlConcat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getObjectCommentAlterSQL";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColumnCommentAlterSQL";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDropSQL";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTableDropSQL";
                break;
            }
            case 14: 
            case 17: 
            case 29: 
            case 58: 
            case 87: 
            case 91: 
            case 146: 
            case 148: 
            case 150: 
            case 157: 
            case 162: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCollationDropSql";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNullableAlterSQL";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAddPrimaryKeySQL";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAddForeignKeyConstraintSQL";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAddUniqueConstraintSQL";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNameAlterSQL";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDefaultAlterSQL";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDefaultAlterOrDropSQL";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultClauseIfNeeded";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addCommentClauseIfNeeded";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addNullabilityClause";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getColumnTypeAlterSQL";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getDropPrimaryKeySQL";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getDropIndexSQL";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getDropSequenceSQL";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getDropConstraintSQL";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getDropViewSQL";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getAddIndexSQL";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getRenameTableSQL";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getDropForeignKeySQL";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameterDirection";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getCreateTableSQL";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "createConstraintsAndIndices";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDefinitionSQL";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getCreateViewSQL";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getCreateSequenceSQL";
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "getAlterSequenceSQL";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "createIndices";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "createConstraints";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "constructFKConstraintActionClause";
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getAddColumnSQL";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesFromIdentifier";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 149: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableHexString";
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getCreateViewWithCheckOptionSQL";
                break;
            }
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "sqlConcat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 17: 
            case 29: 
            case 58: 
            case 87: 
            case 91: 
            case 146: 
            case 148: 
            case 150: 
            case 157: 
            case 162: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

