/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2Dialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE).build();
    public static final H2Dialect INSTANCE = new H2Dialect();

    protected H2Dialect() {
        super(META_MODEL, new TypeHelper.H2TypeHelper(), new KeywordHelper.H2Keywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.H2;
        if (databaseFamilyId == null) {
            H2Dialect.$$$reportNull$$$0(0);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.H2;
        if (icon == null) {
            H2Dialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("H2" == null) {
            H2Dialect.$$$reportNull$$$0(2);
        }
        return "H2";
    }

    @Override
    public boolean supportsRenameDatabase() {
        return false;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            H2Dialect.$$$reportNull$$$0(3);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("H2");
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(4);
        }
        if (table == null) {
            H2Dialect.$$$reportNull$$$0(5);
        }
        if (model == null) {
            H2Dialect.$$$reportNull$$$0(6);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            H2Dialect.$$$reportNull$$$0(8);
        }
        if (connection == null) {
            H2Dialect.$$$reportNull$$$0(9);
        }
        Map<String, Object> rs = DbImplUtil.resultRowAsMap(connection, "select database() d, schema() s", new String[0]);
        String d = (String)ObjectUtils.tryCast((Object)rs.get("D"), String.class);
        String s = (String)ObjectUtils.tryCast((Object)rs.get("S"), String.class);
        return StringUtil.isEmpty((String)s) || StringUtil.isEmpty((String)d) ? null : SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.SCHEMA, Arrays.asList(d, s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            H2Dialect.$$$reportNull$$$0(10);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(11);
        }
        if (pk == null) {
            H2Dialect.$$$reportNull$$$0(12);
        }
        for (DasTypedObject column : pk.getColumnsRef().resolveObjects()) {
            if (column.isNotNull()) continue;
            DialectUtils.getColumnNullableAlterSQL(builder, column, false, "ALTER COLUMN", true);
            builder.newStatement();
        }
        builder.keywords("ALTER", "TABLE").space();
        DasTable table = pk.getTable();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("ADD").space();
        String pkName = pk.getName();
        if (StringUtil.isNotEmpty((String)pkName) && !"PRIMARY".equalsIgnoreCase(pkName)) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)pk.getColumnsRef());
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(14);
        }
        if (column == null) {
            H2Dialect.$$$reportNull$$$0(15);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnTypeNullabilityDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(17);
        }
        if (column == null) {
            H2Dialect.$$$reportNull$$$0(18);
        }
        DialectUtils.getColumnTypeAlterSQL(builder, "ALTER COLUMN", "", false, column);
        DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        DialectUtils.addNullabilityClause(builder, column, false);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(20);
        }
        if (from == null) {
            H2Dialect.$$$reportNull$$$0(21);
        }
        if (toName == null) {
            H2Dialect.$$$reportNull$$$0(22);
        }
        String alterClause = "ALTER COLUMN";
        String renameToClause = "RENAME TO";
        DdlBuilder ddlBuilder = DialectUtils.getColumnNameAlterSQL(builder, from, toName, alterClause, renameToClause);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(24);
        }
        if (from == null) {
            H2Dialect.$$$reportNull$$$0(25);
        }
        if (to == null) {
            H2Dialect.$$$reportNull$$$0(26);
        }
        int before = builder.getStatements().size();
        if (!H2Dialect.isSameName(from, to)) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!(this.isSameType(from, to) && H2Dialect.isSameNullability(from, to) && H2Dialect.isSameDefault(from, to))) {
            this.sqlAlterColumnTypeNullabilityDefault(builder, to).newStatement();
        }
        if (!H2Dialect.isSameComment(from, to)) {
            this.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!H2Dialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(28);
        }
        if (column == null) {
            H2Dialect.$$$reportNull$$$0(29);
        }
        DasTable table = column.getTable();
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("DROP").space();
        builder.columnRef((DasObject)column);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"DEFAULT", "HASH"};
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(31);
        }
        if (column == null) {
            H2Dialect.$$$reportNull$$$0(32);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable());
        builder.space().keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        builder.keyword("IDENTITY");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(33);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(34);
        }
        if (column == null) {
            H2Dialect.$$$reportNull$$$0(35);
        }
        if (attrs == null) {
            H2Dialect.$$$reportNull$$$0(36);
        }
        DialectUtils.getAddColumnSQL(builder, column, true, true, true);
        if (DasUtil.isAutoGenerated((DasColumn)column)) {
            builder.space().keyword("AUTO_INCREMENT");
        }
        builder.newStatement();
        if (StringUtil.isNotEmpty((String)column.getComment())) {
            this.sqlAlterColumnComment(builder, column);
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(38);
        }
        if (keyInfo == null) {
            H2Dialect.$$$reportNull$$$0(39);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(40);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(41);
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, null, null);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(42);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean singlePk) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(43);
        }
        if (column == null) {
            H2Dialect.$$$reportNull$$$0(44);
        }
        builder.columnRef((DasObject)column);
        builder.space();
        builder.type((DasTypedObject)column);
        DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        if (DasUtil.isAutoGenerated((DasColumn)column)) {
            builder.space().keyword("AUTO_INCREMENT");
        }
        if (singlePk) {
            builder.space().keywords("PRIMARY", "KEY");
        }
        if (column.isNotNull()) {
            builder.space().keywords("NOT", "NULL");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(46);
        }
        if (table == null) {
            H2Dialect.$$$reportNull$$$0(47);
        }
        if (constraintName == null) {
            H2Dialect.$$$reportNull$$$0(48);
        }
        if (columns2 == null) {
            H2Dialect.$$$reportNull$$$0(49);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("ADD", "CONSTRAINT").space();
        builder.constraintRef(constraint, constraintName).space();
        builder.keyword("UNIQUE").space();
        builder.symbol("(");
        DialectUtils.appendColumnList(builder, columns2);
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(50);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(51);
        }
        if (sequence == null) {
            H2Dialect.$$$reportNull$$$0(52);
        }
        if (increment == null) {
            H2Dialect.$$$reportNull$$$0(53);
        }
        if (minimum == null) {
            H2Dialect.$$$reportNull$$$0(54);
        }
        if (maximum == null) {
            H2Dialect.$$$reportNull$$$0(55);
        }
        if (restart == null) {
            H2Dialect.$$$reportNull$$$0(56);
        }
        if (cache == null) {
            H2Dialect.$$$reportNull$$$0(57);
        }
        DdlBuilder ddlBuilder = DialectUtils.alterSequenceSQL(builder, sequence, increment, restart);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(58);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(59);
        }
        if (index == null) {
            H2Dialect.$$$reportNull$$$0(60);
        }
        if (accessMethod == null) {
            H2Dialect.$$$reportNull$$$0(61);
        }
        if (tablespace == null) {
            H2Dialect.$$$reportNull$$$0(62);
        }
        if (constraints == null) {
            H2Dialect.$$$reportNull$$$0(63);
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index, accessMethod);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(64);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(65);
        }
        if (sequence == null) {
            H2Dialect.$$$reportNull$$$0(66);
        }
        if (increment == null) {
            H2Dialect.$$$reportNull$$$0(67);
        }
        if (minimum == null) {
            H2Dialect.$$$reportNull$$$0(68);
        }
        if (maximum == null) {
            H2Dialect.$$$reportNull$$$0(69);
        }
        if (start == null) {
            H2Dialect.$$$reportNull$$$0(70);
        }
        if (cache == null) {
            H2Dialect.$$$reportNull$$$0(71);
        }
        builder.keywords("CREATE", "SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence);
        if (StringUtil.isNotEmpty((String)start)) {
            builder.space().keywords("START", "WITH").space().literal(start);
        }
        if (StringUtil.isNotEmpty((String)increment)) {
            builder.space().keywords("INCREMENT", "BY").space().literal(increment);
        }
        if (StringUtil.isNotEmpty((String)cache)) {
            builder.space().keyword("CACHE").space().literal(cache);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(72);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(73);
        }
        if (view2 == null) {
            H2Dialect.$$$reportNull$$$0(74);
        }
        if (definition == null) {
            H2Dialect.$$$reportNull$$$0(75);
        }
        if (checkOption == null) {
            H2Dialect.$$$reportNull$$$0(76);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewWithCheckOptionSQL(builder, view2, definition, "");
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(77);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(78);
        }
        if (table == null) {
            H2Dialect.$$$reportNull$$$0(79);
        }
        if (constraintName == null) {
            H2Dialect.$$$reportNull$$$0(80);
        }
        DdlBuilder.Marker m = builder.mark();
        DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        m.replace(DialectUtils.stripQuotesFromIdentifier(this, constraintName, m.extract()));
        m.finish();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(81);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(82);
        }
        if (table == null) {
            H2Dialect.$$$reportNull$$$0(83);
        }
        if (indexName == null) {
            H2Dialect.$$$reportNull$$$0(84);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)table);
        builder.keywords("DROP", "INDEX").space().identifier(schema, DasUtil.getName((DasObject)schema)).literal(".").identifier((DasObject)index, indexName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(85);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(86);
        }
        if (sequence == null) {
            H2Dialect.$$$reportNull$$$0(87);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SEQUENCE").space().qualifiedRef(sequence);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(88);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(89);
        }
        if (view2 == null) {
            H2Dialect.$$$reportNull$$$0(90);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "VIEW").space().qualifiedRef((DasObject)view2);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(91);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(92);
        }
        if (table == null) {
            H2Dialect.$$$reportNull$$$0(93);
        }
        if (newName == null) {
            H2Dialect.$$$reportNull$$$0(94);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table).space();
        builder.keywords("RENAME", "TO").space();
        builder.newName(newName, (DasObject)table);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(95);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String newName) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(96);
        }
        if (view2 == null) {
            H2Dialect.$$$reportNull$$$0(97);
        }
        if (newName == null) {
            H2Dialect.$$$reportNull$$$0(98);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.rename.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(99);
        }
        if (sequence == null) {
            H2Dialect.$$$reportNull$$$0(100);
        }
        builder.keyword("SELECT").space();
        builder.ref(null, "CURRENT_VALUE").symbol(",").space();
        builder.literal("'NONE'").symbol(",").space();
        builder.literal("'NONE'").symbol(",").space();
        builder.ref(null, "CACHE").symbol(",").space();
        builder.ref(null, "INCREMENT").symbol(",").space();
        builder.literal("0").space();
        builder.keyword("FROM").space().ref(null, "INFORMATION_SCHEMA.SEQUENCES").space();
        builder.keyword("WHERE").space().ref(null, "SEQUENCE_SCHEMA").space().symbol("=").space().literal("'" + DasUtil.getSchema((DasObject)sequence) + "'").space().keyword("AND").space().ref(null, "SEQUENCE_NAME").space().symbol("=").space().literal("'" + sequence.getName() + "'").space().keyword("AND").space().ref(null, "SEQUENCE_CATALOG").space().symbol("=").space().literal("'" + DasUtil.getCatalog((DasObject)sequence) + "'");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(101);
        }
        return ddlBuilder;
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return true;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsRenameRoutine() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return false;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            H2Dialect.$$$reportNull$$$0(102);
        }
        String templateStr = "select view_definition from information_schema.views where table_schema = ''{0}'' and UPPER(table_name) = UPPER(''{1}'') ";
        return Pair.create((Object)MessageFormat.format(templateStr, DasUtil.getSchema((DasObject)element), element.getName()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            H2Dialect.$$$reportNull$$$0(103);
        }
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            H2Dialect.$$$reportNull$$$0(104);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            H2Dialect.$$$reportNull$$$0(105);
        }
        if ((c0 = identifier.charAt(0)) != '_' && !Character.isLetter(c0)) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            H2Dialect.$$$reportNull$$$0(106);
        }
        if (qualifier == null) {
            H2Dialect.$$$reportNull$$$0(107);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(108);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(109);
        }
        if (statement == null) {
            H2Dialect.$$$reportNull$$$0(110);
        }
        builder.keyword("explain").space();
        if (analyze) {
            builder.keyword("analyze").space();
        }
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(111);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/H2Dialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 28: 
            case 31: 
            case 34: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 51: 
            case 59: 
            case 65: 
            case 73: 
            case 78: 
            case 82: 
            case 86: 
            case 89: 
            case 92: 
            case 96: 
            case 99: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 47: 
            case 79: 
            case 83: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 15: 
            case 18: 
            case 29: 
            case 32: 
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 48: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 52: 
            case 66: 
            case 87: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 53: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 54: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 55: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 57: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 74: 
            case 90: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 94: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/H2Dialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnTypeNullabilityDefault";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefinition";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterSequence";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSequence";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceInformation";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnTypeNullabilityDefault";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefinition";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

