/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.hsql.HsqlDB;
import com.intellij.database.model.hsql.HsqlModDatabase;
import com.intellij.database.model.hsql.HsqlModKey;
import com.intellij.database.model.hsql.HsqlModModel;
import com.intellij.database.model.hsql.HsqlModRoot;
import com.intellij.database.model.hsql.HsqlModSchema;
import com.intellij.database.model.hsql.HsqlModTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HsqldbDialect
extends AbstractDatabaseDialect
implements DatabaseDialect,
AbstractDatabaseDialect.SplitAlterColumnSupport {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE).build();
    public static final HsqldbDialect INSTANCE = new HsqldbDialect();

    protected HsqldbDialect() {
        super(META_MODEL, new TypeHelper.HSQLTypeHelper(), new KeywordHelper.HsqldbKeywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.HSQLDB;
        if (databaseFamilyId == null) {
            HsqldbDialect.$$$reportNull$$$0(0);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Hsqldb;
        if (icon == null) {
            HsqldbDialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("HSQLDB" == null) {
            HsqldbDialect.$$$reportNull$$$0(2);
        }
        return "HSQLDB";
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return false;
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            HsqldbDialect.$$$reportNull$$$0(3);
        }
        return "x" + super.getBinaryLiteralString(binaryData);
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            HsqldbDialect.$$$reportNull$$$0(4);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("HSQL");
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(5);
        }
        if (column == null) {
            HsqldbDialect.$$$reportNull$$$0(6);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(8);
        }
        if (table == null) {
            HsqldbDialect.$$$reportNull$$$0(9);
        }
        if (model == null) {
            HsqldbDialect.$$$reportNull$$$0(10);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            HsqldbDialect.$$$reportNull$$$0(12);
        }
        if (connection == null) {
            HsqldbDialect.$$$reportNull$$$0(13);
        }
        Map<String, Object> rs = DbImplUtil.resultRowAsMap(connection, "select current_catalog d, current_schema s from (values (1))", new String[0]);
        String d = (String)ObjectUtils.tryCast((Object)rs.get("D"), String.class);
        String s = (String)ObjectUtils.tryCast((Object)rs.get("S"), String.class);
        return StringUtil.isEmpty((String)s) || StringUtil.isEmpty((String)d) ? null : SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.SCHEMA, Arrays.asList(d, s)));
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database, @NotNull String name) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(14);
        }
        if (database == null) {
            HsqldbDialect.$$$reportNull$$$0(15);
        }
        if (name == null) {
            HsqldbDialect.$$$reportNull$$$0(16);
        }
        if (!this.supportsRenameDatabase()) {
            throw new UnsupportedOperationException("Rename database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "CATALOG").space().qualifiedRef((DasObject)database).space().keywords("RENAME", "TO").space().identifier((DasObject)database, name);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            HsqldbDialect.$$$reportNull$$$0(18);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    public boolean supportsRenameDatabase() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(19);
        }
        if (pk == null) {
            HsqldbDialect.$$$reportNull$$$0(20);
        }
        DdlBuilder ddlBuilder = HsqldbDialect.getAddPrimaryKeySQL(builder, pk);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @NotNull
    private static DdlBuilder getAddPrimaryKeySQL(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(22);
        }
        if (pk == null) {
            HsqldbDialect.$$$reportNull$$$0(23);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)pk.getTable()).space();
        builder.keyword("ADD").space();
        String pkName = pk.getName();
        if (StringUtil.isNotEmpty((String)pkName) && !"PRIMARY".equalsIgnoreCase(pkName)) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (DasConstraint)pk);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(25);
        }
        if (column == null) {
            HsqldbDialect.$$$reportNull$$$0(26);
        }
        throw new UnsupportedOperationException("HSQLDB doesn't support column comments");
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(27);
        }
        if (column == null) {
            HsqldbDialect.$$$reportNull$$$0(28);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        builder.keyword("SET").space();
        builder.keyword(!column.isNotNull() ? "NULL" : "NOT NULL");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(30);
        }
        if (from == null) {
            HsqldbDialect.$$$reportNull$$$0(31);
        }
        if (toName == null) {
            HsqldbDialect.$$$reportNull$$$0(32);
        }
        String alterClause = "ALTER COLUMN";
        String renameToClause = "RENAME TO";
        DdlBuilder ddlBuilder = DialectUtils.getColumnNameAlterSQL(builder, from, toName, alterClause, renameToClause);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(33);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(34);
        }
        if (from == null) {
            HsqldbDialect.$$$reportNull$$$0(35);
        }
        if (to == null) {
            HsqldbDialect.$$$reportNull$$$0(36);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnTypeAlterSQL(builder, "ALTER COLUMN", "", false, to);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(38);
        }
        if (column == null) {
            HsqldbDialect.$$$reportNull$$$0(39);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, column);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(40);
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String[] getIndexStorageOptions() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(41);
        }
        if (column == null) {
            HsqldbDialect.$$$reportNull$$$0(42);
        }
        builder.comment("Column must be a primary key and an integer type");
        builder.newStatement();
        DasTable tableOrig = column.getTable();
        BasicModKey pk = (BasicModKey)DialectUtils.withNewModel(HsqlDB.RDBMS, HsqlModModel.class, HsqlModRoot.class, root2 -> {
            if (column == null) {
                HsqldbDialect.$$$reportNull$$$0(123);
            }
            HsqlModTable table = (HsqlModTable)DialectUtils.create(((HsqlModSchema)DialectUtils.create(((HsqlModDatabase)DialectUtils.create(root2.getDatabases(), DasUtil.getCatalogObject((DasObject)tableOrig))).getSchemas(), DasUtil.getSchemaObject((DasObject)tableOrig))).getTables(), (DasObject)column.getTable());
            DialectUtils.create(table.getColumns(), (DasObject)column);
            HsqlModKey key2 = (HsqlModKey)DialectUtils.create(table.getKeys(), "PK_" + tableOrig.getName() + "_" + column.getName());
            key2.setPrimary(true);
            key2.setColNames(column.getName());
            return key2;
        });
        HsqldbDialect.getAddPrimaryKeySQL(builder, pk);
        builder.newStatement();
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)tableOrig);
        builder.space().keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        builder.keyword("IDENTITY");
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(44);
        }
        if (column == null) {
            HsqldbDialect.$$$reportNull$$$0(45);
        }
        if (attrs == null) {
            HsqldbDialect.$$$reportNull$$$0(46);
        }
        DialectUtils.getAddColumnSQL(builder, column, false, true, true);
        if (DasUtil.isAutoGenerated((DasColumn)column)) {
            builder.space().keyword("IDENTITY");
        }
        builder.newStatement();
        String defaultValue = column.getDefault();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keywords("ALTER", "COLUMN").space();
            builder.columnRef((DasObject)column);
            DialectUtils.addDefaultClauseIfNeeded(builder, column, "SET DEFAULT");
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(47);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(48);
        }
        if (keyInfo == null) {
            HsqldbDialect.$$$reportNull$$$0(49);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(50);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(51);
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, null, null);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(52);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            HsqldbDialect.$$$reportNull$$$0(53);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(54);
        }
        super.sqlDefineColumn(builder, column, singlePk);
        DdlBuilder ddlBuilder = DasUtil.isAutoGenerated((DasColumn)column) ? builder.space().keyword("IDENTITY") : builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(55);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(56);
        }
        if (table == null) {
            HsqldbDialect.$$$reportNull$$$0(57);
        }
        if (constraintName == null) {
            HsqldbDialect.$$$reportNull$$$0(58);
        }
        if (columns2 == null) {
            HsqldbDialect.$$$reportNull$$$0(59);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("ADD", "CONSTRAINT").space();
        builder.constraintRef(constraint, constraintName).space();
        builder.keyword("UNIQUE").space();
        builder.symbol("(");
        DialectUtils.appendColumnList(builder, columns2);
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(61);
        }
        if (sequence == null) {
            HsqldbDialect.$$$reportNull$$$0(62);
        }
        if (increment == null) {
            HsqldbDialect.$$$reportNull$$$0(63);
        }
        if (minimum == null) {
            HsqldbDialect.$$$reportNull$$$0(64);
        }
        if (maximum == null) {
            HsqldbDialect.$$$reportNull$$$0(65);
        }
        if (restart == null) {
            HsqldbDialect.$$$reportNull$$$0(66);
        }
        if (cache == null) {
            HsqldbDialect.$$$reportNull$$$0(67);
        }
        DdlBuilder ddlBuilder = DialectUtils.alterSequenceSQL(builder, sequence, "", restart);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(68);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(69);
        }
        if (index == null) {
            HsqldbDialect.$$$reportNull$$$0(70);
        }
        if (accessMethod == null) {
            HsqldbDialect.$$$reportNull$$$0(71);
        }
        if (tablespace == null) {
            HsqldbDialect.$$$reportNull$$$0(72);
        }
        if (constraints == null) {
            HsqldbDialect.$$$reportNull$$$0(73);
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index, "");
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(74);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(75);
        }
        if (sequence == null) {
            HsqldbDialect.$$$reportNull$$$0(76);
        }
        if (increment == null) {
            HsqldbDialect.$$$reportNull$$$0(77);
        }
        if (minimum == null) {
            HsqldbDialect.$$$reportNull$$$0(78);
        }
        if (maximum == null) {
            HsqldbDialect.$$$reportNull$$$0(79);
        }
        if (start == null) {
            HsqldbDialect.$$$reportNull$$$0(80);
        }
        if (cache == null) {
            HsqldbDialect.$$$reportNull$$$0(81);
        }
        builder.keywords("CREATE", "SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence);
        if (!start.isEmpty()) {
            builder.space().keyword("START WITH").space();
            builder.literal(start);
        }
        if (!increment.isEmpty()) {
            builder.space().keyword("INCREMENT BY").space();
            builder.literal(increment);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(82);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(83);
        }
        if (view2 == null) {
            HsqldbDialect.$$$reportNull$$$0(84);
        }
        if (definition == null) {
            HsqldbDialect.$$$reportNull$$$0(85);
        }
        if (checkOption == null) {
            HsqldbDialect.$$$reportNull$$$0(86);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewWithCheckOptionSQL(builder, view2, definition, "");
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(87);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(88);
        }
        if (table == null) {
            HsqldbDialect.$$$reportNull$$$0(89);
        }
        if (constraintName == null) {
            HsqldbDialect.$$$reportNull$$$0(90);
        }
        DdlBuilder.Marker m = builder.mark();
        DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        m.replace(DialectUtils.stripQuotesFromIdentifier(this, constraintName, m.extract()));
        m.finish();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(91);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(92);
        }
        if (table == null) {
            HsqldbDialect.$$$reportNull$$$0(93);
        }
        if (indexName == null) {
            HsqldbDialect.$$$reportNull$$$0(94);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "INDEX").space().identifier((DasObject)index, indexName);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(95);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(96);
        }
        if (sequence == null) {
            HsqldbDialect.$$$reportNull$$$0(97);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SEQUENCE").space().qualifiedRef(sequence);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(98);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(99);
        }
        if (view2 == null) {
            HsqldbDialect.$$$reportNull$$$0(100);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "VIEW").space().qualifiedRef((DasObject)view2);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(101);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(102);
        }
        if (table == null) {
            HsqldbDialect.$$$reportNull$$$0(103);
        }
        if (newName == null) {
            HsqldbDialect.$$$reportNull$$$0(104);
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)table).space().keywords("RENAME", "TO").space().identifier((DasObject)table, newName);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(105);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String newName) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(106);
        }
        if (view2 == null) {
            HsqldbDialect.$$$reportNull$$$0(107);
        }
        if (newName == null) {
            HsqldbDialect.$$$reportNull$$$0(108);
        }
        DdlBuilder ddlBuilder = this.sqlRenameTable(builder, view2, newName);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(109);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(110);
        }
        if (sequence == null) {
            HsqldbDialect.$$$reportNull$$$0(111);
        }
        builder.keyword("SELECT").space();
        builder.ref(null, "START_WITH").space().keyword("AS").space().plain("LAST_VALUE").symbol(",").space();
        builder.ref(null, "MAXIMUM_VALUE").symbol(",").space();
        builder.ref(null, "MINIMUM_VALUE").symbol(",").space();
        builder.literal("0").space().keyword("AS").space().plain("CACHE_VALUE").symbol(",").space();
        builder.ref(null, "INCREMENT").symbol(",").space();
        builder.keyword("case").space().ref(null, "INCREMENT").space().keyword("when").space().literal("'NO'").space().keyword("then").space().literal("0").space().keyword("else").space().literal("1").space().keyword("end").space().keyword("as").space().plain("INCREMENT_BY").space();
        builder.keyword("FROM").space().ref(null, "INFORMATION_SCHEMA.SYSTEM_SEQUENCES").space();
        builder.keyword("WHERE").space().ref(null, "SEQUENCE_SCHEMA").space().symbol("=").space().literal("'" + DasUtil.getSchema((DasObject)sequence) + "'").space().keyword("AND").space().ref(null, "SEQUENCE_NAME").space().symbol("=").space().literal("'" + sequence.getName() + "'");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(112);
        }
        return ddlBuilder;
    }

    public boolean supportsAccessMethods() {
        return false;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            HsqldbDialect.$$$reportNull$$$0(113);
        }
        String templateStr = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = ''{0}'' and TABLE_SCHEMA = ''{1}'' ";
        return Pair.create((Object)MessageFormat.format(templateStr, element.getName(), DasUtil.getSchema((DasObject)element)), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            HsqldbDialect.$$$reportNull$$$0(114);
        }
        String templateStr = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = ''{0}'' and ROUTINE_SCHEMA = ''{1}'' ";
        Pair pair = Pair.create((Object)MessageFormat.format(templateStr, element.getName(), DasUtil.getSchema((DasObject)element)), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            HsqldbDialect.$$$reportNull$$$0(115);
        }
        return pair;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            HsqldbDialect.$$$reportNull$$$0(116);
        }
        if (!Character.isLetter(c0 = identifier.charAt(0)) && c0 != '$' && c0 != '#') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            HsqldbDialect.$$$reportNull$$$0(117);
        }
        if (qualifier == null) {
            HsqldbDialect.$$$reportNull$$$0(118);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(119);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            HsqldbDialect.$$$reportNull$$$0(120);
        }
        if (statement == null) {
            HsqldbDialect.$$$reportNull$$$0(121);
        }
        if (analyze) {
            throw new UnsupportedOperationException("HSQLDB does not support EXPLAIN ANALYZE");
        }
        builder.keywords("explain", "plan", "for").space();
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqldbDialect.$$$reportNull$$$0(122);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/HsqldbDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 48: 
            case 51: 
            case 54: 
            case 56: 
            case 61: 
            case 69: 
            case 75: 
            case 83: 
            case 88: 
            case 92: 
            case 96: 
            case 99: 
            case 102: 
            case 106: 
            case 110: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 26: 
            case 28: 
            case 39: 
            case 42: 
            case 45: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 57: 
            case 89: 
            case 93: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 58: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 62: 
            case 76: 
            case 97: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 63: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 64: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 65: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 67: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 84: 
            case 100: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 104: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 113: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/HsqldbDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameDatabase";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPrimaryKeySQL";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnNullable";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnType";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefault";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterSequence";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSequence";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameView";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceInformation";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameDatabase";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAddPrimaryKeySQL";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnNullable";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sqlAddColumnAutoIncrement$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

