/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.DBIntrospectionException;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.GenericIntrospectorHelper;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;

public class GenericIntrospector
implements DBIntrospector {
    private final Rdbms myRdbms;
    private DBFacade myFacade;
    private ProgressIndicator myIndicator;
    private ModelFactory myModelFactory;
    private PairConsumer<String, Throwable> myErrorSink;
    private String[] myTableTypes;
    private Set<ObjectKind> myTableKinds;
    private GenericIntrospectorHelper myHelper;
    private ConnectionInfo myInfo;
    @Nullable
    private SourceLoader mySrcLoader;
    private boolean myWithSources;
    public static final Map<Rdbms, PerObjectVersion> VERSIONS = FactoryMap.create(key2 -> PerObjectVersion.DEFAULT.INSTANCE);

    public GenericIntrospector(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            GenericIntrospector.$$$reportNull$$$0(0);
        }
        this.myIndicator = DumbProgressIndicator.INSTANCE;
        this.mySrcLoader = null;
        this.myWithSources = false;
        this.myRdbms = rdbms;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.myModelFactory = modelFactory;
    }

    @Override
    public void init(@Nullable BasicModModel model) {
        if (this.myHelper != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
        Rdbms rdbms = this.myRdbms;
        BasicModModel theModel = this.createModelIfNotSuitable(rdbms, model);
        this.myHelper = new GenericIntrospectorHelper(theModel, rdbms);
    }

    @Override
    public void attachToDB(@NotNull DBFacade db) {
        if (db == null) {
            GenericIntrospector.$$$reportNull$$$0(1);
        }
        if (this.myFacade != null) {
            this.detachFromDB();
        }
        if (db.rdbms() != this.myRdbms) {
            throw new AssertionError((Object)("Database type changed while introspecting (" + this.myRdbms.code + " -> " + db.rdbms().code + ")"));
        }
        this.myFacade = db;
        this.myInfo = this.myFacade.getConnectionInfo();
        if (this.myWithSources) {
            for (SourceLoaderProvider provider : (SourceLoaderProvider[])SourceLoaderProvider.EP_NAME.getExtensions()) {
                this.mySrcLoader = provider.create(this.myFacade);
                if (this.mySrcLoader != null) break;
            }
        }
    }

    @Override
    public void detachFromDB() {
        this.myFacade = null;
        this.myInfo = null;
        this.mySrcLoader = null;
    }

    private BasicModModel createModelIfNotSuitable(@NotNull Rdbms rdbms, @Nullable BasicModModel model) {
        if (rdbms == null) {
            GenericIntrospector.$$$reportNull$$$0(2);
        }
        if (model != null && model.getRdbms() == rdbms) {
            return model;
        }
        return this.myModelFactory.createModel(rdbms);
    }

    @Override
    public void setOptions(@NotNull DBIntrospectionOptions options) {
        if (options == null) {
            GenericIntrospector.$$$reportNull$$$0(3);
        }
        this.myWithSources = options.getSources() != DBIntrospectionOptions.SourceLoading.NO_SOURCES;
    }

    @Override
    @NotNull
    public DBIntrospectionOptions getOptions() {
        DBIntrospectionOptions dBIntrospectionOptions = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        if (dBIntrospectionOptions == null) {
            GenericIntrospector.$$$reportNull$$$0(4);
        }
        return dBIntrospectionOptions;
    }

    @Override
    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myHelper.getModel();
        if (basicModModel == null) {
            GenericIntrospector.$$$reportNull$$$0(5);
        }
        return basicModModel;
    }

    @Override
    public void setProgressIndicator(@Nullable ProgressIndicator indicator) {
        this.myIndicator = indicator != null ? indicator : DumbProgressIndicator.INSTANCE;
    }

    @Override
    @Nullable
    public ProgressIndicator getProgressIndicator() {
        return this.myIndicator;
    }

    @Override
    public void introspectAuto(BasicNamespace ... namespaces) {
        if (namespaces == null) {
            GenericIntrospector.$$$reportNull$$$0(6);
        }
        if (this.myFacade == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            if (namespaces == null) {
                GenericIntrospector.$$$reportNull$$$0(69);
            }
            this.myFacade.inSession(s -> {
                if (namespaces == null) {
                    GenericIntrospector.$$$reportNull$$$0(70);
                }
                DatabaseMetaDataWrapper meta = this.createMeta(s);
                this.myHelper.setCasing(meta.getCasing());
                if (namespaces.length == 0) {
                    this.introspectDatabaseList(meta);
                }
                this.introspectSchemas(meta, this.schemas(namespaces));
            });
        });
    }

    @Override
    public void introspectNamespaces() {
        if (this.myFacade == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> this.myFacade.inSession(s -> {
            DatabaseMetaDataWrapper meta = this.createMeta(s);
            this.myHelper.setCasing(meta.getCasing());
            this.introspectDatabaseList(meta);
        }));
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        if (databases == null) {
            GenericIntrospector.$$$reportNull$$$0(7);
        }
        if (this.myFacade == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            if (databases == null) {
                GenericIntrospector.$$$reportNull$$$0(67);
            }
            this.myFacade.inSession(s -> {
                if (databases == null) {
                    GenericIntrospector.$$$reportNull$$$0(68);
                }
                DatabaseMetaDataWrapper meta = this.createMeta(s);
                this.myHelper.setCasing(meta.getCasing());
                this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.of((Object[])databases).filter(BasicModDatabase.class));
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectSchemas(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModSchema> schemas) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(8);
        }
        if (schemas == null) {
            GenericIntrospector.$$$reportNull$$$0(9);
        }
        try {
            this.myTableTypes = meta.getAllTableTypes();
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)"Failed to retrieve table types", (Object)e);
            this.myTableTypes = null;
        }
        this.myTableKinds = ArrayUtil.isEmpty((Object[])this.myTableTypes) ? null : JBIterable.of((Object[])this.myTableTypes).transform(x -> JdbcTableType.findByName(x).getKind()).toSet();
        MultiMap byCatalog = MultiMap.create();
        for (BasicModSchema schema : schemas) {
            byCatalog.putValue((Object)this.myHelper.getDatabase(schema), (Object)schema);
        }
        String catalog = null;
        try {
            catalog = meta.getConnection().getCatalog();
            this.introspectSchemasByCatalogs(meta, (MultiMap<BasicModNamespace, BasicModSchema>)byCatalog);
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)"Failed to get current catalog", (Object)e);
        }
        finally {
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), (String)catalog);
        }
    }

    private void introspectSchemasByCatalogs(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> byCatalog) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(10);
        }
        if (byCatalog == null) {
            GenericIntrospector.$$$reportNull$$$0(11);
        }
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                GenericIntrospector.$$$reportNull$$$0(66);
            }
            this.introspectTablesInSchema(meta, (BasicModSchema)s);
            this.introspectRoutinesInSchema(meta, (BasicModSchema)s);
            this.introspectTypesInSchema(meta, (BasicModSchema)s);
        });
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                GenericIntrospector.$$$reportNull$$$0(64);
            }
            this.introspectColumnsInSchema(meta, (BasicModSchema)s);
            ModNamingFamily<BasicModNamedElement> tables = GenericIntrospectorLegacyModelUtils.familyOf(s, ObjectKind.TABLE);
            if (tables != null) {
                tables.forEach(t -> {
                    if (meta == null) {
                        GenericIntrospector.$$$reportNull$$$0(65);
                    }
                    this.introspectTableKeys(meta, (BasicModLikeTable)((Object)t));
                });
            }
            this.introspectPrototypesInSchema(meta, (BasicModSchema)s);
            this.introspectTypeAttributesInSchema(meta, (BasicModSchema)s);
        });
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            ModNamingFamily<BasicModNamedElement> tables;
            if (meta == null) {
                GenericIntrospector.$$$reportNull$$$0(61);
            }
            if ((tables = GenericIntrospectorLegacyModelUtils.familyOf(s, ObjectKind.TABLE)) != null) {
                tables.forEach(t -> {
                    if (meta == null) {
                        GenericIntrospector.$$$reportNull$$$0(63);
                    }
                    this.introspectTableForeignKeys(meta, (BasicModLikeTable)((Object)t));
                });
                tables.forEach(t -> {
                    if (meta == null) {
                        GenericIntrospector.$$$reportNull$$$0(62);
                    }
                    this.introspectTableIndices(meta, (BasicModLikeTable)((Object)t));
                });
            }
        });
        if (this.mySrcLoader != null) {
            this.getModel().writeSources(() -> {
                if (meta == null) {
                    GenericIntrospector.$$$reportNull$$$0(58);
                }
                if (byCatalog == null) {
                    GenericIntrospector.$$$reportNull$$$0(59);
                }
                GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
                    if (meta == null) {
                        GenericIntrospector.$$$reportNull$$$0(60);
                    }
                    this.myIndicator.checkCanceled();
                    this.myIndicator.setText("Sources in " + MetaDataUtil.qName(s));
                    this.mySrcLoader.loadSources((Iterable<BasicModSourceAware>)((JBTreeTraverser)DasUtil.dasTraverser().withRoot(s)).filter(BasicModSourceAware.class), meta.getConnection());
                });
            });
        }
    }

    private static void forEachCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<Iterable<BasicModSchema>> process2) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(12);
        }
        if (grouped == null) {
            GenericIntrospector.$$$reportNull$$$0(13);
        }
        if (process2 == null) {
            GenericIntrospector.$$$reportNull$$$0(14);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), entry.getKey() == null ? null : ((BasicModNamespace)entry.getKey()).getName());
            process2.accept((Iterable<BasicModSchema>)entry.getValue());
        }
    }

    private static void forEachSchemaInCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<BasicModSchema> process2) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(15);
        }
        if (grouped == null) {
            GenericIntrospector.$$$reportNull$$$0(16);
        }
        if (process2 == null) {
            GenericIntrospector.$$$reportNull$$$0(17);
        }
        GenericIntrospector.forEachCatalog(meta, grouped, ss -> {
            if (process2 == null) {
                GenericIntrospector.$$$reportNull$$$0(57);
            }
            ss.forEach(process2);
        });
    }

    private void introspectTablesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(18);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(19);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<? extends BasicModLikeTable>> families = this.getTableFamilies(schema);
        families.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.Table> tableIt = meta.tables(this.myHelper.asSchema(schema), null, this.myTableTypes);){
            for (DatabaseMetaDataWrapper.Table table : JBIterable.once(tableIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createTable(schema, table);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve tables in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        families.forEach(GenericIntrospector::cleanupFamily);
    }

    @NotNull
    private JBIterable<ModFamily<? extends BasicModLikeTable>> getTableFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(20);
        }
        JBIterable kinds = JBIterable.from(ModelConsts.LIKE_TABLE_KINDS);
        if (this.myTableKinds != null) {
            kinds = kinds.filter(this.myTableKinds::contains);
        }
        JBIterable jBIterable = kinds.transform(k -> {
            if (schema == null) {
                GenericIntrospector.$$$reportNull$$$0(56);
            }
            return GenericIntrospectorLegacyModelUtils.familyOf(schema, k);
        }).filter(Conditions.notNull());
        if (jBIterable == null) {
            GenericIntrospector.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    private void introspectTableKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModLikeTable table) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(22);
        }
        if (table == null) {
            GenericIntrospector.$$$reportNull$$$0(23);
        }
        Family keys = table.familyOf(ObjectKind.KEY);
        if (table.getKind() != ObjectKind.TABLE || keys == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Keys in " + MetaDataUtil.qName(table));
        keys.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt = meta.tableKeys(this.myHelper.asTable(table));){
            this.myHelper.createKeys(table, keyIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        GenericIntrospector.cleanupFamily((ModFamily)keys);
    }

    private void introspectTableForeignKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModLikeTable table) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(24);
        }
        if (table == null) {
            GenericIntrospector.$$$reportNull$$$0(25);
        }
        Family fKeys = table.familyOf(ObjectKind.FOREIGN_KEY);
        if (table.getKind() != ObjectKind.TABLE || fKeys == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Foreign keys in " + MetaDataUtil.qName(table));
        fKeys.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt = meta.tableFKeyColumns(this.myHelper.asTable(table));){
            this.myHelper.createForeignKeys(table, fkColumnIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        GenericIntrospector.cleanupFamily((ModFamily)fKeys);
    }

    private void introspectTableIndices(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModLikeTable table) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(26);
        }
        if (table == null) {
            GenericIntrospector.$$$reportNull$$$0(27);
        }
        Family indices = table.familyOf(ObjectKind.INDEX);
        if (table.getKind() != ObjectKind.TABLE || indices == null) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Indices in " + MetaDataUtil.qName(table));
        indices.markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt = meta.tableIndexColumns(this.myHelper.asTable(table));){
            this.myHelper.createIndices(table, indexColumnIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        GenericIntrospector.cleanupFamily((ModFamily)indices);
    }

    private void introspectColumnsInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(28);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(29);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table columns in " + MetaDataUtil.qName(schema));
        JBIterable tables = this.getTableFamilies(schema).flatten(s -> s).filter(BasicModLikeTable.class);
        HashMap name2Table = ContainerUtil.newHashMap();
        for (Object table : tables) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)table, ObjectKind.COLUMN));
            name2Table.put(table.getName(), table);
        }
        try {
            Object table;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn> columnIt = meta.tableColumns(this.myHelper.asSchema(schema), null, name2Table.keySet());
            table = null;
            try {
                for (DatabaseMetaDataWrapper.Table table2 : JBIterable.once(columnIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createColumns((BasicModLikeTable)name2Table.get(table2.name), (Iterator<DatabaseMetaDataWrapper.TableColumn>)columnIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                table = throwable;
                throw throwable;
            }
            finally {
                if (columnIt != null) {
                    if (table != null) {
                        try {
                            columnIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)table).addSuppressed(throwable);
                        }
                    } else {
                        columnIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object table : tables) {
            GenericIntrospector.cleanupFamily((ModFamily)table.familyOf(ObjectKind.COLUMN));
        }
    }

    private void introspectTypeAttributesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(30);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(31);
        }
        this.myIndicator.checkCanceled();
        ModNamingFamily<Object> types = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.OBJECT_TYPE);
        if (types == null || types.isEmpty()) {
            return;
        }
        this.myIndicator.setText("Type attributes in " + MetaDataUtil.qName(schema));
        HashMap name2Type = ContainerUtil.newHashMap();
        for (Object type : types) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)type, ObjectKind.OBJECT_ATTRIBUTE));
            name2Type.put(type.getName(), type);
        }
        try {
            Object type;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.UserDefinedType, DatabaseMetaDataWrapper.UserDefinedTypeAttribute> attrIt = meta.userDefinedTypeAttributes(this.myHelper.asSchema(schema), null, name2Type.keySet());
            type = null;
            try {
                for (DatabaseMetaDataWrapper.UserDefinedType type2 : JBIterable.once(attrIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createUserDefinedTypeAttributes((BasicModElement)name2Type.get(type2.name), (Iterator<DatabaseMetaDataWrapper.UserDefinedTypeAttribute>)attrIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                type = throwable;
                throw throwable;
            }
            finally {
                if (attrIt != null) {
                    if (type != null) {
                        try {
                            attrIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)type).addSuppressed(throwable);
                        }
                    } else {
                        attrIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object type : types) {
            GenericIntrospector.cleanupFamily((ModFamily)type.familyOf(ObjectKind.OBJECT_ATTRIBUTE));
        }
    }

    private void introspectPrototypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(32);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(33);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Prototypes in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema);
        JBIterable routines = routineFamilies.flatten(r -> r).filter(BasicModRoutine.class);
        GenericIntrospectorHelper.RoutineMap map2 = this.myHelper.createRoutineMap();
        for (Object routine2 : routines) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)routine2, ObjectKind.ARGUMENT));
            map2.put((BasicModRoutine)routine2);
        }
        try {
            Object routine2;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Routine, DatabaseMetaDataWrapper.RoutineArgument> argumentIt = meta.routineArguments(this.myHelper.asSchema(schema), null, (Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind>)((Function)map2::guessType));
            routine2 = null;
            try {
                for (DatabaseMetaDataWrapper.Routine routine3 : JBIterable.once(argumentIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createArguments(map2.get(routine3), (Iterator<DatabaseMetaDataWrapper.RoutineArgument>)argumentIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                routine2 = throwable;
                throw throwable;
            }
            finally {
                if (argumentIt != null) {
                    if (routine2 != null) {
                        try {
                            argumentIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)routine2).addSuppressed(throwable);
                        }
                    } else {
                        argumentIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object routine2 : routines) {
            GenericIntrospector.cleanupFamily(routine2.familyOf(ObjectKind.ARGUMENT));
        }
        routineFamilies.forEach(ModFamily::sort);
    }

    private void introspectRoutinesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(34);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(35);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Routine list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema);
        routineFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<DatabaseMetaDataWrapper.Routine> routineIt = meta.routines(this.myHelper.asSchema(schema), null, null);){
            for (DatabaseMetaDataWrapper.Routine routine2 : JBIterable.once(routineIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createRoutine(schema, routine2);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve routines in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        routineFamilies.forEach(GenericIntrospector::cleanupFamily);
    }

    private void introspectAdditionalTypes(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(36);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(37);
        }
        ObjectKind target = null;
        String scName = schema.getName();
        if (this.myHelper.getFamilyId().isSybase() && "dbo".equalsIgnoreCase(scName)) {
            target = ObjectKind.ALIAS_TYPE;
        }
        if (target != null) {
            try (ClosableIt<? extends DatabaseMetaDataWrapper.Type> typesIt = meta.types();){
                for (DatabaseMetaDataWrapper.Type type : JBIterable.once(typesIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createType(schema, type, target);
                }
            }
            catch (SQLException e) {
                this.myErrorSink.consume((Object)("Failed to retrieve types in " + MetaDataUtil.qName(schema)), (Object)e);
            }
        }
    }

    private void introspectTypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(38);
        }
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(39);
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Types list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> userDefinedTypeFamilies = this.getUserDefinedTypeFamilies(schema);
        userDefinedTypeFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.UserDefinedType> userDefinedTypesIt = meta.userDefinedTypes(this.myHelper.asSchema(schema), null);){
            for (DatabaseMetaDataWrapper.UserDefinedType userDefinedType : JBIterable.once(userDefinedTypesIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createUserDefinedType(schema, userDefinedType);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve user types in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        this.introspectAdditionalTypes(meta, schema);
        userDefinedTypeFamilies.forEach(GenericIntrospector::cleanupFamily);
    }

    private void introspectDatabaseList(@NotNull DatabaseMetaDataWrapper meta) {
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(40);
        }
        if (this.getModel().getRoot().familyOf(ObjectKind.DATABASE) != null) {
            this.introspectDatabaseListImpl(meta);
        } else if (this.getModel().getRoot().familyOf(ObjectKind.SCHEMA) != null) {
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.empty());
        } else {
            throw new GenericIntrospectionException("Model does not contain database/schema namespace", null);
        }
    }

    private void introspectDatabaseListImpl(@NotNull DatabaseMetaDataWrapper meta) {
        ModNamingFamily databases;
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(41);
        }
        if ((databases = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.DATABASE)) == null) {
            return;
        }
        databases.markChildrenAsSyncPending();
        try (ClosableIt<String> dbIt = meta.databases();){
            this.fillDatabases((Iterator<String>)((Object)dbIt));
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve databases", e);
        }
        this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.from(databases).filter(BasicModDatabase.class).filter(db -> db.isCurrent()));
        GenericIntrospector.cleanupFamily(databases);
        this.updateDatabaseFlags(databases);
    }

    private void introspectSchemaList(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModDatabase> databases) {
        Throwable throwable;
        if (meta == null) {
            GenericIntrospector.$$$reportNull$$$0(42);
        }
        if (databases == null) {
            GenericIntrospector.$$$reportNull$$$0(43);
        }
        for (BasicModDatabase db : databases) {
            db.getSchemas().markChildrenAsSyncPending();
        }
        JBIterable dbs = databases.transform(DasUtil.TO_NAME);
        if (databases.isEmpty() && this.myHelper.isSchemaDbMode()) {
            try {
                throwable = null;
                try (ClosableIt<String> dbIt = meta.databases();){
                    dbs = JBIterable.from((Iterable)ContainerUtil.collect(dbIt));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new GenericIntrospectionException("Failed to retrieve schemas", e);
            }
        }
        try {
            throwable = null;
            try (ClosableIt<DatabaseMetaDataWrapper.Schema> schemaIt = meta.schemas((JBIterable<String>)dbs);){
                this.fillSchemas((Iterator<DatabaseMetaDataWrapper.Schema>)((Object)schemaIt));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve schemas", e);
        }
        for (BasicModDatabase db : databases) {
            GenericIntrospector.cleanupFamily((ModFamily)((Object)db.getSchemas()));
        }
    }

    @Nullable
    private <T extends BasicNamespace> T getCurrentOrSole(@NotNull Iterable<? extends T> namespaces) {
        JBIterable nsp;
        BasicNamespace current;
        if (namespaces == null) {
            GenericIntrospector.$$$reportNull$$$0(44);
        }
        if ((current = (BasicNamespace)(nsp = JBIterable.from(namespaces)).filter(this::isCurrent).first()) != null) {
            return (T)current;
        }
        if (nsp.size() == 1) {
            return (T)((BasicNamespace)nsp.first());
        }
        return null;
    }

    private void fillSchemas(Iterator<DatabaseMetaDataWrapper.Schema> schemaIt) {
        LinkedHashSet schemaFamilies = ContainerUtil.newLinkedHashSet();
        ModNamingFamily root2 = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.SCHEMA);
        if (root2 != null) {
            root2.markChildrenAsSyncPending();
            schemaFamilies.add(root2);
        }
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(schemaIt)) {
            if (root2 == null) {
                ModNamingFamily schemas2;
                BasicModDatabase database = this.myHelper.createDatabase(schema.database);
                ModNamingFamily modNamingFamily = schemas2 = database == null ? null : GenericIntrospectorLegacyModelUtils.familyOf(database, ObjectKind.SCHEMA);
                if (schemas2 != null && schemaFamilies.add(schemas2)) {
                    schemas2.markChildrenAsSyncPending();
                }
            }
            this.myHelper.createSchema(schema);
        }
        schemaFamilies.forEach(schemas -> {
            GenericIntrospector.cleanupFamily(schemas);
            this.updateSchemaFlags((ModNamingFamily<? extends BasicModSchema>)schemas);
        });
    }

    private void updateSchemaFlags(ModNamingFamily<? extends BasicModSchema> schemas) {
        schemas.forEach(s -> s.setCurrent(false));
        boolean hasVisibleSc = !schemas.jbi().filter(BasicMateNamespace::isVisible).isEmpty();
        BasicModSchema curSc = this.getCurrentOrSole(schemas);
        if (curSc != null) {
            if (!hasVisibleSc) {
                curSc.setVisible(true);
            }
            curSc.setCurrent(true);
        } else if (ApplicationManager.getApplication().isUnitTestMode() && schemas.stream().noneMatch(BasicMateNamespace::isVisible)) {
            schemas.forEach(sc -> sc.setVisible(true));
        }
    }

    private void fillDatabases(Iterator<String> dbIt) {
        for (String db : JBIterable.once(dbIt)) {
            this.myHelper.createDatabase(db);
        }
    }

    private void updateDatabaseFlags(ModNamingFamily<?> root2) {
        JBIterable databases = JBIterable.from(root2).filter(BasicModMateDatabase.class);
        boolean hasVisibleDb = !databases.filter(BasicNamespace::isVisible).isEmpty();
        BasicModMateDatabase curDb = (BasicModMateDatabase)this.getCurrentOrSole((Iterable)databases);
        for (BasicModMateDatabase database : databases) {
            database.setCurrent(false);
        }
        if (curDb != null) {
            if (!hasVisibleDb) {
                curDb.setVisible(true);
            }
            curDb.setCurrent(true);
        }
    }

    private boolean isCurrent(@Nullable BasicNamespace nsp) {
        if (nsp instanceof BasicDatabase) {
            return this.isCurrent((BasicDatabase)nsp);
        }
        if (nsp instanceof BasicSchema) {
            return this.isCurrent((BasicSchema)nsp);
        }
        return false;
    }

    private boolean isCurrent(@Nullable BasicDatabase db) {
        if (db == null || this.myInfo == null) {
            return false;
        }
        return db.getName().equals(this.myInfo.databaseName);
    }

    private boolean isCurrent(@Nullable BasicSchema sc) {
        if (sc == null || this.myInfo == null) {
            return false;
        }
        return this.myHelper.isSchemaDbMode() ? sc.getName().equals(this.myInfo.databaseName) : sc.getName().equals(this.myInfo.schemaName) || sc.getName().equals(this.myInfo.userName);
    }

    @NotNull
    private DatabaseMetaDataWrapper createMeta(DBSession session) {
        DatabaseMetaDataWrapper databaseMetaDataWrapper;
        Connection connection = (Connection)session.getSpecificService(Connection.class, "jdbc-connection");
        if (connection == null) {
            throw new GenericIntrospectionException("Failed to get connection", null);
        }
        try {
            databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(connection, connection.getMetaData(), this.myHelper.getFamilyId()).withErrorSink(this.myErrorSink);
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve meta data", e);
        }
        if (databaseMetaDataWrapper == null) {
            GenericIntrospector.$$$reportNull$$$0(45);
        }
        return databaseMetaDataWrapper;
    }

    @NotNull
    public JBIterable<BasicModSchema> schemas(BasicNamespace ... namespaces) {
        JBTreeTraverser traverser = this.getModel().traverser();
        if (namespaces != null && namespaces.length != 0) {
            traverser = (JBTreeTraverser)traverser.withRoots((Iterable)JBIterable.of((Object[])namespaces));
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)traverser.expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).filter(BasicModSchema.class);
        if (jBIterable == null) {
            GenericIntrospector.$$$reportNull$$$0(46);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ModFamily<?>> getRoutineFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(47);
        }
        JBIterable routineFamilies = JBIterable.of((Object)schema.familyOf(ObjectKind.ROUTINE));
        ModFamily packages = schema.familyOf(ObjectKind.PACKAGE);
        if (packages != null) {
            JBIterable pkg = JBIterable.of((Object)packages);
            routineFamilies = routineFamilies.append((Iterable)pkg).append((Iterable)pkg.flatten(p -> p).transform(f -> f.familyOf(ObjectKind.ROUTINE)).filter(Conditions.notNull()));
        }
        JBIterable jBIterable = routineFamilies;
        if (jBIterable == null) {
            GenericIntrospector.$$$reportNull$$$0(48);
        }
        return jBIterable;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public JBIterable<ModFamily<?>> getUserDefinedTypeFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            GenericIntrospector.$$$reportNull$$$0(49);
        }
        @NotNull JBIterable transform = JBIterable.of((Object[])new ObjectKind[]{ObjectKind.ALIAS_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE}).transform(schema::familyOf);
        JBIterable jBIterable = transform.filter(Conditions.notNull());
        if (jBIterable == null) {
            GenericIntrospector.$$$reportNull$$$0(50);
        }
        return jBIterable;
    }

    private static void markChildrenAsSyncPending(@Nullable ModFamily f) {
        if (f == null) {
            return;
        }
        f.markChildrenAsSyncPending();
    }

    private static void cleanupFamily(@Nullable ModFamily f) {
        if (f == null) {
            return;
        }
        f.removeSyncPendingChildren();
        f.sort();
    }

    @Override
    public void introspectSessionState() {
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        if (namespace == null) {
            GenericIntrospector.$$$reportNull$$$0(51);
        }
        if (objectKind == null) {
            GenericIntrospector.$$$reportNull$$$0(52);
        }
        if (objectNames == null) {
            GenericIntrospector.$$$reportNull$$$0(53);
        }
    }

    @Override
    public void introspectServerObjects() {
    }

    @Override
    @NotNull
    public PairConsumer<String, Throwable> getErrorSink() {
        PairConsumer<String, Throwable> pairConsumer = this.myErrorSink;
        if (pairConsumer == null) {
            GenericIntrospector.$$$reportNull$$$0(54);
        }
        return pairConsumer;
    }

    @Override
    public void setErrorSink(@NotNull PairConsumer<String, Throwable> consumer) {
        if (consumer == null) {
            GenericIntrospector.$$$reportNull$$$0(55);
        }
        this.myErrorSink = consumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 21: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 21: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 5: 
            case 21: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/GenericIntrospector";
                break;
            }
            case 6: 
            case 44: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 7: 
            case 43: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 11: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byCatalog";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 14: 
            case 17: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 19: 
            case 20: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 47: 
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectKind";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectNames";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/GenericIntrospector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableFamilies";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createMeta";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "schemas";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineFamilies";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedTypeFamilies";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "attachToDB";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModelIfNotSuitable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 4: 
            case 5: 
            case 21: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 54: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "introspectAuto";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseSchemas";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemas";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemasByCatalogs";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "forEachCatalog";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forEachSchemaInCatalog";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "introspectTablesInSchema";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTableFamilies";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableKeys";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableForeignKeys";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "introspectTableIndices";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "introspectColumnsInSchema";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "introspectTypeAttributesInSchema";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "introspectPrototypesInSchema";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "introspectRoutinesInSchema";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "introspectAdditionalTypes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "introspectTypesInSchema";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseList";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "introspectDatabaseListImpl";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemaList";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentOrSole";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRoutineFamilies";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedTypeFamilies";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "introspectFragment";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setErrorSink";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTableFamilies$16";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEachSchemaInCatalog$15";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasByCatalogs$14";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$13";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasByCatalogs$12";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$11";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$10";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasByCatalogs$9";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$8";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasByCatalogs$7";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectDatabaseSchemas$5";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectAuto$1";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 21: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GenericIntrospectionException
    extends DBIntrospectionException {
        public GenericIntrospectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface SourceLoader {
        public void loadSources(@NotNull Iterable<BasicModSourceAware> var1, @NotNull Connection var2);
    }

    public static interface SourceLoaderProvider {
        public static final ExtensionPointName<SourceLoaderProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.genericSourceLoaderProvider");

        @Nullable
        public SourceLoader create(@NotNull DBFacade var1);
    }
}

