/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.introspection.MsIntrospectorKt$WhenMappings;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsModCustomType;
import com.intellij.database.model.mssql.MsModSchemaObject;
import com.intellij.database.model.mssql.MsTable;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.MsServerType;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000v\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002\u001a*\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002\u001a7\u0010\u001a\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001b0\u001e2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010 \u001a\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u0001H\u0002\u001a\u001c\u0010%\u001a\u0004\u0018\u00010&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0)H\u0002\u001a \u0010*\u001a\u00020+*\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010.H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"2\u0010\u0007\u001a&\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\t0\t \u0004*\u0012\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"ALIAS_TYPE_KIND", "", "MuffledWords", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SURROGATE_NAME_PATTERN", "TABLE_TYPE_KIND", "VARIABLE_TYPES", "Lcom/google/common/collect/ImmutableSet;", "", "catalogPrefix", "database", "Lcom/intellij/database/model/mssql/MsDatabase;", "detectSurrogateName", "", "name", "makeDataType", "Lcom/intellij/database/model/DataType;", "type_name", "max_length", "", "precision", "scale", "normalizeExpression", "expression", "normalizePredicateExpression", "renewType", "T", "Lcom/intellij/database/model/mssql/MsModCustomType;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "typeId", "(Lcom/intellij/database/model/families/ModNamingFamily;ILjava/lang/String;)Lcom/intellij/database/model/mssql/MsModCustomType;", "unpackEvents", "", "Lcom/intellij/database/model/TrigEvent;", "e", "findKeyByColumns", "Lcom/intellij/database/model/mssql/MsKey;", "Lcom/intellij/database/model/mssql/MsTable;", "names", "", "setCreatedAndModifiedTimestamps", "", "Lcom/intellij/database/model/mssql/MsModSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "database-introspection"})
public final class MsIntrospectorKt {
    private static final Pattern MuffledWords = Pattern.compile("\\(\\d+(\\.\\d+)?\\)", 2);
    private static final byte ALIAS_TYPE_KIND = 1;
    private static final byte TABLE_TYPE_KIND = 2;
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^\\s*\\w{2}\\S{2,18}__[\\dA-F]{8,16}\\s*$", 2);
    private static final ImmutableSet<String> VARIABLE_TYPES = ImmutableSet.of((Object)"decimal", (Object)"numeric", (Object)"varbinary", (Object)"varchar", (Object)"binary", (Object)"char", (Object[])new String[]{"nvarchar", "nchar"});

    private static final <T extends MsModCustomType> T renewType(ModNamingFamily<? extends T> family, int typeId, String name) {
        MsModCustomType type = (MsModCustomType)family.find(new Predicate<T>(typeId){
            final /* synthetic */ int $typeId;

            public final boolean test(T it) {
                return it.getTypeId() == this.$typeId;
            }
            {
                this.$typeId = n;
            }
        });
        if (type != null) {
            type.setName(name);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsModCustomType)family.get(name);
        if (type != null && type.getTypeId() == 0) {
            type.setTypeId(typeId);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsModCustomType)family.createNewOne();
        type.setTypeId(typeId);
        type.setName(name);
        return (T)type;
    }

    private static final MsKey findKeyByColumns(@NotNull MsTable $receiver, List<String> names) {
        Object v0;
        block1: {
            Iterable $receiver$iv = $receiver.getKeys();
            for (Object element$iv : $receiver$iv) {
                MsKey it = (MsKey)element$iv;
                if (!it.areColNames(names)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final String normalizePredicateExpression(String expression) {
        return MsIntrospectorKt.normalizeExpression(expression);
    }

    /*
     * WARNING - void declaration
     */
    private static final String normalizeExpression(String expression) {
        int index$iv$iv;
        int startFound$iv$iv;
        String exp;
        CharSequence charSequence;
        if (expression == null || (charSequence = (CharSequence)expression).length() == 0) {
            return null;
        }
        CharSequence $receiver$iv = expression;
        CharSequence $receiver$iv$iv = $receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv2 = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv2);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv2) {
                if (!match$iv$iv) {
                    startFound$iv$iv2 = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (($receiver$iv = (CharSequence)(exp = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) {
            return null;
        }
        int n = exp.length();
        if (n > 2 && exp.charAt(0) == '(' && exp.charAt(n - 1) == ')') {
            $receiver$iv$iv = exp;
            startIndex$iv$iv = 1;
            endIndex$iv$iv = n - 1;
            CharSequence charSequence2 = $receiver$iv$iv;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)charSequence2).substring(startIndex$iv$iv, endIndex$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String $receiver$iv2 = string;
            CharSequence $receiver$iv$iv2 = $receiver$iv2;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $receiver$iv$iv2.length() - 1;
            startFound$iv$iv = 0;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                index$iv$iv = startFound$iv$iv == 0 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $receiver$iv$iv2.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (startFound$iv$iv == 0) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = 1;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            exp = ((Object)$receiver$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
        }
        Matcher m = MuffledWords.matcher(exp);
        while (exp.length() >= 3 && m.find()) {
            void $receiver$iv3;
            int p1 = m.start();
            int p2 = m.end();
            String endIndex$iv$iv2 = exp;
            startFound$iv$iv = 0;
            StringBuilder stringBuilder = new StringBuilder();
            String string = endIndex$iv$iv2;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring(startFound$iv$iv, p1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            endIndex$iv$iv2 = exp;
            startFound$iv$iv = p1 + 1;
            index$iv$iv = p2 - 1;
            stringBuilder = stringBuilder.append(string3);
            String string4 = endIndex$iv$iv2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(startFound$iv$iv, index$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string5;
            endIndex$iv$iv2 = exp;
            stringBuilder = stringBuilder.append(string3);
            String string6 = endIndex$iv$iv2;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(p2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            string3 = string7;
            endIndex$iv$iv2 = stringBuilder.append(string3).toString();
            CharSequence $receiver$iv$iv3 = (CharSequence)$receiver$iv3;
            int startIndex$iv$iv3 = 0;
            int endIndex$iv$iv3 = $receiver$iv$iv3.length() - 1;
            boolean startFound$iv$iv3 = false;
            while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                boolean match$iv$iv;
                int index$iv$iv3 = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                char it = $receiver$iv$iv3.charAt(index$iv$iv3);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv3) {
                    if (!match$iv$iv) {
                        startFound$iv$iv3 = true;
                        continue;
                    }
                    ++startIndex$iv$iv3;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv3;
            }
            exp = ((Object)$receiver$iv$iv3.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString();
            m = MuffledWords.matcher(exp);
        }
        return exp;
    }

    private static final Set<TrigEvent> unpackEvents(byte e) {
        int n;
        byte $receiver$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = e;
        byte that$iv = 1;
        byte $receiver$iv$iv = $receiver$iv;
        int n2 = Byte.toUnsignedInt($receiver$iv$iv);
        if ((byte)(n2 & (n = Byte.toUnsignedInt($receiver$iv$iv = that$iv))) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $receiver$iv = e;
        that$iv = 2;
        $receiver$iv$iv = $receiver$iv;
        n2 = Byte.toUnsignedInt($receiver$iv$iv);
        if ((byte)(n2 & (n = Byte.toUnsignedInt($receiver$iv$iv = that$iv))) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        $receiver$iv = e;
        that$iv = 4;
        $receiver$iv$iv = $receiver$iv;
        n2 = Byte.toUnsignedInt($receiver$iv$iv);
        if ((byte)(n2 & (n = Byte.toUnsignedInt($receiver$iv$iv = that$iv))) != 0) {
            events.add(TrigEvent.DELETE);
        }
        EnumSet<TrigEvent> enumSet = events;
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"events");
        return enumSet;
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull MsModSchemaObject $receiver, Date createdTimestamp, Date modifiedTimestamp) {
        $receiver.setCreatedTimestamp(createdTimestamp);
        $receiver.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final String catalogPrefix(MsDatabase database) {
        String string;
        Object object = database.getRoot();
        if (object == null || (object = object.getServerType()) == null) {
            object = MsServerType.UNKNOWN;
        }
        switch (MsIntrospectorKt$WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
            case 1: {
                if (database.isCurrent()) {
                    string = "sys";
                    break;
                }
                string = '[' + database.getName() + "].sys";
                break;
            }
            default: {
                string = "sys";
            }
        }
        return string;
    }

    private static final boolean detectSurrogateName(String name) {
        if (name == null) {
            return false;
        }
        return SURROGATE_NAME_PATTERN.matcher(name).matches();
    }

    private static final DataType makeDataType(String type_name, int max_length, int precision, byte scale) {
        DataType dt;
        if (type_name != null) {
            if (VARIABLE_TYPES.contains((Object)type_name)) {
                if (precision > 0) {
                    DataType dataType = DataTypeFactory.of(null, type_name, precision, scale, null, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else if (Intrinsics.areEqual((Object)type_name, (Object)"char") || Intrinsics.areEqual((Object)type_name, (Object)"nchar") || Intrinsics.areEqual((Object)type_name, (Object)"varchar") || Intrinsics.areEqual((Object)type_name, (Object)"nvarchar") || Intrinsics.areEqual((Object)type_name, (Object)"varbinary")) {
                    boolean national;
                    boolean bl = national = type_name.charAt(0) == 'n';
                    int length = max_length == -1 ? Integer.MAX_VALUE : (national ? max_length >> 1 : max_length);
                    DataType dataType = DataTypeFactory.of(null, type_name, length, 0, LengthUnit.CHAR, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026CHAR, null, false, false)");
                    dt = dataType;
                } else if (max_length > 0) {
                    DataType dataType = DataTypeFactory.of(null, type_name, max_length, scale, null, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else {
                    DataType dataType = DataTypeFactory.of(type_name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                    dt = dataType;
                }
            } else {
                DataType dataType = DataTypeFactory.of(type_name);
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                dt = dataType;
            }
        } else {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            dt = dataType;
        }
        return dt;
    }

    @NotNull
    public static final /* synthetic */ String access$catalogPrefix(@NotNull MsDatabase database) {
        return MsIntrospectorKt.catalogPrefix(database);
    }

    @NotNull
    public static final /* synthetic */ MsModCustomType access$renewType(@NotNull ModNamingFamily family, int typeId, @NotNull String name) {
        return MsIntrospectorKt.renewType(family, typeId, name);
    }

    @NotNull
    public static final /* synthetic */ DataType access$makeDataType(@Nullable String type_name, int max_length, int precision, byte scale) {
        return MsIntrospectorKt.makeDataType(type_name, max_length, precision, scale);
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(@NotNull MsModSchemaObject $receiver, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        MsIntrospectorKt.setCreatedAndModifiedTimestamps($receiver, createdTimestamp, modifiedTimestamp);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(@Nullable String name) {
        return MsIntrospectorKt.detectSurrogateName(name);
    }

    @Nullable
    public static final /* synthetic */ String access$normalizeExpression(@Nullable String expression) {
        return MsIntrospectorKt.normalizeExpression(expression);
    }

    @Nullable
    public static final /* synthetic */ MsKey access$findKeyByColumns(@NotNull MsTable $receiver, @NotNull List names) {
        return MsIntrospectorKt.findKeyByColumns($receiver, names);
    }

    @Nullable
    public static final /* synthetic */ String access$normalizePredicateExpression(@Nullable String expression) {
        return MsIntrospectorKt.normalizePredicateExpression(expression);
    }

    @NotNull
    public static final /* synthetic */ Set access$unpackEvents(byte e) {
        return MsIntrospectorKt.unpackEvents(e);
    }
}

