/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.MysqlIntrospectorKt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.families.ModFamily;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aD\u0010\u0005\u001a\u00020\u00062)\b\u0004\u0010\u0007\u001a#\u0012\u0019\u0012\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\b\n\u0012\u0004\u0012\u00020\u00060\b2\u000e\b\u0004\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0082\b\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"ON_UPDATE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ourMysqlSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "cleanupFamilies", "", "v", "Lkotlin/Function1;", "Lcom/intellij/database/model/families/ModFamily;", "Lkotlin/ExtensionFunctionType;", "action", "Lkotlin/Function0;", "getDirection", "Lcom/intellij/database/model/DasArgument$Direction;", "id", "", "mode", "", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "manipulation", "getType", "Lcom/intellij/database/model/DasRoutine$Kind;", "type", "database-introspection"})
public final class MysqlIntrospectorKt {
    private static final Pattern ON_UPDATE = Pattern.compile("(?i)on update (\\S+)");
    private static final SequenceIdentity ourMysqlSequenceIdentity = SequenceIdentity.of(1L, null, 1L, null);

    private static final TrigEvent getEvent(String manipulation) {
        if (StringsKt.equals((String)"INSERT", (String)manipulation, (boolean)true)) {
            return TrigEvent.INSERT;
        }
        if (StringsKt.equals((String)"DELETE", (String)manipulation, (boolean)true)) {
            return TrigEvent.DELETE;
        }
        return TrigEvent.UPDATE;
    }

    private static final DasRoutine.Kind getType(String type) {
        if (StringsKt.equals((String)"FUNCTION", (String)type, (boolean)true)) {
            return DasRoutine.Kind.FUNCTION;
        }
        if (StringsKt.equals((String)"PROCEDURE", (String)type, (boolean)true)) {
            return DasRoutine.Kind.PROCEDURE;
        }
        return DasRoutine.Kind.NONE;
    }

    private static final DasArgument.Direction getDirection(String mode) {
        if (StringsKt.equals((String)"INOUT", (String)mode, (boolean)true)) {
            return DasArgument.Direction.INOUT;
        }
        if (StringsKt.equals((String)"OUT", (String)mode, (boolean)true)) {
            return DasArgument.Direction.OUT;
        }
        return DasArgument.Direction.IN;
    }

    private static final DasArgument.Direction getDirection(int id) {
        if (id == 4) {
            return DasArgument.Direction.OUT;
        }
        if (id == 2) {
            return DasArgument.Direction.INOUT;
        }
        return DasArgument.Direction.IN;
    }

    private static final void cleanupFamilies(Function1<? super Function1<? super ModFamily<?>, Unit>, Unit> v, Function0<Unit> action) {
        v.invoke((Object)cleanupFamilies.1.INSTANCE);
        action.invoke();
        v.invoke((Object)cleanupFamilies.2.INSTANCE);
    }

    public static final /* synthetic */ void access$cleanupFamilies(@NotNull Function1 v, @NotNull Function0 action) {
        MysqlIntrospectorKt.cleanupFamilies(v, (Function0<Unit>)action);
    }

    @NotNull
    public static final /* synthetic */ DasRoutine.Kind access$getType(@NotNull String type) {
        return MysqlIntrospectorKt.getType(type);
    }

    @NotNull
    public static final /* synthetic */ DasArgument.Direction access$getDirection(@NotNull String mode) {
        return MysqlIntrospectorKt.getDirection(mode);
    }

    @NotNull
    public static final /* synthetic */ DasArgument.Direction access$getDirection(int id) {
        return MysqlIntrospectorKt.getDirection(id);
    }

    public static final /* synthetic */ Pattern access$getON_UPDATE$p() {
        return ON_UPDATE;
    }

    @NotNull
    public static final /* synthetic */ SequenceIdentity access$getOurMysqlSequenceIdentity$p() {
        return ourMysqlSequenceIdentity;
    }

    @NotNull
    public static final /* synthetic */ TrigEvent access$getEvent(@NotNull String manipulation) {
        return MysqlIntrospectorKt.getEvent(manipulation);
    }
}

