/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.util.containers.JBIterable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.BaseSession;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.OracleExceptionRecognizer;
import org.jetbrains.dekaf.sql.SqlQuery;

public class SchemaLoader {
    private static final Logger LOG = Logger.getInstance(SchemaLoader.class);

    public static ClosableIt<String> catalogs(DatabaseMetaDataWrapper meta) throws SQLException {
        try {
            if (meta.getFamilyId().isPostgres()) {
                return SchemaLoader.pgCatalogs(meta);
            }
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
        }
        try {
            return SchemaLoader.jdbcCatalogs(meta);
        }
        catch (RuntimeException | SQLException e) {
            return SchemaLoader.currentCatalog(meta);
        }
    }

    @NotNull
    private static ClosableIt<String> currentCatalog(DatabaseMetaDataWrapper meta) throws SQLException {
        ClosableIt<String> closableIt = ClosableIt.from(JBIterable.of((Object)meta.getConnection().getCatalog()).iterator());
        if (closableIt == null) {
            SchemaLoader.$$$reportNull$$$0(0);
        }
        return closableIt;
    }

    private static ClosableIt<String> pgCatalogs(@NotNull DatabaseMetaDataWrapper meta) throws SQLException {
        if (meta == null) {
            SchemaLoader.$$$reportNull$$$0(1);
        }
        try (ClosableIt.AutoCloseableGuard<Statement> statement = ClosableIt.AutoCloseableGuard.guarded(meta.getConnection().createStatement());){
            ClosableIt<String> res = new ClosableIt.ResultSetDelegateIt<String>(statement.get().executeQuery("select datname as name from pg_catalog.pg_database where not datistemplate"), (AutoCloseable)statement.get()){

                @Override
                protected String calcValue() throws SQLException {
                    return this.myRs.getString("name", 1);
                }
            }.withErrorSink(meta.getErrorSink());
            statement.release();
            ClosableIt<String> closableIt = res;
            return closableIt;
        }
    }

    private static ClosableIt<String> jdbcCatalogs(@NotNull DatabaseMetaDataWrapper meta) throws SQLException {
        if (meta == null) {
            SchemaLoader.$$$reportNull$$$0(2);
        }
        return new ClosableIt.ResultSetDelegateIt<String>(meta.getMetaData().getCatalogs(), null){

            @Override
            protected String calcValue() throws SQLException {
                return this.myRs.getString("TABLE_CAT", 1);
            }
        }.withErrorSink(meta.getErrorSink());
    }

    public static ClosableIt<DatabaseMetaDataWrapper.Schema> schemas(@NotNull JBIterable<String> catalogs, @Nullable String current, @NotNull DatabaseMetaDataWrapper meta) {
        if (catalogs == null) {
            SchemaLoader.$$$reportNull$$$0(3);
        }
        if (meta == null) {
            SchemaLoader.$$$reportNull$$$0(4);
        }
        ClosableIt<DatabaseMetaDataWrapper.Schema> specific = null;
        if (meta.getFamilyId().isMicrosoft()) {
            specific = SchemaLoader.mssqlSchemas(catalogs.iterator(), meta);
        } else if (meta.getFamilyId().isOracle()) {
            specific = SchemaLoader.oracleSchemas(meta);
        }
        if (specific != null) {
            return ClosableIt.lazyAppendIfEmpty(specific, () -> {
                if (catalogs == null) {
                    SchemaLoader.$$$reportNull$$$0(6);
                }
                if (meta == null) {
                    SchemaLoader.$$$reportNull$$$0(7);
                }
                return SchemaLoader.jdbcSchemas(catalogs, current, meta);
            });
        }
        return SchemaLoader.jdbcSchemas(catalogs, current, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> oracleSchemas(@NotNull DatabaseMetaDataWrapper meta) {
        if (meta == null) {
            SchemaLoader.$$$reportNull$$$0(5);
        }
        try (JdbcIntermediateSession intermediateSession = new JdbcIntermediateSession(null, (DBExceptionRecognizer)OracleExceptionRecognizer.INSTANCE, meta.getConnection(), false){};){
            BaseSession session = new BaseSession((IntegralIntermediateSession)intermediateSession){};
            SqlQuery query = new SqlQuery("select username                                                       \nfrom sys.all_users U                                                  \nwhere exists (select 1 from sys.all_objects where owner = U.username) \n   or username = user                                                 \n   or username = sys_context('userenv','current_schema')              \n", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
            List names = (List)session.query(query).run();
            names.add("PUBLIC");
            names.sort(NaturalComparator.INSTANCE);
            ClosableIt closableIt = (ClosableIt)ClosableIt.from(names.iterator()).transform(schema -> new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)schema), "*"));
            return closableIt;
        }
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> mssqlSchemas(Iterator<String> catalogs, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.mssqlSchemasInCatalog(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.mssqlSchemas(catalogs, meta));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> mssqlSchemasInCatalog(final String catalog, DatabaseMetaDataWrapper meta) {
        try (ClosableIt.AutoCloseableGuard<Statement> statement = ClosableIt.AutoCloseableGuard.guarded(meta.getConnection().createStatement());){
            ClosableIt<DatabaseMetaDataWrapper.Schema> res = new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(statement.get().executeQuery("select name from [" + catalog + "].sys.schemas"), (AutoCloseable)statement.get()){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)this.myRs.getString("name", 1)), catalog);
                }
            }.withErrorSink(meta.getErrorSink());
            statement.release();
            ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = res;
            return closableIt;
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
            return ClosableIt.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas(JBIterable<String> catalogs, String current, DatabaseMetaDataWrapper meta) {
        Throwable throwable;
        if (catalogs.isEmpty()) {
            catalogs = JBIterable.from(Collections.singletonList(null));
        }
        try {
            throwable = null;
            try (ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>> it222 = ClosableIt.AutoCloseableGuard.guarded(SchemaLoader.jdbcSchemas1(catalogs.iterator(), meta));){
                if (it222.get().hasNext()) {
                    ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it222.release();
                    return closableIt;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (UnsupportedOperationException it222) {
        }
        catch (AbstractMethodError it222) {
            // empty catch block
        }
        throwable = null;
        try (ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>> it = ClosableIt.AutoCloseableGuard.guarded(SchemaLoader.jdbcSchemas2(catalogs.iterator(), current, meta));){
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), (String)current);
            if (it.get().hasNext()) {
                ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it.release();
                return closableIt;
            }
        }
        catch (Throwable throwable7) {
            throwable = throwable7;
            throw throwable7;
        }
        it = ClosableIt.AutoCloseableGuard.guarded(SchemaLoader.jdbcSchemas3((JBIterable<String>)catalogs, current, meta));
        throwable = null;
        try {
            if (it.get().hasNext()) {
                ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it.release();
                return closableIt;
            }
        }
        catch (Throwable throwable9) {
            throwable = throwable9;
            throw throwable9;
        }
        finally {
            if (it != null) {
                if (throwable != null) {
                    try {
                        it.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                } else {
                    it.close();
                }
            }
        }
        Object cats = catalogs;
        if (!catalogs.isEmpty()) return (ClosableIt)ClosableIt.from(cats.iterator()).transform(catalog -> new DatabaseMetaDataWrapper.Schema("", (String)catalog));
        cats = Collections.singleton(null);
        return (ClosableIt)ClosableIt.from(cats.iterator()).transform(catalog -> new DatabaseMetaDataWrapper.Schema("", (String)catalog));
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas3(final JBIterable<String> catalogs, final String current, DatabaseMetaDataWrapper meta) {
        try {
            return new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(meta.getMetaData().getSchemas(), null){
                private Iterator<String> myCats;
                private DatabaseMetaDataWrapper.Schema myCur;
                {
                    super(rs, hook);
                    this.myCats = null;
                    this.myCur = null;
                }

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    String schema = this.myRs.getString("TABLE_SCHEM", 1);
                    String catalog = this.myRs.getString("TABLE_CATALOG", 2);
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)schema), catalog == null ? null : DbUtil.intern((String)catalog));
                }

                @Override
                protected DatabaseMetaDataWrapper.Schema nextImpl() {
                    if (this.myCats != null && this.myCats.hasNext() && this.myCur != null) {
                        return new DatabaseMetaDataWrapper.Schema(this.myCur.schema, this.myCats.next());
                    }
                    DatabaseMetaDataWrapper.Schema schema = (DatabaseMetaDataWrapper.Schema)super.nextImpl();
                    if (schema == null) {
                        return null;
                    }
                    if (schema.database == null && !catalogs.isEmpty()) {
                        this.myCur = schema;
                        this.myCats = catalogs.iterator();
                        return (DatabaseMetaDataWrapper.Schema)this.skip();
                    }
                    if (schema.database == null) {
                        schema.database = current;
                    }
                    return schema;
                }
            }.withErrorSink(meta.getErrorSink());
        }
        catch (SQLException e) {
            meta.onError(null, e);
            return ClosableIt.empty();
        }
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas2(Iterator<String> catalogs, String current, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext() || current == null) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.jdbcSchemasInCatalog2(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.jdbcSchemas2(catalogs, current, meta));
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemasInCatalog2(final String catalog, DatabaseMetaDataWrapper meta) {
        String dbName = catalog;
        if (meta.getFamilyId().isTransactSql()) {
            String q = meta.getQuote();
            dbName = q + dbName + q;
        }
        if (JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), (String)dbName)) {
            try {
                return new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(meta.getMetaData().getSchemas(), null){

                    @Override
                    protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                        String schema = this.myRs.getString("TABLE_SCHEM", 1);
                        String cat = this.myRs.getString("TABLE_CATALOG", 2);
                        if (cat != null && !catalog.equals(cat)) {
                            return (DatabaseMetaDataWrapper.Schema)this.skip();
                        }
                        return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)schema), catalog);
                    }
                }.withErrorSink(meta.getErrorSink());
            }
            catch (Exception ex) {
                meta.onError(null, ex);
            }
        }
        return ClosableIt.empty();
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas1(Iterator<String> catalogs, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.jdbcSchemasInCatalog1(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.jdbcSchemas1(catalogs, meta));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemasInCatalog1(final String catalog, DatabaseMetaDataWrapper meta) {
        ResultSet rs = SchemaLoader.getSchemas(catalog, meta);
        if (rs == null) return ClosableIt.empty();
        try (ClosableIt.AutoCloseableGuard<ResultSet> g = ClosableIt.AutoCloseableGuard.guarded(rs);){
            ClosableIt<DatabaseMetaDataWrapper.Schema> res = new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(rs, null){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)this.myRs.getString("TABLE_SCHEM", 1)), catalog);
                }
            }.withErrorSink(meta.getErrorSink());
            g.release();
            ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = res;
            return closableIt;
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
        return ClosableIt.empty();
    }

    private static ResultSet getSchemas(String catalog, DatabaseMetaDataWrapper meta) {
        try {
            return meta.getMetaData().getSchemas(catalog, "%");
        }
        catch (SQLException ex) {
            try {
                String q = meta.getQuote();
                return meta.getMetaData().getSchemas(q + catalog + q, "%");
            }
            catch (SQLException ex2) {
                return null;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/SchemaLoader";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "currentCatalog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/SchemaLoader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pgCatalogs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "jdbcCatalogs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "schemas";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "oracleSchemas";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$schemas$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

