/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.CompositeTextFun;
import com.intellij.database.scripting.SimpleCompositeText;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0014\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016J\u001f\u0010\u0016\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00020\u0005*\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/model/impl/MemoryTextStorage;", "Lcom/intellij/database/model/ModelTextStorage;", "()V", "content", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/database/scripting/CompositeText;", "versions", "", "getVersion", "element", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;)Ljava/lang/Long;", "hasExistingSources", "", "load", "Lcom/intellij/database/model/basic/BasicSourceAware;", "processDeleteQueue", "", "queueDelete", "save", "text", "setVersion", "version", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Long;)V", "writeSession", "runnable", "Ljava/lang/Runnable;", "composeElementKey", "database-model-impl"})
public final class MemoryTextStorage
implements ModelTextStorage {
    private final ConcurrentHashMap<String, CompositeText> content = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> versions = new ConcurrentHashMap();

    @Override
    public void save(@NotNull BasicSourceAware element, @Nullable CompositeText text2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String key2 = this.composeElementKey(element);
        if (text2 != null) {
            Map map2 = this.content;
            SimpleCompositeText simpleCompositeText = CompositeTextFun.copy(text2);
            map2.put(key2, simpleCompositeText);
        } else {
            this.content.remove(key2);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.content.remove(this.composeElementKey(element));
    }

    @Override
    public void processDeleteQueue() {
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String key2 = this.composeElementKey(element);
        return this.content.get(key2);
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return !(element instanceof BasicSourceAware) || this.content.contains(this.composeElementKey(element));
    }

    @Override
    public void writeSession(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        runnable.run();
    }

    @Override
    @Nullable
    public Long getVersion(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.versions.get(this.composeElementKey(element));
    }

    @Override
    public void setVersion(@NotNull BasicElement element, @Nullable Long version) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String key2 = this.composeElementKey(element);
        if (version != null) {
            Map map2 = this.versions;
            Long l = version;
            map2.put(key2, l);
        } else {
            this.versions.remove(key2);
        }
    }

    private final String composeElementKey(@NotNull BasicElement $receiver) {
        BasicModel basicModel = $receiver.getModel();
        String prefix = String.valueOf(basicModel != null ? basicModel.hashCode() : 0);
        String key2 = prefix + '/' + CollectionsKt.joinToString$default((Iterable)$receiver.getDbPath(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        return key2;
    }
}

