/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraKey;
import com.intellij.database.model.oracle.OraModConstraint;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModKey
extends OraKey,
OraModConstraint,
BasicModKey {
    @Override
    @NotNull
    public OraModTable getTable();

    @Override
    @NotNull
    default public OraModTable getDbParent() {
        OraModTable oraModTable = this.getTable();
        if (oraModTable == null) {
            OraModKey.$$$reportNull$$$0(0);
        }
        return oraModTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModKey> getParentFamily();

    @Override
    @NotNull
    default public OraModSchema getSchema() {
        OraModSchema oraModSchema = this.getTable().getSchema();
        if (oraModSchema == null) {
            OraModKey.$$$reportNull$$$0(1);
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            OraModKey.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            OraModKey.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setDeferrable(boolean var1);

    @Override
    public void setInitiallyDeferred(boolean var1);

    public void setUnderlyingIndexName(@Nullable String var1);

    @Override
    public void setPrimary(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            OraModKey.$$$reportNull$$$0(4);
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String colNames = properties.get("ColNames");
        String deferrable = properties.get("Deferrable");
        String initiallyDeferred = properties.get("InitiallyDeferred");
        String underlyingIndexName = properties.get("UnderlyingIndexName");
        String primary = properties.get("Primary");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate(createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate(modifiedTimestamp) : null);
        this.setColNames(colNames != null ? PropertyConverter.importListOfString(colNames) : Collections.emptyList());
        this.setDeferrable(deferrable != null ? PropertyConverter.importBoolean(deferrable) : false);
        this.setInitiallyDeferred(initiallyDeferred != null ? PropertyConverter.importBoolean(initiallyDeferred) : false);
        this.setUnderlyingIndexName(underlyingIndexName != null ? PropertyConverter.importString(underlyingIndexName) : null);
        this.setPrimary(primary != null ? PropertyConverter.importBoolean(primary) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/oracle/OraModKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/oracle/OraModKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

