/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresModDatabase;
import com.intellij.database.model.postgres.PostgresModForeignServer;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModForeignDataWrapper
extends PostgresForeignDataWrapper,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public PostgresModDatabase getDatabase();

    @Override
    @NotNull
    default public PostgresModDatabase getDbParent() {
        PostgresModDatabase postgresModDatabase = this.getDatabase();
        if (postgresModDatabase == null) {
            PostgresModForeignDataWrapper.$$$reportNull$$$0(0);
        }
        return postgresModDatabase;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModForeignDataWrapper> getParentFamily();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModForeignServer> getForeignServers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<NamingIdentifyingFamily> list = Collections.singletonList(this.getForeignServers());
        if (list == null) {
            PostgresModForeignDataWrapper.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getForeignServers());
        if (jBIterable == null) {
            PostgresModForeignDataWrapper.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    public void setHandler(@Nullable String var1);

    public void setHandlerSchema(@Nullable String var1);

    public void setValidator(@Nullable String var1);

    public void setValidatorSchema(@Nullable String var1);

    public void setOptions(@NotNull List<String> var1);

    default public void setOptions(String ... options) {
        this.setOptions(Arrays.asList(options));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            PostgresModForeignDataWrapper.$$$reportNull$$$0(3);
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String handler = properties.get("Handler");
        String handlerSchema = properties.get("HandlerSchema");
        String validator = properties.get("Validator");
        String validatorSchema = properties.get("ValidatorSchema");
        String options = properties.get("Options");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setHandler(handler != null ? PropertyConverter.importString(handler) : null);
        this.setHandlerSchema(handlerSchema != null ? PropertyConverter.importString(handlerSchema) : null);
        this.setValidator(validator != null ? PropertyConverter.importString(validator) : null);
        this.setValidatorSchema(validatorSchema != null ? PropertyConverter.importString(validatorSchema) : null);
        this.setOptions(options != null ? PropertyConverter.importListOfString(options) : Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresModForeignDataWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresModForeignDataWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

