/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresLikeStoredTable;
import com.intellij.database.model.postgres.PostgresLikeTrigger;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgresbase.PostgresBaseSourceAware;
import com.intellij.database.model.properties.PostgresFireMode;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresRule
extends PostgresLikeTrigger,
PostgresBaseSourceAware,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.RULE;
        if (objectKind == null) {
            PostgresRule.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Nullable
    public PostgresLikeStoredTable getLikeStoredTable();

    @Override
    @Nullable
    default public PostgresLikeStoredTable getDbParent() {
        return this.getLikeStoredTable();
    }

    @Override
    @Nullable
    default public PostgresLikeStoredTable getMajorObject() {
        return this.getLikeStoredTable();
    }

    default public @NotNull @Nullable NamingIdentifyingFamily<? extends PostgresRule> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public PostgresSchema getSchema() {
        PostgresLikeStoredTable likeStoredTable = this.getLikeStoredTable();
        return likeStoredTable != null ? likeStoredTable.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            PostgresRule.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            PostgresRule.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull JBIterable<? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            PostgresRule.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    @Nullable
    default public TrigTurn getTurn() {
        return null;
    }

    @Override
    @NotNull
    default public Set<TrigEvent> getEvents() {
        Set<TrigEvent> set = Collections.emptySet();
        if (set == null) {
            PostgresRule.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @Nullable
    default public String getCondition() {
        return null;
    }

    @Override
    @Nullable
    default public PostgresFireMode getFireMode() {
        return null;
    }

    @Override
    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = Collections.emptyList();
        if (list == null) {
            PostgresRule.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    default public boolean isInvalid() {
        return false;
    }

    @NotNull
    default public List<String> getCommands() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PostgresRule.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> commands;
        boolean invalid;
        PostgresFireMode fireMode;
        String condition;
        Set<TrigEvent> events;
        TrigTurn turn;
        long stateNumber;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            PostgresRule.$$$reportNull$$$0(7);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((turn = this.getTurn()) != null) {
            consumer.accept("Turn", PropertyConverter.export((Enum)turn));
        }
        if (!(events = this.getEvents()).isEmpty()) {
            consumer.accept("Events", PropertyConverter.exportSetOfTrigEvent(events));
        }
        if ((condition = this.getCondition()) != null) {
            consumer.accept("Condition", PropertyConverter.export(condition));
        }
        if ((fireMode = this.getFireMode()) != null) {
            consumer.accept("FireMode", PropertyConverter.export(fireMode));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", PropertyConverter.export(invalid));
        }
        if (!(commands = this.getCommands()).isEmpty()) {
            consumer.accept("Commands", PropertyConverter.exportListOfString(commands));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "StateNumber", "Turn", "Events", "Condition", "FireMode", "Errors", "Invalid", "Commands");
        if (list == null) {
            PostgresRule.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresRule";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommands";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresRule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

