/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.DbElementDnDTarget;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbClusterImpl;
import com.intellij.database.psi.DbColumnImpl;
import com.intellij.database.psi.DbCustomTypeImpl;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbForeignKeyImpl;
import com.intellij.database.psi.DbIndexImpl;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbObjectAttributeImpl;
import com.intellij.database.psi.DbPackageImpl;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.psi.DbRoutineImpl;
import com.intellij.database.psi.DbSchemaChildImpl;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.psi.DbTableKeyImpl;
import com.intellij.database.psi.DbTableTypeImpl;
import com.intellij.database.psi.DbTriggerImpl;
import com.intellij.database.util.Casing;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectHashingStrategy;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDataSourceImpl
extends DbElementImpl<DatabaseSystem, DbElement>
implements DbDataSource {
    private static final Pattern DOC_PATTERN = Pattern.compile("(?m)(^[^:]+:)");
    private static final Pattern NEW_LINE = Pattern.compile("\n");
    private final Project myProject;
    private final DbPsiManagerSpi myManager;
    private final ClearableLazyValue<Pair<DatabaseDialectEx, SqlLanguageDialect>> myDialects;
    private final Map<DasObject, DbElement> myElements;
    private final Map<String, SmartList<DasObject>> myQNames;

    public DbDataSourceImpl(@NotNull Project project, @NotNull DatabaseSystem dataSourceInfo, @NotNull DbPsiManagerSpi managerSpi) {
        if (project == null) {
            DbDataSourceImpl.$$$reportNull$$$0(0);
        }
        if (dataSourceInfo == null) {
            DbDataSourceImpl.$$$reportNull$$$0(1);
        }
        if (managerSpi == null) {
            DbDataSourceImpl.$$$reportNull$$$0(2);
        }
        super(null, dataSourceInfo);
        this.myDialects = new ClearableLazyValue<Pair<DatabaseDialectEx, SqlLanguageDialect>>(){

            @NotNull
            protected Pair<DatabaseDialectEx, SqlLanguageDialect> compute() {
                Pair pair = DbDataSourceImpl.this.calcDialects();
                if (pair == null) {
                    1.$$$reportNull$$$0(0);
                }
                return pair;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$1", "compute"));
            }
        };
        this.myElements = ConcurrentFactoryMap.createMap(this::createDbElement, () -> ContainerUtil.createConcurrentWeakKeyWeakValueMap((TObjectHashingStrategy)ContainerUtil.identityStrategy()));
        this.myQNames = ConcurrentFactoryMap.createMap(key2 -> (SmartList)QNameUtil.findByQName(((DatabaseSystem)this.getDelegate()).getModel(), key2, DatabaseElementVirtualFileImpl.NAMER).addAllTo((Collection)new SmartList()), ContainerUtil::createConcurrentWeakMap);
        this.myProject = project;
        this.myManager = managerSpi;
        this.putUserData(DatabaseDataKeys.DND_TARGET_KEY, new DbElementDnDTarget.DataSourceDnDTarget(this));
    }

    @Override
    public boolean isValid() {
        if (this.getProject().isDisposed()) {
            return false;
        }
        return this.myManager.isDataSourceElementValid(this);
    }

    public void clearCaches() {
        this.myQNames.clear();
        this.myDialects.drop();
    }

    @NotNull
    public DbPsiManager getDbManager() {
        DbPsiManagerSpi dbPsiManagerSpi = this.myManager;
        if (dbPsiManagerSpi == null) {
            DbDataSourceImpl.$$$reportNull$$$0(3);
        }
        return dbPsiManagerSpi;
    }

    @Override
    @NotNull
    public DbDataSourceImpl getDataSource() {
        DbDataSourceImpl dbDataSourceImpl = this;
        if (dbDataSourceImpl == null) {
            DbDataSourceImpl.$$$reportNull$$$0(4);
        }
        return dbDataSourceImpl;
    }

    @Override
    @Nullable
    public String getComment() {
        return ((DatabaseSystem)this.myDelegate).getComment();
    }

    @Override
    @NotNull
    public String getTypeName() {
        if ("data source" == null) {
            DbDataSourceImpl.$$$reportNull$$$0(5);
        }
        return "data source";
    }

    @Override
    @NotNull
    public Language getLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            DbDataSourceImpl.$$$reportNull$$$0(6);
        }
        return sqlLanguage;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((DatabaseSystem)this.myDelegate).getName();
        if (string == null) {
            DbDataSourceImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            DbDataSourceImpl.$$$reportNull$$$0(8);
        }
        this.myManager.setDataSourceName(this, name);
        return this;
    }

    public String getUniqueId() {
        return ((DatabaseSystem)this.myDelegate).getUniqueId();
    }

    public String getDatabaseProductName() {
        return ((DatabaseSystem)this.myDelegate).getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return ((DatabaseSystem)this.myDelegate).getDatabaseProductVersion();
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROOT;
        if (objectKind == null) {
            DbDataSourceImpl.$$$reportNull$$$0(9);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean open) {
        return this.myDelegate instanceof Iconable ? ((Iconable)this.myDelegate).getIcon(0) : super.getIcon(open);
    }

    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DbDataSourceImpl.$$$reportNull$$$0(10);
        }
        return project;
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return ((DatabaseSystem)this.myDelegate).getConnectionConfig();
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        this.checkValid();
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)((Pair)this.myDialects.getValue()).first;
        if (databaseDialectEx == null) {
            DbDataSourceImpl.$$$reportNull$$$0(11);
        }
        return databaseDialectEx;
    }

    @NotNull
    public SqlLanguageDialect getSqlDialect() {
        this.checkValid();
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)((Pair)this.myDialects.getValue()).second;
        if (sqlLanguageDialect == null) {
            DbDataSourceImpl.$$$reportNull$$$0(12);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    private Pair<DatabaseDialectEx, SqlLanguageDialect> calcDialects() {
        SqlLanguageDialect sql = (SqlLanguageDialect)ObjectUtils.notNull((Object)this.myManager.getSqlDialect(this), (Object)DbSqlUtil.getGenericDialect());
        DatabaseDialectEx db = (DatabaseDialectEx)ObjectUtils.notNull((Object)this.myManager.getDatabaseDialect(this), (Object)((DatabaseDialectEx)sql.getDatabaseDialect()));
        Pair pair = Pair.create((Object)db, (Object)sql);
        if (pair == null) {
            DbDataSourceImpl.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @NotNull
    public DasModel getModel() {
        this.checkValid();
        DatabaseSystem delegate = (DatabaseSystem)this.getDelegate();
        DasModel dasModel = delegate == null ? DasUtil.emptyModel() : delegate.getModel();
        if (dasModel == null) {
            DbDataSourceImpl.$$$reportNull$$$0(14);
        }
        return dasModel;
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        StringBuilder sb = this.createDocHeaderDefault();
        DatabaseDialectEx dialect = this.getDatabaseDialect();
        sb.append("<b>Dialect:</b> ").append(dialect.getDisplayName()).append("<br>");
        if (this.myDelegate instanceof LocalDataSource) {
            if (!StringUtil.isEmpty((String)this.getDatabaseProductName())) {
                sb.append("<br>").append("<!-- async-doc-cut -->");
                sb.append(DbDataSourceImpl.boldAndNewLine(DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)this.myDelegate))).append("<br>");
            }
        } else {
            DasObject first = (DasObject)((DatabaseSystem)this.myDelegate).getModel().getModelRoots().first();
            sb.append("<br>");
            Casing modes = ((DatabaseSystem)this.myDelegate).getModel().getCasing(ObjectKind.TABLE, first);
            sb.append(MessageFormat.format("<b>Case sensitivity:</b> {0} (quoted: {1})", modes.plain, modes.quoted));
        }
        if (DbImplUtil.canConnectTo(this)) {
            this.scheduleAsyncDocumentationUpdate(sb, this::loadSlowDocumentationInner);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbDataSourceImpl.$$$reportNull$$$0(15);
        }
        return stringBuilder;
    }

    private static String boldAndNewLine(@NotNull String str) {
        if (str == null) {
            DbDataSourceImpl.$$$reportNull$$$0(16);
        }
        return NEW_LINE.matcher(DOC_PATTERN.matcher(str).replaceAll("<b>$1</b>")).replaceAll("<br>\n");
    }

    private void loadSlowDocumentationInner(CharOut charOut, ConnectionProvider provider) throws Exception {
        ((LocalDataSource)this.myDelegate).refreshDatabaseInfo(provider.getConnection().getMetaData());
        charOut.append(DbDataSourceImpl.boldAndNewLine(DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)this.myDelegate)));
    }

    public <S> Function<DasObject, S> mapper() {
        return s -> this.findElement((DasObject)s);
    }

    @Nullable
    public DbElement findElement(@Nullable DasObject o) {
        return o == null ? null : (o instanceof DbElement ? (DbElement)o : this.myElements.get(o));
    }

    @Nullable
    private DbElement createDbElement(@NotNull DasObject dasElement) {
        DbDataSourceImpl parent;
        if (dasElement == null) {
            DbDataSourceImpl.$$$reportNull$$$0(17);
        }
        ObjectKind kind = dasElement.getKind();
        DasObject dasParent = dasElement.getDbParent();
        DbDataSourceImpl dbDataSourceImpl = parent = dasParent == null || dasParent instanceof BasicRoot ? this : this.myElements.get(dasParent);
        DbElementImpl element = kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA ? new DbNamespaceImpl(parent, dasElement) : (dasElement instanceof DasUserDefinedType ? (kind == ObjectKind.TABLE_TYPE ? new DbTableTypeImpl(parent, (DasUserDefinedType)dasElement) : new DbCustomTypeImpl(parent, (DasUserDefinedType)dasElement)) : (dasElement instanceof DasRoutine ? new DbRoutineImpl(parent, (DasRoutine)dasElement) : (dasElement instanceof DasTable ? new DbTableImpl(parent, (DasTable)dasElement) : (kind == ObjectKind.COLUMN && dasElement instanceof DasColumn && parent instanceof DbTable ? new DbColumnImpl((DbTable)parent, (DasColumn)dasElement) : (kind == ObjectKind.OBJECT_ATTRIBUTE && dasElement instanceof DasTypedObject ? new DbObjectAttributeImpl(parent, (DasTypedObject)dasElement) : (kind == ObjectKind.KEY && dasElement instanceof DasTableKey ? new DbTableKeyImpl((DbTable)parent, (DasTableKey)dasElement) : (kind == ObjectKind.FOREIGN_KEY && dasElement instanceof DasForeignKey ? new DbForeignKeyImpl((DbTable)parent, (DasForeignKey)dasElement) : (kind == ObjectKind.INDEX && dasElement instanceof DasIndex ? new DbIndexImpl((DbTable)parent, (DasIndex)dasElement) : (kind == ObjectKind.PACKAGE ? new DbPackageImpl(parent, dasElement) : ((kind == ObjectKind.RULE || kind == ObjectKind.TRIGGER) && dasElement instanceof DasTrigger ? new DbTriggerImpl((DbTable)parent, (DasTrigger)dasElement) : (dasElement instanceof DasCluster ? new DbClusterImpl(parent, (DasCluster)dasElement) : (dasElement instanceof DasSynonym ? new DbSynonymImpl(parent, (DasSynonym)dasElement) : (dasElement instanceof DasSchemaChild ? new DbSchemaChildImpl(parent, (DasSchemaChild)dasElement) : new DbElementImpl<DasObject, DbDataSourceImpl>(parent, dasElement))))))))))))));
        return element;
    }

    @Override
    public void navigate(boolean requestFocus) {
        super.navigate(requestFocus);
    }

    @Nullable
    public DbElement findElement(@NotNull String encodedName, @NotNull ObjectKind kind) {
        if (encodedName == null) {
            DbDataSourceImpl.$$$reportNull$$$0(18);
        }
        if (kind == null) {
            DbDataSourceImpl.$$$reportNull$$$0(19);
        }
        this.checkValid();
        DasObject o = (DasObject)JBIterable.from((Iterable)((Iterable)this.myQNames.get(encodedName))).find(DasUtil.byKind((ObjectKind)kind));
        return o == null ? null : this.findElement(o);
    }

    public <S> JBIterable<S> findChildren(@NotNull DbElement element, @NotNull Class<? extends S> aClass) {
        JBIterable children;
        if (element == null) {
            DbDataSourceImpl.$$$reportNull$$$0(20);
        }
        if (aClass == null) {
            DbDataSourceImpl.$$$reportNull$$$0(21);
        }
        this.checkValid();
        Object delegate = element.getDelegate();
        if (element == this) {
            children = this.getModel().getModelRoots();
        } else if (delegate instanceof DasObject) {
            children = ((DasObject)delegate).getDbChildren(DasObject.class, ObjectKind.NONE);
        } else {
            return JBIterable.empty();
        }
        return children.map(o -> this.myElements.get(o)).filter(aClass);
    }

    public boolean isValidImpl(DbElement element) {
        PsiElement delegatePsi;
        if (!this.isValid()) {
            return false;
        }
        Object delegate = element.getDelegate();
        if (delegate instanceof BasicModElement && ((BasicModElement)delegate).isDropped()) {
            return false;
        }
        PsiElement psiElement = delegatePsi = delegate instanceof PsiElement ? (PsiElement)delegate : null;
        if (delegatePsi != null && !((PsiElement)delegate).isValid()) {
            return false;
        }
        if (delegate == null) {
            return false;
        }
        return this.findElement((DasObject)delegate) == element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerSpi";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbDataSourceImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodedName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbDataSourceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDialects";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "boldAndNewLine";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDbElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

