/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ChooseExtractorAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && DumpAction.getDumpSource(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DumpHandler<?> handler;
        if (e == null) {
            DumpAction.$$$reportNull$$$0(1);
        }
        if ((handler = DumpAction.createHandler(e, this.createHelper())) == null) {
            return;
        }
        handler.performDump(e.getDataContext());
    }

    @Nullable
    private static DumpHandler<?> createHandler(@NotNull AnActionEvent e, ExtractionHelper manager) {
        if (e == null) {
            DumpAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        Object source = DumpAction.getDumpSource(e);
        if (project == null || source == null) {
            return null;
        }
        return source instanceof ConsoleSource ? DumpAction.createConsoleHandler((ConsoleSource)source, manager) : (source instanceof DataGrid ? new DumpHandler.GridHandler(project, (DataGrid)source, manager) : new DumpHandler.DatabaseViewHandler(project, (JBIterable<DbTable>)((JBIterable)source), manager));
    }

    @Nullable
    private static DumpHandler<?> createConsoleHandler(@NotNull ConsoleSource source, @NotNull ExtractionHelper manager) {
        if (source == null) {
            DumpAction.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            DumpAction.$$$reportNull$$$0(4);
        }
        if (!source.console.beforeExecuteQueries(source.model)) {
            return null;
        }
        List<String> queries = DumpAction.getQueries(source);
        Project project = source.console.getProject();
        return queries.isEmpty() ? null : new DumpHandler.ConsoleHandler(project, (JBIterable<String>)JBIterable.from(queries), source.console, manager);
    }

    @NotNull
    public static List<String> getQueries(@NotNull ConsoleSource source) {
        if (source == null) {
            DumpAction.$$$reportNull$$$0(5);
        }
        List list = source.model.statements().transform(it -> {
            if (source == null) {
                DumpAction.$$$reportNull$$$0(12);
            }
            return it.text(source.console.getPStorage(), Conditions.alwaysFalse());
        }).toList();
        if (list == null) {
            DumpAction.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static Object getDumpSource(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            DumpAction.$$$reportNull$$$0(7);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            return dataGrid.isReady() && !dataGrid.isEmpty() && !dataGrid.isEditing() ? dataGrid : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        JdbcConsoleProvider.Info info = QueryActionBase.getInfoClassic(e, DatabaseSettings.getDefaultExecOption());
        if (console != null && info != null) {
            return new ConsoleSource(console, DumpAction.getAdjustedScriptModel(info));
        }
        JBIterable<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup && DbImplUtil.isDataTable(((DatabaseStructure.FamilyGroup)o).kidKind)));
        JBIterable<DbTable> tables = DumpAction.getTables(elements);
        return tables.isEmpty() ? null : tables;
    }

    @NotNull
    private static ScriptModel<?> getAdjustedScriptModel(@NotNull JdbcConsoleProvider.Info info) {
        if (info == null) {
            DumpAction.$$$reportNull$$$0(8);
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole((Editor)info.editor, info.execOption);
        TextRange adjusted = ScriptModelUtil.adjustSelectionRange(info.model, (Document)info.editor.getDocument(), range, info.execOption);
        ScriptModel scriptModel = info.model.subModel(adjusted);
        if (scriptModel == null) {
            DumpAction.$$$reportNull$$$0(9);
        }
        return scriptModel;
    }

    @NotNull
    private static JBIterable<DbTable> getTables(@NotNull JBIterable<DbElement> elements) {
        Set sources;
        List canConnectSources;
        if (elements == null) {
            DumpAction.$$$reportNull$$$0(10);
        }
        JBIterable jBIterable = (canConnectSources = ContainerUtil.filter((Collection)(sources = elements.map(e -> e.getDataSource()).toSet()), DbImplUtil::canConnectTo)).isEmpty() ? JBIterable.empty() : ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots(elements)).expand(Conditions.not((Condition)DasUtil.byClass(DasSchemaChild.class)))).filter(DbTable.class).filter(e -> canConnectSources.contains(e.getDataSource()));
        if (jBIterable == null) {
            DumpAction.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    protected abstract ExtractionHelper createHelper();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedScriptModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDumpSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedScriptModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTables";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQueries$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConsoleSource {
        final JdbcConsole console;
        final ScriptModel<?> model;

        public ConsoleSource(@NotNull JdbcConsole console, @NotNull ScriptModel<?> model) {
            if (console == null) {
                ConsoleSource.$$$reportNull$$$0(0);
            }
            if (model == null) {
                ConsoleSource.$$$reportNull$$$0(1);
            }
            this.console = console;
            this.model = model;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ConsoleSource";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileGroup
    extends ActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            Object source = DumpAction.getDumpSource(e);
            e.getPresentation().setEnabledAndVisible(source != null && e.getProject() != null);
            if (source == null || e.getProject() == null) {
                return;
            }
            if (source instanceof ConsoleSource) {
                FileGroup.updateConsolePresentation((ConsoleSource)source, e);
            } else {
                this.updatePresentation(source, e);
            }
        }

        private static void updateConsolePresentation(@NotNull ConsoleSource source, @NotNull AnActionEvent e) {
            if (source == null) {
                FileGroup.$$$reportNull$$$0(0);
            }
            if (e == null) {
                FileGroup.$$$reportNull$$$0(1);
            }
            List<String> queries = DumpAction.getQueries(source);
            e.getPresentation().setEnabledAndVisible(!queries.isEmpty());
            if (queries.isEmpty()) {
                return;
            }
            e.getPresentation().setText(FileGroup.pluralizeInternal("Execute to &File", FileGroup.getSize(queries)));
            e.getPresentation().setIcon(AllIcons.Actions.Execute);
        }

        private void updatePresentation(@NotNull Object target, @NotNull AnActionEvent e) {
            if (target == null) {
                FileGroup.$$$reportNull$$$0(2);
            }
            if (e == null) {
                FileGroup.$$$reportNull$$$0(3);
            }
            e.getPresentation().setText(FileGroup.pluralizeInternal("Dump Data to &File", FileGroup.getSize(target)), true);
            e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
        }

        @NotNull
        private static String pluralizeInternal(@NotNull String s, int count2) {
            if (s == null) {
                FileGroup.$$$reportNull$$$0(4);
            }
            String string = s + (count2 > 1 ? "(s)" : "");
            if (string == null) {
                FileGroup.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static int getSize(@NotNull Object object) {
            if (object == null) {
                FileGroup.$$$reportNull$$$0(6);
            }
            if (object instanceof JBIterable) {
                return ((JBIterable)object).skip(1).isEmpty() ? 1 : 2;
            }
            if (object instanceof List) {
                return ((List)object).size();
            }
            return 1;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ChooseExtractorAction.ChooserGroup.getActions((Function<DataExtractorFactory, ? extends AnAction>)((Function)ToFileWithCopyAction::new));
            if (anActionArray == null) {
                FileGroup.$$$reportNull$$$0(7);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/DumpAction$FileGroup";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/DumpAction$FileGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pluralizeInternal";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateConsolePresentation";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "pluralizeInternal";
                    break;
                }
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getSize";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ToFileWithCopyAction
        extends ToFile {
            private final DataExtractorFactory myExtractorFactory;

            public ToFileWithCopyAction(@NotNull DataExtractorFactory factory) {
                if (factory == null) {
                    ToFileWithCopyAction.$$$reportNull$$$0(0);
                }
                this.myExtractorFactory = factory;
                this.getTemplatePresentation().setText(factory.getName());
            }

            @Override
            @NotNull
            protected ExtractionHelper createHelper() {
                ExtractionHelper.FileExtractionHelper fileExtractionHelper = new ExtractionHelper.FileExtractionHelper(){

                    @Override
                    @Nullable
                    public DataExtractorFactory getExtractorFactory(@NotNull DataContext context, @NotNull Project project) {
                        if (context == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return myExtractorFactory;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction$1";
                        objectArray[2] = "getExtractorFactory";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                if (fileExtractionHelper == null) {
                    ToFileWithCopyAction.$$$reportNull$$$0(1);
                }
                return fileExtractionHelper;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createHelper";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    public static class ToFile
    extends DumpAction {
        @Override
        @NotNull
        protected ExtractionHelper createHelper() {
            ExtractionHelper.FileExtractionHelper fileExtractionHelper = new ExtractionHelper.FileExtractionHelper();
            if (fileExtractionHelper == null) {
                ToFile.$$$reportNull$$$0(0);
            }
            return fileExtractionHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$ToFile", "createHelper"));
        }
    }

    public static class ToClipboard
    extends DumpAction {
        @Override
        @NotNull
        protected ExtractionHelper createHelper() {
            ExtractionHelper.ClipboardExtractionHelper clipboardExtractionHelper = new ExtractionHelper.ClipboardExtractionHelper();
            if (clipboardExtractionHelper == null) {
                ToClipboard.$$$reportNull$$$0(0);
            }
            return clipboardExtractionHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$ToClipboard", "createHelper"));
        }
    }
}

