/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.fix;

import com.intellij.database.schemaEditor.fix.DdlGraphFixing;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.ImplicitRenameOrder;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FixCyclicRename
implements DdlGraphFixing.CycleFixer {
    @Override
    public boolean fixCycle(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DdlGraph graph, @NotNull List<DdlOperationKey> cycle) {
        if (generator == null) {
            FixCyclicRename.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            FixCyclicRename.$$$reportNull$$$0(1);
        }
        if (graph == null) {
            FixCyclicRename.$$$reportNull$$$0(2);
        }
        if (cycle == null) {
            FixCyclicRename.$$$reportNull$$$0(3);
        }
        boolean prevConf = FixCyclicRename.isImplicitRenameDep(builder, cycle, cycle.size() - 1);
        for (int i2 = 0; i2 < cycle.size(); ++i2) {
            boolean curConf = FixCyclicRename.isImplicitRenameDep(builder, cycle, i2);
            if (curConf && prevConf && FixCyclicRename.processItem(generator, builder, cycle, i2)) {
                return true;
            }
            prevConf = curConf;
        }
        return false;
    }

    private static boolean isImplicitRenameDep(@NotNull DdlGraphBuilder builder, @NotNull List<DdlOperationKey> cycle, int idx) {
        if (builder == null) {
            FixCyclicRename.$$$reportNull$$$0(4);
        }
        if (cycle == null) {
            FixCyclicRename.$$$reportNull$$$0(5);
        }
        DdlOperationKey current = cycle.get(idx);
        DdlOperationKey next = cycle.get((idx + 1) % cycle.size());
        return ImplicitRenameOrder.isRename(current) && ImplicitRenameOrder.isRename(next) && ImplicitRenameOrder.conflicts(current, next, builder);
    }

    private static boolean processItem(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull List<DdlOperationKey> cycle, int idx) {
        if (generator == null) {
            FixCyclicRename.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            FixCyclicRename.$$$reportNull$$$0(7);
        }
        if (cycle == null) {
            FixCyclicRename.$$$reportNull$$$0(8);
        }
        DdlOperationKey current = cycle.get(idx);
        UserDataHolder data = builder.getData(current);
        DeObject from = DasDdlOperations.getAlterFrom(current.target, data);
        DeObject to = DasDdlOperations.getAlterTo(current.target, data);
        generator.removeOperation(builder, current.operation, current.target, data);
        if (data == null) {
            data = builder.newData(null);
        }
        DdlGraph.ALTER_TO.set(data, (Object)to);
        generator.addOperation(builder, DdlOperation.TEMPORARY_RENAME, from, data);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cycle";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/fix/FixCyclicRename";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fixCycle";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRenameDep";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

