/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.AbstractScriptingService$CreatingGenerator$WhenMappings;
import com.intellij.database.scripting.AbstractScriptingService$WhenMappings;
import com.intellij.database.scripting.AbstractScriptingServiceKt$sam$Condition$2c46b29e;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.ScriptContext;
import com.intellij.database.scripting.ScriptingConstraintContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingOrder;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0012\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u00020\u0007:\u0010\u009b\u0001\u009c\u0001\u009d\u0001\u009e\u0001\u009f\u0001\u00a0\u0001\u00a1\u0001\u00a2\u0001B\u0017\b\u0015\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\nJ\u0012\u0010_\u001a\u00020`2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016J\u001d\u0010a\u001a\u0004\u0018\u00018\u00022\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0003\u00a2\u0006\u0002\u0010eJ\u0006\u0010f\u001a\u00020`J&\u0010g\u001a\u00180hR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010i\u001a\u00020jH\u0014J&\u0010k\u001a\u00180hR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010i\u001a\u00020jH\u0014J&\u0010l\u001a\u00180hR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010i\u001a\u00020jH\u0014J&\u0010m\u001a\u00180hR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010i\u001a\u00020jH\u0014J&\u0010n\u001a\u00180hR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010i\u001a\u00020jH\u0014J2\u0010o\u001a\u00180pR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0'H\u0014J&\u0010r\u001a\u00180hR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010i\u001a\u00020jH\u0014J\u0010\u0010s\u001a\u00020\u001c2\u0006\u0010t\u001a\u00020,H\u0016J\u0010\u0010u\u001a\u00020\u001c2\u0006\u0010t\u001a\u00020,H\u0016J\b\u0010F\u001a\u00020EH\u0016J\u0013\u0010v\u001a\b\u0012\u0004\u0012\u00020\u001c0wH\u0016\u00a2\u0006\u0002\u0010xJ\b\u0010y\u001a\u00020\u001cH\u0016J\u0016\u0010z\u001a\b\u0012\u0004\u0012\u00020{0W2\u0006\u0010|\u001a\u00020{H\u0014J\u0016\u0010}\u001a\b\u0012\u0004\u0012\u00020~0W2\u0006\u0010|\u001a\u00020\u0006H\u0014J\u0011\u0010\u007f\u001a\u00020\u001c2\u0007\u0010\u0080\u0001\u001a\u00020EH\u0002J\u000f\u0010\u0081\u0001\u001a\u00020`H\u0010\u00a2\u0006\u0003\b\u0082\u0001J\u0013\u0010\u0083\u0001\u001a\u00020\u00102\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0014J\u0015\u0010\u0086\u0001\u001a\u00020\u00102\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001H\u0014J\u0013\u0010\u0089\u0001\u001a\u00020\u001c2\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0014J.\u0010\u008c\u0001\u001a\u00020`2\u0019\u0010i\u001a\u0015\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0\u008d\u00010W2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016J\u001b\u0010\u008e\u0001\u001a\u00020`2\u0006\u0010i\u001a\u00020j2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016J(\u0010\u008e\u0001\u001a\u00020`2\u0006\u0010i\u001a\u00020j2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0007\u0010\u008f\u0001\u001a\u00020\u0010H\u0016J!\u0010\u008e\u0001\u001a\u00020`2\u0006\u0010i\u001a\u00020j2\u000e\u0010\u0090\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u0091\u0001H\u0016J\u0012\u0010C\u001a\u00020\u001c2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0014J \u0010\u0092\u0001\u001a\u00020`2\u0006\u0010i\u001a\u00020j2\r\u0010\u0093\u0001\u001a\b\u0012\u0004\u0012\u00020d0WH\u0004J\u001d\u0010\u0094\u0001\u001a\b\u0012\u0004\u0012\u00020,0c2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020,0WH\u0004J\u001d\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u00020,0c2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020,0cH\u0002J\t\u0010\u0096\u0001\u001a\u00020\u001cH\u0016J\u0011\u0010\u0097\u0001\u001a\u00020`2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0014\u0010\u0098\u0001\u001a\u00020\u00102\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u001cH\u0014J\r\u0010\u009a\u0001\u001a\u00020\u001c*\u00020,H\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u0004\u0018\u00018\u00022\b\u0010\u0015\u001a\u0004\u0018\u00018\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u0004\u0018\u00018\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R&\u0010\t\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u0001@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\f0'X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100R$\u00104\u001a\u0002032\u0006\u00102\u001a\u000203@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020:X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020@8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR \u0010C\u001a\b\u0012\u0004\u0012\u00020E0DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u0014\u0010J\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010\u0012R\u0014\u0010L\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u001eR\u001a\u0010N\u001a\b\u0012\u0004\u0012\u00020P0OX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010.R\u001a\u0010R\u001a\b\u0012\u0004\u0012\u00020P0OX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010.R\u0019\u0010T\u001a\u00020\u001c*\u00020\u001c8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u001f\u0010T\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\u001c0W8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010XR\u0018\u0010Y\u001a\u00020\u001c*\u00020\u001c8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010VR\u0018\u0010[\u001a\u00020\u0010*\u00020\\8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010^\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService;", "M", "Lcom/intellij/database/model/basic/BasicModel;", "D", "Lcom/intellij/database/model/basic/BasicDatabase;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/scripting/ScriptingService;", "model", "database", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;)V", "SizeAndScale1", "Lcom/intellij/database/scripting/AbstractScriptingService$SizeAndScale;", "getSizeAndScale1", "()Lcom/intellij/database/scripting/AbstractScriptingService$SizeAndScale;", "considerOrderHeuristic", "", "getConsiderOrderHeuristic", "()Z", "setConsiderOrderHeuristic", "(Z)V", "schema", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "currentSchemaName", "", "getCurrentSchemaName", "()Ljava/lang/String;", "currentSchema_", "Lcom/intellij/database/model/basic/BasicSchema;", "getDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "Lcom/intellij/database/model/basic/BasicDatabase;", "defaultPrimitiveSizes", "", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "generated", "", "Lcom/intellij/database/model/basic/BasicElement;", "getGenerated", "()Ljava/util/Set;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/basic/BasicModel;", "<set-?>", "Lcom/intellij/database/scripting/NamingService;", "naming", "getNaming", "()Lcom/intellij/database/scripting/NamingService;", "setNaming", "(Lcom/intellij/database/scripting/NamingService;)V", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "script", "", "Lcom/intellij/database/scripting/CompositeText;", "getScript", "()Ljava/util/List;", "setScript", "(Ljava/util/List;)V", "statementDelimiterOwnsLine", "getStatementDelimiterOwnsLine", "statementDelimiterStr", "getStatementDelimiterStr", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "supportsCreateOrReplace", "getSupportsCreateOrReplace", "scr", "getScr", "(Ljava/lang/String;)Ljava/lang/String;", "", "(Ljava/lang/Iterable;)Ljava/lang/String;", "sqlString", "getSqlString", "useName", "Lcom/intellij/database/model/basic/BasicNamedElement;", "getUseName", "(Lcom/intellij/database/model/basic/BasicNamedElement;)Z", "assumeCurrentSchema", "", "checkForSingleSchema", "objects", "", "Lcom/intellij/database/model/basic/BasicScriptable;", "(Ljava/util/Collection;)Lcom/intellij/database/model/basic/BasicSchema;", "clearScript", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createDropGenerator", "createEnableDisableGenerator", "createExecuteGenerator", "createGenerator", "createRefactoringGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$RefactoringGenerator;", "migrated", "createRefreshingGenerator", "getPreliminaryOrder", "element", "getPreliminaryOrderPart", "getScriptStatements", "", "()[Ljava/lang/String;", "getScriptText", "getScriptableChildren", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "o", "getScriptableMajorObjects", "Lcom/intellij/database/model/basic/BasicMajorObject;", "getStatementDelimiter", "stmt", "init", "init$database_scripting", "isDefaultSize", "d", "Lcom/intellij/database/model/DataType;", "isNullExplicit", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "makeForeignKeyReference", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "makeRefactoringScript", "Lkotlin/Pair;", "makeScript", "recursive", "schemata", "", "sortAndGenerate", "unsortedObjects", "sortPreliminary", "sortTopologically", "toString", "useDatabase", "useSchemaName", "schemaName", "currentScopeName", "CodeGenerator", "CreatingGenerator", "EnableDisableGenerator", "ExecuteGenerator", "RefactoringGenerator", "RefreshMatViewGenerator", "SizeAndScale", "StupidGenerator", "database-scripting"})
public abstract class AbstractScriptingService<M extends BasicModel, D extends BasicDatabase, S extends BasicSchema>
implements ScriptingService {
    @NotNull
    private final M model;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    protected NamingService naming;
    @NotNull
    private D database;
    private S currentSchema_;
    private boolean considerOrderHeuristic;
    @NotNull
    private List<CompositeText> script;
    @NotNull
    private final Set<BasicElement> generated;
    @NotNull
    private final SizeAndScale SizeAndScale1;
    @NotNull
    private final Map<String, SizeAndScale> defaultPrimitiveSizes;
    @NotNull
    private final Set<ObjectKind> supportsCreateOrReplace;
    @NotNull
    private final Set<ObjectKind> supportsCreateIfNotExists;

    @NotNull
    public final M getModel() {
        return this.model;
    }

    @NotNull
    public final Rdbms getRdbms() {
        Rdbms rdbms = this.model.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"model.rdbms");
        return rdbms;
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final NamingService getNaming() {
        NamingService namingService = this.naming;
        if (namingService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"naming");
        }
        return namingService;
    }

    protected final void setNaming(@NotNull NamingService namingService) {
        Intrinsics.checkParameterIsNotNull((Object)namingService, (String)"<set-?>");
        this.naming = namingService;
    }

    @NotNull
    public D getDatabase() {
        return this.database;
    }

    public void setDatabase(@NotNull D database) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        boolean bl2 = bl = database.getModel() == this.model;
        if (_Assertions.ENABLED && !bl) {
            String string = "Alien database";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.currentSchema_ != null && !CollectionsKt.contains((Iterable)database.getSchemas(), this.currentSchema_)) {
            BasicSchema newCurrentSchema = ModelFun.getCurrentSchema(database);
            this.currentSchema_ = newCurrentSchema != null ? newCurrentSchema : (BasicSchema)null;
        }
    }

    @Nullable
    public S getCurrentSchema() {
        return this.currentSchema_;
    }

    public void setCurrentSchema(@Nullable S schema) {
        if (schema != null && this.getDatabase() != null) {
            boolean bl = CollectionsKt.contains((Iterable)this.getDatabase().getSchemas(), schema);
            if (_Assertions.ENABLED && !bl) {
                String string = "Alien schema " + schema.getName() + "; expected a schema of the database " + this.getDatabase().getName();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        this.currentSchema_ = schema;
    }

    private final String getCurrentSchemaName() {
        S s = this.getCurrentSchema();
        return s != null ? s.getRealName() : null;
    }

    @Override
    public boolean getConsiderOrderHeuristic() {
        return this.considerOrderHeuristic;
    }

    @Override
    public void setConsiderOrderHeuristic(boolean bl) {
        this.considerOrderHeuristic = bl;
    }

    @NotNull
    protected final List<CompositeText> getScript() {
        return this.script;
    }

    protected final void setScript(@NotNull List<CompositeText> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.script = list;
    }

    @NotNull
    protected final Set<BasicElement> getGenerated() {
        return this.generated;
    }

    public void init$database_scripting() {
    }

    @Override
    public void useDatabase(@NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.setDatabase(database);
    }

    @Override
    public void assumeCurrentSchema(@Nullable BasicSchema schema) {
        if (schema != null) {
            this.setCurrentSchema(schema);
        } else {
            this.setCurrentSchema(null);
        }
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        BasicSchema basicSchema = schema;
        if (basicSchema == null) {
            basicSchema = this.getCurrentSchema();
        }
        if (basicSchema == null) {
            return;
        }
        BasicSchema s = basicSchema;
        ArrayList<BasicMajorObject> elements = new ArrayList<BasicMajorObject>();
        if (schema != null) {
            this.setCurrentSchema(schema);
        }
        Iterable<BasicMajorObject> $receiver$iv = this.getScriptableMajorObjects(s);
        Iterator<BasicMajorObject> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicMajorObject element$iv;
            BasicMajorObject it = element$iv = iterator.next();
            elements.add(it);
        }
        this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull List<? extends BasicSchema> schemata) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(schemata, (String)"schemata");
        ArrayList<BasicMajorObject> elements = new ArrayList<BasicMajorObject>();
        if (schemata.size() == 1) {
            this.makeScript(task, (BasicSchema)CollectionsKt.first(schemata));
        } else {
            for (BasicSchema basicSchema : schemata) {
                Iterable<BasicMajorObject> $receiver$iv = this.getScriptableMajorObjects(basicSchema);
                Iterator<BasicMajorObject> iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    BasicMajorObject element$iv;
                    BasicMajorObject it = element$iv = iterator.next();
                    elements.add(it);
                }
            }
            this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
        }
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull Collection<? extends BasicScriptable> objects, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        ArrayList<? extends BasicScriptable> elements = new ArrayList<BasicScriptable>(objects);
        S singleSchema = this.checkForSingleSchema(objects);
        if (singleSchema != null) {
            this.setCurrentSchema(singleSchema);
        }
        this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
    }

    private final S checkForSingleSchema(Collection<? extends BasicScriptable> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        BasicSchema schema = null;
        for (BasicScriptable basicScriptable : objects) {
            BasicSchema s;
            if (basicScriptable.getSchema() == null) {
                return null;
            }
            if (schema == null && s == null) {
                throw new TypeCastException("null cannot be cast to non-null type S");
            }
            if (schema == s) continue;
            return null;
        }
        return (S)schema;
    }

    @NotNull
    protected Iterable<BasicMajorObject> getScriptableMajorObjects(@NotNull BasicSchema o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        JBIterable jBIterable = o.getDbChildren(BasicMajorObject.class, null).filter((Condition)getScriptableMajorObjects.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"o.getDbChildren(BasicMaj\u2026icTable || !it.isSystem})");
        return (Iterable)jBIterable;
    }

    @NotNull
    protected Iterable<BasicSchemaObject> getScriptableChildren(@NotNull BasicSchemaObject o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        JBIterable<BasicSchemaObject> jBIterable = o.getDbChildren(BasicSchemaObject.class, null);
        Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"o.getDbChildren(BasicSch\u2026Object::class.java, null)");
        return (Iterable)jBIterable;
    }

    protected final void sortAndGenerate(@NotNull ScriptingTask task, @NotNull Iterable<? extends BasicScriptable> unsortedObjects) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(unsortedObjects, (String)"unsortedObjects");
        Collection<BasicElement> preliminarySortedObjects = this.sortPreliminary(unsortedObjects);
        Collection<BasicElement> topoSortedObjects = this.sortTopologically(preliminarySortedObjects);
        CodeGenerator generator = this.createGenerator(task);
        generator.setElementsToGenerate((Iterable<? extends BasicElement>)topoSortedObjects);
        generator.generate();
    }

    @NotNull
    protected CodeGenerator createGenerator(@NotNull ScriptingTask task) {
        CodeGenerator codeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        switch (AbstractScriptingService$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
            case 1: 
            case 2: {
                codeGenerator = this.createCreatingGenerator(task);
                break;
            }
            case 3: {
                codeGenerator = this.createDropGenerator(task);
                break;
            }
            case 4: 
            case 5: {
                codeGenerator = this.createEnableDisableGenerator(task);
                break;
            }
            case 6: {
                codeGenerator = this.createRefreshingGenerator(task);
                break;
            }
            case 7: {
                codeGenerator = this.createExecuteGenerator(task);
                break;
            }
            default: {
                codeGenerator = new StupidGenerator(task);
            }
        }
        return codeGenerator;
    }

    @NotNull
    protected CodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new CreatingGenerator(task);
    }

    @NotNull
    protected CodeGenerator createEnableDisableGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new EnableDisableGenerator(task);
    }

    @NotNull
    protected CodeGenerator createRefreshingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new RefreshMatViewGenerator(task);
    }

    @NotNull
    protected CodeGenerator createExecuteGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new StupidGenerator(task);
    }

    @NotNull
    protected CodeGenerator createDropGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new StupidGenerator(task);
    }

    @NotNull
    protected final Collection<BasicElement> sortPreliminary(@NotNull Iterable<? extends BasicElement> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        TreeMap<String, BasicElement> sortingTree = new TreeMap<String, BasicElement>();
        for (BasicElement basicElement : objects) {
            String order = this.getPreliminaryOrder(basicElement);
            sortingTree.put(order, basicElement);
        }
        Collection<BasicElement> collection = sortingTree.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sortingTree.values");
        return collection;
    }

    @NotNull
    public String getPreliminaryOrder(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        StringBuilder b = new StringBuilder(60);
        for (BasicElement e = element; e != null; e = e.getDbParent()) {
            CharSequence charSequence = b;
            if (charSequence.length() > 0) {
                b.insert(0, '.');
            }
            b.insert(0, this.getPreliminaryOrderPart(e));
            if (e instanceof BasicMajorObject) break;
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    public String getPreliminaryOrderPart(@NotNull BasicElement element) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String kindOrder = ScriptingUtilsKt.orderString(element.getKind());
        BasicElement basicElement = element;
        if (basicElement instanceof BasicArrangedElement) {
            string = "#" + ScriptingUtilsKt.toFixedOrderString(((BasicArrangedElement)element).getPosition());
        } else if (basicElement instanceof BasicIdentifiedElement) {
            string = ScriptingUtilsKt.toOrderString(((BasicIdentifiedElement)element).getObjectId()) + "_" + ((BasicIdentifiedElement)element).getRealName();
        } else if (basicElement instanceof BasicNamedElement) {
            StringBuilder stringBuilder = new StringBuilder().append("?_");
            String string2 = ((BasicNamedElement)element).getRealName();
            if (string2 == null) {
                string2 = "???";
            }
            string = stringBuilder.append((Object)string2).toString();
        } else {
            string = "?????";
        }
        String elementOrder = string;
        return kindOrder + "_" + elementOrder;
    }

    private final Collection<BasicElement> sortTopologically(Collection<? extends BasicElement> objects) {
        return objects;
    }

    @NotNull
    protected final String getScr(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.getNaming().nameToScript($receiver);
    }

    @NotNull
    protected final String getScr(@NotNull Iterable<String> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.joinToString$default($receiver, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
            final /* synthetic */ AbstractScriptingService this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String $receiver$iv = it;
                AbstractScriptingService this_$iv = this.this$0;
                return this_$iv.getNaming().nameToScript($receiver$iv);
            }
            {
                this.this$0 = abstractScriptingService;
                super(1);
            }
        }), (int)31, null);
    }

    protected final boolean getUseName(@NotNull BasicNamedElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)ModelConsts.NO_NAME) ^ true && (!$receiver.isNameSurrogate() || this.getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES) != false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String currentScopeName(@NotNull BasicElement $receiver) {
        String string;
        String string2;
        block12: {
            block11: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                string2 = $receiver.getRealName();
                if (string2 == null) break block11;
                String string3 = string2;
                AbstractScriptingService this_$iv = this;
                string2 = this_$iv.getNaming().nameToScript((String)$receiver$iv);
                if (string2 != null) break block12;
            }
            string2 = "???";
        }
        String name = string2;
        BasicElement basicElement = $receiver;
        if (basicElement instanceof BasicSchemaObject) {
            String string4;
            String schemaName = ((BasicSchemaObject)$receiver).getSchemaName();
            if (schemaName != null && this.useSchemaName(schemaName)) {
                void $receiver$iv2;
                void this_$iv;
                String string5 = schemaName;
                AbstractScriptingService abstractScriptingService = this;
                StringBuilder stringBuilder = new StringBuilder();
                String string6 = this_$iv.getNaming().nameToScript((String)$receiver$iv2);
                string4 = stringBuilder.append(string6).append(".").toString();
            } else {
                string4 = "";
            }
            String prefix = string4;
            string = prefix + name;
        } else if (basicElement instanceof BasicMinorObject) {
            String string7;
            String schemaName;
            BasicMajorObject majorObject;
            BasicMajorObject basicMajorObject = majorObject = ((BasicMinorObject)$receiver).getMajorObject();
            String string8 = schemaName = basicMajorObject != null ? basicMajorObject.getSchemaName() : null;
            if (schemaName != null && this.useSchemaName(schemaName)) {
                void $receiver$iv;
                void this_$iv;
                String $i$f$getScr = schemaName;
                AbstractScriptingService $receiver$iv2 = this;
                StringBuilder stringBuilder = new StringBuilder();
                String string9 = this_$iv.getNaming().nameToScript((String)$receiver$iv);
                string7 = stringBuilder.append(string9).append(".").toString();
            } else {
                string7 = "";
            }
            String prefix = string7;
            string = prefix + name;
        } else {
            string = name;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean useSchemaName(@Nullable String schemaName) {
        boolean bl;
        if (schemaName == null) return false;
        switch (AbstractScriptingService$WhenMappings.$EnumSwitchMapping$1[this.getOptions().get(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME).ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)schemaName, (Object)this.getCurrentSchemaName()) ^ true;
                break;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    @NotNull
    protected final String getSqlString(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String makeForeignKeyReference(@NotNull BasicForeignKey fk) {
        String string;
        String string2;
        CharSequence charSequence;
        Object $receiver$iv;
        AbstractScriptingService this_$iv;
        StringBuilder stringBuilder;
        boolean toQualify;
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        String domSchemaName = ModelFun.getSchemaName(fk);
        String refSchemaName = fk.getRefSchemaName();
        boolean bl = toQualify = refSchemaName != null && (Intrinsics.areEqual((Object)refSchemaName, (Object)domSchemaName) ^ true || Intrinsics.areEqual((Object)refSchemaName, (Object)this.getCurrentSchemaName()) ^ true);
        if (toQualify) {
            String string3;
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder();
            String string5 = refSchemaName;
            if (string5 != null) {
                String string6 = string5;
                AbstractScriptingService abstractScriptingService = this;
                stringBuilder = stringBuilder2;
                charSequence = this_$iv.getNaming().nameToScript((String)$receiver$iv);
                stringBuilder2 = stringBuilder;
                string4 = charSequence;
            } else {
                string4 = null;
            }
            StringBuilder stringBuilder3 = stringBuilder2.append(string4).append(".");
            String string7 = fk.getRefTableName();
            if (string7 != null) {
                $receiver$iv = string7;
                this_$iv = this;
                stringBuilder = stringBuilder3;
                charSequence = this_$iv.getNaming().nameToScript((String)$receiver$iv);
                stringBuilder3 = stringBuilder;
                string3 = charSequence;
            } else {
                string3 = null;
            }
            string2 = stringBuilder3.append(string3).toString();
        } else {
            String string8 = fk.getRefTableName();
            if (string8 != null) {
                $receiver$iv = string8;
                this_$iv = this;
                string2 = this_$iv.getNaming().nameToScript((String)$receiver$iv);
            } else {
                string2 = null;
            }
        }
        String refTableScr = string2;
        StringBuilder stringBuilder4 = new StringBuilder().append("references ").append(refTableScr);
        if (ModelFun.getRefToPrimaryKey(fk)) {
            string = "";
        } else {
            void this_$iv2;
            void $receiver$iv2;
            Iterable $i$f$getScr = fk.getRefColNames();
            $receiver$iv = this;
            charSequence = new StringBuilder().append(" (");
            stringBuilder = stringBuilder4;
            String string9 = CollectionsKt.joinToString$default((Iterable)$receiver$iv2, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
            stringBuilder4 = stringBuilder;
            string = ((StringBuilder)charSequence).append(string9).append(")").toString();
        }
        String reference = stringBuilder4.append(string).toString();
        return reference;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] getScriptStatements() {
        void var2_2;
        int size$iv = this.script.size();
        String[] result$iv = new String[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            void i2;
            String string;
            void i$iv;
            void var5_5 = i$iv;
            void var9_7 = i$iv++;
            String[] stringArray = result$iv;
            stringArray[var9_7] = string = ((Object)this.script.get((int)i2).getText()).toString();
        }
        return var2_2;
    }

    @Override
    @NotNull
    public String getScriptText() {
        StringBuilder b = new StringBuilder();
        for (CompositeText stmt : this.script) {
            b.append(stmt.getText());
            b.append(this.getStatementDelimiter(stmt));
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeText getScript() {
        void $receiver$iv;
        int initial$iv;
        Iterable iterable = this.script;
        int accumulator$iv = initial$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void t;
            CompositeText compositeText = (CompositeText)element$iv;
            int x = accumulator$iv;
            accumulator$iv = x + t.getText().length();
        }
        int capacity = accumulator$iv + 8 * this.script.size();
        CodeTextBuilder b = new CodeTextBuilder(capacity);
        for (CompositeText stmt : this.script) {
            for (CompositeText.Fragment f : stmt.getFragments()) {
                b.append(f);
            }
            boolean hasDelimiter = b.endsWithIgnoreSpace(this.getStatementDelimiterStr());
            if (!hasDelimiter) {
                if (this.getStatementDelimiterOwnsLine()) {
                    b.ensureEoln(CompositeText.Kind.SQL_DELIMITER);
                }
                CodeTextBuilder.append$default(b, this.getStatementDelimiterStr(), CompositeText.Kind.SQL_DELIMITER, false, 4, null);
            }
            b.ensureBlankLine(CompositeText.Kind.SQL_DELIMITER);
        }
        return b;
    }

    private final String getStatementDelimiter(CompositeText stmt) {
        CompositeText.Fragment fragment = (CompositeText.Fragment)CollectionsKt.lastOrNull(stmt.getFragments());
        return Intrinsics.areEqual((Object)((Object)(fragment != null ? fragment.getKind() : null)), (Object)((Object)CompositeText.Kind.SQL_DELIMITER)) ^ true ? "" + this.getStatementDelimiterStr() + "\n\n" : "\n\n";
    }

    @Override
    public final void clearScript() {
        this.script.clear();
    }

    @NotNull
    public final SizeAndScale getSizeAndScale1() {
        return this.SizeAndScale1;
    }

    @NotNull
    public String getStatementDelimiterStr() {
        return ";";
    }

    public boolean getStatementDelimiterOwnsLine() {
        return false;
    }

    @NotNull
    protected Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    @NotNull
    protected String script(@NotNull DataType d) {
        String string;
        boolean defaultSize;
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        String specification = null;
        if (!d.custom && !d.sizeUnitExplicit && d.size != -1 && (defaultSize = this.isDefaultSize(d))) {
            specification = d.typeName;
            if (d.suffix != null) {
                specification = specification + " " + d.suffix;
            }
        }
        if ((string = specification) == null) {
            String string2 = d.getSpecification();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"d.specification");
        }
        return string;
    }

    protected boolean isDefaultSize(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        SizeAndScale defaults = this.getDefaultPrimitiveSizes().get(d.typeName);
        return defaults != null && d.size == defaults.getSize() && d.scale == defaults.getScale();
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateOrReplace() {
        return this.supportsCreateOrReplace;
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        return this.supportsCreateIfNotExists;
    }

    protected boolean isNullExplicit(@Nullable BasicColumn column) {
        return false;
    }

    @NotNull
    public String toString() {
        return this.script.isEmpty() ? "ScriptingService for " + this.getRdbms() + ". Empty." : "ScriptingService for " + this.model.getRdbms() + "\nGenerated " + this.script.size() + " statements:\n" + this.getScriptText();
    }

    @Override
    public void makeRefactoringScript(@NotNull Iterable<? extends Pair<? extends BasicElement, ? extends BasicElement>> task, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        RefactoringGenerator generator = this.createRefactoringGenerator(MapsKt.toMap(task));
        Collection<BasicElement> preliminarySortedObjects = this.sortPreliminary((Iterable<BasicElement>)generator.getMigrated().keySet());
        Collection<BasicElement> topoSortedObjects = this.sortTopologically(preliminarySortedObjects);
        generator.setElementsToGenerate((Iterable<? extends BasicElement>)topoSortedObjects);
        generator.generate();
    }

    @NotNull
    protected RefactoringGenerator createRefactoringGenerator(@NotNull Map<BasicElement, ? extends BasicElement> migrated) {
        Intrinsics.checkParameterIsNotNull(migrated, (String)"migrated");
        return new RefactoringGenerator(migrated);
    }

    protected AbstractScriptingService(@NotNull M model, @NotNull D database) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        this.options = DefaultScriptingOptions.INSTANCE;
        this.script = new ArrayList();
        this.generated = new HashSet();
        this.SizeAndScale1 = new SizeAndScale(1, 0, 2, null);
        this.defaultPrimitiveSizes = MapsKt.emptyMap();
        this.supportsCreateOrReplace = SetsKt.emptySet();
        this.supportsCreateIfNotExists = SetsKt.emptySet();
        this.model = model;
        this.setDatabase(database);
        BasicSchema cs = ModelFun.getCurrentSchema(database);
        this.setCurrentSchema(cs != null ? cs : null);
    }

    @NotNull
    public static final /* synthetic */ NamingService access$getNaming$p(AbstractScriptingService $this) {
        NamingService namingService = $this.naming;
        if (namingService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"naming");
        }
        return namingService;
    }

    public static final /* synthetic */ void access$setNaming$p(AbstractScriptingService $this, @NotNull NamingService namingService) {
        $this.naming = namingService;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$SizeAndScale;", "", "size", "", "scale", "(II)V", "getScale", "()I", "getSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "database-scripting"})
    public static final class SizeAndScale {
        private final int size;
        private final int scale;

        @NotNull
        public String toString() {
            return this.scale == 0 ? "" + this.size : "" + this.size + ',' + this.scale;
        }

        public final int getSize() {
            return this.size;
        }

        public final int getScale() {
            return this.scale;
        }

        public SizeAndScale(int size, int scale) {
            this.size = size;
            this.scale = scale;
        }

        public /* synthetic */ SizeAndScale(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = -1;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public SizeAndScale() {
            this(0, 0, 3, null);
        }

        public final int component1() {
            return this.size;
        }

        public final int component2() {
            return this.scale;
        }

        @NotNull
        public final SizeAndScale copy(int size, int scale) {
            return new SizeAndScale(size, scale);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SizeAndScale copy$default(SizeAndScale sizeAndScale, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = sizeAndScale.size;
            }
            if ((n3 & 2) != 0) {
                n2 = sizeAndScale.scale;
            }
            return sizeAndScale.copy(n, n2);
        }

        public int hashCode() {
            return Integer.hashCode(this.size) * 31 + Integer.hashCode(this.scale);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SizeAndScale)) break block3;
                    SizeAndScale sizeAndScale = (SizeAndScale)object;
                    if (!(this.size == sizeAndScale.size) || !(this.scale == sizeAndScale.scale)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b\u00a4\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u001cJ\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0012H$J\b\u0010(\u001a\u00020\u001cH\u0014J\b\u0010)\u001a\u00020\u001cH\u0014J\u0010\u0010*\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$J\b\u0010+\u001a\u00020\u001cH\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0004J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0012H\u0004J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0012H\u0004J$\u00100\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00122\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e02H\u0014J)\u00100\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00122\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020$04\"\u00020$H\u0014\u00a2\u0006\u0002\u00105J\u0014\u00106\u001a\u00020\u001c2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001208R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00069"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "builder", "Lcom/intellij/database/scripting/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/scripting/CodeTextBuilder;", "<set-?>", "Lcom/intellij/database/scripting/ScriptContext;", "context", "getContext", "()Lcom/intellij/database/scripting/ScriptContext;", "setContext", "(Lcom/intellij/database/scripting/ScriptContext;)V", "deck", "Ljava/util/Deque;", "Lcom/intellij/database/model/basic/BasicElement;", "getDeck", "()Ljava/util/Deque;", "postponed", "Lcom/intellij/util/containers/MultiMap;", "getPostponed", "()Lcom/intellij/util/containers/MultiMap;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "coding", "", "indent", "", "block", "Lkotlin/Function0;", "createOrReplace", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "generate", "generateElement", "element", "generateFooting", "generateHeading", "ifNotExists", "postStatement", "statement", "Lcom/intellij/database/scripting/CompositeText;", "process", "processElement", "processInnerElements", "condition", "Lkotlin/Function1;", "kinds", "", "(Lcom/intellij/database/model/basic/BasicElement;[Lcom/intellij/database/model/ObjectKind;)V", "setElementsToGenerate", "elements", "", "database-scripting"})
    protected abstract class CodeGenerator {
        @NotNull
        private final Deque<BasicElement> deck;
        @NotNull
        private final MultiMap<BasicElement, BasicElement> postponed;
        @NotNull
        private final CodeTextBuilder builder;
        @NotNull
        private ScriptContext context;
        @NotNull
        private final ScriptingTask task;

        @NotNull
        protected final Deque<BasicElement> getDeck() {
            return this.deck;
        }

        @NotNull
        protected final MultiMap<BasicElement, BasicElement> getPostponed() {
            return this.postponed;
        }

        @NotNull
        protected final CodeTextBuilder getBuilder() {
            return this.builder;
        }

        @NotNull
        protected final ScriptContext getContext() {
            return this.context;
        }

        private final void setContext(ScriptContext scriptContext) {
            this.context = scriptContext;
        }

        public final void setElementsToGenerate(@NotNull Iterable<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            for (BasicElement basicElement : elements) {
                this.deck.offer(basicElement);
            }
        }

        public final void generate() {
            this.generateHeading();
            while (this.deck.poll() != null) {
                BasicElement element;
                if (element.isAutoCreated()) continue;
                this.process(element);
            }
            this.generateFooting();
        }

        protected void generateHeading() {
        }

        protected void generateFooting() {
        }

        protected final void process(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (!AbstractScriptingService.this.getGenerated().contains(element)) {
                Iterable<? extends BasicElement> predecessors = element.getPredecessors();
                boolean postpone = false;
                for (BasicElement basicElement : predecessors) {
                    if (AbstractScriptingService.this.getGenerated().contains(basicElement) || !this.deck.contains(basicElement)) continue;
                    this.postponed.putValue((Object)basicElement, (Object)element);
                    postpone = true;
                }
                if (postpone) {
                    return;
                }
                this.processElement(element);
                if (!AbstractScriptingService.this.getGenerated().contains(element)) {
                    return;
                }
            }
            if (Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)ScriptContext.IN_SCHEMA)) || Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)ScriptContext.OUTSIDE))) {
                Collection collection = this.postponed.get((Object)element);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"postponed[element]");
                Iterable pendingElements = collection;
                for (BasicElement pendingElement : pendingElements) {
                    this.process(pendingElement);
                }
            }
        }

        protected final void processElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            try {
                this.generateElement(element);
                AbstractScriptingService.this.getGenerated().add(element);
            }
            catch (AbortException abortException) {
                // empty catch block
            }
        }

        protected abstract void generateElement(@NotNull BasicElement var1);

        protected void processInnerElements(@NotNull BasicElement element, ObjectKind ... kinds) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)kinds, (String)"kinds");
            ArrayList innerElements = new ArrayList();
            for (int j = 0; j < kinds.length; ++j) {
                ObjectKind kind = kinds[j];
                Family<? extends BasicElement> f = element.familyOf(kind);
                if (f == null) continue;
                CollectionsKt.addAll((Collection)innerElements, (Iterable)f);
            }
            int n = innerElements.size();
            if (n == 0) {
                return;
            }
            if (n >= 2 && Intrinsics.areEqual((Object)((Object)this.task.getOrder()), (Object)((Object)ScriptingOrder.REVERS_ORDER))) {
                Collections.reverse(innerElements);
            }
            Iterator iterator = innerElements.iterator();
            while (iterator.hasNext()) {
                BasicElement innerElement;
                BasicElement basicElement = innerElement = (BasicElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"innerElement");
                this.process(basicElement);
            }
        }

        protected void processInnerElements(@NotNull BasicElement element, @NotNull Function1<? super BasicElement, Boolean> condition) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
            Function1<? super BasicElement, Boolean> function1 = condition;
            List innerElements = ModelFun.iterateChildren(element).filter((Condition)new AbstractScriptingServiceKt$sam$Condition$2c46b29e(function1)).toList();
            int n = innerElements.size();
            if (n == 0) {
                return;
            }
            if (n >= 2 && Intrinsics.areEqual((Object)((Object)this.task.getOrder()), (Object)((Object)ScriptingOrder.REVERS_ORDER))) {
                innerElements = CollectionsKt.toList((Iterable)CollectionsKt.reversed((Iterable)innerElements));
            }
            Iterator iterator = innerElements.iterator();
            while (iterator.hasNext()) {
                BasicElement innerElement;
                BasicElement basicElement = innerElement = (BasicElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"innerElement");
                this.process(basicElement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void coding(@Nullable ScriptContext context, boolean indent, @NotNull Function0<Unit> block) {
            boolean complete;
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            ScriptContext oldContext = this.context;
            ScriptContext scriptContext = context;
            if (scriptContext == null) {
                scriptContext = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) ? ScriptContext.IN_STATEMENT : oldContext;
            }
            ScriptContext newContext = scriptContext;
            CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
            try {
                this.context = newContext;
                if (indent) {
                    CodeTextBuilder.indent$default(this.builder, null, 1, null);
                }
                block.invoke();
                this.builder.returnToIndentation(savedIndentation);
                this.context = oldContext;
            }
            catch (Throwable throwable) {
                boolean complete2;
                this.builder.returnToIndentation(savedIndentation);
                this.context = oldContext;
                boolean bl = complete2 = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptContext.OUTSIDE)) ^ true && this.builder.isNotEmpty();
                if (complete2) {
                    this.postStatement();
                }
                throw throwable;
            }
            boolean bl = complete = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptContext.OUTSIDE)) ^ true && this.builder.isNotEmpty();
            if (complete) {
                this.postStatement();
            }
        }

        public static /* bridge */ /* synthetic */ void coding$default(CodeGenerator codeGenerator, ScriptContext scriptContext, boolean bl, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
            }
            if ((n & 1) != 0) {
                scriptContext = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            codeGenerator.coding(scriptContext, bl, (Function0<Unit>)function0);
        }

        private final void postStatement() {
            if (this.builder.isNotEmpty()) {
                this.postStatement(new SimpleCompositeText(this.builder));
            }
            this.builder.clearAll();
        }

        protected final void postStatement(@NotNull CompositeText statement) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            AbstractScriptingService.this.getScript().add(statement);
        }

        @NotNull
        public final String createOrReplace(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false && AbstractScriptingService.this.getSupportsCreateOrReplace().contains(kind) ? "create or replace" : "create";
        }

        @Nullable
        public final String ifNotExists(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CREATE_IF_NOT_EXISTS) != false && AbstractScriptingService.this.getSupportsCreateIfNotExists().contains(kind) ? "if not exists" : null;
        }

        @NotNull
        protected final ScriptingTask getTask() {
            return this.task;
        }

        public CodeGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            this.task = task;
            this.deck = new ArrayDeque();
            this.postponed = new MultiMap();
            this.builder = new CodeTextBuilder(0, 1, null);
            this.context = ScriptContext.OUTSIDE;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0094\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\"H\u0014J\u001e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\"H\u0014J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200H\u0014J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u00102\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0014J\u0016\u00103\u001a\u00020\u000f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001505H\u0002J\u0010\u00106\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u00107\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:H\u0014J\u0010\u0010;\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010<\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010>\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020@H\u0014J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0014J\u001a\u0010B\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020\u0007H\u0014J\u0010\u0010E\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020CH\u0014J\u0010\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020HH\u0014J\u0010\u0010I\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010J\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020KH\u0014J\u0010\u0010L\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010M\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:H\u0014J\u0010\u0010N\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020CH\u0014J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00150P2\u0006\u0010&\u001a\u00020'H\u0014J\u0014\u0010Q\u001a\u0004\u0018\u00010\u001d2\b\u0010R\u001a\u0004\u0018\u00010SH\u0014J\u0012\u0010T\u001a\u0004\u0018\u00010\u001d2\u0006\u0010&\u001a\u00020'H\u0014J\u0012\u0010U\u001a\u0004\u0018\u00010\u001d2\u0006\u0010&\u001a\u00020'H\u0014J\u0012\u0010V\u001a\u0004\u0018\u00010\u001d2\u0006\u0010&\u001a\u00020'H\u0014J\u0012\u0010W\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010X\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010Y\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020@H\u0014J\u0012\u0010Z\u001a\u0004\u0018\u00010\u001d2\u0006\u0010&\u001a\u00020'H\u0014J\u0012\u0010[\u001a\u0004\u0018\u00010\u001d2\u0006\u0010G\u001a\u00020HH\u0014J\u0010\u0010\\\u001a\u00020]2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010^\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010_\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001dH\u0014J\u0010\u0010`\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006a"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "isExact", "", "()Z", "tableElementsApplicableInExactTask", "", "Lcom/intellij/database/model/ObjectKind;", "getTableElementsApplicableInExactTask", "()Ljava/util/Set;", "addInnerConstraintNameAndIndent", "", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "addOuterConstraintNameAndIndent", "canCreateInColumn", "element", "Lcom/intellij/database/model/basic/BasicElement;", "canCreateInTable", "canCreateIndexInCurrentContext", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "canGenerateElementRightNow", "canGenerateInnerElement", "elementKindNameForCreate", "", "gatherSequenceIdentityParameters", "identity", "Lcom/intellij/database/model/SequenceIdentity;", "parameters", "", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "generateAdditionalTableItems", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateCascadeRules", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateCheck", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "generateColumn", "generateColumnComment", "generateColumnInnerElements", "singleColumnElementsToGenerate", "", "generateComment", "generateDeferrability", "generateDisableTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateElement", "generateForeignKey", "generateIndex", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "generateSequence", "generateSourceAwareElement", "Lcom/intellij/database/model/basic/BasicSourceAware;", "processChildren", "generateSourceAwareUsingSources", "generateSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateTable", "generateTableComment", "Lcom/intellij/database/model/basic/BasicLikeTable;", "generateTableOutsideStuff", "generateTrigger", "generateUnspecificSourceAwareElement", "getSingleColumnElements", "", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeColumnDefinition", "makeColumnSpecification", "makeComputedColumnSpecification", "makeDeferrability", "makeIndexWord", "makeKeyWord", "makeNormalColumnSpecification", "makeSynonymTargetSpec", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "processElementChildren", "scriptIndexColumn", "weDontKnowHowToGenerateThis", "database-scripting"})
    protected class CreatingGenerator
    extends CodeGenerator {
        private final boolean isExact;
        @NotNull
        private final Set<ObjectKind> tableElementsApplicableInExactTask;

        public final boolean isExact() {
            return this.isExact;
        }

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof BasicSequence) {
                this.generateSequence((BasicSequence)element);
            } else if (basicElement instanceof BasicTable) {
                this.generateTable((BasicTable)element);
            } else if (basicElement instanceof BasicColumn) {
                this.generateColumn((BasicColumn)element);
            } else if (basicElement instanceof BasicIndex) {
                this.generateIndex((BasicIndex)element);
            } else if (basicElement instanceof BasicKey) {
                this.generateKey((BasicKey)element);
            } else if (basicElement instanceof BasicForeignKey) {
                this.generateForeignKey((BasicForeignKey)element);
            } else if (basicElement instanceof BasicCheck) {
                this.generateCheck((BasicCheck)element);
            } else if (basicElement instanceof BasicTrigger) {
                this.generateTrigger((BasicTrigger)element);
            } else if (basicElement instanceof BasicSourceAware) {
                this.generateSourceAwareElement((BasicSourceAware)element, true);
            } else if (basicElement instanceof BasicSynonym) {
                this.generateSynonym((BasicSynonym)element);
            } else {
                this.weDontKnowHowToGenerateThis(element);
            }
        }

        protected void generateSequence(@NotNull BasicSequence sequence) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            if (sequence instanceof BasicNamedElement && ((BasicNamedElement)((Object)sequence)).isNameSurrogate()) {
                return;
            }
            String name = AbstractScriptingService.this.currentScopeName(sequence);
            ArrayList parameters = new ArrayList();
            this.gatherSequenceIdentityParameters(sequence, (List<String>)parameters);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, sequence, name, parameters){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicSequence $sequence;
                final /* synthetic */ String $name;
                final /* synthetic */ ArrayList $parameters;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    ObjectKind objectKind = ObjectKind.SEQUENCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"SEQUENCE");
                    charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                    String string = this.this$0.elementKindNameForCreate(this.$sequence);
                    charSequenceArray[1] = string != null ? (CharSequence)string : (CharSequence)"sequence";
                    ObjectKind objectKind2 = ObjectKind.SEQUENCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"SEQUENCE");
                    charSequenceArray[2] = this.this$0.ifNotExists(objectKind2);
                    charSequenceArray[3] = this.$name;
                    codeTextBuilder.phrase(charSequenceArray);
                    Collection collection = this.$parameters;
                    if (!collection.isEmpty()) {
                        CodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ generateSequence.1 this$0;

                            public final void invoke() {
                                for (String p : this.this$0.$parameters) {
                                    CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), p, null, false, 6, null);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, 1, null);
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$sequence = basicSequence;
                    this.$name = string;
                    this.$parameters = arrayList;
                    super(0);
                }
            }, 3, null);
        }

        protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
            SequenceIdentity i2;
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            SequenceIdentity sequenceIdentity = sequence.getSequenceIdentity();
            if (sequenceIdentity == null) {
                return;
            }
            SequenceIdentity sequenceIdentity2 = i2 = sequenceIdentity;
            Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity2, (String)"i");
            this.gatherSequenceIdentityParameters(sequenceIdentity2, parameters);
        }

        protected void gatherSequenceIdentityParameters(@NotNull SequenceIdentity identity, @NotNull List<String> parameters) {
            Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            int sign = identity.increment.signum();
            switch (sign) {
                case 1: {
                    if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)BigInteger.ONE) ^ true && AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                        parameters.add("start with " + identity.next);
                    }
                    if (identity.min != null && Intrinsics.areEqual((Object)identity.min, (Object)BigInteger.ONE) ^ true) {
                        parameters.add("minvalue " + identity.min);
                    }
                    if (Intrinsics.areEqual((Object)identity.increment, (Object)BigInteger.ONE) ^ true) {
                        parameters.add("increment by " + identity.increment);
                    }
                    if (identity.max == null) break;
                    parameters.add("maxvalue " + identity.max);
                    break;
                }
                case -1: {
                    if (identity.next != null && AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                        parameters.add("start with " + identity.next);
                    }
                    if (identity.max != null) {
                        parameters.add("maxvalue " + identity.max);
                    }
                    parameters.add("increment by " + identity.increment);
                    if (identity.min == null) break;
                    parameters.add("minvalue " + identity.min);
                    break;
                }
                default: {
                    if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)BigInteger.ONE) ^ true && AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                        parameters.add("start with " + identity.next);
                    }
                    if (identity.min != null) {
                        parameters.add("minvalue " + identity.min);
                    }
                    if (identity.max == null) break;
                    parameters.add("maxvalue " + identity.max);
                }
            }
        }

        protected void generateTable(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicTable $table;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void header;
                    HeaderFooter headerFooter = this.this$0.makeTableHeaderFooter(this.$table);
                    String string = headerFooter.component1();
                    String footer = headerFooter.component2();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), (CharSequence)header, null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    this.this$0.coding(ScriptContext.IN_TABLE, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateTable.1 this$0;

                        public final void invoke() {
                            for (BasicElement element : this.this$0.$table.getDbChildren()) {
                                if (this.this$0.this$0.AbstractScriptingService.this.getGenerated().contains(element)) continue;
                                CreatingGenerator creatingGenerator = this.this$0.this$0;
                                BasicElement basicElement = element;
                                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
                                if (!creatingGenerator.canCreateInTable(basicElement)) continue;
                                this.this$0.this$0.process(element);
                            }
                            this.this$0.this$0.generateAdditionalTableItems(this.this$0.$table);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), footer, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$table = basicTable;
                    super(0);
                }
            }, 3, null);
            if (Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.OUTSIDE)) || Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.IN_STATEMENT))) {
                this.generateTableOutsideStuff(table);
            }
        }

        protected void generateAdditionalTableItems(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        }

        protected void generateTableOutsideStuff(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            for (BasicElement element : table.getDbChildren()) {
                if (element instanceof BasicColumn || AbstractScriptingService.this.getGenerated().contains(element) || !this.tableElementsApplicableInExactTask.contains(element.getKind()) && this.isExact || element instanceof BasicConstraint && Intrinsics.areEqual((Object)((Object)AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_AFTER_TABLE))) continue;
                BasicElement basicElement = element;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
                this.process(basicElement);
            }
            if (table.getComment() != null) {
                this.generateComment(table);
            }
            for (BasicColumn column : table.getColumns()) {
                if (column.getComment() == null) continue;
                BasicColumn basicColumn = column;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicColumn, (String)"column");
                this.generateComment(basicColumn);
            }
        }

        @NotNull
        protected final Set<ObjectKind> getTableElementsApplicableInExactTask() {
            return this.tableElementsApplicableInExactTask;
        }

        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            String name = AbstractScriptingService.this.currentScopeName(table);
            String temporary = table.isTemporary() ? "temporary" : null;
            String[] stringArray = new String[5];
            ObjectKind objectKind = table.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"table.kind");
            stringArray[0] = this.createOrReplace(objectKind);
            stringArray[1] = temporary;
            String string = this.elementKindNameForCreate(table);
            if (string == null) {
                string = "table";
            }
            stringArray[2] = string;
            ObjectKind objectKind2 = table.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"table.kind");
            stringArray[3] = this.ifNotExists(objectKind2);
            stringArray[4] = name;
            String h = ScriptingUtilsKt.phrase(stringArray);
            return new HeaderFooter(h, null);
        }

        @Nullable
        protected String elementKindNameForCreate(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            ObjectKind objectKind = element.getKind();
            return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE) ? "table" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE) ? "sequence" : null);
        }

        protected boolean canCreateInColumn(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicConstraint && Intrinsics.areEqual((Object)((Object)AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN));
        }

        protected boolean canCreateInTable(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicColumn || element instanceof BasicConstraint && AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT).compareTo((Enum)ScriptingConstraintContext.CONSTRAINT_IN_TABLE) <= 0;
        }

        protected void generateColumn(@NotNull BasicColumn column) {
            List singleColumnElementsToGenerate;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            if (Intrinsics.areEqual((Object)((Object)AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN)) && Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.IN_TABLE))) {
                singleColumnElementsToGenerate = new LinkedList();
                for (BasicElement e : this.getSingleColumnElements(column)) {
                    ((LinkedList)singleColumnElementsToGenerate).add(e);
                }
                ListIterator listIterator = ((LinkedList)singleColumnElementsToGenerate).listIterator();
                Intrinsics.checkExpressionValueIsNotNull(listIterator, (String)"singleColumnElementsToGenerate.listIterator()");
                ListIterator it = listIterator;
                while (it.hasNext()) {
                    BasicElement e = (BasicElement)it.next();
                    if (!AbstractScriptingService.this.getGenerated().contains(e) && this.canGenerateElementRightNow(e)) continue;
                    it.remove();
                }
            } else {
                singleColumnElementsToGenerate = CollectionsKt.emptyList();
            }
            String string = this.makeColumnDefinition(column);
            if (string == null) {
                return;
            }
            String line = string;
            switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$0[this.getContext().ordinal()]) {
                case 1: {
                    CodeTextBuilder.append$default(this.getBuilder(), line, null, false, 6, null);
                    this.generateColumnInnerElements(singleColumnElementsToGenerate);
                    this.getBuilder().addSuffixToTheLastLine(',');
                    break;
                }
                case 2: {
                    BasicLikeTable basicLikeTable = column.getTable();
                    if (basicLikeTable == null) {
                        return;
                    }
                    BasicLikeTable table = basicLikeTable;
                    String tableName = AbstractScriptingService.this.currentScopeName(table);
                    CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, line){
                        final /* synthetic */ CreatingGenerator this$0;
                        final /* synthetic */ String $tableName;
                        final /* synthetic */ String $line;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke() {
                            this.this$0.getBuilder().phrase("alter table", this.$tableName);
                            CodeTextBuilder this_$iv = this.this$0.getBuilder();
                            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                            try {
                                this.this$0.getBuilder().phrase("add", this.$line);
                            }
                            finally {
                                this_$iv.unindent();
                            }
                        }
                        {
                            this.this$0 = creatingGenerator;
                            this.$tableName = string;
                            this.$line = string2;
                            super(0);
                        }
                    }, 3, null);
                    if (column.getComment() == null) break;
                    this.generateColumnComment(column);
                    break;
                }
                default: {
                    this.getBuilder().phrase("Here should be column", line);
                }
            }
        }

        private final void generateColumnInnerElements(Collection<? extends BasicElement> singleColumnElementsToGenerate) {
            Collection<? extends BasicElement> collection = singleColumnElementsToGenerate;
            if (!collection.isEmpty()) {
                this.coding(ScriptContext.IN_COLUMN, true, (Function0<Unit>)((Function0)new Function0<Unit>(this, singleColumnElementsToGenerate){
                    final /* synthetic */ CreatingGenerator this$0;
                    final /* synthetic */ Collection $singleColumnElementsToGenerate;

                    public final void invoke() {
                        for (BasicElement e : this.$singleColumnElementsToGenerate) {
                            this.this$0.process(e);
                        }
                    }
                    {
                        this.this$0 = creatingGenerator;
                        this.$singleColumnElementsToGenerate = collection;
                        super(0);
                    }
                }));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        protected String makeColumnDefinition(@NotNull BasicColumn column) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String string = column.getName();
            AbstractScriptingService this_$iv = AbstractScriptingService.this;
            String name = this_$iv.getNaming().nameToScript((String)$receiver$iv);
            String specification = this.makeColumnSpecification(column);
            return ScriptingUtilsKt.concatWithSpace(name, specification);
        }

        @Nullable
        protected String makeColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return column.isComputed() && column.getDefaultExpression() != null ? this.makeComputedColumnSpecification(column) : this.makeNormalColumnSpecification(column);
        }

        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            boolean autoInc = column instanceof BasicTableColumn && ((BasicTableColumn)column).isAutoInc();
            String specification = this.generalColumnSpecification(column);
            if (column.getDefaultExpression() != null) {
                specification = specification + " default " + column.getDefaultExpression();
            }
            if (column.isNotNull() && !autoInc) {
                specification = specification + " not null";
            }
            if (!column.isNotNull() && AbstractScriptingService.this.isNullExplicit(column) && !autoInc) {
                specification = specification + " null";
            }
            return specification;
        }

        @NotNull
        protected String generalColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            DataType dataType = column.getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
            return AbstractScriptingService.this.script(dataType);
        }

        @Nullable
        protected String makeComputedColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return "as " + column.getDefault();
        }

        @NotNull
        protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getTable();
            if (basicLikeTable == null) {
                return SetsKt.emptySet();
            }
            BasicLikeTable table = basicLikeTable;
            JBIterable jBIterable = table.getDbChildren(BasicConstraint.class, null).filter((Condition)new Condition<BasicConstraint>(this, column){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicColumn $column;

                public final boolean value(BasicConstraint it) {
                    BasicConstraint basicConstraint = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicConstraint, (String)"it");
                    return this.this$0.canCreateInColumn(basicConstraint) && it.getColNames().size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(it.getColNames())), (Object)this.$column.getName());
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$column = basicColumn;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.getDbChildren(Basi\u2026s.first() == column.name}");
            return (Iterable)jBIterable;
        }

        protected void generateIndex(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            if (!this.canCreateIndexInCurrentContext(index)) {
                throw (Throwable)new AbortException();
            }
            String w = this.makeIndexWord(index);
            String condition = index.getCondition();
            StringBuilder b = new StringBuilder();
            for (String col : index.getColNames()) {
                CharSequence charSequence = b;
                if (charSequence.length() > 0) {
                    b.append(", ");
                }
                String string = col;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"col");
                b.append(this.scriptIndexColumn(index, string));
            }
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, index, b, condition){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $w;
                final /* synthetic */ BasicIndex $index;
                final /* synthetic */ StringBuilder $b;
                final /* synthetic */ String $condition;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$1[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                            break;
                        }
                        case 2: {
                            String s = this.this$0.AbstractScriptingService.this.getUseName(this.$index) ? "" + this.$w + ' ' + this.$index.getName() + " (" + this.$b + ')' : "" + this.$w + " (" + this.$b + ')';
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), s, null, false, 6, null);
                            break;
                        }
                        default: {
                            BasicLikeTable basicLikeTable = this.$index.getTable();
                            String tableName = basicLikeTable != null ? this.this$0.AbstractScriptingService.this.currentScopeName(basicLikeTable) : null;
                            String indexName = this.this$0.AbstractScriptingService.this.currentScopeName(this.$index);
                            CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                            CharSequence[] charSequenceArray = new CharSequence[4];
                            ObjectKind objectKind = ObjectKind.INDEX;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"INDEX");
                            charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                            charSequenceArray[1] = this.$w;
                            ObjectKind objectKind2 = ObjectKind.INDEX;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"INDEX");
                            charSequenceArray[2] = this.this$0.ifNotExists(objectKind2);
                            charSequenceArray[3] = indexName;
                            codeTextBuilder.phrase(charSequenceArray);
                            CodeTextBuilder this_$iv = this.this$0.getBuilder();
                            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                            try {
                                this.this$0.getBuilder().phrase("on " + tableName + " (" + this.$b + ')');
                                this.this$0.getBuilder().phrase(ScriptingUtilsKt.concatIfNotNull("where ", this.$condition));
                                break;
                            }
                            finally {
                                this_$iv.unindent();
                            }
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$w = string;
                    this.$index = basicIndex;
                    this.$b = stringBuilder;
                    this.$condition = string2;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected String scriptIndexColumn(@NotNull BasicIndex index, @NotNull String column) {
            String s;
            String string;
            boolean dirs;
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            CharSequence charSequence = column;
            if (charSequence.length() == 0) {
                return "???";
            }
            Set<String> descendants = index.getReverseColNames();
            Collection collection = descendants;
            boolean bl = dirs = !collection.isEmpty();
            if (column.charAt(0) == '\u001b') {
                String string2 = column;
                int n = 1;
                int n2 = column.length();
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                void $receiver$iv;
                String string4 = column;
                AbstractScriptingService this_$iv = AbstractScriptingService.this;
                string = s = this_$iv.getNaming().nameToScript((String)$receiver$iv);
            }
            if (dirs) {
                s = s + (descendants.contains(column) ? " desc" : " asc");
            }
            return s;
        }

        @NotNull
        protected String makeIndexWord(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return index.isUnique() ? "unique index" : "index";
        }

        @NotNull
        protected String makeKeyWord(@NotNull BasicKey key2) {
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            return key2.isPrimary() ? "primary key" : "unique";
        }

        protected boolean canCreateIndexInCurrentContext(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.IN_STATEMENT)) || Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.OUTSIDE));
        }

        protected void generateKey(@NotNull BasicKey key2) {
            boolean indexIsExplicit;
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            String w = this.makeKeyWord(key2);
            BasicIndex index = null;
            if (key2.getUnderlyingIndexName() != null) {
                BasicIndex basicIndex;
                BasicNode basicNode = key2.getTable();
                if (basicNode != null && (basicNode = basicNode.getIndices()) != null) {
                    Object v1;
                    block8: {
                        Iterable $receiver$iv = (Iterable)((Object)basicNode);
                        for (Object element$iv : $receiver$iv) {
                            BasicIndex it = (BasicIndex)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)key2.getUnderlyingIndexName())) continue;
                            v1 = element$iv;
                            break block8;
                        }
                        v1 = null;
                    }
                    basicIndex = v1;
                } else {
                    basicIndex = null;
                }
                index = basicIndex;
            }
            boolean bl = indexIsExplicit = index != null && AbstractScriptingService.this.getUseName(index) && Intrinsics.areEqual((Object)index.getName(), (Object)key2.getName()) ^ true;
            if (indexIsExplicit) {
                Set<BasicElement> set = AbstractScriptingService.this.getGenerated();
                BasicIndex basicIndex = index;
                if (basicIndex == null) {
                    Intrinsics.throwNpe();
                }
                if (!set.contains(basicIndex)) {
                    this.getPostponed().putValue((Object)index, (Object)key2);
                    throw (Throwable)new AbortException();
                }
            }
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key2, w){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicKey $key;
                final /* synthetic */ String $w;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$2[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$key);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                            this.this$0.generateDeferrability(this.$key);
                            break;
                        }
                        case 2: {
                            void this_$iv2;
                            void $receiver$iv2;
                            this.this$0.addInnerConstraintNameAndIndent(this.$key);
                            Iterable iterable = this.$key.getColNames();
                            AbstractScriptingService abstractScriptingService = this.this$0.AbstractScriptingService.this;
                            StringBuilder stringBuilder = new StringBuilder().append(this.$w).append(" (");
                            CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                            String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv2, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(")").toString(), null, false, 6, null);
                            this.this$0.generateDeferrability(this.$key);
                            this.this$0.getBuilder().addSuffixToTheLastLine(',');
                            break;
                        }
                        default: {
                            void this_$iv;
                            void $receiver$iv;
                            String string;
                            String string2;
                            CodeTextBuilder codeTextBuilder;
                            StringBuilder stringBuilder;
                            Object $receiver$iv2;
                            CodeTextBuilder codeTextBuilder2 = this.this$0.getBuilder();
                            StringBuilder stringBuilder2 = new StringBuilder().append("alter table ");
                            String string3 = this.$key.getTableName();
                            if (string3 != null) {
                                $receiver$iv2 = string3;
                                AbstractScriptingService this_$iv2 = this.this$0.AbstractScriptingService.this;
                                stringBuilder = stringBuilder2;
                                codeTextBuilder = codeTextBuilder2;
                                string2 = this_$iv2.getNaming().nameToScript((String)$receiver$iv2);
                                codeTextBuilder2 = codeTextBuilder;
                                stringBuilder2 = stringBuilder;
                                string = string2;
                            } else {
                                string = null;
                            }
                            CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(string).toString(), null, false, 6, null);
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            this.this$0.addOuterConstraintNameAndIndent(this.$key);
                            String w1 = !this.this$0.AbstractScriptingService.this.getUseName(this.$key) ? "add " : "";
                            Iterable $i$f$getScr = this.$key.getColNames();
                            $receiver$iv2 = this.this$0.AbstractScriptingService.this;
                            stringBuilder = new StringBuilder().append(w1).append(this.$w).append(" (");
                            codeTextBuilder = this.this$0.getBuilder();
                            string2 = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string2).append(")").toString(), null, false, 6, null);
                            this.this$0.generateDeferrability(this.$key);
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$key = basicKey;
                    this.$w = string;
                    super(0);
                }
            }, 3, null);
            if (index != null) {
                AbstractScriptingService.this.getGenerated().add(index);
            }
        }

        protected void generateForeignKey(@NotNull BasicForeignKey fk) {
            Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
            String reference = AbstractScriptingService.this.makeForeignKeyReference(fk);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, fk, reference){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicForeignKey $fk;
                final /* synthetic */ String $reference;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$3[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$fk);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$reference, null, false, 6, null);
                            this.this$0.generateCascadeRules(this.$fk);
                            this.this$0.generateDeferrability(this.$fk);
                            break;
                        }
                        case 2: {
                            void this_$iv;
                            void $receiver$iv;
                            this.this$0.addInnerConstraintNameAndIndent(this.$fk);
                            Iterable iterable = this.$fk.getColNames();
                            AbstractScriptingService abstractScriptingService = this.this$0.AbstractScriptingService.this;
                            StringBuilder stringBuilder = new StringBuilder().append("foreign key (");
                            CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                            String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(") ").append(this.$reference).toString(), null, false, 6, null);
                            this.this$0.generateCascadeRules(this.$fk);
                            this.this$0.generateDeferrability(this.$fk);
                            this.this$0.getBuilder().addSuffixToTheLastLine(',');
                            break;
                        }
                        default: {
                            void this_$iv;
                            void $receiver$iv;
                            AbstractScriptingService $receiver$iv2;
                            PostgresTable table;
                            Object object;
                            BasicLikeTable basicLikeTable = this.$fk.getTable();
                            if (!(basicLikeTable instanceof PostgresTable)) {
                                basicLikeTable = null;
                            }
                            if ((object = (table = (PostgresTable)basicLikeTable)) == null || (object = this.this$0.AbstractScriptingService.this.currentScopeName((BasicElement)object)) == null) {
                                String string = this.$fk.getTableName();
                                if (string != null) {
                                    String string2 = string;
                                    AbstractScriptingService this_$iv2 = this.this$0.AbstractScriptingService.this;
                                    object = this_$iv2.getNaming().nameToScript((String)((Object)$receiver$iv2));
                                } else {
                                    object = null;
                                }
                            }
                            Object tableName = object;
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter table " + (String)tableName, null, false, 6, null);
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            this.this$0.addOuterConstraintNameAndIndent(this.$fk);
                            String w1 = !this.this$0.AbstractScriptingService.this.getUseName(this.$fk) ? "add " : "";
                            Iterable $i$f$getScr = this.$fk.getColNames();
                            $receiver$iv2 = this.this$0.AbstractScriptingService.this;
                            StringBuilder stringBuilder = new StringBuilder().append(w1).append("foreign key (");
                            CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                            String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(") ").append(this.$reference).toString(), null, false, 6, null);
                            this.this$0.generateCascadeRules(this.$fk);
                            this.this$0.generateDeferrability(this.$fk);
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$fk = basicForeignKey;
                    this.$reference = string;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void generateCascadeRules(@NotNull BasicForeignKey fk) {
            Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
            String c1 = ScriptingUtilsKt.concatIfNotNull("on update ", this.makeCascadeRuleKeyword(fk.getOnUpdate()));
            String c2 = ScriptingUtilsKt.concatIfNotNull("on delete ", this.makeCascadeRuleKeyword(fk.getOnDelete()));
            String c = ScriptingUtilsKt.phrase(c1, c2);
            if (c != null) {
                CodeTextBuilder this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), c, null, false, 6, null);
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
            CascadeRule cascadeRule = rule;
            if (cascadeRule == null) return null;
            switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$4[cascadeRule.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    String string = rule.keyWord;
                    return string;
                }
                default: {
                    return null;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void generateCheck(@NotNull BasicCheck check) {
            void w1;
            Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
            String def = "check (" + check.getPredicate() + ")";
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, check, (Ref.ObjectRef)w1, def){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicCheck $check;
                final /* synthetic */ Ref.ObjectRef $w1;
                final /* synthetic */ String $def;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$5[this.this$0.getContext().ordinal()]) {
                        case 1: 
                        case 2: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$check);
                            break;
                        }
                        default: {
                            CharSequence charSequence;
                            CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                            CharSequence[] charSequenceArray = new CharSequence[2];
                            charSequenceArray[0] = "alter table";
                            CharSequence[] charSequenceArray2 = charSequenceArray;
                            CharSequence[] charSequenceArray3 = charSequenceArray;
                            int n = 1;
                            Object object = this.$check.getTable();
                            if (object != null && (object = this.this$0.AbstractScriptingService.this.currentScopeName((BasicElement)object)) != null) {
                                charSequence = (CharSequence)object;
                            } else {
                                String string;
                                String string2 = this.$check.getTableName();
                                if (string2 != null) {
                                    void $receiver$iv;
                                    void this_$iv;
                                    String string3 = string2;
                                    AbstractScriptingService abstractScriptingService = this.this$0.AbstractScriptingService.this;
                                    int n2 = n;
                                    CharSequence[] charSequenceArray4 = charSequenceArray2;
                                    CharSequence[] charSequenceArray5 = charSequenceArray3;
                                    CodeTextBuilder codeTextBuilder2 = codeTextBuilder;
                                    String string4 = this_$iv.getNaming().nameToScript((String)$receiver$iv);
                                    codeTextBuilder = codeTextBuilder2;
                                    charSequenceArray3 = charSequenceArray5;
                                    charSequenceArray2 = charSequenceArray4;
                                    n = n2;
                                    string = string4;
                                } else {
                                    string = null;
                                }
                                charSequence = string;
                            }
                            charSequenceArray2[n] = charSequence;
                            codeTextBuilder.phrase(charSequenceArray3);
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            this.this$0.addOuterConstraintNameAndIndent(this.$check);
                            if (this.this$0.AbstractScriptingService.this.getUseName(this.$check)) break;
                            this.$w1.element = "add ";
                        }
                    }
                    this.this$0.generateDeferrability(this.$check);
                    String text2 = (String)this.$w1.element + this.$def;
                    if (Intrinsics.areEqual((Object)((Object)this.this$0.getContext()), (Object)((Object)ScriptContext.IN_TABLE))) {
                        text2 = text2 + ',';
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), text2, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$check = basicCheck;
                    this.$w1 = objectRef;
                    this.$def = string;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void generateDeferrability(@NotNull BasicConstraint constraint) {
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            String dfr = this.makeDeferrability(constraint);
            if (dfr != null) {
                CodeTextBuilder this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), dfr, null, false, 6, null);
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }

        @Nullable
        protected String makeDeferrability(@NotNull BasicConstraint constraint) {
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            return constraint.isDeferrable() ? (constraint.isInitiallyDeferred() ? "deferrable initially deferred" : "deferrable") : null;
        }

        /*
         * WARNING - void declaration
         */
        protected void addInnerConstraintNameAndIndent(@NotNull BasicConstraint constraint) {
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            if (AbstractScriptingService.this.getUseName(constraint)) {
                void $receiver$iv;
                String string = constraint.getName();
                AbstractScriptingService this_$iv = AbstractScriptingService.this;
                String name = this_$iv.getNaming().nameToScript((String)$receiver$iv);
                CodeTextBuilder.append$default(this.getBuilder(), "constraint " + name, null, false, 6, null);
                CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
            }
        }

        protected void addOuterConstraintNameAndIndent(@NotNull BasicConstraint constraint) {
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            if (AbstractScriptingService.this.getUseName(constraint)) {
                String name = AbstractScriptingService.this.currentScopeName(constraint);
                CodeTextBuilder.append$default(this.getBuilder(), "add constraint " + name, null, false, 6, null);
                CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
            }
        }

        protected void generateTrigger(@NotNull BasicTrigger trigger2) {
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            if (trigger2 instanceof BasicSourceAware) {
                this.generateSourceAwareElement((BasicSourceAware)((Object)trigger2), false);
                if (trigger2.isDisabled()) {
                    this.generateDisableTrigger(trigger2);
                }
            } else {
                CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger2){
                    final /* synthetic */ CreatingGenerator this$0;
                    final /* synthetic */ BasicTrigger $trigger;

                    public final void invoke() {
                        String triggerName = this.$trigger instanceof BasicSchemaObject ? this.this$0.AbstractScriptingService.this.currentScopeName(this.$trigger) : this.this$0.AbstractScriptingService.this.currentScopeName(this.$trigger);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- Unknown how to generate trigger " + triggerName, null, false, 6, null);
                    }
                    {
                        this.this$0 = creatingGenerator;
                        this.$trigger = basicTrigger;
                        super(0);
                    }
                }, 3, null);
            }
        }

        protected void generateDisableTrigger(@NotNull BasicTrigger trigger2) {
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            String name = trigger2 instanceof BasicSchemaObject ? AbstractScriptingService.this.currentScopeName(trigger2) : AbstractScriptingService.this.currentScopeName(trigger2);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter trigger " + this.$name + " disable", null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    super(0);
                }
            }, 3, null);
        }

        protected void generateSourceAwareElement(@NotNull BasicSourceAware element, boolean processChildren) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.generateSourceAwareUsingSources(element);
            if (element.getComment() != null) {
                this.generateComment(element);
                if (element instanceof BasicView) {
                    PositioningNamingFamily columns2 = ((BasicView)element).getColumns();
                    Iterator iterator = columns2.iterator();
                    while (iterator.hasNext()) {
                        BasicColumn column;
                        BasicColumn basicColumn = column = (BasicColumn)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicColumn, (String)"column");
                        this.generateComment(basicColumn);
                    }
                }
            }
            if (processChildren) {
                this.processElementChildren(element);
            }
        }

        public static /* bridge */ /* synthetic */ void generateSourceAwareElement$default(CreatingGenerator creatingGenerator, BasicSourceAware basicSourceAware, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateSourceAwareElement");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            creatingGenerator.generateSourceAwareElement(basicSourceAware, bl);
        }

        protected void generateSourceAwareUsingSources(@NotNull BasicSourceAware element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.generateUnspecificSourceAwareElement(element);
        }

        protected void generateUnspecificSourceAwareElement(@NotNull BasicSourceAware element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            CompositeText st = element.getSourceText();
            if (st != null) {
                JBIterable jBIterable = JBIterable.from(st.getFragments()).split(JBIterable.Split.OFF, (Condition)generateUnspecificSourceAwareElement.statements.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(st.fragm\u2026eText.Kind.SQL_DELIMITER}");
                JBIterable statements2 = jBIterable;
                for (JBIterable statementFragments : statements2) {
                    CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, statementFragments){
                        final /* synthetic */ CreatingGenerator this$0;
                        final /* synthetic */ JBIterable $statementFragments;

                        public final void invoke() {
                            for (CompositeText.Fragment fragment : this.$statementFragments) {
                                this.this$0.getBuilder().append(fragment);
                            }
                        }
                        {
                            this.this$0 = creatingGenerator;
                            this.$statementFragments = jBIterable;
                            super(0);
                        }
                    }, 3, null);
                }
            }
        }

        protected void processElementChildren(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            JBIterable<? extends BasicElement> children = element.getDbChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                BasicElement child;
                BasicElement basicElement = child = (BasicElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                if (!this.canGenerateInnerElement(basicElement) || AbstractScriptingService.this.getGenerated().contains(child) || this.getDeck().contains(child)) continue;
                this.processElement(child);
            }
        }

        protected boolean canGenerateInnerElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicSchemaObject || element instanceof BasicSourceAware;
        }

        protected void generateComment(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof BasicLikeTable) {
                this.generateTableComment((BasicLikeTable)element);
            } else if (basicElement instanceof BasicColumn) {
                this.generateColumnComment((BasicColumn)element);
            }
        }

        protected void generateTableComment(@NotNull BasicLikeTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            String string = table.getComment();
            if (string == null || (string = AbstractScriptingService.this.getSqlString(string)) == null) {
                return;
            }
            String comment = string;
            ObjectKind kind = table.getKind();
            String w = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW) ? "materialized view" : kind.code();
            String name = table instanceof BasicSchemaObject ? AbstractScriptingService.this.currentScopeName(table) : AbstractScriptingService.this.currentScopeName(table);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, name, comment){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $w;
                final /* synthetic */ String $name;
                final /* synthetic */ String $comment;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on " + this.$w + ' ' + this.$name + " is " + this.$comment, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$w = string;
                    this.$name = string2;
                    this.$comment = string3;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        protected void generateColumnComment(@NotNull BasicColumn column) {
            void $receiver$iv;
            BasicSchemaObject table;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getTable();
            if (!(basicLikeTable instanceof BasicSchemaObject)) {
                basicLikeTable = null;
            }
            if ((object = (table = (BasicSchemaObject)((Object)basicLikeTable))) == null || (object = AbstractScriptingService.this.currentScopeName((BasicElement)object)) == null) {
                void $receiver$iv2;
                String string = column.getTableName();
                AbstractScriptingService this_$iv = AbstractScriptingService.this;
                object = this_$iv.getNaming().nameToScript((String)$receiver$iv2);
            }
            Object tableName = object;
            String $i$f$getScr = column.getName();
            AbstractScriptingService this_$iv = AbstractScriptingService.this;
            String columnName = this_$iv.getNaming().nameToScript((String)$receiver$iv);
            String string = column.getComment();
            if (string == null || (string = AbstractScriptingService.this.getSqlString(string)) == null) {
                return;
            }
            String comment = string;
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (String)tableName, columnName, comment){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $tableName;
                final /* synthetic */ String $columnName;
                final /* synthetic */ String $comment;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on column " + this.$tableName + '.' + this.$columnName + " is " + this.$comment, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$tableName = string;
                    this.$columnName = string2;
                    this.$comment = string3;
                    super(0);
                }
            }, 3, null);
        }

        protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element instanceof BasicMinorObject && this.getContext().compareTo((Enum)ScriptContext.IN_TABLE) < 0) {
                BasicMajorObject majorObject = ((BasicMinorObject)element).getMajorObject();
                return majorObject == null || AbstractScriptingService.this.getGenerated().contains(majorObject);
            }
            return true;
        }

        protected void generateSynonym(@NotNull BasicSynonym synonym) {
            String text2;
            Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
            String targetSpec = this.makeSynonymTargetSpec(synonym);
            String name = AbstractScriptingService.this.currentScopeName(synonym);
            if (targetSpec != null) {
                String[] stringArray = new String[5];
                ObjectKind objectKind = ObjectKind.SYNONYM;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"SYNONYM");
                stringArray[0] = this.createOrReplace(objectKind);
                stringArray[1] = "synonym";
                stringArray[2] = name;
                stringArray[3] = "for";
                stringArray[4] = targetSpec;
                String string = ScriptingUtilsKt.phrase(stringArray);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                text2 = string;
            } else {
                text2 = "-- unknown what the synonym " + name + " references on :(";
            }
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text2){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $text;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$text = string;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        protected String makeSynonymTargetSpec(@NotNull BasicSynonym synonym) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
            BasicMajorObject targetObject = synonym.getTargetObject();
            if (targetObject != null) {
                return AbstractScriptingService.this.currentScopeName(targetObject);
            }
            String schemaName = synonym.getTargetSchemaName();
            String string2 = synonym.getTargetObjectName();
            if (string2 == null) {
                return null;
            }
            String objectName = string2;
            if (schemaName == null) {
                void $receiver$iv;
                String string3 = objectName;
                AbstractScriptingService this_$iv = AbstractScriptingService.this;
                string = this_$iv.getNaming().nameToScript((String)$receiver$iv);
            } else {
                String $receiver$iv = schemaName;
                AbstractScriptingService this_$iv = AbstractScriptingService.this;
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = this_$iv.getNaming().nameToScript($receiver$iv);
                $receiver$iv = objectName;
                this_$iv = AbstractScriptingService.this;
                stringBuilder = stringBuilder.append(string4).append(".");
                string4 = this_$iv.getNaming().nameToScript($receiver$iv);
                string = stringBuilder.append(string4).toString();
            }
            return string;
        }

        protected final void weDontKnowHowToGenerateThis(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            CodeTextBuilder codeTextBuilder = this.getBuilder();
            StringBuilder stringBuilder = new StringBuilder().append("-- we don't know how to generate ").append(element.getKind().code()).append(' ');
            String string = element.getRealName();
            if (string == null) {
                string = "<with-no-name>";
            }
            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(" (class ").append(element.getClass().getSimpleName()).append(") :( --").toString(), null, false, 6, null);
        }

        public CreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
            this.isExact = Intrinsics.areEqual((Object)((Object)this.getTask()), (Object)((Object)ScriptingTask.CREATE_DEFINITION));
            this.tableElementsApplicableInExactTask = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK});
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$EnableDisableGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "actionWord", "", "getActionWord", "()Ljava/lang/String;", "generateCheck", "", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateEnableDisableForConstraint", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "generateEnableDisableForTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateForeignKey", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "generateTrigger", "database-scripting"})
    protected class EnableDisableGenerator
    extends CodeGenerator {
        @NotNull
        private final String actionWord;

        @NotNull
        public final String getActionWord() {
            return this.actionWord;
        }

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof BasicTable) {
                ObjectKind[] objectKindArray = new ObjectKind[5];
                ObjectKind objectKind = ObjectKind.KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"KEY");
                objectKindArray[0] = objectKind;
                ObjectKind objectKind2 = ObjectKind.FOREIGN_KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"FOREIGN_KEY");
                objectKindArray[1] = objectKind2;
                ObjectKind objectKind3 = ObjectKind.CHECK;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind3, (String)"CHECK");
                objectKindArray[2] = objectKind3;
                ObjectKind objectKind4 = ObjectKind.RULE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind4, (String)"RULE");
                objectKindArray[3] = objectKind4;
                ObjectKind objectKind5 = ObjectKind.TRIGGER;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind5, (String)"TRIGGER");
                objectKindArray[4] = objectKind5;
                this.processInnerElements(element, objectKindArray);
            } else if (basicElement instanceof BasicMatView) {
                ObjectKind[] objectKindArray = new ObjectKind[5];
                ObjectKind objectKind = ObjectKind.KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"KEY");
                objectKindArray[0] = objectKind;
                ObjectKind objectKind6 = ObjectKind.FOREIGN_KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind6, (String)"FOREIGN_KEY");
                objectKindArray[1] = objectKind6;
                ObjectKind objectKind7 = ObjectKind.CHECK;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind7, (String)"CHECK");
                objectKindArray[2] = objectKind7;
                ObjectKind objectKind8 = ObjectKind.RULE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind8, (String)"RULE");
                objectKindArray[3] = objectKind8;
                ObjectKind objectKind9 = ObjectKind.TRIGGER;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind9, (String)"TRIGGER");
                objectKindArray[4] = objectKind9;
                this.processInnerElements(element, objectKindArray);
            } else if (basicElement instanceof BasicView) {
                ObjectKind[] objectKindArray = new ObjectKind[5];
                ObjectKind objectKind = ObjectKind.KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"KEY");
                objectKindArray[0] = objectKind;
                ObjectKind objectKind10 = ObjectKind.FOREIGN_KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind10, (String)"FOREIGN_KEY");
                objectKindArray[1] = objectKind10;
                ObjectKind objectKind11 = ObjectKind.CHECK;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind11, (String)"CHECK");
                objectKindArray[2] = objectKind11;
                ObjectKind objectKind12 = ObjectKind.RULE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind12, (String)"RULE");
                objectKindArray[3] = objectKind12;
                ObjectKind objectKind13 = ObjectKind.TRIGGER;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind13, (String)"TRIGGER");
                objectKindArray[4] = objectKind13;
                this.processInnerElements(element, objectKindArray);
            } else if (basicElement instanceof BasicKey) {
                this.generateKey((BasicKey)element);
            } else if (basicElement instanceof BasicForeignKey) {
                this.generateForeignKey((BasicForeignKey)element);
            } else if (basicElement instanceof BasicCheck) {
                this.generateCheck((BasicCheck)element);
            } else if (basicElement instanceof BasicTrigger) {
                this.generateTrigger((BasicTrigger)element);
            }
        }

        protected void generateKey(@NotNull BasicKey key2) {
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            if (AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_KEYS).booleanValue() && !key2.isClustering()) {
                this.generateEnableDisableForConstraint(key2);
            }
        }

        protected void generateForeignKey(@NotNull BasicForeignKey fk) {
            Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
            if (AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_FOREIGN_KEYS).booleanValue()) {
                this.generateEnableDisableForConstraint(fk);
            }
        }

        protected void generateCheck(@NotNull BasicCheck check) {
            Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
            if (AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_CHECKS).booleanValue()) {
                this.generateEnableDisableForConstraint(check);
            }
        }

        protected void generateTrigger(@NotNull BasicTrigger trigger2) {
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            if (AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_TRIGGERS).booleanValue()) {
                this.generateEnableDisableForTrigger(trigger2);
            }
        }

        protected void generateEnableDisableForTrigger(@NotNull BasicTrigger trigger2) {
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            String triggerName = AbstractScriptingService.this.currentScopeName(trigger2);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName){
                final /* synthetic */ EnableDisableGenerator this$0;
                final /* synthetic */ String $triggerName;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("alter trigger ", this.$triggerName, this.this$0.getActionWord());
                }
                {
                    this.this$0 = enableDisableGenerator;
                    this.$triggerName = string;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        protected void generateEnableDisableForConstraint(@NotNull BasicConstraint constraint) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            BasicLikeTable basicLikeTable = constraint.getTable();
            if (basicLikeTable == null) {
                return;
            }
            BasicLikeTable table = basicLikeTable;
            String tableName = AbstractScriptingService.this.currentScopeName(table);
            String string = constraint.getName();
            AbstractScriptingService this_$iv = AbstractScriptingService.this;
            String constraintName = this_$iv.getNaming().nameToScript((String)$receiver$iv);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, constraintName){
                final /* synthetic */ EnableDisableGenerator this$0;
                final /* synthetic */ String $tableName;
                final /* synthetic */ String $constraintName;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("alter table", this.$tableName, this.this$0.getActionWord(), "constraint", this.$constraintName);
                }
                {
                    this.this$0 = enableDisableGenerator;
                    this.$tableName = string;
                    this.$constraintName = string2;
                    super(0);
                }
            }, 3, null);
        }

        public EnableDisableGenerator(ScriptingTask task) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
            String string2 = this.getTask().name();
            Locale locale = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
            Locale locale2 = locale;
            EnableDisableGenerator enableDisableGenerator = this;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            enableDisableGenerator.actionWord = string = string4;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$RefreshMatViewGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateRefreshAllMatViews", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "generateRefreshMatView", "view", "Lcom/intellij/database/model/basic/BasicMatView;", "database-scripting"})
    protected class RefreshMatViewGenerator
    extends CodeGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof BasicSchema) {
                this.generateRefreshAllMatViews((BasicSchema)element);
            } else if (basicElement instanceof BasicMatView) {
                this.generateRefreshMatView((BasicMatView)element);
            }
        }

        protected void generateRefreshAllMatViews(@NotNull BasicSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Family<? extends BasicElement> family = schema.familyOf(ObjectKind.MAT_VIEW);
            if (family == null) {
                return;
            }
            Family<? extends BasicElement> views = family;
            Iterator iterator = views.iterator();
            while (iterator.hasNext()) {
                BasicElement view2;
                BasicElement basicElement = view2 = (BasicElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"view");
                this.processElement(basicElement);
            }
        }

        protected void generateRefreshMatView(@NotNull BasicMatView view2) {
            Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view2){
                final /* synthetic */ RefreshMatViewGenerator this$0;
                final /* synthetic */ BasicMatView $view;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- refresh " + this.$view.getName(), null, false, 6, null);
                }
                {
                    this.this$0 = refreshMatViewGenerator;
                    this.$view = basicMatView;
                    super(0);
                }
            }, 3, null);
        }

        public RefreshMatViewGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$\u00a8\u0006\n"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$ExecuteGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "database-scripting"})
    protected abstract class ExecuteGenerator
    extends CodeGenerator {
        @Override
        protected abstract void generateElement(@NotNull BasicElement var1);

        public ExecuteGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$StupidGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "database-scripting"})
    protected final class StupidGenerator
    extends CodeGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ StupidGenerator this$0;
                final /* synthetic */ BasicElement $element;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- " + this.$element.getKind().code() + ' ' + this.$element.getName(), null, false, 6, null);
                }
                {
                    this.this$0 = stupidGenerator;
                    this.$element = basicElement;
                    super(0);
                }
            }, 3, null);
        }

        public StupidGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(){

                public final void invoke() {
                    CodeTextBuilder.append$default(this.getBuilder(), "-- We don't know how to generate " + this.getTask().name() + " :(", null, false, 6, null);
                }
            }, 3, null);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0014R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$RefactoringGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "migrated", "", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Ljava/util/Map;)V", "getMigrated", "()Ljava/util/Map;", "generateElement", "", "element", "database-scripting"})
    protected class RefactoringGenerator
    extends CodeGenerator {
        @NotNull
        private final Map<BasicElement, BasicElement> migrated;

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ RefactoringGenerator this$0;
                final /* synthetic */ BasicElement $element;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- unable to refactor " + this.$element.getKind().code() + ' ' + this.$element.getName(), null, false, 6, null);
                }
                {
                    this.this$0 = refactoringGenerator;
                    this.$element = basicElement;
                    super(0);
                }
            }, 3, null);
        }

        @NotNull
        public final Map<BasicElement, BasicElement> getMigrated() {
            return this.migrated;
        }

        public RefactoringGenerator(Map<BasicElement, ? extends BasicElement> migrated) {
            Intrinsics.checkParameterIsNotNull(migrated, (String)"migrated");
            super(ScriptingTask.CREATE_DEFINITION);
            this.migrated = migrated;
        }
    }
}

