/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.impl.MemoryTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.SqlModelBuilderUtils;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabasePreviewDialog;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Queue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcMigration {
    private static final Logger LOG = Logger.getInstance(DbSrcMigration.class);

    public static boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcMigration.$$$reportNull$$$0(0);
        }
        if (!DbSrcUtils.isDbSrcFile(file)) {
            return false;
        }
        BasicElement element = DbSrcUtils.findLocalDsObject(file.getPath(), BasicElement.class, true);
        BasicModel model = element == null ? null : element.getModel();
        return model != null && ((ScriptingFactory)ServiceManager.getService(ScriptingFactory.class)).isRefactoringSupported(model.getRdbms(), element.getKind());
    }

    @Nullable
    public static CompositeText migrate(@NotNull Project project, @NotNull Iterable<VirtualFile> files) {
        ScriptingFactory sf;
        List<com.intellij.openapi.util.Pair<BasicElement, SqlFile>> objects;
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(1);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(2);
        }
        if ((objects = DbSrcMigration.findObjects(files, sf = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class), project)).isEmpty()) {
            return null;
        }
        SqlObjectBuilder builder = (SqlObjectBuilder)SqlLanguageObjectBuilder.INSTANCE.forLanguage(((SqlFile)objects.get((int)0).second).getLanguage());
        if (builder == null) {
            return null;
        }
        Map<BasicElement, BasicModElement> copied = DbSrcMigration.copy(JBIterable.from(objects).transform(p -> (BasicElement)p.first).toSet());
        List<Pair<BasicElement, BasicElement>> migration = DbSrcMigration.buildFromSql(builder, objects, copied);
        if (migration.isEmpty()) {
            return null;
        }
        BasicModel model = (BasicModel)ObjectUtils.assertNotNull((Object)((BasicElement)migration.get(0).getFirst()).getModel());
        ScriptingService ss = sf.createScriptingService(model, model.getRoot().getCurrentDatabase());
        ss.makeRefactoringScript(migration, null);
        return ss.getScript();
    }

    @NotNull
    private static List<Pair<BasicElement, BasicElement>> buildFromSql(SqlObjectBuilder builder, List<com.intellij.openapi.util.Pair<BasicElement, SqlFile>> objects, Map<BasicElement, BasicModElement> copied) {
        ArrayList migration = ContainerUtil.newArrayList();
        for (com.intellij.openapi.util.Pair<BasicElement, SqlFile> object : objects) {
            BasicModElement target = (BasicModElement)ObjectUtils.assertNotNull((Object)copied.get(object.first));
            DasObject sqlObject = (DasObject)JBIterable.from((Iterable)((SqlFile)object.second).getDdl()).filter(DasObject.class).filter(DasUtil.byKind((ObjectKind)target.getKind())).first();
            if (sqlObject == null) continue;
            DbSrcMigration.buildHierarchy(builder, target, sqlObject);
            migration.add(new Pair(object.first, (Object)target));
        }
        ArrayList arrayList = migration;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void buildHierarchy(SqlObjectBuilder builder, BasicModElement target, DasObject sqlObject) {
        DatabaseFamilyId familyId = (DatabaseFamilyId)ObjectUtils.chooseNotNull((Object)GenericIntrospectorLegacyModelUtils.findFamily(target.getModel().getRdbms()), (Object)DatabaseFamilyId.UNKNOWN);
        DbSrcMigration.buildObjectRec(builder, target, sqlObject, familyId);
    }

    private static void buildObjectRec(SqlObjectBuilder builder, BasicModElement target, DasObject sqlObject, DatabaseFamilyId familyId) {
        for (ModFamily<? extends BasicModElement> modFamily : target.getFamilies()) {
            modFamily.markChildrenAsSyncPending();
        }
        for (DasObject dasObject : sqlObject.getDbChildren(DasObject.class, ObjectKind.NONE)) {
            BasicModElement childTarget = SqlModelBuilderUtils.createObject(target, dasObject.getName(), SqlModelBuilderUtils.getSubName(dasObject, familyId), dasObject.getKind());
            if (childTarget == null) continue;
            DbSrcMigration.buildObjectRec(builder, childTarget, dasObject, familyId);
        }
        for (ModFamily<? extends BasicModElement> modFamily : target.getFamilies()) {
            modFamily.removeSyncPendingChildren();
            modFamily.sort();
        }
        builder.build((DasObject)target, sqlObject);
    }

    @NotNull
    private static Map<BasicElement, BasicModElement> copy(@NotNull Set<BasicElement> deepObjects) {
        if (deepObjects == null) {
            DbSrcMigration.$$$reportNull$$$0(4);
        }
        HashMap res = ContainerUtil.newHashMap();
        Set shallowObjects = JBIterable.from(deepObjects).flatMap(o -> JBIterable.generate((Object)o, BasicElement::getDbParent)).filter(o -> {
            if (deepObjects == null) {
                DbSrcMigration.$$$reportNull$$$0(20);
            }
            return !deepObjects.contains(o);
        }).toSet();
        BasicModel baseModel = (BasicModel)ObjectUtils.assertNotNull((Object)deepObjects.iterator().next().getModel());
        BasicModModel targetModel = new ModelFactory(new MemoryTextStorage()).createModel(baseModel.getRdbms());
        targetModel.modify(BasicModRoot.class, r -> {
            if (deepObjects == null) {
                DbSrcMigration.$$$reportNull$$$0(19);
            }
            HashMap tmp = ContainerUtil.newHashMap();
            Queue q = new Queue(10);
            q.addLast((Object)Trinity.create((Object)baseModel.getRoot(), (Object)((BasicModElement)((Object)targetModel.getRoot())), (Object)false));
            while (!q.isEmpty()) {
                Trinity task = (Trinity)q.pullFirst();
                res.put(task.first, task.second);
                DbSrcMigration.shallowCopy((BasicElement)task.first, (BasicModElement)task.second, tmp);
                for (BasicElement element : ((BasicElement)task.first).getDbChildren()) {
                    boolean deep;
                    boolean bl = deep = (Boolean)task.third != false || deepObjects.contains(element);
                    if (!deep && !shallowObjects.contains(element)) continue;
                    Object target = ((ModFamily)ObjectUtils.assertNotNull((Object)((BasicModElement)task.second).familyOf(element.getKind()))).createNewOne();
                    q.addLast((Object)Trinity.create((Object)element, target, (Object)deep));
                }
            }
        });
        HashMap hashMap = res;
        if (hashMap == null) {
            DbSrcMigration.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    private static void shallowCopy(@NotNull BasicElement from, @NotNull BasicModElement to, @NotNull Map<String, String> tmp) {
        if (from == null) {
            DbSrcMigration.$$$reportNull$$$0(6);
        }
        if (to == null) {
            DbSrcMigration.$$$reportNull$$$0(7);
        }
        if (tmp == null) {
            DbSrcMigration.$$$reportNull$$$0(8);
        }
        tmp.clear();
        from.exportProperties(tmp::put);
        to.importProperties(tmp);
    }

    @NotNull
    private static List<com.intellij.openapi.util.Pair<BasicElement, SqlFile>> findObjects(@NotNull Iterable<VirtualFile> files, @NotNull ScriptingFactory sf, @NotNull Project project) {
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(9);
        }
        if (sf == null) {
            DbSrcMigration.$$$reportNull$$$0(10);
        }
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(11);
        }
        FileDocumentManager dm = FileDocumentManager.getInstance();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project);
        ArrayList objects = ContainerUtil.newArrayList();
        BasicModel model = null;
        for (VirtualFile file : files) {
            SqlFile psiFile;
            BasicElement element;
            if (!DbSrcUtils.isDbSrcFile(file) || (element = DbSrcUtils.findLocalDsObject(file.getPath(), BasicElement.class, true)) == null) continue;
            if (model == null) {
                model = element.getModel();
            }
            if (model == null || !sf.isRefactoringSupported(model.getRdbms(), element.getKind())) continue;
            Document doc = dm.getDocument(file);
            SqlFile sqlFile = psiFile = doc == null ? null : (SqlFile)ObjectUtils.tryCast((Object)pdm.getPsiFile(doc), SqlFile.class);
            if (psiFile == null) continue;
            objects.add(com.intellij.openapi.util.Pair.create((Object)element, (Object)psiFile));
        }
        ArrayList arrayList = objects;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public static void showMigrationDialog(@NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull Iterable<VirtualFile> files) {
        Project project;
        CompositeText text2;
        if (dataSource == null) {
            DbSrcMigration.$$$reportNull$$$0(13);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(14);
        }
        if ((text2 = DbSrcMigration.migrate(project = dataSource.getProject(), files)) != null) {
            try {
                text2 = DbSrcMigration.formatCompositeText(project, DbSqlUtil.getSqlDialect((DbElement)dataSource), text2);
            }
            catch (Throwable th) {
                LOG.warn("Formatting failed", th);
            }
        }
        DatabasePreviewDialog dialog = new DatabasePreviewDialog(project, dataSource, searchPath, "Object Migration", "Script", text2 == null ? "" : text2.getText().toString(), text2 == null ? Collections.singletonList("Generation failed") : Collections.emptyList());
        dialog.getPreviewPanel().foldToStatements();
        if (dialog.showAndGet()) {
            DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(dataSource, null).setStatement(dialog.getStatement());
            LoaderContext context = handler.getContext();
            for (VirtualFile file : files) {
                DbElement item = DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class, true);
                if (item == null) continue;
                context.include(item);
            }
            handler.runStatements(false);
        }
    }

    @NotNull
    public static PersistentMarkup formatCompositeText(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CompositeText text2) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(15);
        }
        if (dialect == null) {
            DbSrcMigration.$$$reportNull$$$0(16);
        }
        if (text2 == null) {
            DbSrcMigration.$$$reportNull$$$0(17);
        }
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        ArrayList ranges = ContainerUtil.newArrayList();
        for (CompositeText.Fragment fragment : text2.getFragments()) {
            int start = document.getTextLength();
            document.insertString(start, (CharSequence)StringUtil.convertLineSeparators((String)fragment.getText().toString()));
            int end = document.getTextLength();
            CompositeText.Kind kind = fragment.getKind();
            RangeMarker marker = kind.getReformattable() ? document.createRangeMarker(start, end) : document.createGuardedBlock(start, end);
            ranges.add(com.intellij.openapi.util.Pair.create((Object)marker, (Object)((Object)kind)));
        }
        SqlPsiFacade.getInstance((Project)project).format(project, dialect, (Document)document);
        PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
        for (com.intellij.openapi.util.Pair range : ranges) {
            if (!((RangeMarker)range.first).isValid()) {
                LOG.warn("Range marker died during formatting");
                continue;
            }
            builder.add((CompositeText.Kind)((Object)range.second), ((RangeMarker)range.first).getStartOffset(), ((RangeMarker)range.first).getEndOffset());
        }
        PersistentMarkup persistentMarkup = builder.build(document.getText());
        if (persistentMarkup == null) {
            DbSrcMigration.$$$reportNull$$$0(18);
        }
        return persistentMarkup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scripting/DbSrcMigration";
                break;
            }
            case 4: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepObjects";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmp";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sf";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scripting/DbSrcMigration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromSql";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCompositeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shallowCopy";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showMigrationDialog";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatCompositeText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copy$3";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copy$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

