/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ModelFun;
import com.intellij.database.scripting.AutoNeverAlways;
import com.intellij.database.scripting.ScriptingConstraintContext;
import com.intellij.database.scripting.ScriptingOption;
import com.intellij.database.scripting.ScriptingTask;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\"\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020\u001eH\u0002\u001a\u0016\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010'\u001a\u00020\u001eH\u0000\u001a\u001e\u0010(\u001a\u0004\u0018\u00010)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010+\u001a\u00020\u001eH\u0000\u001aX\u0010*\u001a\b\u0012\u0004\u0012\u0002H,0\u0004\"\u000e\b\u0000\u0010,\u0018\u0001*\u0006\u0012\u0002\b\u00030\"2\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001e2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u00102\u001a\u0002H,H\u0082\b\u00a2\u0006\u0002\u00103\u001aC\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001e2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u00102\u001a\u00020\u0005H\u0082\b\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00178\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"ALL_TASKS", "", "Lcom/intellij/database/scripting/ScriptingTask;", "CONSIDER_CHECKS", "Lcom/intellij/database/scripting/ScriptingOption;", "", "CONSIDER_CURRENT_SEQUENCE_VALUE", "CONSIDER_FOREIGN_KEYS", "CONSIDER_KEYS", "CONSIDER_RULES", "CONSIDER_SCHEMA_NAME", "Lcom/intellij/database/scripting/AutoNeverAlways;", "CONSIDER_SURROGATE_NAMES", "CONSIDER_TRIGGERS", "CREATE_IF_NOT_EXISTS", "CREATE_OR_REPLACE", "CREATION_FIRST_TASKS", "CREATION_TASKS", "IF_EXISTS", "REFORMAT", "SCRIPTING_CONSTRAINT_CONTEXT", "Lcom/intellij/database/scripting/ScriptingConstraintContext;", "SCRIPTING_OPTIONS", "Ljava/util/SortedSet;", "USE_SYSTEM_PROCEDURES", "VARCHAR2_TO_VARCHAR", "allOptions", "Ljava/util/TreeSet;", "allOptionsByCode", "Ljava/util/HashMap;", "", "orderCounter", "", "enumValueOf", "", "enum", "Lkotlin/reflect/KClass;", "name", "getScriptingOptionByCode", "code", "importScriptingOptionValue", "", "option", "value", "E", "formalName", "displayName", "applicableRdbms", "Lorg/jetbrains/dekaf/Rdbms;", "applicableTasks", "defaultValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Ljava/lang/Enum;)Lcom/intellij/database/scripting/ScriptingOption;", "database-scripting"})
@JvmName(name="ScriptingOptionStatic")
public final class ScriptingOptionStatic {
    private static int orderCounter;
    private static final TreeSet<ScriptingOption<?>> allOptions;
    private static final HashMap<String, ScriptingOption<?>> allOptionsByCode;
    private static final Set<ScriptingTask> CREATION_TASKS;
    private static final Set<ScriptingTask> CREATION_FIRST_TASKS;
    private static final Set<ScriptingTask> ALL_TASKS;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CONSIDER_SURROGATE_NAMES;
    @JvmField
    @NotNull
    public static final ScriptingOption<AutoNeverAlways> CONSIDER_SCHEMA_NAME;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CREATE_OR_REPLACE;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CREATE_IF_NOT_EXISTS;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CONSIDER_CURRENT_SEQUENCE_VALUE;
    @JvmField
    @NotNull
    public static final ScriptingOption<ScriptingConstraintContext> SCRIPTING_CONSTRAINT_CONTEXT;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CONSIDER_KEYS;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CONSIDER_FOREIGN_KEYS;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CONSIDER_CHECKS;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CONSIDER_RULES;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> CONSIDER_TRIGGERS;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> VARCHAR2_TO_VARCHAR;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> IF_EXISTS;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> USE_SYSTEM_PROCEDURES;
    @JvmField
    @NotNull
    public static final ScriptingOption<Boolean> REFORMAT;
    @JvmField
    @NotNull
    public static final SortedSet<ScriptingOption<?>> SCRIPTING_OPTIONS;

    @Nullable
    public static final ScriptingOption<?> getScriptingOptionByCode(@NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        return allOptionsByCode.get(code);
    }

    @Nullable
    public static final Object importScriptingOptionValue(@NotNull ScriptingOption<?> option, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        KClass<?> klass = option.getValueClass();
        if (Intrinsics.areEqual(klass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            return Intrinsics.areEqual((Object)value, (Object)"1");
        }
        if (JvmClassMappingKt.getJavaClass(klass).isEnum()) {
            return ScriptingOptionStatic.enumValueOf(option.getValueClass(), value);
        }
        return null;
    }

    private static final Enum<?> enumValueOf(KClass<?> kClass, String name) {
        Object object;
        block3: {
            T[] TArray = JvmClassMappingKt.getJavaClass(kClass).getEnumConstants();
            if (TArray == null) {
                return null;
            }
            T[] enumConstants = TArray;
            if (enumConstants == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<out kotlin.Enum<*>>");
            }
            Object[] $receiver$iv = (Enum[])enumConstants;
            for (int j = 0; j < $receiver$iv.length; ++j) {
                Object element$iv = $receiver$iv[j];
                Enum it = (Enum)element$iv;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)name)) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        return (Enum)object;
    }

    private static final <E extends Enum<?>> ScriptingOption<E> option(String formalName, String displayName, Set<Rdbms> applicableRdbms, Set<? extends ScriptingTask> applicableTasks, E defaultValue) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"E");
        KClass valueClass = Reflection.getOrCreateKotlinClass(Enum.class);
        List items = ArraysKt.toList((Object[])JvmClassMappingKt.getJavaClass((KClass)valueClass).getEnumConstants());
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        ScriptingOption<E> o = new ScriptingOption<E>(ScriptingOptionStatic.orderCounter, valueClass, formalName, displayName, applicableRdbms, applicableTasks, items, defaultValue);
        ScriptingOptionStatic.allOptions.add(o);
        ScriptingOptionStatic.allOptionsByCode.put(o.getCode(), o);
        return o;
    }

    private static final ScriptingOption<Boolean> option(String code, String displayName, Set<Rdbms> applicableRdbms, Set<? extends ScriptingTask> applicableTasks, boolean defaultValue) {
        List items = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        ScriptingOption<Boolean> o = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code, displayName, applicableRdbms, applicableTasks, items, defaultValue);
        ScriptingOptionStatic.allOptions.add(o);
        ScriptingOptionStatic.allOptionsByCode.put(o.getCode(), o);
        return o;
    }

    /*
     * WARNING - void declaration
     */
    static {
        String formalName$iv;
        void defaultValue$iv22;
        Set<ScriptingTask> applicableTasks$iv;
        Set<Rdbms> applicableRdbms$iv;
        String displayName$iv;
        String code$iv;
        allOptions = new TreeSet();
        allOptionsByCode = new HashMap();
        EnumSet<Enum> enumSet = EnumSet.of((Enum)ScriptingTask.CREATE_DEFINITION, (Enum)ScriptingTask.CREATE_COMPLETE, (Enum)ScriptingTask.CREATE_BEFORE_IMPORT, (Enum)ScriptingTask.CREATE_AFTER_IMPORT);
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"EnumSet.of(CREATE_DEFINI\u2026ORT, CREATE_AFTER_IMPORT)");
        CREATION_TASKS = enumSet;
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)ScriptingTask.CREATE_DEFINITION, (Enum)ScriptingTask.CREATE_COMPLETE, (Enum)ScriptingTask.CREATE_BEFORE_IMPORT);
        Intrinsics.checkExpressionValueIsNotNull(enumSet2, (String)"EnumSet.of(CREATE_DEFINI\u2026TE, CREATE_BEFORE_IMPORT)");
        CREATION_FIRST_TASKS = enumSet2;
        EnumSet<ScriptingTask> enumSet3 = EnumSet.allOf(ScriptingTask.class);
        Intrinsics.checkExpressionValueIsNotNull(enumSet3, (String)"EnumSet.allOf(ScriptingTask::class.java)");
        ALL_TASKS = enumSet3;
        String string = "UseSurrogates";
        String string2 = "Use surrogate (auto-generated) names";
        Set<Rdbms> set = ModelFun.KNOWN_RDBMS;
        Set<ScriptingTask> set2 = CREATION_TASKS;
        boolean bl = false;
        List items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        ScriptingOption<Boolean> o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, (boolean)defaultValue$iv22);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CONSIDER_SURROGATE_NAMES = o$iv;
        code$iv = "QualifyWithSchema";
        displayName$iv = "Qualify objects with schema names";
        applicableRdbms$iv = ModelFun.ALL_RDBMS;
        applicableTasks$iv = ALL_TASKS;
        Enum defaultValue$iv22 = AutoNeverAlways.AUTO;
        KClass valueClass$iv = Reflection.getOrCreateKotlinClass(AutoNeverAlways.class);
        List items$iv2 = ArraysKt.toList((Object[])JvmClassMappingKt.getJavaClass((KClass)valueClass$iv).getEnumConstants());
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        ScriptingOption<Enum> o$iv2 = new ScriptingOption<Enum>(ScriptingOptionStatic.orderCounter, valueClass$iv, formalName$iv, displayName$iv, applicableRdbms$iv, applicableTasks$iv, items$iv2, defaultValue$iv22);
        ScriptingOptionStatic.allOptions.add(o$iv2);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv2.getCode(), o$iv2);
        CONSIDER_SCHEMA_NAME = o$iv2;
        formalName$iv = "CreateOrReplace";
        displayName$iv = "Use \"create or replace\" syntax";
        applicableRdbms$iv = SetsKt.setOf((Object[])new Rdbms[]{Oracle.RDBMS, Postgres.RDBMS, H2db.RDBMS});
        applicableTasks$iv = CREATION_TASKS;
        boolean defaultValue$iv = false;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CREATE_OR_REPLACE = o$iv;
        code$iv = "CreateIfNotExists";
        displayName$iv = "Use \"create\u2026 if not exists\" syntax";
        applicableRdbms$iv = SetsKt.setOf((Object[])new Rdbms[]{Postgres.RDBMS, Mysql.RDBMS});
        applicableTasks$iv = CREATION_TASKS;
        defaultValue$iv = false;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CREATE_IF_NOT_EXISTS = o$iv;
        code$iv = "CurrentSequenceValue";
        displayName$iv = "Specify \"start with\u2026\" for sequences";
        applicableRdbms$iv = SetsKt.setOf((Object)Oracle.RDBMS);
        applicableTasks$iv = CREATION_FIRST_TASKS;
        defaultValue$iv = false;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CONSIDER_CURRENT_SEQUENCE_VALUE = o$iv;
        code$iv = "ConstraintContext";
        displayName$iv = "Place constraints";
        applicableRdbms$iv = ModelFun.ALL_RDBMS;
        applicableTasks$iv = CREATION_FIRST_TASKS;
        Enum defaultValue$iv3 = ScriptingConstraintContext.CONSTRAINT_IN_COLUMN;
        valueClass$iv = Reflection.getOrCreateKotlinClass(ScriptingConstraintContext.class);
        items$iv2 = ArraysKt.toList((Object[])JvmClassMappingKt.getJavaClass((KClass)valueClass$iv).getEnumConstants());
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv2 = new ScriptingOption<Enum>(ScriptingOptionStatic.orderCounter, valueClass$iv, formalName$iv, displayName$iv, applicableRdbms$iv, applicableTasks$iv, items$iv2, defaultValue$iv3);
        ScriptingOptionStatic.allOptions.add(o$iv2);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv2.getCode(), o$iv2);
        SCRIPTING_CONSTRAINT_CONTEXT = o$iv2;
        formalName$iv = "ConsiderKeys";
        displayName$iv = "Consider (non-clustered) keys";
        applicableRdbms$iv = SetsKt.setOf((Object)Oracle.RDBMS);
        applicableTasks$iv = SetsKt.setOf((Object[])new ScriptingTask[]{ScriptingTask.ENABLE_CONSTRAINTS, ScriptingTask.DISABLE_CONSTRAINTS});
        defaultValue$iv = false;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CONSIDER_KEYS = o$iv;
        code$iv = "ConsiderForeignKeys";
        displayName$iv = "Consider foreign keys";
        applicableRdbms$iv = SetsKt.setOf((Object[])new Rdbms[]{Oracle.RDBMS, Mssql.RDBMS});
        applicableTasks$iv = SetsKt.setOf((Object[])new ScriptingTask[]{ScriptingTask.ENABLE_CONSTRAINTS, ScriptingTask.DISABLE_CONSTRAINTS});
        defaultValue$iv = true;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CONSIDER_FOREIGN_KEYS = o$iv;
        code$iv = "ConsiderChecks";
        displayName$iv = "Consider check constraints";
        applicableRdbms$iv = SetsKt.setOf((Object[])new Rdbms[]{Oracle.RDBMS, Mssql.RDBMS});
        applicableTasks$iv = SetsKt.setOf((Object[])new ScriptingTask[]{ScriptingTask.ENABLE_CONSTRAINTS, ScriptingTask.DISABLE_CONSTRAINTS});
        defaultValue$iv = true;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CONSIDER_CHECKS = o$iv;
        code$iv = "ConsiderRules";
        displayName$iv = "Consider rules";
        applicableRdbms$iv = SetsKt.setOf((Object)Postgres.RDBMS);
        applicableTasks$iv = SetsKt.setOf((Object[])new ScriptingTask[]{ScriptingTask.ENABLE_CONSTRAINTS, ScriptingTask.DISABLE_CONSTRAINTS});
        defaultValue$iv = true;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CONSIDER_RULES = o$iv;
        code$iv = "ConsiderTriggers";
        displayName$iv = "Consider triggers";
        applicableRdbms$iv = ModelFun.KNOWN_RDBMS;
        applicableTasks$iv = SetsKt.setOf((Object[])new ScriptingTask[]{ScriptingTask.ENABLE_CONSTRAINTS, ScriptingTask.DISABLE_CONSTRAINTS});
        defaultValue$iv = true;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        CONSIDER_TRIGGERS = o$iv;
        code$iv = "Varchar2Varchar";
        displayName$iv = "Use VARCHAR instead of VARCHAR2";
        applicableRdbms$iv = SetsKt.setOf((Object)Oracle.RDBMS);
        applicableTasks$iv = SetsKt.setOf((Object[])new ScriptingTask[]{ScriptingTask.CREATE_COMPLETE, ScriptingTask.CREATE_DEFINITION, ScriptingTask.CREATE_BEFORE_IMPORT, ScriptingTask.EXECUTE});
        defaultValue$iv = false;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        VARCHAR2_TO_VARCHAR = o$iv;
        code$iv = "IfExists";
        displayName$iv = "Use \"if exists\" syntax";
        applicableRdbms$iv = SetsKt.setOf((Object)Postgres.RDBMS);
        applicableTasks$iv = SetsKt.setOf((Object)((Object)ScriptingTask.DISABLE_CONSTRAINTS));
        defaultValue$iv = false;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        IF_EXISTS = o$iv;
        code$iv = "UseSystemProc";
        displayName$iv = "Use system procedures";
        applicableRdbms$iv = SetsKt.setOf((Object)Oracle.RDBMS);
        applicableTasks$iv = SetsKt.setOf((Object[])new ScriptingTask[]{ScriptingTask.REFRESH, ScriptingTask.RECOMPILE});
        defaultValue$iv = false;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, (Set<? extends ScriptingTask>)applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        USE_SYSTEM_PROCEDURES = o$iv;
        code$iv = "Reformat";
        displayName$iv = "Reformat generated code";
        applicableRdbms$iv = ModelFun.ALL_RDBMS;
        applicableTasks$iv = ALL_TASKS;
        defaultValue$iv = false;
        items$iv = CollectionsKt.listOf((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
        ScriptingOptionStatic.orderCounter = ScriptingOptionStatic.orderCounter + 1;
        o$iv = new ScriptingOption<Boolean>(ScriptingOptionStatic.orderCounter, Reflection.getOrCreateKotlinClass(Boolean.TYPE), code$iv, displayName$iv, applicableRdbms$iv, applicableTasks$iv, items$iv, defaultValue$iv);
        ScriptingOptionStatic.allOptions.add(o$iv);
        ScriptingOptionStatic.allOptionsByCode.put(o$iv.getCode(), o$iv);
        REFORMAT = o$iv;
        NavigableSet navigableSet = Collections.unmodifiableNavigableSet((NavigableSet)allOptions);
        Intrinsics.checkExpressionValueIsNotNull(navigableSet, (String)"java.util.Collections.un\u2026eNavigableSet(allOptions)");
        SCRIPTING_OPTIONS = navigableSet;
    }
}

