/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.sqlite.SqliteCheck;
import com.intellij.database.model.sqlite.SqliteIndex;
import com.intellij.database.model.sqlite.SqliteKey;
import com.intellij.database.model.sqlite.SqliteModel;
import com.intellij.database.model.sqlite.SqliteRoot;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.model.sqlite.SqliteTable;
import com.intellij.database.model.sqlite.SqliteTableColumn;
import com.intellij.database.model.sqlite.SqliteVirtualTable;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.SqliteNamingService;
import com.intellij.database.scripting.SqliteScriptingService;
import com.intellij.database.scripting.SqliteScriptingService$SqliteCreatingGenerator$WhenMappings;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u0012\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00180\bR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\t\u001a\u00020\nH\u0014J\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/SqliteScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/sqlite/SqliteModel;", "Lcom/intellij/database/model/sqlite/SqliteRoot;", "Lcom/intellij/database/model/sqlite/SqliteSchema;", "model", "(Lcom/intellij/database/model/sqlite/SqliteModel;)V", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "init", "", "init$database_scripting", "script", "", "d", "Lcom/intellij/database/model/DataType;", "SqliteCreatingGenerator", "VERSION", "database-scripting"})
public final class SqliteScriptingService
extends AbstractScriptingService<SqliteModel, SqliteRoot, SqliteSchema> {
    @Override
    public void init$database_scripting() {
        super.init$database_scripting();
        this.setNaming(SqliteNamingService.INSTANCE);
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new SqliteCreatingGenerator(task);
    }

    @Override
    @NotNull
    protected String script(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        if (d == DataType.UNKNOWN) {
            return "";
        }
        return super.script(d);
    }

    public SqliteScriptingService(@NotNull SqliteModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicModel basicModel = model;
        SqliteRoot sqliteRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqliteRoot, (String)"model.root");
        super(basicModel, (BasicDatabase)sqliteRoot);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020$H\u0014J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020\u0016H\u0014J\u0010\u0010(\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/database/scripting/SqliteScriptingService$SqliteCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/sqlite/SqliteModel;", "Lcom/intellij/database/model/sqlite/SqliteRoot;", "Lcom/intellij/database/model/sqlite/SqliteSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/SqliteScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "canGenerateElementRightNow", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateCheck", "", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "generateElement", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "generateOnConflict", "", "onNullConflict", "Lcom/intellij/database/model/properties/SqliteOnConflictAlgorithm;", "generateVirtualTable", "table", "Lcom/intellij/database/model/sqlite/SqliteVirtualTable;", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeNormalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "Lcom/intellij/database/model/basic/BasicTable;", "scriptIndexColumn", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "shouldAddAutoIncToKey", "database-scripting"})
    private final class SqliteCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element instanceof SqliteVirtualTable) {
                this.generateVirtualTable((SqliteVirtualTable)element);
            } else {
                super.generateElement(element);
            }
        }

        private final void generateVirtualTable(SqliteVirtualTable table) {
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
                final /* synthetic */ SqliteCreatingGenerator this$0;
                final /* synthetic */ SqliteVirtualTable $table;

                public final void invoke() {
                    String name = this.this$0.SqliteScriptingService.this.currentScopeName(this.$table);
                    String module = this.$table.getModule();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create virtual table " + name + " using " + module + '(', null, false, 6, null);
                    for (String argument : this.$table.getArguments()) {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), argument, CompositeText.Kind.FIXED_TEXT, false, 4, null);
                        this.this$0.getBuilder().addSuffixToTheLastLine(',');
                    }
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                }
                {
                    this.this$0 = sqliteCreatingGenerator;
                    this.$table = sqliteVirtualTable;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void generateKey(@NotNull BasicKey key2) {
            boolean indexIsExplicit;
            void index;
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            if (!(key2 instanceof SqliteKey)) {
                super.generateKey(key2);
                return;
            }
            String w = ((SqliteKey)key2).isPrimary() ? "primary key" : "unique";
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            if (((SqliteKey)key2).getUnderlyingIndexName() != null) {
                SqliteIndex sqliteIndex;
                void v0 = index;
                BasicNode basicNode = ((SqliteKey)key2).getTable();
                if (basicNode != null && (basicNode = basicNode.getIndices()) != null) {
                    Object v2;
                    void var10_6;
                    block10: {
                        void $receiver$iv;
                        Iterable iterable = (Iterable)((Object)basicNode);
                        var10_6 = v0;
                        for (Object element$iv : $receiver$iv) {
                            SqliteIndex it = (SqliteIndex)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)((SqliteKey)key2).getUnderlyingIndexName())) continue;
                            v2 = element$iv;
                            break block10;
                        }
                        v2 = null;
                    }
                    Object var11_10 = v2;
                    v0 = var10_6;
                    sqliteIndex = var11_10;
                } else {
                    sqliteIndex = null;
                }
                v0.element = sqliteIndex;
            }
            if ((BasicIndex)index.element != null && ((BasicIndex)index.element).getColNames().size() != ((SqliteKey)key2).getColNames().size()) {
                index.element = null;
            }
            boolean bl = indexIsExplicit = (BasicIndex)index.element != null && ((BasicIndex)index.element).getNaturalName() != null && Intrinsics.areEqual((Object)((BasicIndex)index.element).getName(), (Object)((SqliteKey)key2).getName()) ^ true;
            if (indexIsExplicit) {
                Set<BasicElement> set = SqliteScriptingService.this.getGenerated();
                BasicIndex basicIndex = (BasicIndex)index.element;
                if (basicIndex == null) {
                    Intrinsics.throwNpe();
                }
                if (!set.contains(basicIndex)) {
                    this.getPostponed().putValue((Object)((BasicIndex)index.element), (Object)key2);
                    throw (Throwable)new AbortException();
                }
            }
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key2, w, (Ref.ObjectRef)index){
                final /* synthetic */ SqliteCreatingGenerator this$0;
                final /* synthetic */ BasicKey $key;
                final /* synthetic */ String $w;
                final /* synthetic */ Ref.ObjectRef $index;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    boolean autoinc = SqliteCreatingGenerator.access$shouldAddAutoIncToKey(this.this$0, this.$key);
                    switch (SqliteScriptingService$SqliteCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[SqliteCreatingGenerator.access$getContext$p$s526720334(this.this$0).ordinal()]) {
                        case 1: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$key);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                            if (autoinc) {
                                CodeTextBuilder.append$default(this.this$0.getBuilder(), " autoincrement", null, false, 6, null);
                            }
                            if ((BasicIndex)this.$index.element == null) break;
                            BasicIndex basicIndex = (BasicIndex)this.$index.element;
                            if (basicIndex == null) {
                                Intrinsics.throwNpe();
                            }
                            if (basicIndex.getReverseColNames().isEmpty()) break;
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), " desc", null, false, 6, null);
                            break;
                        }
                        case 2: {
                            String string;
                            this.this$0.addInnerConstraintNameAndIndent(this.$key);
                            if ((BasicIndex)this.$index.element == null) {
                                void $receiver$iv;
                                Iterable iterable = ((SqliteKey)this.$key).getColNames();
                                SqliteScriptingService this_$iv = this.this$0.SqliteScriptingService.this;
                                string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((AbstractScriptingService)this_$iv){
                                    final /* synthetic */ AbstractScriptingService this$0;

                                    @NotNull
                                    public final String invoke(@NotNull String it) {
                                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                        String $receiver$iv = it;
                                        AbstractScriptingService this_$iv = this.this$0;
                                        return this_$iv.getNaming().nameToScript($receiver$iv);
                                    }
                                    {
                                        this.this$0 = abstractScriptingService;
                                        super(1);
                                    }
                                }), (int)31, null);
                            } else {
                                string = CollectionsKt.joinToString$default((Iterable)((SqliteKey)this.$key).getColNames(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
                                    final /* synthetic */ generateKey.2 this$0;

                                    @NotNull
                                    public final String invoke(String it) {
                                        SqliteCreatingGenerator sqliteCreatingGenerator = this.this$0.this$0;
                                        BasicIndex basicIndex = (BasicIndex)this.this$0.$index.element;
                                        if (basicIndex == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        String string = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                                        return sqliteCreatingGenerator.scriptIndexColumn(basicIndex, string);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                }), (int)31, null);
                            }
                            String columns2 = string;
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w + " (" + columns2 + (autoinc ? " autoincrement" : "") + ")", null, false, 6, null);
                            this.this$0.getBuilder().addSuffixToTheLastLine(',');
                            break;
                        }
                        default: {
                            throw (Throwable)new AbortException();
                        }
                    }
                    if (((SqliteKey)this.$key).getOnConflict() != null) {
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm = ((SqliteKey)this.$key).getOnConflict();
                        if (sqliteOnConflictAlgorithm == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqliteOnConflictAlgorithm), (String)"key.onConflict!!");
                        CodeTextBuilder.append$default(codeTextBuilder, SqliteCreatingGenerator.access$generateOnConflict(this.this$0, sqliteOnConflictAlgorithm), null, false, 6, null);
                    }
                }
                {
                    this.this$0 = sqliteCreatingGenerator;
                    this.$key = basicKey;
                    this.$w = string;
                    this.$index = objectRef;
                    super(0);
                }
            }, 3, null);
            if ((BasicIndex)index.element != null) {
                SqliteScriptingService.this.getGenerated().add((BasicIndex)index.element);
            }
        }

        @Override
        @Nullable
        protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
            return rule != null && Intrinsics.areEqual((Object)((Object)rule), (Object)((Object)CascadeRule.no_action)) ^ true ? rule.keyWord : null;
        }

        @Override
        protected void generateCheck(@NotNull BasicCheck check) {
            Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
            super.generateCheck(check);
            if (check instanceof SqliteCheck && ((SqliteCheck)check).getOnConflict() != null) {
                AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, check){
                    final /* synthetic */ SqliteCreatingGenerator this$0;
                    final /* synthetic */ BasicCheck $check;

                    public final void invoke() {
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm = ((SqliteCheck)this.$check).getOnConflict();
                        if (sqliteOnConflictAlgorithm == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqliteOnConflictAlgorithm), (String)"check.onConflict!!");
                        CodeTextBuilder.append$default(codeTextBuilder, SqliteCreatingGenerator.access$generateOnConflict(this.this$0, sqliteOnConflictAlgorithm), null, false, 6, null);
                    }
                    {
                        this.this$0 = sqliteCreatingGenerator;
                        this.$check = basicCheck;
                        super(0);
                    }
                }, 3, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected String scriptIndexColumn(@NotNull BasicIndex index, @NotNull String column) {
            String string;
            boolean dirs;
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            if (!(index instanceof SqliteIndex)) {
                return super.scriptIndexColumn(index, column);
            }
            CharSequence charSequence = column;
            if (charSequence.length() == 0) {
                return "???";
            }
            Set<String> descendants = ((SqliteIndex)index).getReverseColNames();
            Collection collection = descendants;
            boolean bl = dirs = !collection.isEmpty();
            if (column.charAt(0) == '\u001b') {
                String string2 = column;
                int n = 1;
                int n2 = column.length();
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                void $receiver$iv;
                String string4 = column;
                SqliteScriptingService this_$iv = SqliteScriptingService.this;
                string = this_$iv.getNaming().nameToScript((String)$receiver$iv);
            }
            String s = string;
            String collation = (String)CollectionsKt.getOrNull(((SqliteIndex)index).getColumnCollations(), (int)((SqliteIndex)index).getColNames().indexOf(column));
            if (StringUtil.isNotEmpty((String)collation)) {
                s = s + " collate " + collation;
            }
            if (dirs) {
                s = s + (descendants.contains(column) ? " desc" : " asc");
            }
            return s;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicColumn column) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            if (!(column instanceof SqliteTableColumn)) {
                return super.makeNormalColumnSpecification(column);
            }
            DataType dataType = ((SqliteTableColumn)column).getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
            String specification = SqliteScriptingService.this.script(dataType);
            if (((SqliteTableColumn)column).getCollation() != null) {
                void $receiver$iv;
                void this_$iv;
                StringBuilder stringBuilder = new StringBuilder().append(specification).append(" collate ");
                String string2 = ((SqliteTableColumn)column).getCollation();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                string = string2;
                SqliteScriptingService sqliteScriptingService = SqliteScriptingService.this;
                StringBuilder stringBuilder2 = stringBuilder;
                String string3 = this_$iv.getNaming().nameToScript((String)$receiver$iv);
                specification = stringBuilder2.append(string3).toString();
            }
            if (((SqliteTableColumn)column).getDefaultExpression() != null) {
                specification = specification + " default " + ((SqliteTableColumn)column).getDefaultExpression();
            }
            if (((SqliteTableColumn)column).isNotNull()) {
                specification = specification + " not null";
            }
            SqliteOnConflictAlgorithm onNullConflict = ((SqliteTableColumn)column).getOnNullConflict();
            if (!((SqliteTableColumn)column).isNotNull() && (onNullConflict != null || SqliteScriptingService.this.isNullExplicit(null))) {
                specification = specification + " null";
            }
            if (onNullConflict != null) {
                specification = specification + " " + this.generateOnConflict(onNullConflict);
            }
            String string4 = string = specification;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return ((Object)StringsKt.trim((CharSequence)string4)).toString();
        }

        private final String generateOnConflict(SqliteOnConflictAlgorithm onNullConflict) {
            String string = onNullConflict.toString();
            StringBuilder stringBuilder = new StringBuilder().append("on conflict ");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            return stringBuilder.append(string4).toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldAddAutoIncToKey(BasicKey key2) {
            if (!key2.isPrimary()) return false;
            BasicColumn basicColumn = ModelFun.singleColumn(key2);
            if (!(basicColumn instanceof BasicTableColumn)) {
                basicColumn = null;
            }
            BasicTableColumn basicTableColumn = (BasicTableColumn)basicColumn;
            if (basicTableColumn == null) return false;
            boolean bl = basicTableColumn.isAutoInc();
            if (!bl) return false;
            return true;
        }

        @Override
        protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (!super.canGenerateElementRightNow(element)) {
                return false;
            }
            if (!(element instanceof SqliteKey) || ((SqliteKey)element).getColNames().size() != 1) {
                return true;
            }
            SqliteIndex index = (SqliteIndex)((SqliteKey)element).getUnderlyingIndex();
            if (index == null || index.getColNames().size() != ((SqliteKey)element).getColNames().size()) {
                return true;
            }
            List<String> collations = index.getColumnCollations();
            return collations.isEmpty() || collations.size() == 1 && StringUtil.isEmpty((String)collations.get(0));
        }

        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            HeaderFooter hf = super.makeTableHeaderFooter(table);
            if (table instanceof SqliteTable && ((SqliteTable)table).isWithoutRowId()) {
                hf = new HeaderFooter(hf.getHeader(), "without rowid");
            }
            return hf;
        }

        public SqliteCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }

        public static final /* synthetic */ boolean access$shouldAddAutoIncToKey(SqliteCreatingGenerator $this, @NotNull BasicKey key2) {
            return $this.shouldAddAutoIncToKey(key2);
        }

        @NotNull
        public static final /* synthetic */ ScriptContext access$getContext$p$s526720334(SqliteCreatingGenerator $this) {
            return super.getContext();
        }

        public static final /* synthetic */ void access$setContext$p$s526720334(SqliteCreatingGenerator $this, @NotNull ScriptContext scriptContext) {
            super.setContext(scriptContext);
        }

        @NotNull
        public static final /* synthetic */ String access$generateOnConflict(SqliteCreatingGenerator $this, @NotNull SqliteOnConflictAlgorithm onNullConflict) {
            return $this.generateOnConflict(onNullConflict);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/SqliteScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
            INSTANCE = this;
        }

        static {
            new VERSION();
        }
    }
}

