/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabasePluginId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.generic.GenericModDatabase;
import com.intellij.database.model.generic.GenericModModel;
import com.intellij.database.model.generic.GenericModRoot;
import com.intellij.database.model.generic.GenericModSchema;
import com.intellij.database.model.generic.GenericModTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.TraverserBasedASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DbSqlUtil {
    private static final Logger LOG = Logger.getInstance(DbSqlUtil.class);

    private DbSqlUtil() {
    }

    @Nullable
    public static SqlLanguageDialect findDialectById(@NotNull String id) {
        if (id == null) {
            DbSqlUtil.$$$reportNull$$$0(0);
        }
        return (SqlLanguageDialect)ObjectUtils.tryCast((Object)Language.findLanguageByID((String)id), SqlLanguageDialect.class);
    }

    @NotNull
    public static Collection<SqlLanguageDialect> getSqlDialects() {
        List list = JBIterable.from((Iterable)SqlLanguage.INSTANCE.getDialects()).filter(SqlLanguageDialect.class).toList();
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<SqlLanguageDialect> getTopLevelSqlDialects() {
        List list = JBIterable.from((Iterable)SqlLanguage.INSTANCE.getDialects()).filter(SqlLanguageDialect.class).filter(o -> !(o instanceof InjectableLanguage)).toList();
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static PsiElement getPsiDelegate(@Nullable DasObject info) {
        DasObject delegate = info instanceof DbElement ? ((DbElement)info).getDelegate() : info;
        return delegate instanceof PsiElement ? (PsiElement)delegate : null;
    }

    @Nullable
    public static SqlLanguageDialect getSqlDialect(@Nullable PsiElement element) {
        SqlLanguageDialect language;
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof SqlFile) {
            language = ((SqlFile)containingFile).getSqlLanguage();
        } else if (containingFile instanceof DummyHolder) {
            language = containingFile.getLanguage();
        } else {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            language = LanguageUtil.getLanguageForPsi((Project)element.getProject(), (VirtualFile)virtualFile);
        }
        return language instanceof SqlLanguageDialect ? language : null;
    }

    @NotNull
    public static Condition<VirtualFile> SQL_FILE_FILTER(Project project) {
        if (project == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtil.$$$reportNull$$$0(3);
            }
            return condition;
        }
        Condition condition = file -> {
            ObjectKind kind;
            if (!file.isValid()) {
                return false;
            }
            ObjectKind objectKind = !(file instanceof DatabaseElementVirtualFileImpl) ? null : (kind = ((DatabaseElementVirtualFileImpl)((Object)file)).isBusy() ? ObjectKind.NONE : ((DatabaseElementVirtualFileImpl)((Object)file)).getObjectKind());
            if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
                return false;
            }
            return file.getFileType() == SqlFileType.INSTANCE || LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == SqlFileType.INSTANCE;
        };
        if (condition == null) {
            DbSqlUtil.$$$reportNull$$$0(4);
        }
        return condition;
    }

    @Nullable
    public static <T> T getSqlFileAttributeAt(@NotNull PsiFile file, @NotNull Key<T> attr, int offset) {
        SqlFile sqlFile;
        if (file == null) {
            DbSqlUtil.$$$reportNull$$$0(5);
        }
        if (attr == null) {
            DbSqlUtil.$$$reportNull$$$0(6);
        }
        return (T)((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)file, SqlFile.class)) != null ? sqlFile.getAttributeAt(attr, offset) : null);
    }

    @NotNull
    public static String getDelimiterAt(@Nullable PsiFile file, int offset) {
        String delim = file == null ? null : (String)DbSqlUtil.getSqlFileAttributeAt(file, SqlFileAttributes.DELIMITER, offset);
        String string = StringUtil.notNullize((String)delim, (String)";");
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean delimiterNeedsSpacing(@NotNull String delim) {
        if (delim == null) {
            DbSqlUtil.$$$reportNull$$$0(8);
        }
        return !delim.equals(";");
    }

    @NotNull
    public static String sql2Html(@NotNull Project project, @NotNull Language language, @NotNull CharSequence sequence) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(9);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(10);
        }
        if (sequence == null) {
            DbSqlUtil.$$$reportNull$$$0(11);
        }
        DdlBuilder.Colored colored = new DdlBuilder.Colored();
        GenericDialect dialect = language instanceof SqlLanguageDialect ? (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect() : GenericDialect.INSTANCE;
        colored.withDialect(dialect);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, null);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(sequence);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            boolean pushed = false;
            IElementType type = lexer.getTokenType();
            if (type != null && (keys = highlighter.getTokenHighlights(type)).length > 0) {
                pushed = true;
                colored.pushStyle(keys[0]);
            }
            colored.plain(StringUtil.escapeXml((String)lexer.getTokenText()));
            lexer.advance();
            if (!pushed) continue;
            colored.popStyle();
        }
        String string = colored.getStatement();
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static List<String> getQueries(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(14);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(15);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        Ref model = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                DbSqlUtil.$$$reportNull$$$0(71);
            }
            if (language == null) {
                DbSqlUtil.$$$reportNull$$$0(72);
            }
            if (text2 == null) {
                DbSqlUtil.$$$reportNull$$$0(73);
            }
            PsiFile psi = PsiFileFactory.getInstance((Project)project).createFileFromText("fake.sql", language, (CharSequence)text2);
            model.set((Object)facade.createScriptModel(psi));
        }, ModalityState.any());
        List list = ((ScriptModel)model.get()).statements().transform(ScriptModelUtil.TO_TEXT).toList();
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForResolve(@NotNull PsiFile sqlFile) {
        if (sqlFile == null) {
            DbSqlUtil.$$$reportNull$$$0(17);
        }
        JBIterable<DbDataSource> jBIterable = DbSqlUtil.getAppropriateDataSources(sqlFile, true, false);
        if (jBIterable == null) {
            DbSqlUtil.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull PsiFile sqlFile, boolean forResolve, boolean matchingOnly) {
        JBIterable sqlDataSources;
        if (sqlFile == null) {
            DbSqlUtil.$$$reportNull$$$0(19);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)sqlFile.getProject());
        boolean isReadonly = sqlFile instanceof PsiFileWithStubSupport && ((PsiFileWithStubSupport)sqlFile).getStubTree() == null && sqlFile.getNode() instanceof TraverserBasedASTNode;
        SqlLanguageDialect sqlDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.getSqlDialect((PsiElement)sqlFile), (Object)DbSqlUtil.getGenericDialect());
        JBIterable resultAll = JBIterable.from((Iterable)facade.getDataSources()).filter(ds -> (!isReadonly || !(ds instanceof SqlDataSource)) && ds.isValid());
        JBIterable resultSelected = resultAll.filter(ds -> DbImplUtil.getDatabaseDialect((DbElement)ds) == sqlDialect.getDatabaseDialect());
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)sqlFile);
        if (!isReadonly && forResolve && virtualFile != null && virtualFile.getFileType() == SqlFileType.INSTANCE && !(sqlDataSources = resultAll.filterMap(o -> o.getDelegate() instanceof SqlDataSource ? o : null).filter(o -> ((SqlDataSource)o.getDelegate()).containsFile(virtualFile)).collect()).isEmpty()) {
            JBIterable jBIterable = sqlDataSources;
            if (jBIterable == null) {
                DbSqlUtil.$$$reportNull$$$0(20);
            }
            return jBIterable;
        }
        JBIterable jBIterable = !matchingOnly && resultSelected.isEmpty() ? resultAll : resultSelected;
        if (jBIterable == null) {
            DbSqlUtil.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @Nullable
    public static DbElement findAnyContext(@NotNull Project project, @NotNull DatabaseSystem dataSource, @Nullable ObjectPath path) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(22);
        }
        if (dataSource == null) {
            DbSqlUtil.$$$reportNull$$$0(23);
        }
        DatabaseElementVirtualFileImpl namespaceFile = DatabaseElementVirtualFileImpl.findFile(project, dataSource, path);
        DbElement namespace = null;
        if (namespaceFile != null) {
            namespace = namespaceFile.findElement();
        }
        if (namespace == null) {
            namespace = DbImplUtil.getDbDataSource(project, dataSource);
        }
        return namespace;
    }

    @Nullable
    public static DasTable detectTable(@NotNull Project project, @NotNull Language language, @Nullable DbElement context, @Nullable String queryText, @Nullable DataRequest request, @NotNull List<DataConsumer.Column> columns2) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(24);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(25);
        }
        if (columns2 == null) {
            DbSqlUtil.$$$reportNull$$$0(26);
        }
        DataConsumer.Column tableColumn = null;
        if (!columns2.isEmpty()) {
            for (DataConsumer.Column column : columns2) {
                if (StringUtil.isNotEmpty((String)column.table) && (tableColumn == null || Comparing.equal((String)column.catalog, (String)tableColumn.catalog) && Comparing.equal((String)column.schema, (String)tableColumn.schema) && Comparing.equal((String)column.table, (String)tableColumn.table))) {
                    tableColumn = column;
                    continue;
                }
                tableColumn = null;
                break;
            }
        }
        DasTable table = null;
        if (language instanceof SqlLanguageDialect && queryText != null) {
            SqlTableType type = request instanceof ConsoleDataRequest && ((ConsoleDataRequest)request).resultType instanceof SqlTableType ? (SqlTableType)((ConsoleDataRequest)request).resultType : DbSqlUtil.parseQueryType(project, (SqlLanguageDialect)language, context, queryText, null);
            PsiElement element = type == null ? null : type.getTypeElement();
            DasTable dasTable = table = element instanceof DasTable ? (DasTable)element : null;
            if (table == null && element instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref = (SqlReferenceExpression)element;
                String name = ref.getReferencePart(ObjectKind.TABLE);
                String refSchema = ref.getReferencePart(ObjectKind.SCHEMA);
                String refCatalog = ref.getReferencePart(ObjectKind.DATABASE);
                String schema = refSchema.isEmpty() && tableColumn != null && tableColumn.schema != null ? tableColumn.schema : refSchema;
                String catalog = refCatalog.isEmpty() && tableColumn != null && tableColumn.catalog != null ? tableColumn.catalog : refCatalog;
                table = (DasTable)DialectUtils.withNewModel(UnknownDatabase.RDBMS, GenericModModel.class, GenericModRoot.class, root2 -> (GenericModTable)DialectUtils.create(((GenericModSchema)DialectUtils.create(((GenericModDatabase)DialectUtils.create(root2.getDatabases(), catalog)).getSchemas(), schema)).getTables(), name));
            }
        }
        if (tableColumn != null && table != null) {
            String catalog;
            DatabaseFamilyId familyId = ((SqlLanguageDialect)language).getDatabaseDialect().getFamilyId();
            String schema = familyId.isMysql() ? DasUtil.NO_NAME : DasUtil.getSchema(table);
            String string = catalog = familyId.isMysql() ? DasUtil.getSchema(table) : DasUtil.getCatalog(table);
            if (StringUtil.isNotEmpty((String)tableColumn.table) && !table.getName().equals(tableColumn.table) || StringUtil.isNotEmpty((String)tableColumn.schema) && !schema.equals(tableColumn.schema) || StringUtil.isNotEmpty((String)tableColumn.catalog) && !catalog.isEmpty() && !catalog.equals(tableColumn.catalog)) {
                table = null;
            }
        }
        return table;
    }

    @NotNull
    public static List<DataConsumer.Column> createColumnsFromType(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable String catalog, @Nullable String schema, @NotNull String tableName) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(27);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(28);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(29);
        }
        if (tableName == null) {
            DbSqlUtil.$$$reportNull$$$0(30);
        }
        ArrayList columns2 = ContainerUtil.newArrayListWithCapacity((int)type.getColumnCount());
        List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(project, dialect, type);
        int count2 = type.getColumnCount();
        for (int i2 = 0; i2 < count2; ++i2) {
            String name = columnNames.get(i2);
            String typeName = type.getColumnType(i2).getDisplayName();
            columns2.add(new DataConsumer.Column(i2, name, 1111, typeName, null, 0, 0, catalog, schema, tableName));
        }
        ArrayList arrayList = columns2;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(32);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(33);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(34);
        }
        List<String> columnNames = DbSqlUtil.getColumnNames(type);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(columnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, type, columnNames, duplicates);
        List<String> list = columnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType partType, @NotNull SqlTableType fullType) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(36);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(37);
        }
        if (partType == null) {
            DbSqlUtil.$$$reportNull$$$0(38);
        }
        if (fullType == null) {
            DbSqlUtil.$$$reportNull$$$0(39);
        }
        List<String> partColumnNames = DbSqlUtil.getColumnNames(partType);
        List<String> fullColumnNames = DbSqlUtil.getColumnNames(fullType);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(fullColumnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, partType, partColumnNames, duplicates);
        List<String> list = partColumnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static void makeUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @NotNull List<String> columnNames, @NotNull Set<String> duplicates) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(41);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(42);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(43);
        }
        if (columnNames == null) {
            DbSqlUtil.$$$reportNull$$$0(44);
        }
        if (duplicates == null) {
            DbSqlUtil.$$$reportNull$$$0(45);
        }
        DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(project).withDialect(dialect);
        for (int i2 = 0; i2 < columnNames.size(); ++i2) {
            String name = columnNames.get(i2);
            String typeAlias = type.getColumnTypeAlias(i2);
            if (duplicates.contains(name) && typeAlias != null) {
                builder.suppressQuoteIdentifiers(!type.isColumnTypeAliasQuoted(i2));
                builder.columnRef(typeAlias).symbol(".");
            }
            builder.suppressQuoteIdentifiers(!type.isColumnQuoted(i2));
            builder.columnRef(name);
            columnNames.set(i2, builder.getStatement());
            builder.clear();
        }
    }

    private static List<String> getColumnNames(SqlTableType type) {
        ArrayList columnNames = ContainerUtil.newArrayListWithCapacity((int)type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            columnNames.add(StringUtil.notNullize((String)type.getColumnName(i2)));
        }
        return columnNames;
    }

    private static Set<String> getDuplicateNames(List<String> names) {
        THashSet duplicates = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        THashSet distinctNames = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (String name : names) {
            if (distinctNames.add(name)) continue;
            duplicates.add(name);
        }
        return duplicates;
    }

    @NotNull
    public static List<PsiElement> resolveToColumnList(@NotNull SqlReferenceExpression ref) {
        String text2;
        if (ref == null) {
            DbSqlUtil.$$$reportNull$$$0(46);
        }
        if (!"*".equals(text2 = StringUtil.notNullize((String)ref.getText())) && !text2.endsWith(".*")) {
            PsiElement resolve = ref.getReference().resolve();
            List<Object> list = resolve == null ? Collections.emptyList() : Collections.singletonList(resolve);
            if (list == null) {
                DbSqlUtil.$$$reportNull$$$0(47);
            }
            return list;
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        if (type == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                DbSqlUtil.$$$reportNull$$$0(48);
            }
            return list;
        }
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            res.add(type.getColumnElement(i2));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    @Nullable
    public static SqlResultSetExpression parseQuery(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull String queryText, SqlReader sqlReader) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(50);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(51);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(52);
        }
        SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)project);
        SqlFile sql = (sqlReader != null ? sqlReader : psiFacade.createSqlReader()).getReadOnlyPsi(language, (CharSequence)queryText);
        SyntaxTraverser traverser = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sql);
        SqlResultSetExpression queryExpression = (SqlResultSetExpression)traverser.filter(SqlResultSetExpression.class).first();
        if (queryExpression == null || queryExpression.getTextRange().getStartOffset() != 0) {
            return null;
        }
        SqlSelectIntoClause selectIntoClause = (SqlSelectIntoClause)traverser.filter(SqlSelectIntoClause.class).first();
        if (selectIntoClause != null) {
            return null;
        }
        return queryExpression;
    }

    @Nullable
    public static SqlTableType parseQueryType(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable DbElement context, @NotNull String queryText, @Nullable SqlReader sqlReader) {
        SqlType sqlType;
        SqlResultSetExpression sql;
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(53);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(54);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(55);
        }
        if ((sql = DbSqlUtil.parseQuery(project, dialect, queryText, sqlReader)) == null) {
            return null;
        }
        if (context != null) {
            sql.getContainingFile().putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)context.getDataSource());
            DasNamespace namespace = (DasNamespace)ObjectUtils.tryCast((Object)context, DasNamespace.class);
            sql.getContainingFile().putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, (Object)SearchPath.of((DasObject)namespace));
        }
        return (sqlType = sql.getSqlType()) instanceof SqlTableType ? (SqlTableType)sqlType : null;
    }

    public static boolean isResultEditable(@Nullable DataRequest request, DasTable detectedTable) {
        DasTable table;
        if (!(request instanceof DataRequest.QueryRequest)) {
            return false;
        }
        if (!(request instanceof ConsoleDataRequest)) {
            return true;
        }
        Object resultType = ((ConsoleDataRequest)request).resultType;
        if (!(resultType instanceof SqlTableType)) {
            return false;
        }
        SqlTableType type = (SqlTableType)resultType;
        PsiElement element = type.getTypeElement();
        Object object = element instanceof DasTable ? (DasTable)element : (table = element instanceof SqlReferenceExpression ? detectedTable : null);
        if (table == null || !DasUtil.getColumns((DasObject)table).iterator().hasNext()) {
            return false;
        }
        return DbImplUtil.isDataTable(table.getKind());
    }

    @Nullable
    public static IntrospectionScopeUpdater getScopeUpdater(@NotNull SyntaxTraverser<PsiElement> s, @Nullable ObjectPath ns, @NotNull DasModel model) {
        ObjectName objectName;
        ObjectKind kind;
        if (s == null) {
            DbSqlUtil.$$$reportNull$$$0(56);
        }
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(57);
        }
        IntrospectionScopeUpdater res = null;
        ObjectName db = ns != null ? DbSqlUtil.getCurrentDatabase(ns) : DbSqlUtil.getCurrentDatabase(model);
        for (SqlSynonymDefinition statement : ((SyntaxTraverser)s.expand(Conditions.instanceOf(SqlAlterStatement.class))).filter(SqlSynonymDefinition.class)) {
            kind = statement.getKind();
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            SqlNameElement newName = statement.getNameElement();
            SqlReferenceExpression oldName = statement.getTargetReference();
            if (newName == null || oldName == null) continue;
            if (res == null) {
                res = new IntrospectionScopeUpdater();
            }
            ObjectName oldObjectName = new ObjectName(oldName.getName(), oldName.isQuotedIdentifier());
            ObjectName newObjectName = new ObjectName(newName.getName(), newName.isQuotedIdentifier());
            if (kind == ObjectKind.DATABASE) {
                res.toRemove(oldObjectName, null);
                res.toAdd(newObjectName, null);
                continue;
            }
            res.toRemove(db, oldObjectName);
            res.toAdd(db, newObjectName);
        }
        for (SqlSynonymDefinition statement : s.filter(SqlCreateStatement.class)) {
            SqlNameElement element;
            kind = statement.getKind();
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA || (element = statement.getNameElement()) == null) continue;
            if (res == null) {
                res = new IntrospectionScopeUpdater();
            }
            objectName = new ObjectName(element.getName(), element.isQuotedIdentifier());
            if (kind == ObjectKind.DATABASE) {
                res.toAdd(objectName, null);
                continue;
            }
            res.toAdd(db, objectName);
        }
        for (SqlSynonymDefinition statement : s.filter(SqlDropStatement.class)) {
            ObjectKind kind2;
            SqlReferenceExpression expression = statement.getTargetExpression();
            if (expression == null || (kind2 = expression.getReferenceElementType().getTargetKind()) != ObjectKind.DATABASE && kind2 != ObjectKind.SCHEMA) continue;
            if (res == null) {
                res = new IntrospectionScopeUpdater();
            }
            objectName = new ObjectName(expression.getName(), expression.isQuotedIdentifier());
            if (kind2 == ObjectKind.DATABASE) {
                res.toRemove(objectName, null);
                continue;
            }
            res.toRemove(db, objectName);
        }
        return res;
    }

    @Nullable
    private static ObjectName getCurrentDatabase(@NotNull DasModel model) {
        DasNamespace cur;
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(58);
        }
        if ((cur = model.getCurrentRootNamespace()) == null) {
            Iterator it = model.getModelRoots().filter(DasNamespace.class).iterator();
            if (!it.hasNext()) {
                return null;
            }
            cur = (DasNamespace)it.next();
            if (it.hasNext()) {
                return null;
            }
        }
        return cur.getKind() == ObjectKind.DATABASE ? ObjectName.quoted((String)cur.getName()) : null;
    }

    @Nullable
    private static ObjectName getCurrentDatabase(@NotNull ObjectPath ns) {
        if (ns == null) {
            DbSqlUtil.$$$reportNull$$$0(59);
        }
        ObjectName db = ObjectName.quoted((String)(ns.kind == ObjectKind.DATABASE ? ns.getName() : (ns.path.size() > 1 ? (String)ns.path.get(ns.path.size() - 2) : null)));
        return db;
    }

    public static ObjectName getName(@Nullable DasObject object) {
        return object == null ? null : new ObjectName(object.getName(), DbSqlUtil.isQuoted(object));
    }

    public static boolean isQuoted(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtil.isQuoted((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlDefinition) {
            return ((SqlDefinition)object).isNameQuoted();
        }
        if (object instanceof SqlNameElement) {
            return DbSqlUtil.isQuoted((SqlNameElement)object);
        }
        if (object instanceof BasicNamedElement) {
            return ((BasicNamedElement)object).isNameQuoted() || !((BasicNamedElement)object).isNameScripted();
        }
        if (object instanceof DeObject) {
            DasObject edited = ((DeObject)object).editedObject;
            boolean unmodified = edited != null && edited.getName().equals(object.getName());
            return unmodified && DbSqlUtil.isQuoted(edited);
        }
        return true;
    }

    public static boolean isSqlObject(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtil.isSqlObject((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlElement) {
            return true;
        }
        if (object instanceof DeObject) {
            return true;
        }
        if (object instanceof BasicNamedElement) {
            return ((BasicNamedElement)object).isNameScripted();
        }
        return false;
    }

    public static boolean isQuoted(@Nullable SqlNameElement element) {
        return element != null && element.isQuotedIdentifier();
    }

    @Nullable
    public static SqlElement getSqlElement(@Nullable DbElement element) {
        DasObject dasObject;
        DasObject dasObject2 = dasObject = element == null ? null : (DasObject)ObjectUtils.tryCast((Object)element.getDelegate(), DasObject.class);
        if (dasObject == null) {
            return null;
        }
        return DbSqlUtil.getSqlElement(element.getDataSource(), dasObject);
    }

    @Nullable
    public static SqlElement getSqlElement(@Nullable DbDataSource dataSource, @Nullable DasObject dasObject) {
        if (dataSource == null || dasObject == null) {
            return null;
        }
        SqlDataSource source = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), SqlDataSource.class);
        return source == null ? null : source.fromModel(dasObject);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DbElement element) {
        DbDataSourceImpl dataSource = element == null ? null : (DbDataSourceImpl)((Object)ObjectUtils.tryCast((Object)element.getDataSource(), DbDataSourceImpl.class));
        SqlLanguageDialect sqlLanguageDialect = dataSource == null ? DbSqlUtil.getGenericDialect() : dataSource.getSqlDialect();
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(60);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        SqlLanguageDialect res;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(61);
        }
        SqlLanguageDialect sqlLanguageDialect = (res = DbSqlUtil.findSqlDialect(dialect)) == null ? DbSqlUtil.getGenericDialect() : res;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(62);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(63);
        }
        if (dialect.getFamilyId() == DatabaseFamilyId.UNKNOWN) {
            return DbSqlUtil.getGenericDialect();
        }
        for (SqlLanguageDialect language : DbSqlUtil.getSqlDialects()) {
            if (language.getDatabaseDialect() != dialect) continue;
            return language;
        }
        return null;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable LocalDataSource dataSource) {
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect(dataSource);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? DbSqlUtil.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(64);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @NotNull DatabaseSystem databaseSystem) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(65);
        }
        if (databaseSystem == null) {
            DbSqlUtil.$$$reportNull$$$0(66);
        }
        if (databaseSystem instanceof DbDataSource) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)((DbDataSource)databaseSystem));
            if (sqlLanguageDialect == null) {
                DbSqlUtil.$$$reportNull$$$0(67);
            }
            return sqlLanguageDialect;
        }
        if (databaseSystem instanceof LocalDataSource) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((LocalDataSource)databaseSystem);
            if (sqlLanguageDialect == null) {
                DbSqlUtil.$$$reportNull$$$0(68);
            }
            return sqlLanguageDialect;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(databaseSystem.getUniqueId());
        SqlLanguageDialect sqlLanguageDialect = dataSource == null ? DbSqlUtil.getGenericDialect() : DbSqlUtil.getSqlDialect((DbElement)dataSource);
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(69);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable LocalDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        String defaultDialect = dataSource.getDefaultDialect();
        SqlLanguageDialect result2 = StringUtil.isEmpty((String)defaultDialect) ? null : DbSqlUtil.findDialectById(defaultDialect);
        return result2 != null ? result2 : DbSqlUtil.guessSqlDialect(dataSource);
    }

    @Nullable
    public static SqlLanguageDialect guessSqlDialect(@Nullable RawConnectionConfig connectionInfo) {
        DatabaseDialectEx dbDialect = connectionInfo == null ? null : DbImplUtil.guessDatabaseDialect(connectionInfo);
        return dbDialect == null ? null : DbSqlUtil.findSqlDialect(dbDialect);
    }

    @NotNull
    public static SqlLanguageDialect getGenericDialect() {
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.findDialectById("GenericSQL"));
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(70);
        }
        return sqlLanguageDialect;
    }

    public static void ensureSqlDialectsLoaded() {
        DbSqlUtil.getGenericDialect();
    }

    private static void initSqlDialects() {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)DatabasePluginId.get());
        LanguageExtensionPoint[] extensions = (LanguageExtensionPoint[])Extensions.getExtensions((ExtensionPointName)new ExtensionPointName("com.intellij.lang.parserDefinition"));
        HashSet<String> dialectIds = new HashSet<String>();
        SqlCommonKeywords.class.getName();
        for (LanguageExtensionPoint parserDefinition : extensions) {
            if (parserDefinition.getPluginDescriptor() != plugin || parserDefinition.implementationClass == null || !StringUtil.startsWith((CharSequence)parserDefinition.implementationClass, (CharSequence)"com.intellij.sql")) continue;
            try {
                parserDefinition.getInstance();
                dialectIds.add(parserDefinition.language);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (!dialectIds.containsAll(Arrays.asList("MySQL", "Oracle", "PostgreSQL", "SQLite", "GenericSQL"))) {
            LOG.error("Required SQL dialects not found among: " + dialectIds);
        }
    }

    public static boolean areKeywordsLowerCase(@Nullable Project project) {
        Case keywordCaseMode;
        SqlCodeStyleSettings codeStyleSettings = null;
        if (project != null) {
            codeStyleSettings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
        }
        if (codeStyleSettings == null) {
            codeStyleSettings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)project));
        }
        return (keywordCaseMode = SqlCodeStyleSettings.getCaseMode((int)codeStyleSettings.KEYWORD_CASE)) == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    static {
        DbSqlUtil.initSqlDialects();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 31: 
            case 35: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 31: 
            case 35: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 31: 
            case 35: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delim";
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 36: 
            case 41: 
            case 50: 
            case 53: 
            case 65: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 15: 
            case 25: 
            case 51: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 13: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 28: 
            case 33: 
            case 37: 
            case 42: 
            case 54: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 29: 
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullType";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialects";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelSqlDialects";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "SQL_FILE_FILTER";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesForResolve";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateDataSources";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsFromType";
                break;
            }
            case 35: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnNames";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToColumnList";
                break;
            }
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDialectById";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 31: 
            case 35: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSqlFileAttributeAt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "delimiterNeedsSpacing";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sql2Html";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForResolve";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateDataSources";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findAnyContext";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "detectTable";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsFromType";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnNames";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "makeUnambiguousColumnNames";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveToColumnList";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "parseQuery";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "parseQueryType";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getScopeUpdater";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDatabase";
                break;
            }
            case 61: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findSqlDialect";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQueries$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 31: 
            case 35: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

