/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseColorManager<T extends SharedColors>
implements PersistentStateComponent<T> {
    private static Key<CachedColor> COLOR_KEY = Key.create((String)"COLOR_KEY");
    private static final SimpleModificationTracker ourModificationTracker = new SimpleModificationTracker();
    protected T myState;

    public static DatabaseColorManager<LocalColors> getLocalColorManager(@NotNull Project project) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(0);
        }
        return (DatabaseColorManager)ServiceManager.getService((Project)project, Local.class);
    }

    public static DatabaseColorManager<SharedColors> getSharedColorManager(@NotNull Project project) {
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(1);
        }
        return (DatabaseColorManager)ServiceManager.getService((Project)project, Shared.class);
    }

    private static long getModCount() {
        return ourModificationTracker.getModificationCount() + UISettings.getInstance().getModificationCount();
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            DatabaseColorManager.$$$reportNull$$$0(2);
        }
        return t;
    }

    public void loadState(T state) {
        this.myState = state;
        if (JBIterable.from(((SharedColors)this.myState).colors.keySet()).find(key2 -> key2.endsWith(":ROOT") || key2.endsWith(":NONE") || key2.endsWith(":data source")) != null) {
            Map<String, String> orig = ((SharedColors)this.myState).colors;
            ((SharedColors)this.myState).colors = ContainerUtil.newHashMap();
            for (String key3 : orig.keySet()) {
                String value = orig.get(key3);
                String newKey = StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)key3, (String)":data source"), (String)":NONE"), (String)":ROOT");
                if (((SharedColors)this.myState).colors.containsKey(newKey)) continue;
                ((SharedColors)this.myState).colors.put(newKey, value);
            }
        }
    }

    @Nullable
    public static Color getColor(@NotNull Project project, @Nullable VirtualFile file, boolean includingAttached) {
        DbElement element;
        if (project == null) {
            DatabaseColorManager.$$$reportNull$$$0(3);
        }
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement tableOrView = DbImplUtil.findElement(project, file);
            element = tableOrView != null ? tableOrView : DbImplUtil.findDataSource(project, file);
        } else {
            JdbcConsole console = DbConsoleRootType.isConsoleFile(file) ? JdbcConsole.getConsole(project, file) : (includingAttached ? JdbcConsoleProvider.getAttachedConsole(project, file) : null);
            DbDataSource dataSource = console == null ? null : DbConsoleRootType.getDataSource(project, console.getLanguageConsole().getVirtualFile());
            element = dataSource == null ? null : DbSqlUtil.findAnyContext(project, (DatabaseSystem)dataSource, console.getCurrentNamespace());
        }
        return DatabaseColorManager.getColor(element);
    }

    @Nullable
    public static Color getColor(@Nullable DbElement element) {
        if (element == null) {
            return null;
        }
        CachedColor info = (CachedColor)COLOR_KEY.get((UserDataHolder)element);
        long modificationCount = DatabaseColorManager.getModCount();
        if (info != null && info.modCount != modificationCount) {
            info = null;
        }
        if (info == null) {
            Color c;
            String colorName = DatabaseColorManager.getColorName(element, null);
            info = new CachedColor();
            info.modCount = modificationCount;
            if (colorName != null && (c = FileColorManager.getInstance((Project)element.getProject()).getColor(colorName)) != null) {
                info.color = c;
            }
            COLOR_KEY.set((UserDataHolder)element, (Object)info);
        }
        return info.color;
    }

    public static void setColorName(@NotNull DbElement element, @Nullable String colorName, boolean recursively, boolean isShared) {
        if (element == null) {
            DatabaseColorManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DatabaseColorManager<LocalColors> localColorManager = DatabaseColorManager.getLocalColorManager(element.getProject());
        Object local = localColorManager.getState();
        Object shared = DatabaseColorManager.getSharedColorManager(element.getProject()).getState();
        String elementId = DatabaseColorManager.getElementId(element);
        boolean changed = ((SharedColors)shared).colors.remove(elementId) != null;
        changed |= ((SharedColors)local).colors.remove(elementId) != null;
        if (colorName != null) {
            boolean doNotChange;
            Ref sharedRef = Ref.create(null);
            boolean bl = doNotChange = !changed && colorName.equals(DatabaseColorManager.getColorName(element, (Ref<Boolean>)sharedRef)) && isShared == Boolean.TRUE.equals(sharedRef.get());
            if (!doNotChange) {
                changed = true;
                ((SharedColors)(isShared ? shared : local)).colors.put(elementId, colorName);
            }
        }
        if (recursively) {
            changed |= DatabaseColorManager.clearChildren(elementId, ((SharedColors)shared).colors);
            changed |= DatabaseColorManager.clearChildren(elementId, ((SharedColors)local).colors);
        }
        if (changed) {
            ourModificationTracker.incModificationCount();
        }
    }

    private static boolean clearChildren(String elementId, Map<String, String> colors) {
        boolean changed = false;
        String id = elementId.substring(0, elementId.lastIndexOf(58) + 1);
        for (String s : ArrayUtil.toStringArray(colors.keySet())) {
            int idx = s.indexOf(id);
            if (idx <= 0 || s.charAt(idx - 1) != '/') continue;
            changed |= colors.remove(s) != null;
        }
        return changed;
    }

    @Nullable
    public static String getColorName(@Nullable DbElement element, Ref<Boolean> sharedRef) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (element == null) {
            return null;
        }
        Object local = DatabaseColorManager.getLocalColorManager(element.getProject()).getState();
        Object shared = DatabaseColorManager.getSharedColorManager(element.getProject()).getState();
        if (((SharedColors)shared).colors.isEmpty() && ((SharedColors)local).colors.isEmpty()) {
            return null;
        }
        for (DbElement e = element; e != null; e = e.getDbParent()) {
            boolean isShared;
            String elementId = DatabaseColorManager.getElementId(e);
            String s = ((SharedColors)local).colors.get(elementId);
            boolean bl = isShared = s == null;
            if (s == null) {
                s = ((SharedColors)shared).colors.get(elementId);
                boolean bl2 = isShared = s != null;
            }
            if (s == null) continue;
            if (sharedRef != null) {
                sharedRef.set((Object)isShared);
            }
            return s;
        }
        return null;
    }

    @NotNull
    private static String getElementId(@NotNull DbElement element) {
        if (element == null) {
            DatabaseColorManager.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        for (DbElement cur = element; cur != null; cur = cur.getDbParent()) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(cur instanceof DbDataSource ? ((DbDataSource)cur).getUniqueId() : DatabaseElementVirtualFileImpl.escape(cur.getName()));
        }
        if (!(element instanceof DbDataSource)) {
            sb.append(":").append(element.getKind().name());
        }
        String string = sb.toString();
        if (string == null) {
            DatabaseColorManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void cleanupColors(Project project) {
        Map local = ((LocalColors)DatabaseColorManager.getLocalColorManager((Project)project).getState()).colors;
        Map<String, String> shared = ((SharedColors)DatabaseColorManager.getSharedColorManager((Project)project).getState()).colors;
        if (local.isEmpty() && shared.isEmpty()) {
            return;
        }
        List dataSources2 = DbPsiFacade.getInstance((Project)project).getDataSources();
        Set existingRoots = JBIterable.from((Iterable)dataSources2).map(o -> o.getUniqueId()).toSet();
        DatabaseColorManager.cleanupColors(local, existingRoots);
        DatabaseColorManager.cleanupColors(shared, existingRoots);
    }

    private static void cleanupColors(Map<String, String> colors, Set<String> roots) {
        block0: for (String s : ArrayUtil.toStringArray(colors.keySet())) {
            for (String root2 : roots) {
                if (!s.contains(root2)) continue;
                continue block0;
            }
            colors.remove(s);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseColorManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseColorManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalColorManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSharedColorManager";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setColorName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedColor {
        Color color;
        long modCount;

        private CachedColor() {
        }
    }

    public static class LocalColors
    extends SharedColors {
        @OptionTag(value="use-colors")
        public boolean useColors = true;
        @OptionTag(value="in-editor-tabs")
        public boolean inEditorTabs = true;
        @OptionTag(value="in-database-view")
        public boolean inDatabaseView = true;
        @OptionTag(value="in-toolbars")
        public boolean useInToolbars = true;
        @OptionTag(value="in-editor")
        public boolean useInEditor = false;
    }

    public static class SharedColors {
        @Tag(value="colors")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, String> colors = ContainerUtil.newHashMap();
    }

    @State(name="DatabaseLocalColorSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
    private static class Local
    extends DatabaseColorManager<LocalColors>
    implements PersistentStateComponent<LocalColors> {
        public Local(final Project project) {
            this.myState = new LocalColors();
            project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosingBeforeSave(@NotNull Project eventProject) {
                    if (eventProject == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (project == eventProject) {
                        DatabaseColorManager.cleanupColors(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventProject", "com/intellij/database/view/DatabaseColorManager$Local$1", "projectClosingBeforeSave"));
                }
            });
        }
    }

    @State(name="DatabaseColorSettings", storages={@Storage(value="databaseColors.xml")})
    private static class Shared
    extends DatabaseColorManager<SharedColors>
    implements PersistentStateComponent<SharedColors> {
        public Shared() {
            this.myState = new SharedColors();
        }
    }
}

