/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseToolWindowFactory;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.DbElementDnDTarget;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.FileEditorSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBPoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@State(name="DatabaseView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DatabaseView
extends SimpleToolWindowPanel
implements PersistentStateComponent<Element>,
Disposable {
    public static final DataKey<DatabaseView> DATABASE_VIEW_KEY = DataKey.create((String)"DATABASE_VIEW_KEY");
    static final String DATABASE_VIEW_POPUP_MENU = "DatabaseViewPopupMenu";
    private final Project myProject;
    private final DbPsiFacade myDbFacade;
    private final Tree myTree;
    private final CopyProvider myCopyProvider;
    private final DatabaseViewOptions myViewOptions = new DatabaseViewOptions();
    private final MyAutoScrollFromSourceHandler myAutoScrollHandler;
    private final DatabaseStructure myStructure;

    public static DatabaseView getDatabaseView(Project project) {
        return (DatabaseView)((Object)ServiceManager.getService((Project)project, DatabaseView.class));
    }

    @NotNull
    static SimpleTextAttributes linkAttrs() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)scheme.getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES));
        if (simpleTextAttributes == null) {
            DatabaseView.$$$reportNull$$$0(0);
        }
        return simpleTextAttributes;
    }

    public DatabaseView(DbPsiFacade dbFacade, JdbcDriverManager jdbcManager) {
        super(true, true);
        this.myProject = dbFacade.getProject();
        this.myDbFacade = dbFacade;
        this.myAutoScrollHandler = new MyAutoScrollFromSourceHandler(this.myProject, this);
        this.myStructure = new DatabaseStructure(dbFacade, this.myViewOptions);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myStructure), true);
        Disposer.register((Disposable)this, (Disposable)asyncTreeModel);
        this.myTree = new DnDAwareTree((TreeModel)asyncTreeModel){
            {
                MyRenderer cellRenderer = new MyRenderer();
                this.setCellRenderer(cellRenderer);
                this.addMouseMotionListener(cellRenderer);
                this.addMouseListener(cellRenderer);
                HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
                UIUtil.putClientProperty((JComponent)((Object)this), (Key)TreeState.VISIT, visitor -> DatabaseView.this.getAsyncModel().accept(visitor, true));
            }

            public int getToggleClickCount() {
                TreePath path = this.getSelectionPath();
                Object object = path == null ? null : path.getLastPathComponent();
                return object instanceof DasSchemaChild ? -1 : super.getToggleClickCount();
            }

            @Nullable
            public Color getFileColorFor(Object object) {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public Color getFileColorForPath(@NotNull TreePath path) {
                DasObject o;
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(DatabaseView.this.getProject()).getState();
                if (!state.useColors || !state.inDatabaseView) {
                    return null;
                }
                DbDataSource dataSource = (DbDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class);
                DbElement e = DbImplUtil.findElement(dataSource, o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class));
                Color color = DatabaseColorManager.getColor(e);
                return color == null ? null : ColorUtil.softer((Color)color);
            }

            public boolean isFileColorsEnabled() {
                DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(DatabaseView.this.getProject()).getState();
                boolean enabled = state.useColors && state.inDatabaseView;
                boolean opaque = DatabaseView.this.myTree.isOpaque();
                if (enabled && opaque) {
                    DatabaseView.this.myTree.setOpaque(false);
                } else if (!enabled && !opaque) {
                    DatabaseView.this.myTree.setOpaque(true);
                }
                return enabled;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/view/DatabaseView$1", "getFileColorForPath"));
            }
        };
        this.initComponents();
        this.myDbFacade.addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade modificationTracker) {
                DatabaseView.this.refreshView();
            }
        }, (Disposable)this);
        jdbcManager.addModificationTrackerListener(new ModificationTrackerListener<JdbcDriverManager>(){

            public void modificationCountChanged(JdbcDriverManager source) {
                DatabaseView.this.refreshView();
            }
        }, this);
        this.enableDnD();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DatabaseSettings.TOPIC, (Object)new DatabaseSettings.Listener(){

            @Override
            public void settingsChanged() {
                DatabaseView.this.refreshView();
            }
        });
        this.myCopyProvider = new TextCopyProvider(){

            @Nullable
            public Collection<String> getTextLinesToCopy() {
                Set selectedElements = JBIterable.of((Object[])DatabaseView.this.myTree.getSelectionPaths()).map(o -> o.getLastPathComponent()).filter(DasObject.class).toSet();
                if (selectedElements.isEmpty()) {
                    return null;
                }
                ArrayList lines = ContainerUtil.newArrayList();
                for (DasObject selectedElement : selectedElements) {
                    String name = selectedElement.getName();
                    if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                    lines.add(name);
                }
                return lines;
            }
        };
    }

    @NotNull
    public DatabaseViewOptions getViewOptions() {
        DatabaseViewOptions databaseViewOptions = this.myViewOptions;
        if (databaseViewOptions == null) {
            DatabaseView.$$$reportNull$$$0(1);
        }
        return databaseViewOptions;
    }

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            DatabaseView.$$$reportNull$$$0(2);
        }
        return tree;
    }

    @NotNull
    public Object getTreeRoot() {
        Object object = this.myStructure.getRoot();
        if (object == null) {
            DatabaseView.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    private AsyncTreeModel getAsyncModel() {
        AsyncTreeModel asyncTreeModel = (AsyncTreeModel)this.myTree.getModel();
        if (asyncTreeModel == null) {
            DatabaseView.$$$reportNull$$$0(4);
        }
        return asyncTreeModel;
    }

    @NotNull
    public JBIterable<Object> getSelectedElements() {
        JBIterable jBIterable = JBIterable.of((Object[])this.myTree.getSelectionPaths()).map(o -> o.getLastPathComponent());
        if (jBIterable == null) {
            DatabaseView.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public static <T extends DbElement> Set<T> getSelectedElements(@NotNull DataContext dataContext, Class<T> aClass) {
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(6);
        }
        Set set = (Set)JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext))).filter(aClass).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
        if (set == null) {
            DatabaseView.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public static JBIterable<DbElement> getSelectedElements(@NotNull DataContext dataContext, boolean useParentForGroups) {
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(8);
        }
        JBIterable elements = JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)));
        JBIterable jBIterable = (!useParentForGroups ? elements : elements.map(o -> {
            if (o instanceof DatabaseStructure.FamilyGroup) {
                return o.getParent();
            }
            return o;
        })).filter(DbElement.class);
        if (jBIterable == null) {
            DatabaseView.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbElement> getSelectedElements(@NotNull DataContext dataContext, @NotNull Condition<DatabaseStructure.Group> expand) {
        JBIterable elements;
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(10);
        }
        if (expand == null) {
            DatabaseView.$$$reportNull$$$0(11);
        }
        JBIterable jBIterable = (elements = JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)))).isEmpty() ? JBIterable.empty() : ((JBTreeTraverser)JBTreeTraverser.from(o -> {
            if (expand == null) {
                DatabaseView.$$$reportNull$$$0(31);
            }
            return o instanceof DatabaseStructure.Group && expand.value((Object)((DatabaseStructure.Group)((Object)o))) ? ((DatabaseStructure.Group)((Object)o)).iterateChildren() : JBIterable.empty();
        }).withRoots((Iterable)elements)).filter(DbElement.class);
        if (jBIterable == null) {
            DatabaseView.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Nullable
    public static DbNamespaceImpl getLowestSchema(@Nullable DbElement element) {
        if (element == null) {
            return null;
        }
        DasObject o = element instanceof DbDataSource ? DatabaseStructure.getTopSingleRoot((DbDataSource)element) : DatabaseStructure.getTopSingleRoot((DasObject)element.getDelegate());
        DbElement result2 = DbImplUtil.findElement(element.getDataSource(), o);
        return result2 instanceof DbNamespaceImpl ? (DbNamespaceImpl)result2 : null;
    }

    private void initComponents() {
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.updateEmptyText();
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch(this.myTree, o -> {
            DatabaseDriver driver;
            DatabaseSystem delegate;
            Object node = o.getLastPathComponent();
            if (node instanceof DbDataSource && (delegate = ((DbDataSource)node).getDelegate()) instanceof LocalDataSource && (driver = ((LocalDataSource)delegate).getDatabaseDriver()) != null && driver.isPredefined()) {
                return driver.getName() + " " + node;
            }
            return String.valueOf(node);
        });
        this.myTree.setRootVisible(false);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)DATABASE_VIEW_POPUP_MENU, (String)"J2EEAttributesViewPopup");
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.setToolbar(this.createToolbar().getComponent());
        this.myAutoScrollHandler.install();
    }

    private void updateEmptyText() {
        String shortcut;
        String emptyText = this.myDbFacade.getDataSources().isEmpty() ? (StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("NewElement")))) ? "Create a data source with " + shortcut : "Create a data source with context menu") : "Loading...";
        this.myTree.getEmptyText().setText(emptyText);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void refreshView() {
        this.updateEmptyText();
        this.myStructure.refreshAll();
    }

    @NotNull
    public final Promise<Void> selectElement(@Nullable Object element) {
        Promise<Void> promise = element == null ? Promises.resolvedPromise() : this.selectElements(Collections.singleton(element));
        if (promise == null) {
            DatabaseView.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @NotNull
    public final Promise<Void> selectElements(@NotNull Collection<?> elements) {
        if (elements == null) {
            DatabaseView.$$$reportNull$$$0(14);
        }
        Promise promise = Promises.collectResults((List)JBIterable.from(elements).map(o -> this.getAsyncModel().getTreePath(DatabaseStructure.unwrap(o))).toList(), (boolean)true).processed(paths -> {
            if (paths != null) {
                TreeUtil.selectPaths((JTree)this.myTree, (Collection)paths);
            }
        }).then(o -> null);
        if (promise == null) {
            DatabaseView.$$$reportNull$$$0(15);
        }
        return promise;
    }

    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)this.myTree);
            DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(), (JComponent)this.myTree);
        }
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        AnAction group2 = ActionManager.getInstance().getAction("DatabaseViewToolbar");
        actionGroup.addAll(((DefaultActionGroup)group2).getChildActionsOrStubs());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)actionGroup, true);
        toolbar.setTargetComponent((JComponent)this.myTree);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            DatabaseView.$$$reportNull$$$0(16);
        }
        return actionToolbar;
    }

    public void dispose() {
    }

    public void setupToolWindow(ToolWindowEx toolWindow) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        DatabaseViewOptions opts = this.myViewOptions;
        group2.addAction((AnAction)DatabaseViewActions.toggle("Group Data Sources", (Getter<Boolean>)((Getter)() -> opts.GROUP_DATA_SOURCES), (Setter<Boolean>)((Setter)b -> {
            opts.GROUP_DATA_SOURCES = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Group Schema", (Getter<Boolean>)((Getter)() -> opts.GROUP_SCHEMA), (Setter<Boolean>)((Setter)b -> {
            opts.GROUP_SCHEMA = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Group Contents", (Getter<Boolean>)((Getter)() -> opts.GROUP_CONTENTS), (Setter<Boolean>)((Setter)b -> {
            opts.GROUP_CONTENTS = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Show Keys && etc.", (Getter<Boolean>)((Getter)() -> opts.SHOW_TABLE_DETAILS), (Setter<Boolean>)((Setter)b -> {
            opts.SHOW_TABLE_DETAILS = b;
        }), this::refreshView, (Consumer<Presentation>)((Consumer)p -> p.setVisible(!opts.GROUP_CONTENTS))));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Show Empty Groups", (Getter<Boolean>)((Getter)() -> opts.SHOW_EMPTY_GROUPS), (Setter<Boolean>)((Setter)b -> {
            opts.SHOW_EMPTY_GROUPS = b;
        }), this::refreshView, (Consumer<Presentation>)((Consumer)p -> p.setVisible(opts.GROUP_CONTENTS || opts.GROUP_SCHEMA))));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Show Intermediate Nodes", (Getter<Boolean>)((Getter)() -> opts.SHOW_INTERMEDIATE), (Setter<Boolean>)((Setter)b -> {
            opts.SHOW_INTERMEDIATE = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Sort Alphabetically", (Getter<Boolean>)((Getter)() -> opts.SORT_POSITIONED), (Setter<Boolean>)((Setter)b -> {
            opts.SORT_POSITIONED = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll from Editor", (Getter<Boolean>)((Getter)this.myAutoScrollHandler::isAutoScrollEnabled), (Setter<Boolean>)((Setter)this.myAutoScrollHandler::setAutoScrollEnabled)));
        group2.addAction((AnAction)JdbcConsole.createToggleConsoleToolbarAction(this.myProject)).setAsSecondary(true);
        toolWindow.setAdditionalGearActions((ActionGroup)group2);
        DumbAwareAction consoleTitleAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(!DatabaseView.this.isToolbarVisible());
            }

            public void actionPerformed(AnActionEvent e) {
                JBIterable.of((Object[])DatabaseView.this.myTree.getSelectionPaths()).map(path -> (DbDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class)).filter(Conditions.notNull()).unique().forEach(dataSource -> DatabaseEditorHelper.openConsoleFile((DbElement)dataSource));
            }
        };
        consoleTitleAction.copyFrom(ActionManager.getInstance().getAction("Jdbc.OpenConsole"));
        consoleTitleAction.getTemplatePresentation().setIcon(DatabaseIcons.ConsoleRun);
        consoleTitleAction.getTemplatePresentation().setHoveredIcon(DatabaseIcons.ConsoleRunHover);
        DumbAwareAction refreshTitleAction = new DumbAwareAction(){
            final AnAction baseAction = ActionManager.getInstance().getAction("DatabaseView.SynchronizeAction");
            {
                this.copyFrom(this.baseAction);
                this.getTemplatePresentation().setIcon(DatabaseIcons.SchemaRefresh);
                this.getTemplatePresentation().setHoveredIcon(DatabaseIcons.SchemaRefreshHover);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(!DatabaseView.this.isToolbarVisible());
            }

            public void actionPerformed(AnActionEvent e) {
                this.baseAction.actionPerformed(new AnActionEvent(e.getInputEvent(), DataManager.getInstance().getDataContext((Component)((Object)DatabaseView.this)), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
            }
        };
        DumbAwareAction scrollFromEditorAction = new DumbAwareAction("Scroll from Editor", "Select database element open in the active editor", AllIcons.General.Locate){

            public void actionPerformed(AnActionEvent e) {
                FileEditor fileEditor;
                EditorWindow window = FileEditorManagerEx.getInstanceEx((Project)DatabaseView.this.myProject).getCurrentWindow();
                EditorWithProviderComposite editorComposite = window == null ? null : window.getSelectedEditor();
                FileEditor fileEditor2 = fileEditor = editorComposite == null ? null : (FileEditor)editorComposite.getSelectedEditorWithProvider().first;
                if (fileEditor == null) {
                    return;
                }
                DatabaseView.this.myAutoScrollHandler.selectElementFromEditorInner(fileEditor, true);
            }
        };
        scrollFromEditorAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.LocateHover);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        toolWindow.setTitleActions(new AnAction[]{refreshTitleAction, consoleTitleAction, scrollFromEditorAction, actionsManager.createCollapseAllHeaderAction((JTree)this.myTree)});
    }

    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        if (DATABASE_VIEW_KEY.is(dataId)) {
            return this;
        }
        if (DatabaseDataKeys.DB_PSI_FACADE.is(dataId)) {
            return this.myDbFacade;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.tools.datasource";
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            Collection c = this.getDataFromSelectedPaths(CommonDataKeys.PSI_ELEMENT);
            if (c.isEmpty()) {
                return null;
            }
            if (JBIterable.from(c).filter(DbDataSource.class).size() == c.size()) {
                return new DdlActions.DeleteProvider1();
            }
            return new DdlActions.DeleteProvider2();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyProvider;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            Collection<PsiElement> c = this.getDataFromSelectedPaths(CommonDataKeys.PSI_ELEMENT);
            return c.isEmpty() ? null : c.toArray(new PsiElement[c.size()]);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Collection<Navigatable> c = this.getDataFromSelectedPaths(CommonDataKeys.NAVIGATABLE);
            return c.isEmpty() ? null : c.toArray(new Navigatable[c.size()]);
        }
        return DatabaseView.getDataFromPath(dataId, this.myProject, this.myTree.getSelectionPath());
    }

    @NotNull
    private <T> Collection<T> getDataFromSelectedPaths(@NotNull DataKey<T> key2) {
        TreePath[] paths;
        if (key2 == null) {
            DatabaseView.$$$reportNull$$$0(17);
        }
        if ((paths = this.myTree.getSelectionPaths()) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DatabaseView.$$$reportNull$$$0(18);
            }
            return list;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (TreePath path : paths) {
            ContainerUtil.addIfNotNull((Collection)result2, DatabaseView.getDataFromPath(key2.getName(), this.myProject, path));
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            DatabaseView.$$$reportNull$$$0(19);
        }
        return linkedHashSet;
    }

    private static <T> T getDataFromPath(@NotNull String dataId, @NotNull Project project, @Nullable TreePath path) {
        if (dataId == null) {
            DatabaseView.$$$reportNull$$$0(20);
        }
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(21);
        }
        Object node = path == null ? null : path.getLastPathComponent();
        Object result2 = node instanceof DataProvider ? ((DataProvider)node).getData(dataId) : DbNodeDescriptor.getData(dataId, project, node);
        return (T)result2;
    }

    @Nullable
    private DnDTarget findDndTargetAt(@NotNull Point point, boolean strict) {
        TreePath path;
        if (point == null) {
            DatabaseView.$$$reportNull$$$0(22);
        }
        TreePath treePath = path = strict ? this.myTree.getPathForLocation(point.x, point.y) : this.myTree.getClosestPathForLocation(point.x, point.y);
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        DbDataSource dataSource = (DbDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class);
        DasObject o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
        DbElement e = DbImplUtil.findElement(dataSource, o);
        if (node instanceof DatabaseStructure.FamilyGroup && e instanceof DasNamespace && ((DatabaseStructure.FamilyGroup)((Object)node)).kidKind != ObjectKind.TABLE) {
            return null;
        }
        DnDTarget target = DatabaseView.getDnDTarget(e);
        if (target != null) {
            return target;
        }
        return null;
    }

    @Nullable
    private static DnDTarget getDnDTarget(Object element) {
        PsiElement parent;
        if (element instanceof DatabaseStructure.FamilyGroup && (parent = ((DatabaseStructure.FamilyGroup)((Object)element)).getParent()) instanceof DbNamespaceImpl) {
            return new DbElementDnDTarget.GroupElementDnDTarget((DbNamespaceImpl)parent, ((DatabaseStructure.FamilyGroup)((Object)element)).kidKind);
        }
        return element instanceof UserDataHolder ? (DnDTarget)((UserDataHolder)element).getUserData(DatabaseDataKeys.DND_TARGET_KEY) : null;
    }

    public static void refreshViewAndSelect(@NotNull Project project, @NotNull Collection<?> selection) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(23);
        }
        if (selection == null) {
            DatabaseView.$$$reportNull$$$0(24);
        }
        DataSourceStorage.getProjectStorage(project).incModificationCount();
        DataSourceStorage.getStorage().incModificationCount();
        DatabaseView view2 = DatabaseView.getDatabaseView(project);
        view2.refreshView();
        view2.selectElements(selection);
    }

    public static void select(@NotNull PsiElement element, boolean requestFocus) {
        if (element == null) {
            DatabaseView.$$$reportNull$$$0(25);
        }
        DatabaseView.select(element.getProject(), requestFocus, Collections.singleton(element));
    }

    public static void select(@NotNull Project project, boolean requestFocus, @NotNull Collection<?> elements) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(26);
        }
        if (elements == null) {
            DatabaseView.$$$reportNull$$$0(27);
        }
        ToolWindow window = DatabaseView.getDatabaseToolWindow(project);
        DatabaseView databaseView = DatabaseView.getDatabaseView(project);
        Runnable runnable = () -> {
            if (elements == null) {
                DatabaseView.$$$reportNull$$$0(30);
            }
            databaseView.selectElements(elements);
        };
        if (requestFocus) {
            window.activate(runnable);
        } else {
            runnable.run();
        }
    }

    @NotNull
    public static ToolWindow getDatabaseToolWindow(@NotNull Project project) {
        ToolWindow window;
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(28);
        }
        if ((window = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.DATABASE_VIEW)) == null) {
            DatabaseToolWindowFactory factory = new DatabaseToolWindowFactory();
            window = ToolWindowManager.getInstance((Project)project).registerToolWindow(ToolWindowId.DATABASE_VIEW, true, ToolWindowAnchor.RIGHT, (Disposable)project, true);
            factory.createToolWindowContent(project, window);
        }
        ToolWindow toolWindow = window;
        if (toolWindow == null) {
            DatabaseView.$$$reportNull$$$0(29);
        }
        return toolWindow;
    }

    @Nullable
    public Element getState() {
        Element element = XmlSerializer.serialize((Object)this.myViewOptions, null);
        try {
            TreeState.createOn((JTree)this.myTree).writeExternal(element);
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    public void loadState(Element state) {
        XmlSerializer.deserializeInto((Object)this.myViewOptions, (Element)state);
        TreeState.createFrom((Element)state).applyTo((JTree)this.myTree, this.myStructure.getRoot());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseView";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expand";
                break;
            }
            case 14: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 21: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "linkAttrs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncModel";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseView";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "selectElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "selectElements";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFromSelectedPaths";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectElements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromSelectedPaths";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromPath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findDndTargetAt";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "refreshViewAndSelect";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseToolWindow";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$select$23";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSelectedElements$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        final DatabaseView myView;

        MyAutoScrollFromSourceHandler(Project project, DatabaseView view2) {
            super(project, (JComponent)((Object)view2), (Disposable)view2);
            this.myView = view2;
        }

        protected boolean isAutoScrollEnabled() {
            return ((DatabaseView)this.myView).myViewOptions.AUTO_SCROLL_FROM_SOURCE;
        }

        protected void setAutoScrollEnabled(boolean enabled) {
            FileEditorManager fileEditorManager;
            FileEditor[] editors;
            ((DatabaseView)this.myView).myViewOptions.AUTO_SCROLL_FROM_SOURCE = enabled;
            if (enabled && (editors = (fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)).getSelectedEditors()).length != 0) {
                this.selectElementFromEditor(editors[0]);
            }
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            this.selectElementFromEditorInner(editor, false);
        }

        void selectElementFromEditorInner(@NotNull FileEditor editor, boolean force) {
            VirtualFile file;
            PsiFile psiFile;
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(1);
            }
            PsiFile psiFile2 = psiFile = (file = FileEditorManagerEx.getInstanceEx((Project)this.myProject).getFile(editor)) == null ? null : PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile == null) {
                return;
            }
            DbElement element = SelectInDatabaseView.askProviders((SelectInContext)new FileEditorSelectInContext(editor, psiFile));
            DbElement selection = (DbElement)DatabaseView.getSelectedElements(DataManager.getInstance().getDataContext((Component)((Object)this.myView)), false).first();
            if (element != null && (force || selection == null || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)selection, (boolean)false))) {
                DatabaseView.select(this.myProject, false, Collections.singleton(element));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "editor";
            objectArray2[1] = "com/intellij/database/view/DatabaseView$MyAutoScrollFromSourceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditorInner";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTransferable
    implements Transferable {
        private final Object[] myObjects;

        public MyTransferable(Object[] objects) {
            this.myObjects = objects;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor, DnDEventImpl.ourDataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder sb = new StringBuilder();
                for (Object object : this.myObjects) {
                    if (!(object instanceof PsiNamedElement)) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(((PsiNamedElement)object).getName());
                }
                return sb.toString();
            }
            if (DnDEventImpl.ourDataFlavor.equals(flavor)) {
                return this.myObjects;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class MyDnDSource
    implements DnDSource {
        private MyDnDSource() {
        }

        public boolean canStartDragging(DnDAction action, Point dragOrigin) {
            return !JBIterable.of((Object[])DatabaseView.this.myTree.getSelectionPaths()).isEmpty();
        }

        @NotNull
        public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
            Object[] selection = JBIterable.of((Object[])DatabaseView.this.myTree.getSelectionPaths()).map(path -> {
                DbDataSource dataSource = (DbDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class);
                DasObject o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
                DbElement e = DbImplUtil.findElement(dataSource, o);
                return ObjectUtils.notNull((Object)e, (Object)path.getLastPathComponent());
            }).unique().toList().toArray();
            DnDDragStartBean dnDDragStartBean = new DnDDragStartBean((Object)new MyTransferable(selection), dragOrigin);
            if (dnDDragStartBean == null) {
                MyDnDSource.$$$reportNull$$$0(0);
            }
            return dnDDragStartBean;
        }

        @NotNull
        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
            TreePath[] paths = (TreePath[])ObjectUtils.notNull((Object)DatabaseView.this.myTree.getSelectionPaths());
            Object node = paths[0].getLastPathComponent();
            ItemPresentation presentation = (ItemPresentation)ObjectUtils.notNull((Object)((MyRenderer)DatabaseView.this.myTree.getCellRenderer()).getPresentation(node));
            SimpleColoredComponent c = new SimpleColoredComponent();
            c.setForeground(DatabaseView.this.myTree.getForeground());
            c.setBackground(DatabaseView.this.myTree.getBackground());
            c.setIcon(presentation.getIcon(false));
            if (presentation instanceof PresentationData) {
                for (PresentableNodeDescriptor.ColoredFragment fragment : ((PresentationData)presentation).getColoredText()) {
                    c.append(fragment.getText(), fragment.getAttributes());
                }
            }
            if (paths.length > 1) {
                c.append(" +" + (paths.length - 1), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
            Dimension size = c.getPreferredSize();
            c.setSize(size);
            BufferedImage image = UIUtil.createImage((Component)c, (int)size.width, (int)size.height, (int)2);
            c.setOpaque(false);
            Graphics2D g = image.createGraphics();
            c.paint((Graphics)g);
            g.dispose();
            Pair pair = Pair.create((Object)image, (Object)new Point(0, 0));
            if (pair == null) {
                MyDnDSource.$$$reportNull$$$0(1);
            }
            return pair;
        }

        public void dragDropEnd() {
        }

        public void dropActionChanged(int gestureModifiers) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/view/DatabaseView$MyDnDSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startDragging";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDraggedImage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class MyDnDTarget
    implements DnDNativeTarget {
        private MyDnDTarget() {
        }

        public boolean update(DnDEvent aEvent) {
            boolean canCreateDataSource;
            Point point = aEvent.getPointOn((Component)DatabaseView.this.myTree);
            DnDTarget target = DatabaseView.this.findDndTargetAt(point, canCreateDataSource = this.hasDdlDataSourceFiles(aEvent));
            boolean targetOk = target != null && aEvent.delegateUpdateTo(target);
            boolean ok = targetOk || canCreateDataSource;
            aEvent.setDropPossible(ok);
            if (ok) {
                RelativeRectangle rectangle;
                if (targetOk) {
                    Rectangle bounds = (Rectangle)ObjectUtils.assertNotNull((Object)DatabaseView.this.myTree.getPathBounds(DatabaseView.this.myTree.getClosestPathForLocation(point.x, point.y)));
                    rectangle = new RelativeRectangle((Component)DatabaseView.this.myTree, bounds);
                } else {
                    Rectangle bounds = DatabaseView.this.getBounds();
                    rectangle = new RelativeRectangle((Component)((Object)DatabaseView.this), bounds);
                }
                aEvent.setHighlighting(rectangle, 1);
            }
            return ok;
        }

        public void drop(DnDEvent aEvent) {
            boolean canCreateDataSource = this.hasDdlDataSourceFiles(aEvent);
            DnDTarget target = DatabaseView.this.findDndTargetAt(aEvent.getPointOn((Component)DatabaseView.this.myTree), canCreateDataSource);
            if (target != null && aEvent.delegateUpdateTo(target)) {
                aEvent.delegateDropTo(target);
            } else {
                ArrayList newElements = new ArrayList();
                List files = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
                for (DbPsiManager manager : DatabaseView.this.myDbFacade.getDbManagers()) {
                    newElements.addAll(manager.createDataSourceByFiles((Collection)files));
                }
                DatabaseView.select(DatabaseView.this.myProject, true, newElements);
            }
        }

        private boolean hasDdlDataSourceFiles(DnDEvent aEvent) {
            List files = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
            for (DbPsiManager manager : DatabaseView.this.myDbFacade.getDbManagers()) {
                if (!manager.canCreateDataSourceByFiles((Collection)files)) continue;
                return true;
            }
            return SystemInfo.isMac && files.isEmpty();
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }

    private class MyRenderer
    extends MouseAdapter
    implements TreeCellRenderer {
        PresentationData presentation = new PresentationData();
        TreePath pathUnderMouse;
        NodeRenderer nodeRenderer = new NodeRenderer(){

            @Nullable
            protected ItemPresentation getPresentation(Object node) {
                return MyRenderer.this.getPresentation(node);
            }
        };

        private MyRenderer() {
        }

        @Nullable
        ItemPresentation getPresentation(Object node) {
            if (node instanceof DasObject) {
                DbNodeDescriptor.updatePresentation(this.presentation, (DasObject)node, DatabaseView.this.myProject);
                return this.presentation;
            }
            return node instanceof NavigationItem ? ((NavigationItem)node).getPresentation() : null;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            SimpleColoredComponent component = (SimpleColoredComponent)this.nodeRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            component.setOpaque(false);
            component.setIconOpaque(false);
            component.setTransparentIconBackground(true);
            component.setIconTextGap(JBUI.scale((int)5));
            if (value instanceof DbDataSource && ((DbDataSource)value).getDelegate() instanceof LocalDataSource) {
                boolean activate = this.pathUnderMouse != null && value == this.pathUnderMouse.getLastPathComponent();
                LocalDataSource delegate = (LocalDataSource)((DbDataSource)value).getDelegate();
                DasModel model = delegate.getModel();
                IntrospectionScope scope = delegate.getIntrospectionScope();
                JBIterable allSchemas = ((JBTreeTraverser)((JBTreeTraverser)(model instanceof BasicModel ? ((BasicModel)model).traverser(true) : model.traverser()).expandAndFilter(DasUtil.byClass(DasNamespace.class))).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).filter(DasNamespace.class);
                int enabled = 0;
                int total = 0;
                for (DasNamespace ns : allSchemas) {
                    enabled += DatabaseModelLoader.matches((DasObject)ns, scope) ? 1 : 0;
                    ++total;
                }
                component.append(" ");
                String text2 = enabled == total && enabled == 0 ? "..." : (enabled == total || total == 0 ? Integer.toString(enabled) : enabled + "/" + total);
                component.append(" " + text2 + " ", activate ? DatabaseView.linkAttrs() : DbNodeDescriptor.getGrayAttrs(), (Object)"link");
            }
            return component;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int mouseX;
            Object o = this.pathUnderMouse == null ? null : this.pathUnderMouse.getLastPathComponent();
            LocalDataSource dataSource = DbImplUtil.getMaybeLocalDataSource(o instanceof DbDataSource ? (DatabaseSystem)o : null);
            if (dataSource == null) {
                return;
            }
            int row = DatabaseView.this.myTree.getRowForPath(this.pathUnderMouse);
            Rectangle bounds = DatabaseView.this.myTree.getPathBounds(this.pathUnderMouse);
            if (bounds == null) {
                return;
            }
            SimpleColoredComponent component = (SimpleColoredComponent)this.getTreeCellRendererComponent((JTree)DatabaseView.this.myTree, o, false, false, false, row, false);
            boolean isLink = "link".equals(component.getFragmentTagAt((mouseX = e.getX()) - bounds.x));
            if (!isLink) {
                return;
            }
            JBPopup popup = DataSourceUiUtil.buildHiddenNamespacesPopup(DatabaseView.this.myProject, dataSource);
            popup.show(new RelativePoint((Component)DatabaseView.this.myTree, (Point)new JBPoint(mouseX, bounds.y + bounds.height)));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle r1;
            TreePath p0 = this.pathUnderMouse;
            TreePath p1 = DatabaseView.this.myTree.getPathForLocation(e.getX(), e.getY());
            Rectangle r0 = p0 == null ? null : DatabaseView.this.myTree.getPathBounds(p0);
            Rectangle rectangle = r1 = p1 == null ? null : DatabaseView.this.myTree.getPathBounds(p1);
            if (r0 == null && r1 == null) {
                return;
            }
            this.pathUnderMouse = p1;
            Rectangle clip = r0 == null ? r1 : (r1 == null ? r0 : r0.union(r1));
            DatabaseView.this.myTree.repaint(clip);
        }
    }
}

