/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.google.common.collect.Iterables;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbClusterImpl;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DeleteTableHelper;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.TextRanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteQueryGenerator {
    private final DbDataSource myDataSource;
    private final Set<DbTable> myTables = ContainerUtil.newLinkedHashSet();
    private final Set<DbRoutine> myProcedures = ContainerUtil.newLinkedHashSet();
    private final Set<DbPackage> myPackages = ContainerUtil.newLinkedHashSet();
    private final MultiMap<DbPackage, DbElement> myPackageContent = MultiMap.createLinkedSet();
    private final Set<DbColumn> myColumns = ContainerUtil.newLinkedHashSet();
    private final Set<DbIndex> myIndices = ContainerUtil.newLinkedHashSet();
    private final Set<DbTableKey> myKeys = ContainerUtil.newLinkedHashSet();
    private final Set<DbForeignKey> myForeignKeys = ContainerUtil.newLinkedHashSet();
    private final Set<DbTrigger> myTriggers = ContainerUtil.newLinkedHashSet();
    private final Set<DbTableChild> myRules = ContainerUtil.newLinkedHashSet();
    private final Set<DbElement> myOperators = ContainerUtil.newLinkedHashSet();
    private final Set<DbElement> mySequences = ContainerUtil.newLinkedHashSet();
    private final Set<DbCustomType> myCustomTypes = ContainerUtil.newLinkedHashSet();
    private final Set<DbClusterImpl> myClusters = ContainerUtil.newLinkedHashSet();
    private final Set<DbSynonymImpl> mySynonyms = ContainerUtil.newLinkedHashSet();
    private final Set<DbNamespaceImpl> mySchemasAndDbs = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myCollations = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myUserMappings = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myForeignServers = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myForeignDataWrappers = ContainerUtil.newLinkedHashSet();

    public static boolean canDeleteAnything(Iterable<DbElement> elements) {
        return !JBIterable.from(elements).filter(DeleteQueryGenerator::canDeleteElement).isEmpty();
    }

    private static boolean canDeleteElement(@NotNull DbElement e) {
        if (e == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(0);
        }
        if (DataImporter.isBusy(e)) {
            return false;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)e.getDataSource());
        if (e.getDbParent() instanceof DbPackage) {
            return dialect.getFamilyId().isOracle();
        }
        return e instanceof DbTable || e instanceof DbRoutine || e instanceof DbColumn && dialect.supportsDropColumn() || e instanceof DbIndex && dialect.supportsDropIndex() || e instanceof DbSynonymImpl && dialect.supportsDropSynonym() || e instanceof DbTableKey && dialect.supportsDropPrimaryKey() || e instanceof DbForeignKey && dialect.supportsDropForeignKey() || e instanceof DbTrigger && dialect.supportsDropTrigger() || e instanceof DbCustomType && dialect.supportsDropType() || e instanceof DbPackage || e instanceof DbClusterImpl && dialect.supportsDropCluster() || e instanceof DbNamespaceImpl && e.getKind() == ObjectKind.SCHEMA && dialect.supportsDropSchema() || e instanceof DbNamespaceImpl && e.getKind() == ObjectKind.DATABASE && dialect.supportsDropDatabase() || e.getKind() == ObjectKind.SEQUENCE && dialect.supportsDropSequence() || e.getKind() == ObjectKind.RULE && dialect.supportsDropRule() || e.getDelegate() instanceof DasOperator || e.getKind() == ObjectKind.COLLATION && dialect.supportsDropCollation() || e.getKind() == ObjectKind.USER_MAPPING && dialect.supportsDropUserMapping() || e.getKind() == ObjectKind.SERVER && dialect.supportsDropForeignServer() || e.getKind() == ObjectKind.FOREIGN_DATA_WRAPPER && dialect.supportsDropForeignDataWrapper();
    }

    public DeleteQueryGenerator(DbDataSource dataSource, Collection<DbElement> elements) {
        this.myDataSource = dataSource;
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)this.myDataSource);
        JBIterable namespaces = JBIterable.from(elements).filter(DbNamespaceImpl.class);
        namespaces.filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).addAllTo(this.mySchemasAndDbs);
        namespaces.filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).filter(s -> !this.mySchemasAndDbs.contains(s.getDbParent())).addAllTo(this.mySchemasAndDbs);
        for (DbElement e : elements) {
            if (e.getDbParent() instanceof DbPackage) {
                if (!dialect.getFamilyId().isOracle()) continue;
                this.myPackageContent.putValue((Object)((DbPackage)e.getDbParent()), (Object)e);
                continue;
            }
            if (e.getKind() == ObjectKind.SEQUENCE) {
                this.mySequences.add(e);
                continue;
            }
            if (e instanceof DbTableChild && e.getKind() == ObjectKind.RULE) {
                this.myRules.add((DbTableChild)e);
                continue;
            }
            if (e instanceof DbCustomType) {
                this.myCustomTypes.add((DbCustomType)e);
                continue;
            }
            if (e instanceof DbRoutine) {
                this.myProcedures.add((DbRoutine)e);
                continue;
            }
            if (e instanceof DbTable) {
                this.myTables.add((DbTable)e);
                continue;
            }
            if (e instanceof DbColumn) {
                this.myColumns.add((DbColumn)e);
                continue;
            }
            if (e instanceof DbPackage) {
                this.myPackages.add((DbPackage)e);
                continue;
            }
            if (e instanceof DbClusterImpl) {
                this.myClusters.add((DbClusterImpl)e);
                continue;
            }
            if (e instanceof DbIndex) {
                this.myIndices.add((DbIndex)e);
                continue;
            }
            if (e instanceof DbTableKey) {
                this.myKeys.add((DbTableKey)e);
                continue;
            }
            if (e instanceof DbForeignKey) {
                this.myForeignKeys.add((DbForeignKey)e);
                continue;
            }
            if (e instanceof DbTrigger) {
                this.myTriggers.add((DbTrigger)e);
                continue;
            }
            if (e instanceof DbSynonymImpl) {
                this.mySynonyms.add((DbSynonymImpl)e);
                continue;
            }
            if (e.getDelegate() instanceof DasOperator) {
                this.myOperators.add(e);
                continue;
            }
            if (e.getKind() == ObjectKind.COLLATION) {
                this.myCollations.add((DasObject)e);
                continue;
            }
            if (e.getKind() == ObjectKind.USER_MAPPING) {
                this.myUserMappings.add((DasObject)e);
                continue;
            }
            if (e.getKind() == ObjectKind.SERVER) {
                this.myForeignServers.add((DasObject)e);
                continue;
            }
            if (e.getKind() != ObjectKind.FOREIGN_DATA_WRAPPER) continue;
            this.myForeignDataWrappers.add((DasObject)e);
        }
        this.myPackages.forEach(arg_0 -> this.myPackageContent.remove(arg_0));
    }

    @NotNull
    public DdlBuilder generateQueries(@NotNull List<String> messages) {
        DbTable table;
        List<DasTable> tablesDeletionOrder;
        if (messages == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(1);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        Project project = this.myDataSource.getProject();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)this.myDataSource);
        try {
            AbstractDataSource ds = (AbstractDataSource)this.myDataSource.getDelegate();
            tablesDeletionOrder = DeleteTableHelper.getDeletionOrder(ds.getModel(), ContainerUtil.map(this.myTables, element -> {
                Object delegate = element.getDelegate();
                return delegate instanceof DasTable && !(delegate instanceof DasRoutine) ? (DasTable)delegate : null;
            }), dialect.supportsDropForeignKey());
        }
        catch (UnsupportedOperationException e) {
            DataSourceUiUtil.showNotification(project, "Deletion for dataSource " + this.myDataSource.getName() + " failed", e.getMessage(), true);
            DdlBuilder ddlBuilder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
            if (ddlBuilder == null) {
                DeleteQueryGenerator.$$$reportNull$$$0(2);
            }
            return ddlBuilder;
        }
        tablesDeletionOrder.remove(null);
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        DdlBuilder keyBuilder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        if (dialect.supportsDropForeignKey()) {
            for (DbForeignKey dbForeignKey : this.myForeignKeys) {
                table = dbForeignKey.getTable();
                if (this.myTables.contains(table) || QNameUtil.isFakeName(dbForeignKey.getName())) continue;
                dialect.sqlDropForeignKey(keyBuilder, (DasTable)table, (DasForeignKey)dbForeignKey, dbForeignKey.getName()).newStatement();
            }
        }
        if (dialect.supportsDropConstraint()) {
            for (DbTableKey dbTableKey : this.myKeys) {
                table = dbTableKey.getTable();
                if (this.myTables.contains(table) || QNameUtil.isFakeName(dbTableKey.getName())) continue;
                if (dbTableKey.isPrimary()) {
                    dialect.sqlDropPrimaryKey(keyBuilder, (DasTableKey)dbTableKey).newStatement();
                    continue;
                }
                if (dbTableKey.isPrimary()) continue;
                dialect.sqlDropConstraint(keyBuilder, (DasTable)table, (DasObject)dbTableKey, dbTableKey.getName()).newStatement();
            }
        }
        if (dialect.supportsDropTrigger()) {
            for (DbTrigger dbTrigger : this.myTriggers) {
                table = dbTrigger.getTable();
                if (this.myTables.contains(table) || QNameUtil.isFakeName(dbTrigger.getName())) continue;
                dialect.sqlDropTrigger(keyBuilder, (DasTrigger)dbTrigger).newStatement();
            }
        }
        if (dialect.supportsDropRule()) {
            for (DbTableChild dbTableChild : this.myRules) {
                table = dbTableChild.getTable();
                if (this.myTables.contains(table)) continue;
                dialect.sqlDropRule(keyBuilder, (DasTableChild)dbTableChild).newStatement();
            }
        }
        if (dialect.supportsDropOperator()) {
            for (DbElement dbElement : this.myOperators) {
                DasOperator operator = (DasOperator)ObjectUtils.tryCast((Object)dbElement.getDelegate(), DasOperator.class);
                if (operator == null) continue;
                dialect.sqlDropOperator(keyBuilder, operator).newStatement();
            }
        }
        if (dialect.supportsDropType()) {
            for (DbCustomType dbCustomType : this.myCustomTypes) {
                dialect.sqlDropType(keyBuilder, (DasUserDefinedType)dbCustomType).newStatement();
            }
        }
        if (dialect.supportsDropSynonym()) {
            for (DbSynonymImpl dbSynonymImpl : this.mySynonyms) {
                dialect.sqlDropSynonym(keyBuilder, dbSynonymImpl).newStatement();
            }
        }
        if (dialect.supportsDropCluster()) {
            for (DbClusterImpl dbClusterImpl : this.myClusters) {
                dialect.sqlDropCluster(keyBuilder, dbClusterImpl).newStatement();
            }
        }
        if (dialect.supportsDropCollation()) {
            for (DasObject dasObject : this.myCollations) {
                dialect.sqlDropCollation(keyBuilder, dasObject).newStatement();
            }
        }
        if (dialect.supportsDropUserMapping()) {
            for (DasObject dasObject : this.myUserMappings) {
                dialect.sqlDropUserMapping(keyBuilder, dasObject);
            }
        }
        if (dialect.supportsDropForeignServer()) {
            for (DasObject dasObject : this.myForeignServers) {
                dialect.sqlDropForeignServer(keyBuilder, dasObject);
            }
        }
        if (dialect.supportsDropForeignDataWrapper()) {
            for (DasObject dasObject : this.myForeignDataWrappers) {
                dialect.sqlDropForeignDataWrapper(keyBuilder, dasObject);
            }
        }
        for (DasTable dasTable : tablesDeletionOrder) {
            ObjectKind kind = dasTable.getKind();
            if (kind == ObjectKind.TABLE || kind == ObjectKind.VIRTUAL_TABLE || kind == ObjectKind.FOREIGN_TABLE) {
                for (DasForeignKey keyInfo : DasUtil.getForeignKeys((DasTable)dasTable)) {
                    if (!dialect.supportsDropForeignKey() || this.myTables.size() <= 1 || QNameUtil.isFakeName(keyInfo.getName())) continue;
                    dialect.sqlDropForeignKey(keyBuilder, dasTable, keyInfo, keyInfo.getName()).newStatement();
                }
                dialect.sqlDropTable(builder, dasTable, false, false, this.myDataSource.getModel()).newStatement();
                continue;
            }
            if (kind == ObjectKind.VIEW && dialect.supportsDropView()) {
                dialect.sqlDropView(builder, dasTable, false).newStatement();
                continue;
            }
            if (kind == ObjectKind.MAT_VIEW && dialect.supportsDropMaterializedView()) {
                dialect.sqlDropMaterializedView(builder, dasTable).newStatement();
                continue;
            }
            messages.add("Don't know how to drop " + kind.code() + " `" + dasTable.getName() + "`");
        }
        if (dialect.supportsDropSequence()) {
            for (DbElement dbElement : this.mySequences) {
                dialect.sqlDropSequence(builder, (DasObject)dbElement, false).newStatement();
            }
        }
        if (dialect.supportsDropSchema()) {
            for (DbNamespaceImpl dbNamespaceImpl : this.mySchemasAndDbs) {
                (dbNamespaceImpl.getKind() == ObjectKind.SCHEMA ? dialect.sqlDropSchema(builder, dbNamespaceImpl) : dialect.sqlDropDatabase(builder, dbNamespaceImpl)).newStatement();
            }
        }
        result2.addAll(keyBuilder.getStatements());
        result2.addAll(builder.getStatements());
        result2.addAll(this.generateDropColumnsAndIndexQueries(dialect, new LinkedHashSet<DasTable>(tablesDeletionOrder)).getStatements());
        if (dialect.getFamilyId().isOracle()) {
            for (Map.Entry entry : this.myPackageContent.entrySet()) {
                result2.addAll(this.generateDropContentFromPackages((DbPackage)entry.getKey(), (Collection)entry.getValue(), messages).getStatements());
            }
        }
        DdlBuilder procedureBuilder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        if (dialect.supportsDropProcedure()) {
            for (DbRoutine p : this.myProcedures) {
                dialect.sqlDropProcedure(procedureBuilder, (DasRoutine)p).newStatement();
            }
        }
        if (dialect.supportsDropPackage()) {
            for (DbPackage pkg : this.myPackages) {
                dialect.sqlDropPackage(procedureBuilder, (DasSchemaChild)pkg).newStatement();
            }
        }
        result2.addAll(procedureBuilder.getStatements());
        DdlBuilder ddlBuilder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        ddlBuilder.getStatements().addAll(result2);
        DdlBuilder ddlBuilder2 = ddlBuilder;
        if (ddlBuilder2 == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(3);
        }
        return ddlBuilder2;
    }

    @NotNull
    private DdlBuilder generateDropContentFromPackages(DbPackage pkg, Collection<DbElement> content, @NotNull List<String> msgs) {
        if (msgs == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(4);
        }
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        try {
            StringBuilder pkgDef = new StringBuilder();
            DatabaseEditorHelper.loadDefinition((DbElement)pkg, pkgDef);
            SqlReader reader = SqlPsiFacade.getInstance((Project)pkg.getProject()).createSqlReader();
            SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((DbElement)pkg.getDataSource());
            SqlFile psi = reader.getReadOnlyPsi(dialect, (CharSequence)pkgDef);
            JBIterable packages = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)psi)).expand(Conditions.not((Condition)Conditions.instanceOf(SqlStatement.class)))).filter(SqlStatement.class).filter(Conditions.instanceOf(DasObject.class));
            TextRanges dropRanges = new TextRanges();
            for (SqlStatement pkgPartDef : packages) {
                DeleteQueryGenerator.findContentRanges(dialect, pkgPartDef, content, dropRanges, msgs, pkgDef);
            }
            for (TextRange range : JBIterable.once((Iterator)dropRanges.revIterator())) {
                pkgDef.replace(range.getStartOffset(), range.getEndOffset(), "");
            }
            String res = pkgDef.toString().trim();
            res = StringUtil.trimEnd((String)res, (String)";");
            builder.plain(res);
        }
        catch (Exception e) {
            msgs.add("Failed to load definition of package `" + pkg.getName() + "`");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    private static void findContentRanges(@NotNull SqlLanguageDialect sqlDialect, @NotNull SqlStatement defRoot, @NotNull Collection<DbElement> content, @NotNull TextRanges ranges, @NotNull List<String> msgs, @NotNull CharSequence text2) {
        if (sqlDialect == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(6);
        }
        if (defRoot == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(7);
        }
        if (content == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(8);
        }
        if (ranges == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(9);
        }
        if (msgs == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(11);
        }
        List<List<DbElement>> partition = DeleteQueryGenerator.partitionByNameAndKind(content, (DatabaseDialectEx)sqlDialect.getDatabaseDialect());
        for (List<DbElement> homonyms : partition) {
            Set<PsiObject> found = DeleteQueryGenerator.filterOverloads(DeleteQueryGenerator.findObjectsByNameAndKind(defRoot, homonyms.get(0)), homonyms);
            if (found.size() < homonyms.size()) {
                if (found.isEmpty()) {
                    msgs.add("Failed to find `" + homonyms.get(0).getName() + "` definition in package. Not removed.");
                } else {
                    msgs.add("Failed to find some `" + homonyms.get(0).getName() + "` definitions in package. Not all removed.");
                }
            }
            for (PsiObject object : found) {
                ranges.union(DeleteQueryGenerator.expandedRange(sqlDialect, (PsiElement)object, text2));
            }
        }
    }

    @NotNull
    private static Set<PsiObject> filterOverloads(@NotNull Set<PsiObject> found, @NotNull List<DbElement> homonyms) {
        if (found == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(12);
        }
        if (homonyms == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(13);
        }
        if (homonyms.size() == found.size()) {
            Set<PsiObject> set = found;
            if (set == null) {
                DeleteQueryGenerator.$$$reportNull$$$0(14);
            }
            return set;
        }
        if (homonyms.get(0).getKind() == ObjectKind.ROUTINE) {
            Set<PsiObject> set = DeleteQueryGenerator.filterRoutineOverloads(found, homonyms);
            if (set == null) {
                DeleteQueryGenerator.$$$reportNull$$$0(15);
            }
            return set;
        }
        Set<PsiObject> set = Collections.emptySet();
        if (set == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(16);
        }
        return set;
    }

    @NotNull
    private static Set<PsiObject> filterRoutineOverloads(@NotNull Set<PsiObject> found, @NotNull List<DbElement> homonyms) {
        if (found == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(17);
        }
        if (homonyms == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(18);
        }
        HashSet sigs = ContainerUtil.newHashSet();
        for (DbElement homonym : homonyms) {
            sigs.add(DeleteQueryGenerator.getSig((DasObject)homonym));
        }
        HashSet res = ContainerUtil.newHashSet();
        for (PsiObject object : found) {
            if (!sigs.contains(DeleteQueryGenerator.getSig((DasObject)object))) continue;
            res.add(object);
        }
        if (res.size() == homonyms.size()) {
            HashSet hashSet = res;
            if (hashSet == null) {
                DeleteQueryGenerator.$$$reportNull$$$0(19);
            }
            return hashSet;
        }
        Set<PsiObject> set = Collections.emptySet();
        if (set == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    private static Trinity<DasRoutine.Kind, Boolean, Integer> getSig(DasObject object) {
        DasRoutine routine2 = (DasRoutine)object;
        Trinity trinity = Trinity.create((Object)routine2.getRoutineKind(), (Object)(routine2.getReturnArgument() != null ? 1 : 0), (Object)JBIterable.from((Iterable)routine2.getArguments()).size());
        if (trinity == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(21);
        }
        return trinity;
    }

    private static List<List<DbElement>> partitionByNameAndKind(@NotNull Collection<DbElement> content, @NotNull CasingProvider provider) {
        if (content == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(22);
        }
        if (provider == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(23);
        }
        ArrayList res = ContainerUtil.newArrayList();
        HashMap partition = ContainerUtil.newHashMap();
        for (DbElement element : content) {
            List homonyms;
            Map byName = (Map)partition.get(element.getKind());
            if (byName == null) {
                boolean sensitive = DasUtil.isCaseSensitive((Casing)provider.getCasing(element.getKind(), (DasObject)element.getDbParent()));
                byName = DasUtil.newCaseAwareMap((boolean)sensitive);
                partition.put(element.getKind(), byName);
            }
            if ((homonyms = (List)byName.get(element.getName())) == null) {
                homonyms = ContainerUtil.newSmartList();
                byName.put(element.getName(), homonyms);
                res.add(homonyms);
            }
            homonyms.add(element);
        }
        return res;
    }

    @NotNull
    private static Set<PsiObject> findObjectsByNameAndKind(@NotNull SqlStatement root2, @NotNull DbElement element) {
        if (root2 == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(24);
        }
        if (element == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(25);
        }
        JBIterable objects = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)root2)).expand(Conditions.or((Condition)Conditions.is((Object)root2), (Condition)Conditions.not((Condition)Conditions.instanceOf(SqlStatement.class))))).filter(PsiObject.class);
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        Casing casing = dialect.getCasing(element.getKind(), (DasObject)element.getDbParent());
        HashSet res = ContainerUtil.newHashSet();
        for (PsiObject object : objects) {
            if (!DeleteQueryGenerator.areEqual((DasObject)object, (DasObject)element, casing)) continue;
            res.add(object);
        }
        HashSet hashSet = res;
        if (hashSet == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    @NotNull
    private static TextRange expandedRange(@NotNull SqlLanguageDialect dialect, @NotNull PsiElement start, @NotNull CharSequence text2) {
        int ls;
        PsiElement tmp;
        if (dialect == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(27);
        }
        if (start == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(28);
        }
        if (text2 == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(29);
        }
        TokenSet ws = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect)).getWhitespaceTokens();
        TokenSet sep = dialect.getStatementSeparators();
        PsiElement end = start;
        boolean lineEnd = false;
        while ((tmp = PsiTreeUtil.nextLeaf((PsiElement)end)) != null) {
            IElementType type;
            IElementType iElementType = type = tmp.getNode() == null ? null : tmp.getNode().getElementType();
            if (ws.contains(type)) {
                end = tmp;
                lineEnd = tmp.getText().contains("\n");
                if (!lineEnd) continue;
                break;
            }
            if (!sep.contains(type)) break;
            end = tmp;
            break;
        }
        for (ls = start.getTextRange().getStartOffset() - 1; ls > 0 && text2.charAt(ls) == ' '; --ls) {
        }
        ++ls;
        int le = end.getTextRange().getEndOffset();
        if (!lineEnd) {
            ++le;
            while (le < text2.length() && text2.charAt(le) == ' ') {
                ++le;
            }
            if (le < text2.length() && text2.charAt(le) == '\n') {
                ++le;
            }
        }
        TextRange textRange = TextRange.create((int)ls, (int)le);
        if (textRange == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(30);
        }
        return textRange;
    }

    private static boolean areEqual(@NotNull DasObject a, @NotNull DasObject b, @NotNull Casing casing) {
        if (a == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(31);
        }
        if (b == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(32);
        }
        if (casing == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(33);
        }
        if (a.getKind() != b.getKind()) {
            return false;
        }
        return DasUtil.nameEqual((DasObject)a, (String)b.getName(), (Casing)casing);
    }

    private static boolean areRoutinesEqual(@Nullable DasRoutine a, @Nullable DasRoutine b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getRoutineKind() != b.getRoutineKind()) {
            return false;
        }
        if (!DeleteQueryGenerator.areArgumentsEqual(a.getReturnArgument(), b.getReturnArgument())) {
            return false;
        }
        Iterator ait = a.getArguments().iterator();
        Iterator bit = b.getArguments().iterator();
        do {
            boolean aOk = ait.hasNext();
            boolean bOk = bit.hasNext();
            if (aOk && bOk) continue;
            return aOk == bOk;
        } while (DeleteQueryGenerator.areArgumentsEqual((DasArgument)ait.next(), (DasArgument)bit.next()));
        return false;
    }

    private static boolean areArgumentsEqual(@Nullable DasArgument a, @Nullable DasArgument b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.getArgumentDirection() != b.getArgumentDirection()) {
            return false;
        }
        return Comparing.equal((String)a.getDataType().getSpecification(), (String)b.getDataType().getSpecification());
    }

    private DdlBuilder generateDropColumnsAndIndexQueries(DatabaseDialectEx dialect, Set<DasTable> alreadyDroppedTables) {
        DbTable table;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        if (this.myColumns.isEmpty() && this.myIndices.isEmpty()) {
            return builder;
        }
        if (dialect.supportsDropIndex()) {
            for (DbIndex index : this.myIndices) {
                String indexName = index.getName();
                if (QNameUtil.isFakeName(indexName) || alreadyDroppedTables.contains((table = (DbTable)index.getParent()).getDelegate())) continue;
                dialect.sqlDropIndex(builder, (DasTable)table.getDelegate(), (DasIndex)index, indexName, true).newStatement();
            }
        }
        Map classify = ContainerUtil.classify(this.myColumns.iterator(), o -> o.getDbParent());
        for (Map.Entry entry : classify.entrySet()) {
            table = (DbTable)entry.getKey();
            Set columns2 = (Set)entry.getValue();
            TreeSet<String> columnNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (DbElement c : columns2) {
                columnNames.add(c.getName());
            }
            if (dialect.supportsDropForeignKey()) {
                for (DasForeignKey key2 : DasUtil.getForeignKeys((DasTable)table)) {
                    TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    Iterables.addAll(treeSet, (Iterable)key2.getColumnsRef().names());
                    if (!columnNames.containsAll(treeSet) || this.myForeignKeys.contains(key2)) continue;
                    dialect.sqlDropForeignKey(builder, (DasTable)table, key2, key2.getName()).newStatement();
                }
            }
            LinkedHashSet droppedIndices = ContainerUtil.newLinkedHashSet();
            if (dialect.supportsDropIndex()) {
                for (DasIndex dasIndex : DasUtil.getIndices((DasTable)table)) {
                    TreeSet indexCols = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    Iterables.addAll(indexCols, (Iterable)dasIndex.getColumnsRef().names());
                    if (!columnNames.containsAll(indexCols) || droppedIndices.contains(dasIndex) || this.myIndices.contains(dasIndex)) continue;
                    dialect.sqlDropIndex(builder, (DasTable)table, dasIndex, dasIndex.getName(), false).newStatement();
                    droppedIndices.add(dasIndex);
                }
            }
            if (alreadyDroppedTables.contains(table.getDelegate())) continue;
            if (Iterables.size((Iterable)DasUtil.getColumns((DasObject)table)) == columns2.size() && !dialect.supportsEmptyTables()) {
                dialect.sqlDropTable(builder, (DasTable)table.getDelegate(), false, false, this.myDataSource.getModel()).newStatement();
                continue;
            }
            if (!dialect.supportsDropColumn()) continue;
            for (DbElement dbElement : this.myColumns) {
                if (!(dbElement.getDelegate() instanceof DasColumn)) continue;
                dialect.sqlDropColumn(builder, (DasColumn)dbElement.getDelegate()).newStatement();
            }
        }
        return builder;
    }

    public void fillNamespacesToRemove(List<Pair<ObjectName, ObjectName>> toRemove) {
        for (DbNamespaceImpl namespace : this.mySchemasAndDbs) {
            ObjectKind kind = namespace.getKind();
            if (kind == ObjectKind.DATABASE) {
                toRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)ObjectName.quoted((String)namespace.getName()), null));
                continue;
            }
            if (kind != ObjectKind.SCHEMA) continue;
            Object parent = namespace.getDbParent();
            if (parent != null && parent.getKind() != ObjectKind.DATABASE) {
                parent = null;
            }
            toRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)ObjectName.quoted((String)(parent == null ? null : parent.getName())), (Object)ObjectName.quoted((String)namespace.getName())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DeleteQueryGenerator";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDialect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defRoot";
                break;
            }
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 11: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homonyms";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DeleteQueryGenerator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateQueries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDropContentFromPackages";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverloads";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRoutineOverloads";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSig";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjectsByNameAndKind";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "expandedRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateQueries";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDropContentFromPackages";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findContentRanges";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterOverloads";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterRoutineOverloads";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "partitionByNameAndKind";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findObjectsByNameAndKind";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "expandedRange";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

