/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasIndex;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseIndexColumnEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.JBListTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseIndexEditor
extends DatabaseEditorBaseEx
implements DatabaseEditorUtil.EmbeddableEditor {
    private final TableEditorModel myTableModel;
    private JTextField myNameField;
    private JBCheckBox myUniqueBox;
    private JPanel myMainPanel;
    private JPanel myTablePanel;
    private ListTableModel<DatabaseIndexColumnEditor> myColumnsTableModel;
    private final IndexEditorModel myIndexModel;
    private final DatabaseEditorCapabilities.IndexEditorCaps myCaps;
    private EditorModelBase.Listener myChangeListener;
    private final Map<ColumnEditorModel, Disposable> mySubscribedColumns;
    private JBListTable myTable;
    private boolean myValid;

    public DatabaseIndexEditor(@NotNull DatabaseEditorState state, @NotNull IndexEditorModel model, @NotNull DatabaseEditorCapabilities.IndexEditorCaps caps) {
        if (state == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(1);
        }
        if (caps == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(2);
        }
        super(state);
        this.myChangeListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseIndexEditor.this.fromModelToUi();
            }
        };
        this.mySubscribedColumns = ContainerUtil.newHashMap();
        this.myIndexModel = model;
        this.myCaps = caps;
        this.myTableModel = this.myIndexModel.modelsCache.get(this.myIndexModel.getTable(), TableEditorModel.class);
        this.$$$setupUI$$$();
        this.applyCaps();
        this.setupControls();
    }

    private void applyCaps() {
        this.myNameField.setEnabled(this.myCaps.getRename().isAvailable());
        this.myUniqueBox.setEnabled(this.myCaps.getUnique().isAvailable());
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.myTableModel.getObject();
        if (deTable == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(3);
        }
        return deTable;
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    @Override
    public boolean canDoAnything() {
        return this.myCaps.canDoAnything();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.myNameField;
        if (jTextField == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(5);
        }
        return jTextField;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = new JComponent[]{this.myNameField, this.myUniqueBox, this.myTable.getTable()};
        if (jComponentArray == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(6);
        }
        return jComponentArray;
    }

    @NotNull
    public IndexEditorModel getIndexModel() {
        IndexEditorModel indexEditorModel = this.myIndexModel;
        if (indexEditorModel == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(7);
        }
        return indexEditorModel;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeIndex> getModel() {
        IndexEditorModel indexEditorModel = this.getIndexModel();
        if (indexEditorModel == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(8);
        }
        return indexEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        int i2;
        DatabaseIndexEditor.setValue(this.myNameField, this.myIndexModel.getName());
        DatabaseIndexEditor.setValue((JCheckBox)this.myUniqueBox, this.myIndexModel.isUnique());
        ArrayList items = ContainerUtil.newArrayList((Iterable)this.myColumnsTableModel.getItems());
        int count2 = this.myIndexModel.getItemsCount();
        if (items.size() > count2) {
            items.subList(count2, items.size()).clear();
        } else {
            for (i2 = items.size(); i2 < count2; ++i2) {
                items.add(new DatabaseIndexColumnEditor(this, this.myCaps.getColumnEditorCaps()));
            }
        }
        for (i2 = 0; i2 < items.size(); ++i2) {
            ((DatabaseIndexColumnEditor)items.get(i2)).updateFromModel(i2);
        }
        if (!items.equals(this.myColumnsTableModel.getItems())) {
            this.myColumnsTableModel.setItems((List)items);
        }
        this.myValid = true;
        for (DatabaseIndexColumnEditor item : items) {
            this.myValid &= item.isObjectValid();
        }
        this.updateColumnSubscriptions();
    }

    private void updateColumnSubscriptions() {
        HashSet subs = ContainerUtil.newHashSet();
        for (DeIndex.Item item : this.myIndexModel.getItems()) {
            if (EditorModelUtil.isStub(item.column)) continue;
            ColumnEditorModel m = this.myIndexModel.modelsCache.get(item.column, ColumnEditorModel.class);
            if (!this.mySubscribedColumns.containsKey(m)) {
                Disposable holder = new Disposable(){

                    public void dispose() {
                    }
                };
                Disposer.register((Disposable)this, (Disposable)holder);
                m.addListener(this.myChangeListener, holder);
                this.mySubscribedColumns.put(m, holder);
            }
            subs.add(m);
        }
        for (Map.Entry column : ContainerUtil.newArrayList(this.mySubscribedColumns.entrySet())) {
            if (subs.contains(column.getKey())) continue;
            Disposer.dispose((Disposable)((Disposable)column.getValue()));
            this.mySubscribedColumns.remove(column.getKey());
        }
    }

    private void initSubscriptions() {
        this.myIndexModel.addListener(this.myChangeListener, this);
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!DatabaseIndexEditor.this.myUpdating) {
                    DatabaseIndexEditor.this.myIndexModel.setName(DatabaseIndexEditor.this.myNameField.getText());
                    DatabaseIndexEditor.this.myIndexModel.commit();
                }
            }
        });
        this.myUniqueBox.addItemListener(e -> {
            if (!this.myUpdating) {
                this.myIndexModel.setUnique(this.myUniqueBox.isSelected());
                this.myIndexModel.commit();
            }
        });
        this.myTableModel.addListener(this.myChangeListener, this);
    }

    private void createUIComponents() {
        this.myColumnsTableModel = DatabaseEditorUtil.createTableModel(this.myIndexModel, new DatabaseEditorUtil.EditorModelHelper<DatabaseIndexColumnEditor>(){

            @Override
            @Nullable
            public DatabaseIndexColumnEditor createRow() {
                ArrayList items = ContainerUtil.newArrayList(DatabaseIndexEditor.this.myIndexModel.getItems());
                items.add(new DeIndex.Item(DatabaseIndexEditor.this.getTable().columns.isEmpty() ? DatabaseColumnRefEditor.createStub("", DatabaseIndexEditor.this.getTable()) : DatabaseIndexEditor.this.getTable().columns.get(0), DasIndex.Sorting.NONE));
                DatabaseIndexEditor.this.myIndexModel.setItems(items);
                return new DatabaseIndexColumnEditor(DatabaseIndexEditor.this, DatabaseIndexEditor.this.myCaps.getColumnEditorCaps());
            }

            @Override
            public boolean removeRow(DatabaseIndexColumnEditor item, int idx) {
                ArrayList items = ContainerUtil.newArrayList(DatabaseIndexEditor.this.myIndexModel.getItems());
                items.remove(idx);
                DatabaseIndexEditor.this.myIndexModel.setItems(items);
                return true;
            }

            @Override
            public boolean exchangeRows(DatabaseIndexColumnEditor item0, int idx0, DatabaseIndexColumnEditor item1, int idx1) {
                ArrayList items = ContainerUtil.newArrayList(DatabaseIndexEditor.this.myIndexModel.getItems());
                DeIndex.Item tmp = (DeIndex.Item)items.get(idx0);
                items.set(idx0, items.get(idx1));
                items.set(idx1, tmp);
                DatabaseIndexEditor.this.myIndexModel.setItems(items);
                return true;
            }
        }, true);
        TableView view2 = new TableView();
        view2.setModelAndUpdateColumns(this.myColumnsTableModel);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myColumnsTableModel, this, -1, JBUI.scale((int)300), null);
        this.myTablePanel = new JPanel(new BorderLayout());
        JPanel panel = ToolbarDecorator.createDecorator((JTable)this.myTable.getTable()).setToolbarPosition(ActionToolbarPosition.LEFT).createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(panel, (JTable)this.myTable.getTable());
        this.myTablePanel.add((Component)panel, "Center");
    }

    public int getIndex(@NotNull DatabaseIndexColumnEditor editor) {
        if (editor == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(9);
        }
        return this.myColumnsTableModel.getItems().indexOf(editor);
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        DatabaseEditorUtil.ColoredFragmentsBuilder res = new DatabaseEditorUtil.ColoredFragmentsBuilder();
        res.append(this.myIndexModel.getName());
        if (this.myIndexModel.isUnique()) {
            res.append(" UNIQUE");
        }
        res.append(" INDEX ");
        res.append(this.getIndex().getTableName());
        res.append(" (");
        int idx = 0;
        for (DeIndex.Item item : this.myIndexModel.getItems()) {
            if (idx != 0) {
                res.append(", ");
            }
            res.appendRef(this.getObjectName(item.column), DatabaseIndexEditor.isGood(item.column));
            if (item.sorting == DasIndex.Sorting.ASCENDING) {
                res.append(" ASC");
            } else if (item.sorting == DasIndex.Sorting.DESCENDING) {
                res.append(" DESC");
            }
            ++idx;
        }
        res.append(")");
        Iterable<Pair<String, TextAttributesKey>> iterable = res.build();
        if (iterable == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(10);
        }
        return iterable;
    }

    @Override
    public boolean isObjectValid() {
        return this.myValid;
    }

    @NotNull
    public DeIndex getIndex() {
        DeIndex deIndex = (DeIndex)this.myIndexModel.getObject();
        if (deIndex == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(11);
        }
        return deIndex;
    }

    @NotNull
    public JCheckBox getUniqueCheckBox() {
        JBCheckBox jBCheckBox = this.myUniqueBox;
        if (jBCheckBox == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(12);
        }
        return jBCheckBox;
    }

    @NotNull
    public JTextField getNameEditor() {
        JTextField jTextField = this.myNameField;
        if (jTextField == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(13);
        }
        return jTextField;
    }

    @NotNull
    public ListTableModel<DatabaseIndexColumnEditor> getColumnsListModel() {
        ListTableModel<DatabaseIndexColumnEditor> listTableModel = this.myColumnsTableModel;
        if (listTableModel == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(14);
        }
        return listTableModel;
    }

    @NotNull
    public DatabaseEditorCapabilities.IndexEditorCaps getCaps() {
        DatabaseEditorCapabilities.IndexEditorCaps indexEditorCaps = this.myCaps;
        if (indexEditorCaps == null) {
            DatabaseIndexEditor.$$$reportNull$$$0(15);
        }
        return indexEditorCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseIndexEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseIndexEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueCheckBox";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsListModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myTablePanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 3, 1, 0, 3, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Columns:");
        jBLabel2.setDisplayedMnemonic('C');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setColumns(15);
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myUniqueBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Unique");
        jBCheckBox.setMnemonic('U');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

