/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileModel
implements DasModel {
    private final MultiMap<DasObject, DasObject> myChildren;
    private final MultiMap<DasTable, DasConstraint> myExported;
    private final List<DasObject> myRoots;
    private final DasNamespace myCurrentRootNamespace;
    private final SqlFile myFile;

    public SqlFileModel(@NotNull SqlFile file) {
        if (file == null) {
            SqlFileModel.$$$reportNull$$$0(0);
        }
        this.myChildren = MultiMap.createLinkedSet();
        this.myExported = MultiMap.createLinkedSet();
        this.myRoots = ContainerUtil.newArrayList();
        for (DasObject object : file.traverser().bfsTraversal()) {
            DasForeignKey foreignKey;
            DasTable target;
            DasObject parent = object.getDbParent();
            if (object instanceof DasForeignKey && (target = (foreignKey = (DasForeignKey)object).getRefTable()) != null) {
                this.myExported.putValue((Object)target, (Object)foreignKey);
            }
            if (parent == null) continue;
            this.myChildren.putValue((Object)parent, (Object)object);
        }
        ContainerUtil.addAll(this.myRoots, (Iterable)file.getModelRoots());
        this.myCurrentRootNamespace = SqlFileModel.getCurrentRoot(file);
        this.myFile = file;
    }

    @Nullable
    private static DasNamespace getCurrentRoot(@NotNull SqlFile file) {
        if (file == null) {
            SqlFileModel.$$$reportNull$$$0(1);
        }
        DasNamespace root2 = null;
        ObjectPath current = SearchPath.getCurrent((SearchPath)DatabaseEditorHelper.getSearchPath((PsiFile)file));
        if (current != null) {
            root2 = (DasNamespace)QNameUtil.findByQName((DasModel)file, QNameUtil.getQualifiedName(current)).filter(DasNamespace.class).first();
        }
        return root2;
    }

    @NotNull
    public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable jBIterable = JBIterable.from(this.myRoots);
        if (jBIterable == null) {
            SqlFileModel.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @Nullable
    public DasNamespace getCurrentRootNamespace() {
        return this.myCurrentRootNamespace;
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(arg_0 -> this.myChildren.get(arg_0)).withRoots(this.myRoots);
        if (jBTreeTraverser == null) {
            SqlFileModel.$$$reportNull$$$0(3);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
        JBIterable jBIterable = JBIterable.from((Iterable)this.myExported.get((Object)table));
        if (jBIterable == null) {
            SqlFileModel.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlFileModel.$$$reportNull$$$0(5);
        }
        Casing casing = this.myFile.getCasing(kind, context);
        if (casing == null) {
            SqlFileModel.$$$reportNull$$$0(6);
        }
        return casing;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/SqlFileModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/SqlFileModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

