/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDocumentationProvider
extends DocumentationProviderEx {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        BuiltinFunction definition;
        if (element instanceof SqlDefinition) {
            SqlDefinition definition2 = (SqlDefinition)element;
            String kindName = SqlElementDescriptionProvider.getKindName(definition2);
            return kindName + " " + QNameUtil.getQualifiedName((DasObject)definition2);
        }
        if (element instanceof SqlFunctionCallExpression && (definition = ((SqlFunctionCallExpression)element).getFunctionDefinition()) != null) {
            return definition.getName();
        }
        return null;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        if (element instanceof SqlDefinition) {
            PsiElement textElement = element.getParent() instanceof SqlAlterInstruction ? element.getParent() : element;
            SqlDefinition definition = (SqlDefinition)element;
            String kindName = SqlElementDescriptionProvider.getKindName(definition);
            return kindName + " <b>" + QNameUtil.getQualifiedName((DasObject)definition) + "</b><br><pre><code>" + DbSqlUtil.sql2Html(element.getProject(), (Language)SqlImplUtil.getSqlDialectSafe(element), (CharSequence)ObjectUtils.notNull((Object)textElement.getText(), (Object)"")) + "</code></pre>";
        }
        if (element instanceof SqlFunctionCallExpression) {
            Class<?> dialectClass = element.getContainingFile().getLanguage().getClass();
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)element;
            BuiltinFunction definition = callExpression.getFunctionDefinition();
            if (definition instanceof SqlFunctionDefinition) {
                return SqlDocumentationProvider.getDocumentation((SqlFunctionDefinition)definition, SqlFunctionsUtil.chooseTheBestPrototype(callExpression, false), dialectClass);
            }
        }
        return null;
    }

    @Nullable
    public static String getDocumentation(@NotNull SqlFunctionDefinition definition, @Nullable SqlFunctionDefinition.Prototype prototype, @NotNull Class<? extends Language> dialectClass) {
        if (definition == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (dialectClass == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(1);
        }
        int prototypeId = prototype == null ? 0 : prototype.getPrototypeId();
        String name = definition.getAliasedFunction();
        String basePath = "functions/" + name.replace('@', '_');
        if (prototypeId > 0) {
            try {
                return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + "-" + prototypeId + ".html");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + ".html");
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof SqlFunctionDefinition.Prototype && element != null) {
            SqlFunctionDefinition.Prototype prototype = (SqlFunctionDefinition.Prototype)object;
            SqlExpression expr = SqlPsiElementFactory.createExpressionFromText(prototype.getFunction().getName() + "()", SqlImplUtil.getSqlDialectSafe(element), psiManager.getProject(), null);
            SqlFunctionsUtil.setExplicitPrototype(expr, prototype);
            return expr;
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        DbElement element;
        if (editor == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(3);
        }
        return (element = (DbElement)SqlDocumentationProvider.findRelatedDbElements(TargetElementUtil.findReference((Editor)editor), null).filter(DbImplUtil.CAN_CONNECT_TO).first()) == null ? super.getCustomDocumentationElement(editor, file, contextElement) : element;
    }

    @NotNull
    public static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiReference refAt, @Nullable SqlDefinition definition) {
        SqlReferenceImpl targetRef;
        SqlReferenceElementType refType;
        SqlDefinition element;
        SqlDefinition resolved;
        SqlReferenceImpl ref;
        if (refAt instanceof SqlReferenceImpl) {
            ref = (SqlReferenceImpl)refAt;
        } else if (definition != null) {
            SqlNameElement nameElement = definition.getNameElement();
            if (definition.getKind() == ObjectKind.BODY && nameElement != null && nameElement.getLastChild() instanceof SqlReferenceExpression) {
                nameElement = (SqlNameElement)nameElement.getLastChild();
            }
            PsiReference nameRef = nameElement != null ? nameElement.getReference() : null;
            ref = nameRef instanceof SqlReferenceImpl ? (SqlReferenceImpl)nameRef : null;
        } else {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        if (ref != null) {
            resolved = ref.resolve();
            element = ref.getElement();
            refType = ref.getReferenceElementType();
        } else {
            resolved = definition;
            element = definition;
            SqlReferenceElementType sqlReferenceElementType = refType = definition.getKind() == ObjectKind.COLUMN ? SqlCompositeElementTypes.SQL_COLUMN_REFERENCE : SqlCompositeElementTypes.SQL_REFERENCE;
        }
        if (!(resolved instanceof DasObject)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        DasObject dasResolved = (DasObject)resolved;
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element);
        String refText = QNameUtil.getQualifiedName(dasResolved, (Function<DasObject, String>)((Function)o -> dialect.getDatabaseDialect().quoteIdentifier(dialect.getCasing(o.getKind(), null).choose(!DbSqlUtil.isQuoted(o)).apply(o.getName()), false, false)));
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, (PsiElement)element);
        SqlReferenceImpl sqlReferenceImpl = targetRef = newRef == null ? ref : newRef.getReference();
        if (targetRef == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        if (newRef != null) {
            newRef.getContainingFile().putUserData(SqlReferenceImpl.IGNORE_LOCAL_DDL, (Object)true);
        }
        JBIterable jBIterable = JBIterable.of((Object[])targetRef.multiResolve(false)).transform(result2 -> result2.getElement()).filter(DbElement.class);
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiElement o) {
        if (o == null || !o.isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlReferenceExpression.class, (boolean)false);
        SqlDefinition definition = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)o, SqlDefinition.class, (boolean)false);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)o);
        DbDataSource dataSource = virtualFile == null ? null : DbImplUtil.findDataSource(o.getProject(), virtualFile);
        JBIterable<DbElement> result1 = ref != null ? SqlDocumentationProvider.findRelatedDbElements((PsiReference)ref.getReference(), null) : JBIterable.empty();
        JBIterable result2 = SyntaxTraverser.psiApi().parents((Object)definition).filter(SqlDefinition.class).flatMap(parentDef -> SqlDocumentationProvider.findRelatedDbElements(null, parentDef));
        JBIterable jBIterable = result1.append((Iterable)result2).append((Object)dataSource);
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlDocumentationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlDocumentationProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

