/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.common.SqlGeneratedParser;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.support.SqlPairedBraceMatcher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.TObjectLongHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlGeneratedParserUtil
extends GeneratedParserUtilBase {
    private static final WhitespacesAndCommentsBinder BLOCK_LEFT_BINDER = WhitespacesBinders.leadingCommentsBinder((TokenSet)SqlTokens.COMMENT_TOKENS);
    private static final WhitespacesAndCommentsBinder BLOCK_RIGHT_BINDER = WhitespacesBinders.trailingCommentsBinder((TokenSet)SqlTokens.COMMENT_TOKENS);
    public static final GeneratedParserUtilBase.Parser PARSE_FUNCTION_CALL_TAIL = new GeneratedParserUtilBase.Parser(){

        public boolean parse(PsiBuilder builder, int level) {
            return SqlGeneratedParserUtil.getParser(builder).parseFunctionCallTail(builder, level);
        }
    };
    private static final Key<TObjectLongHashMap<String>> MODES_KEY = Key.create((String)"MODES_KEY");
    private static final Key<LighterASTNode> EXPOSED_REF_KEY = Key.create((String)"EXPOSED_REF_KEY");
    public static final GeneratedParserUtilBase.Hook<Void> UNWRAP_IF_SINGLE = (builder, marker, param) -> {
        int end;
        if (marker == null) {
            return null;
        }
        PsiBuilderImpl.ProductionMarker m = (PsiBuilderImpl.ProductionMarker)marker;
        int start = m.getStartIndex();
        if (start + 1 == (end = m.getEndIndex())) {
            marker.drop();
        } else {
            int cnt = 0;
            int pos = builder.rawTokenIndex();
            for (int i2 = end; i2 > start && cnt < 2; --i2) {
                IElementType type = builder.rawLookup(i2 - pos - 1);
                if (type == null || SqlGeneratedParserUtil.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) continue;
                ++cnt;
            }
            if (cnt == 1) {
                marker.drop();
            }
        }
        return marker;
    };

    public static PsiBuilder adapt_builder_(IElementType root2, PsiBuilder builder, PsiParser parser, TokenSet[] tokenSets) {
        TokenSet[] combinedTokenSets = tokenSets == null ? SqlGeneratedParser.EXTENDS_SETS_ : (TokenSet[])ArrayUtil.mergeArrays((Object[])tokenSets, (Object[])SqlGeneratedParser.EXTENDS_SETS_);
        PsiBuilder result2 = GeneratedParserUtilBase.adapt_builder_((IElementType)root2, (PsiBuilder)builder, (PsiParser)parser, (TokenSet[])combinedTokenSets);
        GeneratedParserUtilBase.ErrorState.get((PsiBuilder)result2).braces = SqlPairedBraceMatcher.PAIRS;
        GeneratedParserUtilBase.ErrorState.get((PsiBuilder)result2).altMode = true;
        return result2;
    }

    protected static SqlParser getParser(@NotNull PsiBuilder builder) {
        if (builder == null) {
            SqlGeneratedParserUtil.$$$reportNull$$$0(0);
        }
        return (SqlParser)((GeneratedParserUtilBase.Builder)builder).parser;
    }

    public static TokenSet create_token_set_(IElementType ... tokenTypes_) {
        TokenSet set = TokenSet.create((IElementType[])tokenTypes_);
        if (set.contains((IElementType)SqlCompositeElementTypes.SQL_EXPRESSION) || set.contains((IElementType)SqlCompositeElementTypes.SQL_BINARY_EXPRESSION)) {
            set = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_EXPRESSION, SqlCompositeElementTypes.SQL_VARIABLE_REFERENCE, SqlCompositeElementTypes.SQL_ARGUMENT_REFERENCE, SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, SqlCompositeElementTypes.SQL_STRING_LITERAL, SqlCompositeElementTypes.SQL_STRING_LITERAL_CONCATENATION, SqlCompositeElementTypes.SQL_SPECIAL_LITERAL})});
        }
        if (set.contains((IElementType)SqlCompositeElementTypes.SQL_STATEMENT)) {
            set = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_USE_SCHEMA_STATEMENT})});
        }
        return set;
    }

    public static boolean remapStatementType(PsiBuilder builder, int level, IElementType statementType) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        GeneratedParserUtilBase.Frame frame = state.currentFrame;
        while (frame != null) {
            if (state.typeExtends(frame.elementType, (IElementType)SqlCompositeElementTypes.SQL_STATEMENT)) {
                if (frame.elementType instanceof IStubElementType && frame.elementType != SqlCompositeElementTypes.SQL_ALTER_STATEMENT) {
                    return true;
                }
                frame.elementType = statementType;
                return true;
            }
            frame = frame.parentFrame;
        }
        return true;
    }

    public static boolean convertToUseStatement(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.remapStatementType(builder, level, (IElementType)SqlCompositeElementTypes.SQL_USE_SCHEMA_STATEMENT);
    }

    public static LighterASTNode getExposedFunctionRef(PsiBuilder builder) {
        LighterASTNode ref = (LighterASTNode)EXPOSED_REF_KEY.get((UserDataHolder)builder);
        if (ref == null) {
            ref = builder.getLatestDoneMarker();
        }
        return ref;
    }

    public static boolean exposeFunctionRef(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        LighterASTNode marker;
        LighterASTNode prev = (LighterASTNode)EXPOSED_REF_KEY.get((UserDataHolder)builder);
        if (prev == (marker = builder.getLatestDoneMarker())) {
            return parser.parse(builder, level);
        }
        EXPOSED_REF_KEY.set((UserDataHolder)builder, (Object)marker);
        boolean result2 = parser.parse(builder, level);
        EXPOSED_REF_KEY.set((UserDataHolder)builder, (Object)prev);
        return result2;
    }

    private static TObjectLongHashMap<String> getParsingModes(PsiBuilder builder) {
        TObjectLongHashMap flags = (TObjectLongHashMap)builder.getUserDataUnprotected(MODES_KEY);
        if (flags == null) {
            flags = new TObjectLongHashMap();
            builder.putUserDataUnprotected(MODES_KEY, (Object)flags);
        }
        return flags;
    }

    public static boolean reportError(PsiBuilder builder, int level, int ignored) {
        builder.eof();
        SqlGeneratedParserUtil.report_error_((PsiBuilder)builder, (boolean)false);
        return true;
    }

    public static boolean doNotCollapse(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        if (frame != null && (frame.modifiers & 8) != 0) {
            frame = frame.parentFrame;
        }
        if (frame != null) {
            frame.modifiers &= 0xFFFFFFFE;
        }
        return true;
    }

    public static boolean setOn(PsiBuilder builder, int level, String mode) {
        TObjectLongHashMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        map2.put((Object)mode, map2.get((Object)mode) << 1 | 1L);
        return true;
    }

    public static boolean isOn(PsiBuilder builder, int level, String mode) {
        TObjectLongHashMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        return (map2.get((Object)mode) & 1L) != 0L;
    }

    public static boolean isQualificationForbidden(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.isOn(builder, level, "FORBID_QUALIFICATION");
    }

    public static boolean forbidQualification(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        return SqlGeneratedParserUtil.withOn(builder, level, "FORBID_QUALIFICATION", parser);
    }

    public static boolean clearOn(PsiBuilder builder, int level, String mode) {
        TObjectLongHashMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        long prev = map2.get((Object)mode);
        if ((prev & 1L) == 1L) {
            map2.put((Object)mode, prev >> 1);
        } else {
            builder.error("could not clear inactive mode '" + mode + "' at offset " + builder.getCurrentOffset());
        }
        return true;
    }

    public static boolean clearIfOn(PsiBuilder builder, int level, String mode) {
        boolean result2;
        TObjectLongHashMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        boolean bl = result2 = (map2.get((Object)mode) & 1L) != 0L;
        if (result2) {
            map2.put((Object)mode, map2.get((Object)mode) >> 1);
        }
        return result2;
    }

    public static boolean withClearedAfter(PsiBuilder builder, int level, String mode, GeneratedParserUtilBase.Parser parser) {
        boolean result2 = parser.parse(builder, level);
        TObjectLongHashMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        map2.put((Object)mode, 0L);
        return result2;
    }

    public static boolean withOn(PsiBuilder builder, int level, String mode, GeneratedParserUtilBase.Parser parser) {
        return SqlGeneratedParserUtil.withImpl(builder, level, mode, true, parser, parser);
    }

    public static boolean withOff(PsiBuilder builder, int level, String mode, GeneratedParserUtilBase.Parser parser) {
        return SqlGeneratedParserUtil.withImpl(builder, level, mode, false, parser, parser);
    }

    public static boolean withCleared(PsiBuilder builder, int level, String mode, GeneratedParserUtilBase.Parser whenOn, GeneratedParserUtilBase.Parser whenOff) {
        return SqlGeneratedParserUtil.withImpl(builder, level, mode, false, whenOn, whenOff);
    }

    private static boolean withImpl(PsiBuilder builder, int level, String mode, boolean onOff, GeneratedParserUtilBase.Parser whenOn, GeneratedParserUtilBase.Parser whenOff) {
        boolean change;
        TObjectLongHashMap<String> map2 = SqlGeneratedParserUtil.getParsingModes(builder);
        long prev = map2.get((Object)mode);
        boolean bl = change = (prev & 1L) == 0L == onOff;
        if (change) {
            map2.put((Object)mode, prev << 1 | (long)(onOff ? 1 : 0));
        }
        boolean result2 = (change ? whenOn : whenOff).parse(builder, level);
        if (change) {
            map2.put((Object)mode, prev);
        }
        return result2;
    }

    public static boolean parseAndMarkError(PsiBuilder builder, int level, String contentName, GeneratedParserUtilBase.Parser parser) {
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, null);
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        boolean parse = parser.parse(builder, level);
        state.clearVariants(state.currentFrame);
        if (parse) {
            m.precede().error("unexpected '" + contentName + "'");
        }
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)m, null, (boolean)true, (boolean)false, null);
        return parse;
    }

    public static boolean otherBranchGuard(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        PsiBuilder.Marker mark = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)8);
        boolean result2 = !SqlGeneratedParserUtil.withProtectedLastVariantPos((PsiBuilder)builder, (int)level, (GeneratedParserUtilBase.Parser)parser);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)mark, (boolean)result2, (boolean)false, null);
        return result2;
    }

    public static boolean commaParenSemicolonStrict(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType == SqlTokens.SQL_COMMA || tokenType == SqlTokens.SQL_RIGHT_PAREN || tokenType == SqlTokens.SQL_SEMICOLON;
    }

    public static boolean commaParenSemicolonFast(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType == SqlTokens.SQL_COMMA || tokenType == SqlTokens.SQL_RIGHT_PAREN || SqlGeneratedParserUtil.getParser(builder).getLanguage().getStatementSeparators().contains(tokenType);
    }

    public static boolean parenSemicolonFast(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType == SqlTokens.SQL_RIGHT_PAREN || SqlGeneratedParserUtil.getParser(builder).getLanguage().getStatementSeparators().contains(tokenType);
    }

    public static boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        return SqlGeneratedParserUtil.getParser(builder).statementRecover(builder, level, prefixParser);
    }

    public static boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).statementRecoverPrefixParser(builder, level);
    }

    public static boolean isCompletionHere(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.CompletionState completionState = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).completionState;
        String txt = builder.getTokenText();
        int offset = builder.getCurrentOffset();
        int tokLen = txt == null ? 0 : txt.length();
        return completionState != null && (offset + tokLen == completionState.offset || offset == completionState.offset);
    }

    public static boolean clearVariants(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        state.clearVariants(state.currentFrame);
        return true;
    }

    public static boolean reservedKeywordHereCondition(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).isReservedKeywordHere(builder, builder.getTokenType());
    }

    public static boolean reservedKeywordCondition(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType instanceof SqlKeywordTokenType && SqlGeneratedParserUtil.getParser(builder).getLanguage().isReservedKeyword(tokenType);
    }

    public static boolean reservedKeywordConditionPL(PsiBuilder builder, int level) {
        IElementType tokenType = builder.getTokenType();
        return tokenType instanceof SqlKeywordTokenType && SqlGeneratedParserUtil.getParser(builder).getLanguage().isReservedKeywordPL(tokenType);
    }

    public static boolean consumeTokenIgnoreCase(PsiBuilder builder, int level, String text2) {
        return SqlGeneratedParserUtil.consumeToken((PsiBuilder)builder, (String)text2, (boolean)false);
    }

    public static boolean consumeAllTokensUpTo(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        SqlGeneratedParserUtil.parseAsTree(builder, level, (IElementType)SqlCompositeElementTypes.SQL_GENERIC_ELEMENT, true, TOKEN_ADVANCER, parser);
        return true;
    }

    public static boolean parseBlockContent(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        return SqlGeneratedParserUtil.parseBlockContent(builder, level, parser, parser);
    }

    public static boolean consumeStringTokenSilently(PsiBuilder builder, int level) {
        if (builder.getTokenType() == SqlTokens.SQL_STRING_TOKEN) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeStringToken(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).consumeStringToken(builder, true);
    }

    public static boolean parseBlockContent(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser0, GeneratedParserUtilBase.Parser parser) {
        boolean r;
        PsiBuilder.Marker m = builder.mark();
        boolean p = r = parser0.parse(builder, level + 1);
        boolean bl = r = r && SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (PsiBuilder)builder, (int)level, (IElementType)SqlElementTypes.SQL_DUMMY_BLOCK, (boolean)false, (GeneratedParserUtilBase.Parser)parser, (GeneratedParserUtilBase.Parser)TRUE_CONDITION);
        if (r || p) {
            m.done(SqlElementTypes.SQL_DUMMY_BLOCK);
            m.setCustomEdgeTokenBinders(BLOCK_LEFT_BINDER, BLOCK_RIGHT_BINDER);
        } else {
            m.rollbackTo();
        }
        return r || p;
    }

    public static boolean parseAsTree(PsiBuilder builder, int level, IElementType element, boolean checkParens, GeneratedParserUtilBase.Parser advancer, GeneratedParserUtilBase.Parser condition) {
        return SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (PsiBuilder)builder, (int)level, (IElementType)element, (boolean)checkParens, (GeneratedParserUtilBase.Parser)advancer, (GeneratedParserUtilBase.Parser)condition);
    }

    public static boolean parseAsTree(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        return SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (PsiBuilder)builder, (int)level, (IElementType)SqlElementTypes.SQL_DUMMY_BLOCK, (boolean)false, (GeneratedParserUtilBase.Parser)parser, (GeneratedParserUtilBase.Parser)TRUE_CONDITION);
    }

    public static boolean parseListAsTree(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser, GeneratedParserUtilBase.Parser separator) {
        boolean result2 = SqlGeneratedParserUtil.report_error_((PsiBuilder)builder, (boolean)parser.parse(builder, level));
        return SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (PsiBuilder)builder, (int)level, (IElementType)SqlElementTypes.SQL_DUMMY_BLOCK, (boolean)false, (GeneratedParserUtilBase.Parser)parser, (GeneratedParserUtilBase.Parser)separator) || result2;
    }

    public static boolean parseScript(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        SqlGeneratedParserUtil.parseAsTree(builder, level, SqlElementTypes.SQL_DUMMY_BLOCK, true, parser, TRUE_CONDITION);
        return true;
    }

    public static boolean parseReference(PsiBuilder builder, int level, SqlReferenceElementType type) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)(type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE ? "<operator>" : "<reference>"));
        return SqlGeneratedParserUtil.getParser(builder).parseReferenceExpressionOrVariable(builder, type);
    }

    public static boolean parseIdentifierInner(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<identifier>");
        return SqlGeneratedParserUtil.getParser(builder).parseIdentifierInner(builder, true, true, false);
    }

    public static boolean parseIdentifier(PsiBuilder builder, int level) {
        return SqlGeneratedParser.single_identifier(builder, level);
    }

    public static boolean consumeIdentifier(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<identifier>");
        return SqlGeneratedParserUtil.getParser(builder).consumeIdentifier(builder);
    }

    public static boolean consumeDelimitedIdentifier(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SqlTokens.SQL_IDENT_DELIMITED);
    }

    public static boolean parseSimpleExpression(PsiBuilder builder, int level, int type) {
        PsiBuilder.Marker marker = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, (String)"<expression>");
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<expression>");
        SqlParser parser = SqlGeneratedParserUtil.getParser(builder);
        boolean result2 = false;
        switch (type) {
            case 1: {
                result2 = parser.parseLValueExpression(builder, level);
                break;
            }
            case 5: {
                result2 = parser.parseLiteral(builder, level, true);
                break;
            }
            case 7: {
                result2 = parser.parseLiteralReferenceOrFunction(builder, level, true);
                break;
            }
            default: {
                builder.error("Unknown parseSimpleExpression: " + type);
            }
        }
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)marker, null, (boolean)result2, (boolean)false, null);
        return result2;
    }

    public static boolean parseValueExpression(PsiBuilder builder, int level) {
        PsiBuilder.Marker marker = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, (String)"<expression>");
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<expression>");
        SqlParser parser = SqlGeneratedParserUtil.getParser(builder);
        boolean result2 = parser.parseValueExpression(builder, level, true);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)marker, null, (boolean)result2, (boolean)false, null);
        return result2;
    }

    public static boolean parseQualificationItem(PsiBuilder builder, int level) {
        if (!SqlGeneratedParserUtil.parseIdentifierInner(builder, level)) {
            return false;
        }
        return SqlGeneratedParserUtil.remapCurrentReference(builder, level);
    }

    public static boolean remapCurrentReference(PsiBuilder builder, int level) {
        IElementType type;
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        IElementType iElementType = type = state.currentFrame == null ? null : (IElementType)ObjectUtils.chooseNotNull((Object)state.currentFrame.elementType, (Object)SqlCompositeElementTypes.SQL_REFERENCE);
        if (type == SqlCompositeElementTypes.SQL_REFERENCE && !SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SqlTokens.SQL_PERIOD)) {
            state.currentFrame.elementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
        }
        return true;
    }

    public static boolean identifierCondition(PsiBuilder builder, int level) {
        IElementType type = builder.getTokenType();
        SqlParser parser = SqlGeneratedParserUtil.getParser(builder);
        SqlLanguageDialectEx language = parser.getLanguage();
        boolean skipFunction = parser.isReservedKeywordHere(builder, type) && !language.getSupportedFunctions().containsKey(builder.getTokenText()) && builder.rawLookup(1) != SqlTokens.SQL_PERIOD;
        return !skipFunction;
    }

    public static boolean parseSimpleRefOrFunction(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser extra) {
        if (!SqlGeneratedParserUtil.identifierCondition(builder, level)) {
            return false;
        }
        PsiBuilder.Marker marker = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, (IElementType)SqlCompositeElementTypes.SQL_REFERENCE, null);
        boolean result2 = SqlGeneratedParserUtil.parseIdentifierInner(builder, level);
        result2 = result2 && (extra == null || extra.parse(builder, level));
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)marker, (boolean)result2, (boolean)false, null);
        if (!result2) {
            return false;
        }
        PsiBuilderImpl.ProductionMarker refMarker = (PsiBuilderImpl.ProductionMarker)ObjectUtils.assertNotNull((Object)((PsiBuilderImpl.ProductionMarker)builder.getLatestDoneMarker()));
        int offset = builder.getCurrentOffset();
        result2 = SqlGeneratedParserUtil.exposeFunctionRef(builder, level, PARSE_FUNCTION_CALL_TAIL);
        if (!result2) {
            if (!SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SqlTokens.SQL_PERIOD)) {
                refMarker.remapTokenType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
            }
        } else {
            marker.precede().done((IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL);
            if (offset != builder.getCurrentOffset() && refMarker.getTokenType() == SqlCompositeElementTypes.SQL_REFERENCE) {
                refMarker.remapTokenType((IElementType)SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE);
            }
        }
        return true;
    }

    public static boolean parseArgumentListTail(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.exposeFunctionRef(builder, level, PARSE_FUNCTION_CALL_TAIL);
    }

    public static boolean parseString(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<string>");
        return SqlGeneratedParserUtil.getParser(builder).parseStringLiteralOrParameter(builder);
    }

    public static boolean parseNumber(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<number>");
        return SqlGeneratedParserUtil.getParser(builder).parseNumberLiteralOrParameter(builder, false);
    }

    public static boolean parseFloat(PsiBuilder builder, int level) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<number>");
        return SqlGeneratedParserUtil.getParser(builder).parseNumberLiteralOrParameter(builder, true);
    }

    public static boolean consumeNumericToken(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SqlTokens.SQL_INTEGER_TOKEN) || SqlGeneratedParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SqlTokens.SQL_FLOAT_TOKEN);
    }

    public static boolean parseDatabaseFunction(PsiBuilder builder, int level, boolean allowNoParens, boolean pinned) {
        SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<function call>");
        if (allowNoParens) {
            return SqlGeneratedParser.database_function_call_expression(builder, level);
        }
        if (pinned) {
            return SqlGeneratedParser.database_pinned_function_call_strict_expression(builder, level);
        }
        return SqlGeneratedParser.database_function_call_strict_expression(builder, level);
    }

    public static boolean parseAndRemapToCallable(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        boolean result2;
        PsiBuilderImpl.ProductionMarker refMarker = (PsiBuilderImpl.ProductionMarker)ObjectUtils.tryCast((Object)builder.getLatestDoneMarker(), PsiBuilderImpl.ProductionMarker.class);
        IElementType type = refMarker == null ? null : refMarker.getTokenType();
        int offset = builder.getCurrentOffset();
        boolean bl = result2 = SqlGeneratedParserUtil.getParser(builder).canBeCalled(type) && parser.parse(builder, level);
        if (result2) {
            boolean empty;
            boolean bl2 = empty = offset == builder.getCurrentOffset();
            if (type instanceof SqlReferenceElementType) {
                refMarker.remapTokenType((IElementType)(empty ? SqlCompositeElementTypes.SQL_REFERENCE : SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE));
            } else {
                result2 = !empty;
            }
        }
        return result2;
    }

    public static boolean parseAndRemapToGenericReference(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser parser) {
        IElementType type;
        boolean result2 = parser.parse(builder, level);
        PsiBuilderImpl.ProductionMarker refMarker = (PsiBuilderImpl.ProductionMarker)ObjectUtils.tryCast((Object)builder.getLatestDoneMarker(), PsiBuilderImpl.ProductionMarker.class);
        IElementType iElementType = type = refMarker == null ? null : refMarker.getTokenType();
        if (type instanceof SqlReferenceElementType) {
            refMarker.remapTokenType((IElementType)SqlCompositeElementTypes.SQL_REFERENCE);
        }
        return result2;
    }

    public static SqlReferenceElementType shorten(SqlReferenceElementType ref) {
        if (ref == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
            return SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
        }
        return ref;
    }

    public static boolean remapReference(PsiBuilder builder, int level, IElementType ref, GeneratedParserUtilBase.Parser parser) {
        PsiBuilderImpl.ProductionMarker refMarker;
        SqlReferenceElementType refType = (SqlReferenceElementType)ObjectUtils.tryCast((Object)ref, SqlReferenceElementType.class);
        if (refType != null && refType.isQualified() && SqlGeneratedParserUtil.isQualificationForbidden(builder, level)) {
            ref = SqlGeneratedParserUtil.shorten(refType);
        }
        IElementType type = (refMarker = (PsiBuilderImpl.ProductionMarker)ObjectUtils.tryCast((Object)builder.getLatestDoneMarker(), PsiBuilderImpl.ProductionMarker.class)) == null ? null : refMarker.getTokenType();
        boolean subscript = SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SqlTokens.SQL_LEFT_BRACKET);
        boolean result2 = parser.parse(builder, level);
        if (result2 && type == SqlCompositeElementTypes.SQL_REFERENCE && subscript) {
            refMarker.remapTokenType(ref);
        }
        return result2;
    }

    public static boolean remapReference(PsiBuilder builder, int level, IElementType ref) {
        return SqlGeneratedParserUtil.remapReference(builder, level, ref, TRUE_CONDITION);
    }

    public static boolean isDialect(PsiBuilder builder, int level, SqlLanguageDialect dialect) {
        return SqlGeneratedParserUtil.getParser(builder).getLanguage() == dialect;
    }

    public static boolean parseStatementSeparator(PsiBuilder builder, int level, boolean mark) {
        return SqlGeneratedParserUtil.getParser(builder).parseStatementSeparatorAndMark(builder, mark);
    }

    public static boolean statementSeparatorParsed(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).isStatementSeparatorParsed();
    }

    public static boolean parseKnownFunctionArgumentList(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseKnownFunctionArgumentList(builder, level);
    }

    public static boolean parseFunctionArgument(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseFunctionArgument(builder, level, true, true);
    }

    public static boolean parseCustomReferenceExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseParameterOrVariableReference(builder, true);
    }

    public static boolean parseOptReferenceDotTail(PsiBuilder builder, int level, SqlReferenceElementType refType, GeneratedParserUtilBase.Parser tail) {
        if (tail.parse(builder, level)) {
            return true;
        }
        if (SqlGeneratedParser.opt_reference_with_tail(builder, level, tail)) {
            PsiBuilderImpl.ProductionMarker latestDoneMarker = (PsiBuilderImpl.ProductionMarker)ObjectUtils.assertNotNull((Object)((PsiBuilderImpl.ProductionMarker)builder.getLatestDoneMarker()));
            latestDoneMarker.remapTokenType((IElementType)refType);
            return tail.parse(builder, level);
        }
        return false;
    }

    public static boolean consumeSystemVar(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.consumeWellKnownTokens(builder, SqlGeneratedParserUtil.getParser(builder).getLanguage().getSystemVariables(), "<system variable>");
    }

    public static boolean consumeExceptionName(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.consumeWellKnownTokens(builder, SqlGeneratedParserUtil.getParser(builder).getLanguage().getExceptionNames(), "<exception name>");
    }

    public static boolean consumeWellKnownTokens(PsiBuilder builder, Set<String> tokens, String tokenName) {
        if (SqlGeneratedParserUtil.isInCompletion(builder, 0)) {
            for (String t : tokens) {
                SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)t);
            }
        } else {
            SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)tokenName);
        }
        IElementType type = builder.getTokenType();
        if ((type == SqlTokens.SQL_IDENT || type instanceof SqlTokenType) && tokens.contains(builder.getTokenText())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean isInCompletion(PsiBuilder builder, int level) {
        return GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).completionState != null;
    }

    public static boolean argumentListStart(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseFunctionParametersStart(builder, level, null);
    }

    public static boolean argumentListEnd(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseFunctionParametersEnd(builder, level, null);
    }

    public static boolean argumentListRecover(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).argumentListRecover(builder, level);
    }

    public static boolean isText(PsiBuilder builder, int level, String txt) {
        builder.eof();
        return StringUtil.startsWith((CharSequence)builder.getOriginalText(), (int)builder.getCurrentOffset(), (CharSequence)txt);
    }

    public static boolean remapCurrentFrame(PsiBuilder builder, int level, IElementType type) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        while (frame != null && frame.elementType == null) {
            frame = frame.parentFrame;
        }
        if (frame != null) {
            frame.elementType = type;
        }
        return true;
    }

    public static boolean expandPrevFrame(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        LighterASTNode marker = builder.getLatestDoneMarker();
        if (marker != null) {
            while (frame != null && frame.elementType == null) {
                frame = frame.parentFrame;
            }
            if (frame != null) {
                frame.elementType = marker.getTokenType();
                ((PsiBuilder.Marker)marker).drop();
            }
        }
        return true;
    }

    public static boolean isQueryParsed(PsiBuilder builder, int level) {
        IElementType type = SqlGeneratedParserUtil.getLastMarkerType(builder);
        return type == SqlCompositeElementTypes.SQL_QUERY_EXPRESSION || type == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION || type == SqlCompositeElementTypes.SQL_UNION_EXPRESSION || type == SqlCompositeElementTypes.SQL_INTERSECT_EXPRESSION || type == SqlCompositeElementTypes.SQL_VALUES_EXPRESSION;
    }

    public static boolean dispatchQandXconflict(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser recParser, GeneratedParserUtilBase.Parser qParser, GeneratedParserUtilBase.Parser qTailParser, GeneratedParserUtilBase.Parser xParser, GeneratedParserUtilBase.Parser xTailParser) {
        if (builder.getTokenType() == SqlTokens.SQL_LEFT_PAREN) {
            boolean tryX;
            if (!recParser.parse(builder, level)) {
                return false;
            }
            IElementType type = SqlGeneratedParserUtil.getLastMarkerType(builder);
            boolean isQuery = type == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION;
            int offset = builder.getCurrentOffset();
            boolean bl = tryX = !isQuery;
            if (!tryX) {
                qTailParser.parse(builder, level);
                boolean bl2 = tryX = offset == builder.getCurrentOffset();
            }
            if (tryX) {
                xTailParser.parse(builder, level);
                isQuery &= offset == builder.getCurrentOffset();
            }
            if (isQuery) {
                SqlGeneratedParserUtil.remapCurrentFrame(builder, level, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION);
            }
            return true;
        }
        if (qParser.parse(builder, level)) {
            return SqlGeneratedParserUtil.remapCurrentFrame(builder, level, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION);
        }
        return xParser.parse(builder, level);
    }

    @Nullable
    private static IElementType getLastMarkerType(PsiBuilder builder) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        return marker == null ? null : marker.getTokenType();
    }

    public static boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseParenContentQorJ(builder, level);
    }

    public static boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.getParser(builder).parseParenContentQorV(builder, level);
    }

    public static boolean consumeText(PsiBuilder b, int l) {
        b.eof();
        int c = 0;
        while (!SqlGeneratedParserUtil.isTextBreaker(b.rawLookup(0))) {
            b.advanceLexer();
            ++c;
        }
        if (c == 0) {
            b.advanceLexer();
        }
        return true;
    }

    private static boolean isTextBreaker(IElementType item) {
        return item == null || SqlTokens.WHITE_SPACE_TOKENS.contains(item) || SqlTokens.COMMENT_TOKENS.contains(item) || SqlTokens.STRING_TOKENS.contains(item) || SqlTokens.STATEMENT_SEPARATORS.contains(item) || item == SqlTokens.SQL_IDENT_DELIMITED;
    }

    public static boolean delimitedWithText(PsiBuilder builder, int level, String text2, boolean sensitive) {
        if (!SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SqlTokens.SQL_IDENT_DELIMITED)) {
            return false;
        }
        SqlLanguageDialectEx language = SqlGeneratedParserUtil.getParser(builder).getLanguage();
        String unquoted = language.getDatabaseDialect().unquoteIdentifier(builder.getTokenText());
        return Comparing.strEqual((String)text2, (String)unquoted, (boolean)sensitive);
    }

    public static boolean suggestInjection(PsiBuilder builder, int level, SqlSuggestedInjection language) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        if (marker == null || marker.getTokenType() != SqlCompositeElementTypes.SQL_STRING_LITERAL) {
            return true;
        }
        PsiBuilder.Marker mark = builder.mark();
        mark.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        mark.done(SqlInfoElementType.getElementType(language));
        return true;
    }

    public static boolean injectSql(PsiBuilder builder, int level) {
        SqlSuggestedInjection injection = SqlGeneratedParserUtil.getParser(builder).getCurrentSqlInjection();
        return injection == null || SqlGeneratedParserUtil.suggestInjection(builder, level, injection);
    }

    public static boolean injectJson(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.suggestInjection(builder, level, SqlSuggestedInjection.JSON);
    }

    public static boolean injectXml(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.suggestInjection(builder, level, SqlSuggestedInjection.XML);
    }

    public static boolean injectXPath(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.suggestInjection(builder, level, SqlSuggestedInjection.XPath2);
    }

    public static boolean nonEmpty(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        GeneratedParserUtilBase.Frame frame2 = frame = frame == null ? null : frame.parentFrame;
        if (frame == null) {
            return true;
        }
        return frame.offset < builder.getCurrentOffset();
    }

    public static boolean rightAfter(PsiBuilder builder, int level, String text2) {
        if (!SqlGeneratedParserUtil.nextTokenIs((PsiBuilder)builder, (String)text2)) {
            return false;
        }
        return SqlGeneratedParserUtil.rightAfterImpl(builder);
    }

    public static boolean rightAfter(PsiBuilder builder, int level, IElementType type) {
        if (!SqlGeneratedParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)type)) {
            return false;
        }
        return SqlGeneratedParserUtil.rightAfterImpl(builder);
    }

    private static boolean rightAfterImpl(PsiBuilder builder) {
        IElementType prev = builder.rawLookup(-1);
        if (prev == null || SqlTokens.WHITE_SPACE_TOKENS.contains(prev)) {
            return false;
        }
        builder.advanceLexer();
        return true;
    }

    public static boolean hasFrameUpward(PsiBuilder builder, int level, int nframes, IElementType type) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        for (int i2 = 0; i2 < nframes && frame != null && frame.elementType != type; ++i2) {
            frame = frame.parentFrame;
        }
        return frame != null && frame.elementType == type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/SqlGeneratedParserUtil", "getParser"));
    }
}

