/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.mysql.MysqlDdlParsing;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.mysql.MysqlDmlParsing;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.MysqlExpressionParsing;
import com.intellij.sql.dialects.mysql.MysqlGeneratedParser;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MysqlParser
extends SqlParser {
    public static final SqlSuggestedInjection MYSQL_INJECTION = new SqlSuggestedInjection("MySQL");
    private static final WhitespacesAndCommentsBinder LEFT_BINDER = MysqlParser.newControlCommentBinder(true);
    private static final WhitespacesAndCommentsBinder RIGHT_BINDER = MysqlParser.newControlCommentBinder(false);

    private static WhitespacesAndCommentsBinder newControlCommentBinder(final boolean left) {
        return new WhitespacesAndCommentsBinder(){

            public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
                for (int i2 = 0; i2 < tokens.size(); ++i2) {
                    IElementType type = tokens.get(i2);
                    if (left && type == SqlTokens.MYSQL_PRAGMA_BEGIN) {
                        return i2;
                    }
                    if (!left && type == SqlTokens.MYSQL_PRAGMA_END) {
                        return i2 + 1;
                    }
                    if (left || SqlTokens.WHITE_SPACE_TOKENS.contains(type) || SqlTokens.COMMENT_TOKENS.contains(type)) continue;
                    return i2;
                }
                return left ? tokens.size() : 0;
            }
        };
    }

    public MysqlParser() {
        super(MysqlDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    protected boolean isVariableReference2(PsiBuilder builder) {
        return this.allowVariables(builder) || super.isVariableReference2(builder);
    }

    public boolean allowVariables(PsiBuilder builder) {
        return SqlGeneratedParserUtil.isOn(builder, 0, "ALLOW_VARIABLES");
    }

    @Override
    protected boolean allowIntervalLiteral() {
        return false;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first) {
        return !first && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT_DELIMITED) || super.allowNoopStringConcatenation(builder, first);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, MysqlExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.addVariant((PsiBuilder)builder, (String)"DELIMITER");
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)MysqlTokens.MYSQL_DELIMITER)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            if (this.getLanguage().getStatementSeparators().contains(builder.getTokenType())) {
                builder.advanceLexer();
            } else {
                SqlParserUtil.consumeOptionalToken(builder, BAD_CHARACTER);
                builder.error("delimiter expected");
            }
            mark.done((IElementType)MysqlElementTypes.MYSQL_DELIMITER_STATEMENT);
            this.statementSeparatorParsed();
            return true;
        }
        boolean inPragma = builder.rawLookup(-2) == MYSQL_PRAGMA_BEGIN;
        boolean result2 = MysqlGeneratedParser.statement(builder, level);
        if (result2) {
            LighterASTNode marker = (LighterASTNode)ObjectUtils.assertNotNull((Object)builder.getLatestDoneMarker());
            if (inPragma && builder.rawLookup(2) == MYSQL_PRAGMA_END && builder.rawLookup(-1) != MYSQL_PRAGMA_END && this.getLanguage().getStatementSeparators().contains(builder.getTokenType())) {
                builder.advanceLexer();
                this.statementSeparatorParsed();
                IElementType tokenType = marker.getTokenType();
                PsiBuilder.Marker precede = ((PsiBuilder.Marker)marker).precede();
                ((PsiBuilder.Marker)marker).drop();
                precede.done(tokenType);
                marker = (LighterASTNode)precede;
            }
            ((PsiBuilder.Marker)marker).setCustomEdgeTokenBinders(LEFT_BINDER, RIGHT_BINDER);
        }
        return result2;
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return MysqlGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return MysqlDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return MysqlDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = MysqlExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    protected boolean allowAnyIdentifierInOdbc() {
        return true;
    }

    @Override
    public boolean parseReferenceExpressionOrVariable(PsiBuilder builder, SqlReferenceElementType refType) {
        if (refType == SQL_VARIABLE_REFERENCE || this.allowVariables(builder) && this.getLanguage().isVariablePrefix(builder.getTokenText())) {
            return this.parseParameterOrVariableReference(builder, false);
        }
        return this.parseReferenceExpressionInner(builder, true, true, refType);
    }

    @Override
    public boolean parseLValueExpression(PsiBuilder builder, int level) {
        if (this.isVariableReference(builder)) {
            return this.parseParameterOrVariableReference(builder, false);
        }
        return super.parseLValueExpression(builder, level);
    }

    @Override
    public boolean parseParameterReferenceInner(PsiBuilder builder, IElementType paramToken, IElementType resultType) {
        PsiBuilder.Marker mark = builder.mark();
        if (paramToken != SQL_IDENT) {
            builder.advanceLexer();
            this.parseIdentifier(builder, false);
        } else if (GeneratedParserUtilBase.nextTokenIsFast((PsiBuilder)builder, (String)"@@session") || GeneratedParserUtilBase.nextTokenIsFast((PsiBuilder)builder, (String)"@@global")) {
            if (SqlParserUtil.consumeToken(builder, (IElementType)SQL_IDENT) && SqlParserUtil.consumeToken(builder, (IElementType)SQL_PERIOD)) {
                this.parseIdentifier(builder, false);
            }
        } else {
            this.parseIdentifier(builder, false);
        }
        mark.done(resultType);
        return true;
    }

    @Override
    public IElementType parseLiteralOther(PsiBuilder builder, int level) {
        String prefix;
        Object resultType;
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_BRACE) && (resultType = "ts".equals(prefix = builder.getTokenText()) ? SQL_TIMESTAMP_LITERAL : ("d".equals(prefix) ? SQL_DATE_LITERAL : ("t".equals(prefix) ? SQL_TIME_LITERAL : null))) != null) {
            builder.advanceLexer();
            this.consumeStringToken(builder, false);
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_BRACE);
            return resultType;
        }
        return super.parseLiteralOther(builder, level);
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean plain) {
        if (!super.parseFunctionParametersAndParens(builder, level, functionName, definition, plain)) {
            return false;
        }
        String against = "AGAINST";
        if ("MATCH".equals(functionName)) {
            SqlFunctionDefinition def2 = this.getLanguage().getSupportedFunctions().get(against);
            String text2 = builder.getTokenText();
            if (!against.equalsIgnoreCase(text2)) {
                SqlParserUtil.markTokenAsUnexpectedAndAdvance(builder, against);
                return true;
            }
            PsiBuilder.Marker marker = GeneratedParserUtilBase.enter_section_((PsiBuilder)builder, (int)level, (int)0, (IElementType)SQL_FUNCTION_CALL, (String)"<function call expression>");
            this.parseReferenceExpression(builder, false, SQL_ANY_CALLABLE_REFERENCE);
            super.parseFunctionParametersAndParens(builder, level, functionName, def2, plain);
            GeneratedParserUtilBase.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)marker, null, (boolean)true, (boolean)false, null);
        }
        return true;
    }

    @Override
    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return MYSQL_INJECTION;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, MysqlExpressionParsing::parenthesized_values_expr, MysqlDmlParsing::top_query_expression, MysqlParser::parseTopQueryExpressionTail, MysqlExpressionParsing::row_element_list, (b, l) -> MysqlExpressionParsing.root_expr_0(b, l, -1) && MysqlExpressionParsing.row_element_list_separator(b, l) && MysqlExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, MysqlDmlParsing::parenthesized_aliased_join_expression, MysqlDmlParsing::top_query_expression, MysqlParser::parseTopQueryExpressionTail, MysqlDmlParsing::comma_join_expression, MysqlParser::parsePJoinExpressionTail);
    }

    private static boolean parsePJoinExpressionTail(PsiBuilder b, int l) {
        MysqlDmlParsing.join_expression_0(b, l, -1);
        MysqlDmlParsing.left_comma_join_expression(b, l);
        return true;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        MysqlDmlParsing.query_expression_0(builder, level, -1);
        return MysqlDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

