/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.vfs.SearchPath;
import com.intellij.lang.InjectableLanguage;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PostgresDialectBase;
import com.intellij.sql.dialects.postgres.PostgresElementFactory;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.dialects.postgres.PostgresReservedKeywords;
import com.intellij.sql.dialects.postgres.PostgresTokens;
import com.intellij.sql.dialects.postgres.psi.PgCodeBlockElementType;
import com.intellij.sql.dialects.postgres.psi.PgCreatePreparedStatement;
import com.intellij.sql.dialects.postgres.refactoring.PostgresExtractVariableHelper;
import com.intellij.sql.dialects.sybase.SybaseDialect;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlForLoopStatement;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresDialect
extends PostgresDialectBase {
    public static final PostgresDialect INSTANCE = new PostgresDialect();
    private static final ObjectName PUBLIC_NAME = ObjectName.quoted((String)"public");

    public PostgresDialect() {
        super("PostgreSQL");
    }

    protected PostgresDialect(@NonNls @NotNull String id) {
        if (id == null) {
            PostgresDialect.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.PostgresDialect postgresDialect = com.intellij.database.dialects.PostgresDialect.INSTANCE;
        if (postgresDialect == null) {
            PostgresDialect.$$$reportNull$$$0(1);
        }
        return postgresDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map2 = LazyData.ourFunctionMap;
        if (map2 == null) {
            PostgresDialect.$$$reportNull$$$0(2);
        }
        return map2;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(PostgresTokens.class);
        if (set == null) {
            PostgresDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            PostgresDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            PostgresDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        Object preparedStatement;
        SqlDmlInstruction insert;
        SqlPrimitiveType type;
        SyntaxTraverser.ApiEx api;
        PsiElement conflictAction;
        String nameUC;
        if (element == null) {
            PostgresDialect.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PostgresDialect.$$$reportNull$$$0(7);
        }
        String string = nameUC = name == null ? null : name.toUpperCase(Locale.ENGLISH);
        if (SqlImplUtil.equalsInsensitiveOrTrue(name, LazyData.RE_EXCLUDED.name, resolve) && (conflictAction = (PsiElement)(api = SyntaxTraverser.psiApi()).parents((Object)element).filter(PostgresDialect.isType((IElementType)PostgresElementTypes.PG_CONFLICT_ACTION_CLAUSE)).first()) != null && !api.children((Object)conflictAction).filter(PostgresDialect.isType((IElementType)SqlTokens.SQL_UPDATE)).isEmpty() && !processor.executeTarget(LazyData.RE_EXCLUDED, element, (SqlType)((type = (insert = (SqlDmlInstruction)api.parents((Object)element).filter(SqlDmlInstruction.class).first()) == null ? SqlType.UNKNOWN : insert.getTargetExpression().getSqlType()) == SqlType.UNKNOWN ? SqlTableTypeBase.EMPTY_TABLE : type), false, ResolveState.initial())) {
            return false;
        }
        if (resolve && name != null && LazyData.ARG_PATTERN.matcher(name).matches() && (preparedStatement = (PgCreatePreparedStatement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{PgCreatePreparedStatement.class})) != null && !processor.executeTarget(((PgCreatePreparedStatement)((Object)preparedStatement)).getArgument(name), element, (SqlType)SqlType.UNKNOWN, null, ResolveState.initial())) {
            return false;
        }
        if (this.inPl(element)) {
            if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.RE_FOUND.name, name, resolve) && !processor.executeTarget(LazyData.RE_FOUND, element, this.BOOLEAN, false, ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.SQLSTATE.name, name, resolve) && PostgresDialect.raiseStatement(element) && !processor.executeTarget(LazyData.SQLSTATE, element, this.INTEGER, false, ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.SQLERRM.name, name, resolve) && PostgresDialect.raiseStatement(element) && !processor.executeTarget(LazyData.SQLERRM, element, this.STRING, false, ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(PostgresElementTypes.Extra.OPERATOR_CLASS)) {
            if (!resolve) {
                for (DasObject target : LazyData.RE_OPS.values()) {
                    if (processor.executeTarget(target, element, REFERENCE, false, ResolveState.initial())) continue;
                    return false;
                }
            } else if (LazyData.RE_OPS.containsKey(nameUC) && !processor.executeTarget(LazyData.RE_OPS.get(nameUC), element, REFERENCE, false, ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (DasObject entity : LazyData.RESERVED_INTEGER_ENTITIES.values()) {
                if (PostgresDialect.processReservedEntitiesWithTypeSimple(entity, this.INTEGER, name, element, resolve, processor, true, false)) continue;
                return false;
            }
        }
        if (element instanceof SqlReferenceExpression) {
            SqlType querySqlType;
            SqlQueryExpression query;
            SqlReferenceExpression variableRef;
            SqlForLoopStatement forLoop;
            SqlExpression qualifier = ((SqlReferenceExpression)element).getQualifierExpression();
            PsiElement qualifierTarget = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
            SqlForLoopStatement sqlForLoopStatement = forLoop = qualifierTarget == null ? null : (SqlForLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlForLoopStatement.class);
            while (!(forLoop == null || (variableRef = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)forLoop, SqlReferenceExpression.class)) != null && qualifierTarget.equals(variableRef.resolve()))) {
                forLoop = (SqlForLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)forLoop, SqlForLoopStatement.class, (boolean)true);
            }
            if (forLoop != null && (query = (SqlQueryExpression)PsiTreeUtil.getChildOfType((PsiElement)forLoop, SqlQueryExpression.class)) != null && (querySqlType = query.getSqlType()) instanceof SqlTableType) {
                return SqlImplUtil.processDeclarationsInType((SqlTableType)querySqlType, (PsiScopeProcessor)processor, ResolveState.initial(), element);
            }
        }
        if (element instanceof SqlReferenceExpression) {
            SqlReferenceElementType type2 = ((SqlReferenceExpression)element).getReferenceElementType();
            if (type2 == SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE) {
                if (!PostgresDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_PG_DEFAULT, REFERENCE, name, element, resolve, processor, false, false)) {
                    return false;
                }
                if (!PostgresDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_PG_GLOBAL, REFERENCE, name, element, resolve, processor, false, false)) {
                    return false;
                }
            }
            if (resolve && ((SqlReferenceExpression)element).getQualifierExpression() == null) {
                for (ReservedEntity object : LazyData.ourObjects) {
                    if (processor.executeTarget(object, element, null, false, ResolveState.initial())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    private static Condition<PsiElement> isType(IElementType type) {
        Condition condition = Conditions.compose((Function)SyntaxTraverser.psiApi().TO_TYPE, (Condition)Conditions.is((Object)type));
        if (condition == null) {
            PostgresDialect.$$$reportNull$$$0(8);
        }
        return condition;
    }

    private boolean inPl(PsiElement element) {
        return this == PlDialect.INSTANCE || PsiTreeUtil.getParentOfType((PsiElement)element, PgCodeBlockElementType.BodyElement.class) != null;
    }

    private static boolean raiseStatement(@NotNull PsiElement element) {
        SqlStatement statement;
        if (element == null) {
            PostgresDialect.$$$reportNull$$$0(9);
        }
        return (statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) != null && statement.getNode().getElementType() == PostgresElementTypes.PG_RAISE_STATEMENT;
    }

    @Override
    @NotNull
    public SqlType getDefinitionType(@NotNull SqlTypedDefinition definition, @Nullable PsiElement usage) {
        if (definition == null) {
            PostgresDialect.$$$reportNull$$$0(10);
        }
        int usageOffset = usage == null ? Integer.MAX_VALUE : usage.getTextOffset();
        SqlType defined = definition.getSqlType();
        if (SqlType.Category.RECORD.is(defined) && this.inPl((PsiElement)definition)) {
            SqlBlockStatementImpl block = (SqlBlockStatementImpl)PsiTreeUtil.getTopmostParentOfType((PsiElement)definition, SqlBlockStatementImpl.class);
            Query search = block == null ? ReferencesSearch.search((PsiElement)definition) : ReferencesSearch.search((PsiElement)definition, (SearchScope)new LocalSearchScope((PsiElement)block));
            Collection all = search.findAll();
            PsiReference required = null;
            for (PsiReference ref : all) {
                int offset;
                if (ref.getElement().getParent() instanceof SqlSelectIntoClause) {
                    required = ref;
                }
                if ((offset = ref.getElement().getTextOffset()) < usageOffset) continue;
                break;
            }
            if (required != null) {
                SqlType type;
                SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)required.getElement(), SqlQueryExpression.class);
                if (query != null) {
                    SqlType sqlType = query.getSqlType();
                    if (sqlType == null) {
                        PostgresDialect.$$$reportNull$$$0(11);
                    }
                    return sqlType;
                }
                SqlReturningClause returningClause = (SqlReturningClause)PsiTreeUtil.getParentOfType((PsiElement)required.getElement(), SqlReturningClause.class);
                SqlType sqlType = type = returningClause != null ? returningClause.getSqlType() : null;
                if (type != null) {
                    SqlType sqlType2 = type;
                    if (sqlType2 == null) {
                        PostgresDialect.$$$reportNull$$$0(12);
                    }
                    return sqlType2;
                }
            }
        }
        SqlType sqlType = super.getDefinitionType(definition, usage);
        if (sqlType == null) {
            PostgresDialect.$$$reportNull$$$0(13);
        }
        return sqlType;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        Couple<ObjectName> scAndDb = PostgresDialect.getScAndDb(dataSource);
        TreePattern treePattern = this.applyImplicitImports(SqlImportUtil.getRealDsNames(dataSource), SybaseDialect.forcedContextExpandedToSchemas(dataSource, this.getDatabaseDialect(), searchPath, SqlImportUtil.optAr(TreePatternUtils.create((ObjectName)scAndDb.first, SqlDbElementType.SCHEMA, new TreePatternNode.Group[0])), SqlImportUtil.optAr(TreePatternUtils.create((ObjectName)scAndDb.second, SqlDbElementType.DATABASE, new TreePatternNode.Group[0]))));
        if (treePattern == null) {
            PostgresDialect.$$$reportNull$$$0(14);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectName dbName = PostgresDialect.getDbName(dataSource);
        DasNamespace namespace = PostgresDialect.getDefaultNamespace(dataSource, dbName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == SqlDbElementType.SCHEMA ? null : TreePatternUtils.create(PUBLIC_NAME, SqlDbElementType.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                PostgresDialect.$$$reportNull$$$0(15);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbName, TreePatternUtils.create(PUBLIC_NAME, SqlDbElementType.SCHEMA, new TreePatternNode.Group[0])))));
        if (treePattern == null) {
            PostgresDialect.$$$reportNull$$$0(16);
        }
        return treePattern;
    }

    @Nullable
    private static ObjectName getDbName(@Nullable DbDataSource dataSource) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig(dataSource);
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(config), (Object)SqlDialectImplUtil.getUserName(config))));
    }

    private static Couple<ObjectName> getScAndDb(@Nullable DbDataSource dataSource) {
        ObjectName dbName = PostgresDialect.getDbName(dataSource);
        ObjectName scName = null;
        DasNamespace namespace = PostgresDialect.getDefaultNamespace(dataSource, dbName);
        if (namespace != null) {
            DasObject parent;
            if (namespace.getKind() == SqlDbElementType.SCHEMA) {
                scName = ObjectName.quoted((String)namespace.getName());
            }
            if ((parent = namespace.getDbParent()) != null && parent.getKind() == SqlDbElementType.DATABASE) {
                dbName = ObjectName.quoted((String)parent.getName());
            }
        }
        if (scName == null) {
            scName = PUBLIC_NAME;
        }
        return Couple.of((Object)scName, (Object)dbName);
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            PostgresDialect.$$$reportNull$$$0(17);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(ObjectName.quoted((String)"pg_catalog")), true, SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA);
        if (treePattern == null) {
            PostgresDialect.$$$reportNull$$$0(18);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public SqlTableType createSequenceType(@NotNull PsiElement element, @Nullable PsiElement object) {
        if (element == null) {
            PostgresDialect.$$$reportNull$$$0(19);
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(ContainerUtil.newArrayList((Object[])new SqlImplUtil.Column[]{PostgresDialect.col(element, object, "sequence_name", this.STRING), PostgresDialect.col(element, object, "last_value", this.INTEGER), PostgresDialect.col(element, object, "start_value", this.INTEGER), PostgresDialect.col(element, object, "increment_by", this.INTEGER), PostgresDialect.col(element, object, "max_value", this.INTEGER), PostgresDialect.col(element, object, "min_value", this.INTEGER), PostgresDialect.col(element, object, "cache_value", this.INTEGER), PostgresDialect.col(element, object, "long_cnt", this.INTEGER), PostgresDialect.col(element, object, "is_cycled", this.BOOLEAN), PostgresDialect.col(element, object, "is_called", this.BOOLEAN)}), element);
        if (sqlTableType == null) {
            PostgresDialect.$$$reportNull$$$0(20);
        }
        return sqlTableType;
    }

    private static SqlImplUtil.Column col(final @NotNull PsiElement element, final @Nullable PsiElement object, @NotNull String name, @NotNull SqlType type) {
        if (element == null) {
            PostgresDialect.$$$reportNull$$$0(21);
        }
        if (name == null) {
            PostgresDialect.$$$reportNull$$$0(22);
        }
        if (type == null) {
            PostgresDialect.$$$reportNull$$$0(23);
        }
        return new SqlImplUtil.Column(name, type, (PsiElement)new SqlFileImpl.FakeDefinition(element, name, null){

            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectKind;
            }

            @Override
            @Nullable
            public DasObject getDbParent() {
                return (DasObject)ObjectUtils.chooseNotNull((Object)ObjectUtils.tryCast((Object)object, DasObject.class), (Object)ObjectUtils.tryCast((Object)element, DasObject.class));
            }

            public boolean isNameQuoted() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect$1", "getKind"));
            }
        }, null);
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place) {
        if (expectedTypes == null) {
            PostgresDialect.$$$reportNull$$$0(24);
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) || expectedTypes.contains(SqlDbElementType.ANY)) {
            boolean isTable;
            boolean bl = isTable = type == SqlDbElementType.TABLE;
            if (type == SqlDbElementType.LOCAL_ALIAS) {
                if (element == null) {
                    isTable = true;
                } else {
                    PsiElement parent = element.getParent();
                    boolean bl2 = isTable = parent instanceof SqlFromClause || parent instanceof SqlJoinExpression;
                }
            }
            if (isTable) {
                SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
                return ref == null || ref.getQualifierExpression() == null;
            }
        }
        if (type == PostgresElementTypes.Extra.EXTENSION && expectedTypes.contains(PostgresElementTypes.Extra.FOREIGN_DATA_WRAPPER)) {
            return true;
        }
        if (type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes, place);
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        if (column == null) {
            PostgresDialect.$$$reportNull$$$0(25);
        }
        if (super.isAutoIncrementColumn(column)) {
            return true;
        }
        String type = column.getDataType().getSpecification();
        return com.intellij.database.dialects.PostgresDialect.SERIAL_PATTERN.matcher(type).matches();
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new PostgresExtractVariableHelper();
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            PostgresDialect.$$$reportNull$$$0(26);
        }
        return true;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            PostgresDialect.$$$reportNull$$$0(27);
        }
        return kind == SqlDbElementType.KEY || kind == SqlDbElementType.INDEX || kind == SqlDbElementType.TRIGGER || kind == SqlDbElementType.RULE || kind == SqlDbElementType.SERVER;
    }

    @Override
    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            PostgresDialect.$$$reportNull$$$0(28);
        }
        return super.shouldSkipFromQualification(kind) || kind == SqlDbElementType.FOREIGN_DATA_WRAPPER;
    }

    @Override
    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name) {
        IElementType res;
        if (name == null) {
            PostgresDialect.$$$reportNull$$$0(29);
        }
        return (res = PostgresElementFactory.findComposite(name)) == null ? super.getFunctionParserExtension(name) : res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PostgresDialect";
                break;
            }
            case 6: 
            case 9: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PostgresDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "isType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequenceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "raiseStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSequenceType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "col";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        public static final Pattern ARG_PATTERN = Pattern.compile("\\$\\d+");
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final Set<String> ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtil.loadTokens(INSTANCE, "exceptions.txt"));
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtil.loadObjects(INSTANCE, "fallback.txt");
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(PostgresReservedKeywords.class);
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_ABS, SqlTokens.SQL_OP_NOT2, SqlTokens.PG_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.PG_OP_PRIME, SqlTokens.PG_OP_CUSTOM, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_PLUS_EQ, SqlTokens.SQL_OP_MINUS_EQ, SqlTokens.SQL_OP_MUL_EQ, SqlTokens.SQL_OP_DIV_EQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_MODULO_EQ, SqlTokens.SQL_OP_BITWISE_AND_EQ, SqlTokens.SQL_OP_BITWISE_OR_EQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2});
        static final Map<String, DasObject> RESERVED_INTEGER_ENTITIES = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID");
        static final Map<String, DasObject> RE_OPS = SqlDialectImplUtil.buildEntities(PostgresElementTypes.Extra.OPERATOR_CLASS, "INTEGER_OPS", "TEXT_PATTERN_OPS", "INT8_OPS", "INT4_OPS", "INT2_OPS", "VARCHAR_PATTERN_OPS", "BPCHAR_PATTERN_OPS", "JSONB_PATH_OPS");
        static final ReservedEntity RE_EXCLUDED = new ReservedEntity("EXCLUDED", SqlDbElementType.TABLE);
        static final ReservedEntity RE_FOUND = new ReservedEntity("FOUND", ObjectKind.COLUMN);
        static final ReservedEntity SQLSTATE = new ReservedEntity("SQLSTATE", ObjectKind.COLUMN);
        static final ReservedEntity SQLERRM = new ReservedEntity("SQLERRM", ObjectKind.COLUMN);
        static final ReservedEntity RE_PG_DEFAULT = new ReservedEntity("pg_default", SqlDbElementType.TABLESPACE);
        static final ReservedEntity RE_PG_GLOBAL = new ReservedEntity("pg_global", SqlDbElementType.TABLESPACE);
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }

    public static class PlDialect
    extends PostgresDialect
    implements InjectableLanguage {
        public static final PlDialect INSTANCE = new PlDialect();

        public PlDialect() {
            super("PostgresPLSQL");
        }
    }
}

